# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetEnrollmentStatusesResult',
    'AwaitableGetEnrollmentStatusesResult',
    'get_enrollment_statuses',
    'get_enrollment_statuses_output',
]

@pulumi.output_type
class GetEnrollmentStatusesResult:
    """
    A collection of values returned by getEnrollmentStatuses.
    """
    def __init__(__self__, compartment_id=None, enrollment_status_collections=None, filters=None, id=None, state=None, status=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if enrollment_status_collections and not isinstance(enrollment_status_collections, list):
            raise TypeError("Expected argument 'enrollment_status_collections' to be a list")
        pulumi.set(__self__, "enrollment_status_collections", enrollment_status_collections)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="enrollmentStatusCollections")
    def enrollment_status_collections(self) -> Sequence['outputs.GetEnrollmentStatusesEnrollmentStatusCollectionResult']:
        """
        The list of enrollment_status_collection.
        """
        return pulumi.get(self, "enrollment_status_collections")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetEnrollmentStatusesFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The enrollment status' current state.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The current Cloud Advisor enrollment status.
        """
        return pulumi.get(self, "status")


class AwaitableGetEnrollmentStatusesResult(GetEnrollmentStatusesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEnrollmentStatusesResult(
            compartment_id=self.compartment_id,
            enrollment_status_collections=self.enrollment_status_collections,
            filters=self.filters,
            id=self.id,
            state=self.state,
            status=self.status)


def get_enrollment_statuses(compartment_id: Optional[_builtins.str] = None,
                            filters: Optional[Sequence[Union['GetEnrollmentStatusesFilterArgs', 'GetEnrollmentStatusesFilterArgsDict']]] = None,
                            state: Optional[_builtins.str] = None,
                            status: Optional[_builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEnrollmentStatusesResult:
    """
    This data source provides the list of Enrollment Statuses in Oracle Cloud Infrastructure Optimizer service.

    Lists the Cloud Advisor enrollment statuses.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_enrollment_statuses = oci.Optimizer.get_enrollment_statuses(compartment_id=compartment_id,
        state=enrollment_status_state,
        status=enrollment_status_status)
    ```


    :param _builtins.str compartment_id: The OCID of the compartment.
    :param _builtins.str state: A filter that returns results that match the lifecycle state specified.
    :param _builtins.str status: A filter that returns results that match the Cloud Advisor enrollment status specified.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['state'] = state
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Optimizer/getEnrollmentStatuses:getEnrollmentStatuses', __args__, opts=opts, typ=GetEnrollmentStatusesResult).value

    return AwaitableGetEnrollmentStatusesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        enrollment_status_collections=pulumi.get(__ret__, 'enrollment_status_collections'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'),
        status=pulumi.get(__ret__, 'status'))
def get_enrollment_statuses_output(compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                   filters: Optional[pulumi.Input[Optional[Sequence[Union['GetEnrollmentStatusesFilterArgs', 'GetEnrollmentStatusesFilterArgsDict']]]]] = None,
                                   state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetEnrollmentStatusesResult]:
    """
    This data source provides the list of Enrollment Statuses in Oracle Cloud Infrastructure Optimizer service.

    Lists the Cloud Advisor enrollment statuses.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_enrollment_statuses = oci.Optimizer.get_enrollment_statuses(compartment_id=compartment_id,
        state=enrollment_status_state,
        status=enrollment_status_status)
    ```


    :param _builtins.str compartment_id: The OCID of the compartment.
    :param _builtins.str state: A filter that returns results that match the lifecycle state specified.
    :param _builtins.str status: A filter that returns results that match the Cloud Advisor enrollment status specified.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['state'] = state
    __args__['status'] = status
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Optimizer/getEnrollmentStatuses:getEnrollmentStatuses', __args__, opts=opts, typ=GetEnrollmentStatusesResult)
    return __ret__.apply(lambda __response__: GetEnrollmentStatusesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        enrollment_status_collections=pulumi.get(__response__, 'enrollment_status_collections'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state'),
        status=pulumi.get(__response__, 'status')))
