# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'BackupCopyStatusArgs',
    'BackupCopyStatusArgsDict',
    'BackupDbSystemDetailArgs',
    'BackupDbSystemDetailArgsDict',
    'BackupSourceBackupDetailsArgs',
    'BackupSourceBackupDetailsArgsDict',
    'ConfigurationConfigurationDetailArgs',
    'ConfigurationConfigurationDetailArgsDict',
    'ConfigurationConfigurationDetailItemArgs',
    'ConfigurationConfigurationDetailItemArgsDict',
    'ConfigurationDbConfigurationOverridesArgs',
    'ConfigurationDbConfigurationOverridesArgsDict',
    'ConfigurationDbConfigurationOverridesItemArgs',
    'ConfigurationDbConfigurationOverridesItemArgsDict',
    'DbSystemCredentialsArgs',
    'DbSystemCredentialsArgsDict',
    'DbSystemCredentialsPasswordDetailsArgs',
    'DbSystemCredentialsPasswordDetailsArgsDict',
    'DbSystemInstanceArgs',
    'DbSystemInstanceArgsDict',
    'DbSystemInstancesDetailArgs',
    'DbSystemInstancesDetailArgsDict',
    'DbSystemManagementPolicyArgs',
    'DbSystemManagementPolicyArgsDict',
    'DbSystemManagementPolicyBackupPolicyArgs',
    'DbSystemManagementPolicyBackupPolicyArgsDict',
    'DbSystemManagementPolicyBackupPolicyCopyPolicyArgs',
    'DbSystemManagementPolicyBackupPolicyCopyPolicyArgsDict',
    'DbSystemNetworkDetailsArgs',
    'DbSystemNetworkDetailsArgsDict',
    'DbSystemPatchOperationArgs',
    'DbSystemPatchOperationArgsDict',
    'DbSystemSourceArgs',
    'DbSystemSourceArgsDict',
    'DbSystemStorageDetailsArgs',
    'DbSystemStorageDetailsArgsDict',
    'GetBackupsFilterArgs',
    'GetBackupsFilterArgsDict',
    'GetConfigurationsFilterArgs',
    'GetConfigurationsFilterArgsDict',
    'GetDbSystemsFilterArgs',
    'GetDbSystemsFilterArgsDict',
    'GetDefaultConfigurationsFilterArgs',
    'GetDefaultConfigurationsFilterArgsDict',
    'GetShapesFilterArgs',
    'GetShapesFilterArgsDict',
]

MYPY = False

if not MYPY:
    class BackupCopyStatusArgsDict(TypedDict):
        backup_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the backup in the source region
        """
        region: NotRequired[pulumi.Input[_builtins.str]]
        """
        Region name of the remote region
        """
        state: NotRequired[pulumi.Input[_builtins.str]]
        """
        The current state of the backup.
        """
        state_details: NotRequired[pulumi.Input[_builtins.str]]
        """
        A message describing the current state of copy in more detail
        """
elif False:
    BackupCopyStatusArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BackupCopyStatusArgs:
    def __init__(__self__, *,
                 backup_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 state_details: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] backup_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the backup in the source region
        :param pulumi.Input[_builtins.str] region: Region name of the remote region
        :param pulumi.Input[_builtins.str] state: The current state of the backup.
        :param pulumi.Input[_builtins.str] state_details: A message describing the current state of copy in more detail
        """
        if backup_id is not None:
            pulumi.set(__self__, "backup_id", backup_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if state_details is not None:
            pulumi.set(__self__, "state_details", state_details)

    @_builtins.property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the backup in the source region
        """
        return pulumi.get(self, "backup_id")

    @backup_id.setter
    def backup_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region name of the remote region
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the backup.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="stateDetails")
    def state_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A message describing the current state of copy in more detail
        """
        return pulumi.get(self, "state_details")

    @state_details.setter
    def state_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state_details", value)


if not MYPY:
    class BackupDbSystemDetailArgsDict(TypedDict):
        config_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        OCID of the configuration that was applied on the source dbSystem at the time when backup was taken.
        """
        db_version: NotRequired[pulumi.Input[_builtins.str]]
        """
        The major and minor versions of the database system software.
        """
        system_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        Type of the database system.
        """
elif False:
    BackupDbSystemDetailArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BackupDbSystemDetailArgs:
    def __init__(__self__, *,
                 config_id: Optional[pulumi.Input[_builtins.str]] = None,
                 db_version: Optional[pulumi.Input[_builtins.str]] = None,
                 system_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] config_id: OCID of the configuration that was applied on the source dbSystem at the time when backup was taken.
        :param pulumi.Input[_builtins.str] db_version: The major and minor versions of the database system software.
        :param pulumi.Input[_builtins.str] system_type: Type of the database system.
        """
        if config_id is not None:
            pulumi.set(__self__, "config_id", config_id)
        if db_version is not None:
            pulumi.set(__self__, "db_version", db_version)
        if system_type is not None:
            pulumi.set(__self__, "system_type", system_type)

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        OCID of the configuration that was applied on the source dbSystem at the time when backup was taken.
        """
        return pulumi.get(self, "config_id")

    @config_id.setter
    def config_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "config_id", value)

    @_builtins.property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The major and minor versions of the database system software.
        """
        return pulumi.get(self, "db_version")

    @db_version.setter
    def db_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_version", value)

    @_builtins.property
    @pulumi.getter(name="systemType")
    def system_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of the database system.
        """
        return pulumi.get(self, "system_type")

    @system_type.setter
    def system_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_type", value)


if not MYPY:
    class BackupSourceBackupDetailsArgsDict(TypedDict):
        source_backup_id: pulumi.Input[_builtins.str]
        """
        Backup ID of the COPY source type.
        """
        source_region: pulumi.Input[_builtins.str]
        """
        Backup Region of the COPY source type.
        """
elif False:
    BackupSourceBackupDetailsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BackupSourceBackupDetailsArgs:
    def __init__(__self__, *,
                 source_backup_id: pulumi.Input[_builtins.str],
                 source_region: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] source_backup_id: Backup ID of the COPY source type.
        :param pulumi.Input[_builtins.str] source_region: Backup Region of the COPY source type.
        """
        pulumi.set(__self__, "source_backup_id", source_backup_id)
        pulumi.set(__self__, "source_region", source_region)

    @_builtins.property
    @pulumi.getter(name="sourceBackupId")
    def source_backup_id(self) -> pulumi.Input[_builtins.str]:
        """
        Backup ID of the COPY source type.
        """
        return pulumi.get(self, "source_backup_id")

    @source_backup_id.setter
    def source_backup_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "source_backup_id", value)

    @_builtins.property
    @pulumi.getter(name="sourceRegion")
    def source_region(self) -> pulumi.Input[_builtins.str]:
        """
        Backup Region of the COPY source type.
        """
        return pulumi.get(self, "source_region")

    @source_region.setter
    def source_region(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "source_region", value)


if not MYPY:
    class ConfigurationConfigurationDetailArgsDict(TypedDict):
        items: NotRequired[pulumi.Input[Sequence[pulumi.Input['ConfigurationConfigurationDetailItemArgsDict']]]]
        """
        List of ConfigParms object.
        """
elif False:
    ConfigurationConfigurationDetailArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConfigurationConfigurationDetailArgs:
    def __init__(__self__, *,
                 items: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationConfigurationDetailItemArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ConfigurationConfigurationDetailItemArgs']]] items: List of ConfigParms object.
        """
        if items is not None:
            pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationConfigurationDetailItemArgs']]]]:
        """
        List of ConfigParms object.
        """
        return pulumi.get(self, "items")

    @items.setter
    def items(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationConfigurationDetailItemArgs']]]]):
        pulumi.set(self, "items", value)


if not MYPY:
    class ConfigurationConfigurationDetailItemArgsDict(TypedDict):
        allowed_values: NotRequired[pulumi.Input[_builtins.str]]
        """
        Range or list of allowed values.
        """
        config_key: NotRequired[pulumi.Input[_builtins.str]]
        """
        The configuration variable name.
        """
        data_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        Data type of the variable.
        """
        default_config_value: NotRequired[pulumi.Input[_builtins.str]]
        """
        Default value for the configuration variable.
        """
        description: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Updatable) Details about the configuration set.
        """
        is_overridable: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether the value can be overridden or not.
        """
        is_restart_required: NotRequired[pulumi.Input[_builtins.bool]]
        """
        If true, modifying this configuration value will require a restart of the database.
        """
        overriden_config_value: NotRequired[pulumi.Input[_builtins.str]]
        """
        User-selected configuration variable value.
        """
elif False:
    ConfigurationConfigurationDetailItemArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConfigurationConfigurationDetailItemArgs:
    def __init__(__self__, *,
                 allowed_values: Optional[pulumi.Input[_builtins.str]] = None,
                 config_key: Optional[pulumi.Input[_builtins.str]] = None,
                 data_type: Optional[pulumi.Input[_builtins.str]] = None,
                 default_config_value: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 is_overridable: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_restart_required: Optional[pulumi.Input[_builtins.bool]] = None,
                 overriden_config_value: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] allowed_values: Range or list of allowed values.
        :param pulumi.Input[_builtins.str] config_key: The configuration variable name.
        :param pulumi.Input[_builtins.str] data_type: Data type of the variable.
        :param pulumi.Input[_builtins.str] default_config_value: Default value for the configuration variable.
        :param pulumi.Input[_builtins.str] description: (Updatable) Details about the configuration set.
        :param pulumi.Input[_builtins.bool] is_overridable: Whether the value can be overridden or not.
        :param pulumi.Input[_builtins.bool] is_restart_required: If true, modifying this configuration value will require a restart of the database.
        :param pulumi.Input[_builtins.str] overriden_config_value: User-selected configuration variable value.
        """
        if allowed_values is not None:
            pulumi.set(__self__, "allowed_values", allowed_values)
        if config_key is not None:
            pulumi.set(__self__, "config_key", config_key)
        if data_type is not None:
            pulumi.set(__self__, "data_type", data_type)
        if default_config_value is not None:
            pulumi.set(__self__, "default_config_value", default_config_value)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if is_overridable is not None:
            pulumi.set(__self__, "is_overridable", is_overridable)
        if is_restart_required is not None:
            pulumi.set(__self__, "is_restart_required", is_restart_required)
        if overriden_config_value is not None:
            pulumi.set(__self__, "overriden_config_value", overriden_config_value)

    @_builtins.property
    @pulumi.getter(name="allowedValues")
    def allowed_values(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Range or list of allowed values.
        """
        return pulumi.get(self, "allowed_values")

    @allowed_values.setter
    def allowed_values(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "allowed_values", value)

    @_builtins.property
    @pulumi.getter(name="configKey")
    def config_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The configuration variable name.
        """
        return pulumi.get(self, "config_key")

    @config_key.setter
    def config_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "config_key", value)

    @_builtins.property
    @pulumi.getter(name="dataType")
    def data_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Data type of the variable.
        """
        return pulumi.get(self, "data_type")

    @data_type.setter
    def data_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_type", value)

    @_builtins.property
    @pulumi.getter(name="defaultConfigValue")
    def default_config_value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Default value for the configuration variable.
        """
        return pulumi.get(self, "default_config_value")

    @default_config_value.setter
    def default_config_value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_config_value", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Details about the configuration set.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="isOverridable")
    def is_overridable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the value can be overridden or not.
        """
        return pulumi.get(self, "is_overridable")

    @is_overridable.setter
    def is_overridable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_overridable", value)

    @_builtins.property
    @pulumi.getter(name="isRestartRequired")
    def is_restart_required(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, modifying this configuration value will require a restart of the database.
        """
        return pulumi.get(self, "is_restart_required")

    @is_restart_required.setter
    def is_restart_required(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_restart_required", value)

    @_builtins.property
    @pulumi.getter(name="overridenConfigValue")
    def overriden_config_value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User-selected configuration variable value.
        """
        return pulumi.get(self, "overriden_config_value")

    @overriden_config_value.setter
    def overriden_config_value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "overriden_config_value", value)


if not MYPY:
    class ConfigurationDbConfigurationOverridesArgsDict(TypedDict):
        items: pulumi.Input[Sequence[pulumi.Input['ConfigurationDbConfigurationOverridesItemArgsDict']]]
        """
        List of configuration overridden values.
        """
elif False:
    ConfigurationDbConfigurationOverridesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConfigurationDbConfigurationOverridesArgs:
    def __init__(__self__, *,
                 items: pulumi.Input[Sequence[pulumi.Input['ConfigurationDbConfigurationOverridesItemArgs']]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ConfigurationDbConfigurationOverridesItemArgs']]] items: List of configuration overridden values.
        """
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> pulumi.Input[Sequence[pulumi.Input['ConfigurationDbConfigurationOverridesItemArgs']]]:
        """
        List of configuration overridden values.
        """
        return pulumi.get(self, "items")

    @items.setter
    def items(self, value: pulumi.Input[Sequence[pulumi.Input['ConfigurationDbConfigurationOverridesItemArgs']]]):
        pulumi.set(self, "items", value)


if not MYPY:
    class ConfigurationDbConfigurationOverridesItemArgsDict(TypedDict):
        config_key: pulumi.Input[_builtins.str]
        """
        Configuration variable name.
        """
        overriden_config_value: pulumi.Input[_builtins.str]
        """
        User-selected variable value.
        """
elif False:
    ConfigurationDbConfigurationOverridesItemArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConfigurationDbConfigurationOverridesItemArgs:
    def __init__(__self__, *,
                 config_key: pulumi.Input[_builtins.str],
                 overriden_config_value: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] config_key: Configuration variable name.
        :param pulumi.Input[_builtins.str] overriden_config_value: User-selected variable value.
        """
        pulumi.set(__self__, "config_key", config_key)
        pulumi.set(__self__, "overriden_config_value", overriden_config_value)

    @_builtins.property
    @pulumi.getter(name="configKey")
    def config_key(self) -> pulumi.Input[_builtins.str]:
        """
        Configuration variable name.
        """
        return pulumi.get(self, "config_key")

    @config_key.setter
    def config_key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "config_key", value)

    @_builtins.property
    @pulumi.getter(name="overridenConfigValue")
    def overriden_config_value(self) -> pulumi.Input[_builtins.str]:
        """
        User-selected variable value.
        """
        return pulumi.get(self, "overriden_config_value")

    @overriden_config_value.setter
    def overriden_config_value(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "overriden_config_value", value)


if not MYPY:
    class DbSystemCredentialsArgsDict(TypedDict):
        password_details: pulumi.Input['DbSystemCredentialsPasswordDetailsArgsDict']
        """
        Details for the database system password. Password can be passed as `VaultSecretPasswordDetails` or `PlainTextPasswordDetails`.
        """
        username: pulumi.Input[_builtins.str]
        """
        The database system administrator username.
        """
elif False:
    DbSystemCredentialsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DbSystemCredentialsArgs:
    def __init__(__self__, *,
                 password_details: pulumi.Input['DbSystemCredentialsPasswordDetailsArgs'],
                 username: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input['DbSystemCredentialsPasswordDetailsArgs'] password_details: Details for the database system password. Password can be passed as `VaultSecretPasswordDetails` or `PlainTextPasswordDetails`.
        :param pulumi.Input[_builtins.str] username: The database system administrator username.
        """
        pulumi.set(__self__, "password_details", password_details)
        pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter(name="passwordDetails")
    def password_details(self) -> pulumi.Input['DbSystemCredentialsPasswordDetailsArgs']:
        """
        Details for the database system password. Password can be passed as `VaultSecretPasswordDetails` or `PlainTextPasswordDetails`.
        """
        return pulumi.get(self, "password_details")

    @password_details.setter
    def password_details(self, value: pulumi.Input['DbSystemCredentialsPasswordDetailsArgs']):
        pulumi.set(self, "password_details", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> pulumi.Input[_builtins.str]:
        """
        The database system administrator username.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "username", value)


if not MYPY:
    class DbSystemCredentialsPasswordDetailsArgsDict(TypedDict):
        password_type: pulumi.Input[_builtins.str]
        """
        The password type.
        """
        password: NotRequired[pulumi.Input[_builtins.str]]
        """
        The database system password.
        """
        secret_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret where the password is stored.
        """
        secret_version: NotRequired[pulumi.Input[_builtins.str]]
        """
        The secret version of the stored password.
        """
elif False:
    DbSystemCredentialsPasswordDetailsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DbSystemCredentialsPasswordDetailsArgs:
    def __init__(__self__, *,
                 password_type: pulumi.Input[_builtins.str],
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_id: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] password_type: The password type.
        :param pulumi.Input[_builtins.str] password: The database system password.
        :param pulumi.Input[_builtins.str] secret_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret where the password is stored.
        :param pulumi.Input[_builtins.str] secret_version: The secret version of the stored password.
        """
        pulumi.set(__self__, "password_type", password_type)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if secret_id is not None:
            pulumi.set(__self__, "secret_id", secret_id)
        if secret_version is not None:
            pulumi.set(__self__, "secret_version", secret_version)

    @_builtins.property
    @pulumi.getter(name="passwordType")
    def password_type(self) -> pulumi.Input[_builtins.str]:
        """
        The password type.
        """
        return pulumi.get(self, "password_type")

    @password_type.setter
    def password_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "password_type", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The database system password.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret where the password is stored.
        """
        return pulumi.get(self, "secret_id")

    @secret_id.setter
    def secret_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_id", value)

    @_builtins.property
    @pulumi.getter(name="secretVersion")
    def secret_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The secret version of the stored password.
        """
        return pulumi.get(self, "secret_version")

    @secret_version.setter
    def secret_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_version", value)


if not MYPY:
    class DbSystemInstanceArgsDict(TypedDict):
        availability_domain: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the availability domain of AD-local storage. If `isRegionallyDurable` is set to true, `availabilityDomain` should not be specified. If `isRegionallyDurable` is set to false, `availabilityDomain` must be specified.
        """
        description: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Updatable) A user-provided description of a database system.
        """
        display_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Updatable) A user-friendly display name for the database system. Avoid entering confidential information.
        """
        id: NotRequired[pulumi.Input[_builtins.str]]
        """
        A unique identifier for the database instance node. Immutable on creation.
        """
        lifecycle_details: NotRequired[pulumi.Input[_builtins.str]]
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        state: NotRequired[pulumi.Input[_builtins.str]]
        """
        The current state of the database system.
        """
        time_created: NotRequired[pulumi.Input[_builtins.str]]
        """
        The date and time that the database system was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        time_updated: NotRequired[pulumi.Input[_builtins.str]]
        """
        The date and time that the database system was updated, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
elif False:
    DbSystemInstanceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DbSystemInstanceArgs:
    def __init__(__self__, *,
                 availability_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 id: Optional[pulumi.Input[_builtins.str]] = None,
                 lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] availability_domain: Specifies the availability domain of AD-local storage. If `isRegionallyDurable` is set to true, `availabilityDomain` should not be specified. If `isRegionallyDurable` is set to false, `availabilityDomain` must be specified.
        :param pulumi.Input[_builtins.str] description: (Updatable) A user-provided description of a database system.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly display name for the database system. Avoid entering confidential information.
        :param pulumi.Input[_builtins.str] id: A unique identifier for the database instance node. Immutable on creation.
        :param pulumi.Input[_builtins.str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[_builtins.str] state: The current state of the database system.
        :param pulumi.Input[_builtins.str] time_created: The date and time that the database system was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] time_updated: The date and time that the database system was updated, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        if availability_domain is not None:
            pulumi.set(__self__, "availability_domain", availability_domain)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the availability domain of AD-local storage. If `isRegionallyDurable` is set to true, `availabilityDomain` should not be specified. If `isRegionallyDurable` is set to false, `availabilityDomain` must be specified.
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_domain", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A user-provided description of a database system.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A user-friendly display name for the database system. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A unique identifier for the database instance node. Immutable on creation.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "id", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the database system.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time that the database system was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time that the database system was updated, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)


if not MYPY:
    class DbSystemInstancesDetailArgsDict(TypedDict):
        description: NotRequired[pulumi.Input[_builtins.str]]
        """
        A user-provided description of the database instance node.
        """
        display_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Display name of the database instance node. Avoid entering confidential information.
        """
        private_ip: NotRequired[pulumi.Input[_builtins.str]]
        """
        Private IP in customer subnet that will be assigned to the database instance node. This value is optional. If the IP is not provided, the IP will be chosen from the available IP addresses in the specified subnet.
        """
elif False:
    DbSystemInstancesDetailArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DbSystemInstancesDetailArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] description: A user-provided description of the database instance node.
        :param pulumi.Input[_builtins.str] display_name: Display name of the database instance node. Avoid entering confidential information.
        :param pulumi.Input[_builtins.str] private_ip: Private IP in customer subnet that will be assigned to the database instance node. This value is optional. If the IP is not provided, the IP will be chosen from the available IP addresses in the specified subnet.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A user-provided description of the database instance node.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Display name of the database instance node. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Private IP in customer subnet that will be assigned to the database instance node. This value is optional. If the IP is not provided, the IP will be chosen from the available IP addresses in the specified subnet.
        """
        return pulumi.get(self, "private_ip")

    @private_ip.setter
    def private_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_ip", value)


if not MYPY:
    class DbSystemManagementPolicyArgsDict(TypedDict):
        backup_policy: NotRequired[pulumi.Input['DbSystemManagementPolicyBackupPolicyArgsDict']]
        """
        (Updatable) PostgreSQL database system backup policy.
        """
        maintenance_window_start: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Updatable) The start of the maintenance window in UTC.

        This string is of the format: "{day-of-week} {time-of-day}". "{day-of-week}" is a case-insensitive string like "mon", "tue", &c. "{time-of-day}" is the "Time" portion of an RFC3339-formatted timestamp. Any second or sub-second time data will be truncated to zero.
        """
elif False:
    DbSystemManagementPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DbSystemManagementPolicyArgs:
    def __init__(__self__, *,
                 backup_policy: Optional[pulumi.Input['DbSystemManagementPolicyBackupPolicyArgs']] = None,
                 maintenance_window_start: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input['DbSystemManagementPolicyBackupPolicyArgs'] backup_policy: (Updatable) PostgreSQL database system backup policy.
        :param pulumi.Input[_builtins.str] maintenance_window_start: (Updatable) The start of the maintenance window in UTC.
               
               This string is of the format: "{day-of-week} {time-of-day}". "{day-of-week}" is a case-insensitive string like "mon", "tue", &c. "{time-of-day}" is the "Time" portion of an RFC3339-formatted timestamp. Any second or sub-second time data will be truncated to zero.
        """
        if backup_policy is not None:
            pulumi.set(__self__, "backup_policy", backup_policy)
        if maintenance_window_start is not None:
            pulumi.set(__self__, "maintenance_window_start", maintenance_window_start)

    @_builtins.property
    @pulumi.getter(name="backupPolicy")
    def backup_policy(self) -> Optional[pulumi.Input['DbSystemManagementPolicyBackupPolicyArgs']]:
        """
        (Updatable) PostgreSQL database system backup policy.
        """
        return pulumi.get(self, "backup_policy")

    @backup_policy.setter
    def backup_policy(self, value: Optional[pulumi.Input['DbSystemManagementPolicyBackupPolicyArgs']]):
        pulumi.set(self, "backup_policy", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceWindowStart")
    def maintenance_window_start(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The start of the maintenance window in UTC.

        This string is of the format: "{day-of-week} {time-of-day}". "{day-of-week}" is a case-insensitive string like "mon", "tue", &c. "{time-of-day}" is the "Time" portion of an RFC3339-formatted timestamp. Any second or sub-second time data will be truncated to zero.
        """
        return pulumi.get(self, "maintenance_window_start")

    @maintenance_window_start.setter
    def maintenance_window_start(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintenance_window_start", value)


if not MYPY:
    class DbSystemManagementPolicyBackupPolicyArgsDict(TypedDict):
        backup_start: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Updatable) Hour of the day when the backup starts.
        """
        copy_policy: NotRequired[pulumi.Input['DbSystemManagementPolicyBackupPolicyCopyPolicyArgsDict']]
        """
        (Updatable) Backup copy details
        """
        days_of_the_months: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]
        """
        (Updatable) Day of the month when the backup should start. To ensure that the backup runs monthly, the latest day of the month that you can use to schedule a backup is the the 28th day.
        """
        days_of_the_weeks: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        (Updatable) The day of the week that the backup starts.
        """
        kind: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Updatable) The kind of backup policy.
        """
        retention_days: NotRequired[pulumi.Input[_builtins.int]]
        """
        (Updatable) How many days the data should be stored after the database system deletion.
        """
elif False:
    DbSystemManagementPolicyBackupPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DbSystemManagementPolicyBackupPolicyArgs:
    def __init__(__self__, *,
                 backup_start: Optional[pulumi.Input[_builtins.str]] = None,
                 copy_policy: Optional[pulumi.Input['DbSystemManagementPolicyBackupPolicyCopyPolicyArgs']] = None,
                 days_of_the_months: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 days_of_the_weeks: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 kind: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_days: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.str] backup_start: (Updatable) Hour of the day when the backup starts.
        :param pulumi.Input['DbSystemManagementPolicyBackupPolicyCopyPolicyArgs'] copy_policy: (Updatable) Backup copy details
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] days_of_the_months: (Updatable) Day of the month when the backup should start. To ensure that the backup runs monthly, the latest day of the month that you can use to schedule a backup is the the 28th day.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] days_of_the_weeks: (Updatable) The day of the week that the backup starts.
        :param pulumi.Input[_builtins.str] kind: (Updatable) The kind of backup policy.
        :param pulumi.Input[_builtins.int] retention_days: (Updatable) How many days the data should be stored after the database system deletion.
        """
        if backup_start is not None:
            pulumi.set(__self__, "backup_start", backup_start)
        if copy_policy is not None:
            pulumi.set(__self__, "copy_policy", copy_policy)
        if days_of_the_months is not None:
            pulumi.set(__self__, "days_of_the_months", days_of_the_months)
        if days_of_the_weeks is not None:
            pulumi.set(__self__, "days_of_the_weeks", days_of_the_weeks)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if retention_days is not None:
            pulumi.set(__self__, "retention_days", retention_days)

    @_builtins.property
    @pulumi.getter(name="backupStart")
    def backup_start(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Hour of the day when the backup starts.
        """
        return pulumi.get(self, "backup_start")

    @backup_start.setter
    def backup_start(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_start", value)

    @_builtins.property
    @pulumi.getter(name="copyPolicy")
    def copy_policy(self) -> Optional[pulumi.Input['DbSystemManagementPolicyBackupPolicyCopyPolicyArgs']]:
        """
        (Updatable) Backup copy details
        """
        return pulumi.get(self, "copy_policy")

    @copy_policy.setter
    def copy_policy(self, value: Optional[pulumi.Input['DbSystemManagementPolicyBackupPolicyCopyPolicyArgs']]):
        pulumi.set(self, "copy_policy", value)

    @_builtins.property
    @pulumi.getter(name="daysOfTheMonths")
    def days_of_the_months(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]:
        """
        (Updatable) Day of the month when the backup should start. To ensure that the backup runs monthly, the latest day of the month that you can use to schedule a backup is the the 28th day.
        """
        return pulumi.get(self, "days_of_the_months")

    @days_of_the_months.setter
    def days_of_the_months(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]):
        pulumi.set(self, "days_of_the_months", value)

    @_builtins.property
    @pulumi.getter(name="daysOfTheWeeks")
    def days_of_the_weeks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) The day of the week that the backup starts.
        """
        return pulumi.get(self, "days_of_the_weeks")

    @days_of_the_weeks.setter
    def days_of_the_weeks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "days_of_the_weeks", value)

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The kind of backup policy.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kind", value)

    @_builtins.property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) How many days the data should be stored after the database system deletion.
        """
        return pulumi.get(self, "retention_days")

    @retention_days.setter
    def retention_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retention_days", value)


if not MYPY:
    class DbSystemManagementPolicyBackupPolicyCopyPolicyArgsDict(TypedDict):
        compartment_id: pulumi.Input[_builtins.str]
        """
        (Updatable) target compartment to place a new backup
        """
        regions: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]
        """
        (Updatable) List of region names of the remote region
        """
        retention_period: NotRequired[pulumi.Input[_builtins.int]]
        """
        (Updatable) Retention period in days of the backup copy.
        """
elif False:
    DbSystemManagementPolicyBackupPolicyCopyPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DbSystemManagementPolicyBackupPolicyCopyPolicyArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[_builtins.str],
                 regions: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 retention_period: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) target compartment to place a new backup
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] regions: (Updatable) List of region names of the remote region
        :param pulumi.Input[_builtins.int] retention_period: (Updatable) Retention period in days of the backup copy.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "regions", regions)
        if retention_period is not None:
            pulumi.set(__self__, "retention_period", retention_period)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) target compartment to place a new backup
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter
    def regions(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        (Updatable) List of region names of the remote region
        """
        return pulumi.get(self, "regions")

    @regions.setter
    def regions(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "regions", value)

    @_builtins.property
    @pulumi.getter(name="retentionPeriod")
    def retention_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) Retention period in days of the backup copy.
        """
        return pulumi.get(self, "retention_period")

    @retention_period.setter
    def retention_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retention_period", value)


if not MYPY:
    class DbSystemNetworkDetailsArgsDict(TypedDict):
        subnet_id: pulumi.Input[_builtins.str]
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the customer subnet associated with the database system.
        """
        is_reader_endpoint_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        (Updatable) Specifies if the reader endpoint is enabled on the dbSystem.
        """
        nsg_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        (Updatable) List of customer Network Security Group [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with the database system.
        """
        primary_db_endpoint_private_ip: NotRequired[pulumi.Input[_builtins.str]]
        """
        Private IP in customer subnet. The value is optional. If the IP is not provided, the IP will be chosen from the available IP addresses from the specified subnet.
        """
elif False:
    DbSystemNetworkDetailsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DbSystemNetworkDetailsArgs:
    def __init__(__self__, *,
                 subnet_id: pulumi.Input[_builtins.str],
                 is_reader_endpoint_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 primary_db_endpoint_private_ip: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the customer subnet associated with the database system.
        :param pulumi.Input[_builtins.bool] is_reader_endpoint_enabled: (Updatable) Specifies if the reader endpoint is enabled on the dbSystem.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] nsg_ids: (Updatable) List of customer Network Security Group [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with the database system.
        :param pulumi.Input[_builtins.str] primary_db_endpoint_private_ip: Private IP in customer subnet. The value is optional. If the IP is not provided, the IP will be chosen from the available IP addresses from the specified subnet.
        """
        pulumi.set(__self__, "subnet_id", subnet_id)
        if is_reader_endpoint_enabled is not None:
            pulumi.set(__self__, "is_reader_endpoint_enabled", is_reader_endpoint_enabled)
        if nsg_ids is not None:
            pulumi.set(__self__, "nsg_ids", nsg_ids)
        if primary_db_endpoint_private_ip is not None:
            pulumi.set(__self__, "primary_db_endpoint_private_ip", primary_db_endpoint_private_ip)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the customer subnet associated with the database system.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter(name="isReaderEndpointEnabled")
    def is_reader_endpoint_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Specifies if the reader endpoint is enabled on the dbSystem.
        """
        return pulumi.get(self, "is_reader_endpoint_enabled")

    @is_reader_endpoint_enabled.setter
    def is_reader_endpoint_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_reader_endpoint_enabled", value)

    @_builtins.property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) List of customer Network Security Group [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with the database system.
        """
        return pulumi.get(self, "nsg_ids")

    @nsg_ids.setter
    def nsg_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "nsg_ids", value)

    @_builtins.property
    @pulumi.getter(name="primaryDbEndpointPrivateIp")
    def primary_db_endpoint_private_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Private IP in customer subnet. The value is optional. If the IP is not provided, the IP will be chosen from the available IP addresses from the specified subnet.
        """
        return pulumi.get(self, "primary_db_endpoint_private_ip")

    @primary_db_endpoint_private_ip.setter
    def primary_db_endpoint_private_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "primary_db_endpoint_private_ip", value)


if not MYPY:
    class DbSystemPatchOperationArgsDict(TypedDict):
        operation: pulumi.Input[_builtins.str]
        """
        The operation can be one of these values: `INSERT`, `REMOVE`.
        """
        selection: pulumi.Input[_builtins.str]
        """
        In case of `INSERT`, selection is `instances`. In case of `REMOVE`, selection is `instances[?id == '${var.instance_id}']`.
        """
        from_: NotRequired[pulumi.Input[_builtins.str]]
        position: NotRequired[pulumi.Input[_builtins.str]]
        selected_item: NotRequired[pulumi.Input[_builtins.str]]
        value: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]
        """
        Specify instance details such as displayName, description or privateIp. Example: `{"displayName": "value"}`.
        """
elif False:
    DbSystemPatchOperationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DbSystemPatchOperationArgs:
    def __init__(__self__, *,
                 operation: pulumi.Input[_builtins.str],
                 selection: pulumi.Input[_builtins.str],
                 from_: Optional[pulumi.Input[_builtins.str]] = None,
                 position: Optional[pulumi.Input[_builtins.str]] = None,
                 selected_item: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        :param pulumi.Input[_builtins.str] operation: The operation can be one of these values: `INSERT`, `REMOVE`.
        :param pulumi.Input[_builtins.str] selection: In case of `INSERT`, selection is `instances`. In case of `REMOVE`, selection is `instances[?id == '${var.instance_id}']`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] value: Specify instance details such as displayName, description or privateIp. Example: `{"displayName": "value"}`.
        """
        pulumi.set(__self__, "operation", operation)
        pulumi.set(__self__, "selection", selection)
        if from_ is not None:
            pulumi.set(__self__, "from_", from_)
        if position is not None:
            pulumi.set(__self__, "position", position)
        if selected_item is not None:
            pulumi.set(__self__, "selected_item", selected_item)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def operation(self) -> pulumi.Input[_builtins.str]:
        """
        The operation can be one of these values: `INSERT`, `REMOVE`.
        """
        return pulumi.get(self, "operation")

    @operation.setter
    def operation(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "operation", value)

    @_builtins.property
    @pulumi.getter
    def selection(self) -> pulumi.Input[_builtins.str]:
        """
        In case of `INSERT`, selection is `instances`. In case of `REMOVE`, selection is `instances[?id == '${var.instance_id}']`.
        """
        return pulumi.get(self, "selection")

    @selection.setter
    def selection(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "selection", value)

    @_builtins.property
    @pulumi.getter(name="from")
    def from_(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "from_")

    @from_.setter
    def from_(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "from_", value)

    @_builtins.property
    @pulumi.getter
    def position(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "position")

    @position.setter
    def position(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "position", value)

    @_builtins.property
    @pulumi.getter(name="selectedItem")
    def selected_item(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "selected_item")

    @selected_item.setter
    def selected_item(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "selected_item", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specify instance details such as displayName, description or privateIp. Example: `{"displayName": "value"}`.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "value", value)


if not MYPY:
    class DbSystemSourceArgsDict(TypedDict):
        source_type: pulumi.Input[_builtins.str]
        """
        The source descriminator. Example: `{"source_type": "BACKUP"}`.
        """
        backup_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the database system backup.
        """
        is_having_restore_config_overrides: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Deprecated. Don't use.
        """
elif False:
    DbSystemSourceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DbSystemSourceArgs:
    def __init__(__self__, *,
                 source_type: pulumi.Input[_builtins.str],
                 backup_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_having_restore_config_overrides: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[_builtins.str] source_type: The source descriminator. Example: `{"source_type": "BACKUP"}`.
        :param pulumi.Input[_builtins.str] backup_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the database system backup.
        :param pulumi.Input[_builtins.bool] is_having_restore_config_overrides: Deprecated. Don't use.
        """
        pulumi.set(__self__, "source_type", source_type)
        if backup_id is not None:
            pulumi.set(__self__, "backup_id", backup_id)
        if is_having_restore_config_overrides is not None:
            pulumi.set(__self__, "is_having_restore_config_overrides", is_having_restore_config_overrides)

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> pulumi.Input[_builtins.str]:
        """
        The source descriminator. Example: `{"source_type": "BACKUP"}`.
        """
        return pulumi.get(self, "source_type")

    @source_type.setter
    def source_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "source_type", value)

    @_builtins.property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the database system backup.
        """
        return pulumi.get(self, "backup_id")

    @backup_id.setter
    def backup_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_id", value)

    @_builtins.property
    @pulumi.getter(name="isHavingRestoreConfigOverrides")
    def is_having_restore_config_overrides(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Deprecated. Don't use.
        """
        return pulumi.get(self, "is_having_restore_config_overrides")

    @is_having_restore_config_overrides.setter
    def is_having_restore_config_overrides(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_having_restore_config_overrides", value)


if not MYPY:
    class DbSystemStorageDetailsArgsDict(TypedDict):
        is_regionally_durable: pulumi.Input[_builtins.bool]
        """
        Specifies if the block volume used for the database system is regional or AD-local. If not specified, it will be set to false. If `isRegionallyDurable` is set to true, `availabilityDomain` should not be specified. If `isRegionallyDurable` is set to false, `availabilityDomain` must be specified.
        """
        system_type: pulumi.Input[_builtins.str]
        """
        Type of the database system.
        """
        availability_domain: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the availability domain of AD-local storage. If `isRegionallyDurable` is set to true, `availabilityDomain` should not be specified. If `isRegionallyDurable` is set to false, `availabilityDomain` must be specified.
        """
        iops: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Updatable) Guaranteed input/output storage requests per second (IOPS) available to the database system. Find more about the supported Peformance Tiers [here](https://docs.oracle.com/en-us/iaas/Content/postgresql/performance-tiers.htm).
        """
elif False:
    DbSystemStorageDetailsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DbSystemStorageDetailsArgs:
    def __init__(__self__, *,
                 is_regionally_durable: pulumi.Input[_builtins.bool],
                 system_type: pulumi.Input[_builtins.str],
                 availability_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 iops: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.bool] is_regionally_durable: Specifies if the block volume used for the database system is regional or AD-local. If not specified, it will be set to false. If `isRegionallyDurable` is set to true, `availabilityDomain` should not be specified. If `isRegionallyDurable` is set to false, `availabilityDomain` must be specified.
        :param pulumi.Input[_builtins.str] system_type: Type of the database system.
        :param pulumi.Input[_builtins.str] availability_domain: Specifies the availability domain of AD-local storage. If `isRegionallyDurable` is set to true, `availabilityDomain` should not be specified. If `isRegionallyDurable` is set to false, `availabilityDomain` must be specified.
        :param pulumi.Input[_builtins.str] iops: (Updatable) Guaranteed input/output storage requests per second (IOPS) available to the database system. Find more about the supported Peformance Tiers [here](https://docs.oracle.com/en-us/iaas/Content/postgresql/performance-tiers.htm).
        """
        pulumi.set(__self__, "is_regionally_durable", is_regionally_durable)
        pulumi.set(__self__, "system_type", system_type)
        if availability_domain is not None:
            pulumi.set(__self__, "availability_domain", availability_domain)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)

    @_builtins.property
    @pulumi.getter(name="isRegionallyDurable")
    def is_regionally_durable(self) -> pulumi.Input[_builtins.bool]:
        """
        Specifies if the block volume used for the database system is regional or AD-local. If not specified, it will be set to false. If `isRegionallyDurable` is set to true, `availabilityDomain` should not be specified. If `isRegionallyDurable` is set to false, `availabilityDomain` must be specified.
        """
        return pulumi.get(self, "is_regionally_durable")

    @is_regionally_durable.setter
    def is_regionally_durable(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "is_regionally_durable", value)

    @_builtins.property
    @pulumi.getter(name="systemType")
    def system_type(self) -> pulumi.Input[_builtins.str]:
        """
        Type of the database system.
        """
        return pulumi.get(self, "system_type")

    @system_type.setter
    def system_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "system_type", value)

    @_builtins.property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the availability domain of AD-local storage. If `isRegionallyDurable` is set to true, `availabilityDomain` should not be specified. If `isRegionallyDurable` is set to false, `availabilityDomain` must be specified.
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_domain", value)

    @_builtins.property
    @pulumi.getter
    def iops(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Guaranteed input/output storage requests per second (IOPS) available to the database system. Find more about the supported Peformance Tiers [here](https://docs.oracle.com/en-us/iaas/Content/postgresql/performance-tiers.htm).
        """
        return pulumi.get(self, "iops")

    @iops.setter
    def iops(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "iops", value)


if not MYPY:
    class GetBackupsFilterArgsDict(TypedDict):
        name: _builtins.str
        values: Sequence[_builtins.str]
        regex: NotRequired[_builtins.bool]
elif False:
    GetBackupsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetBackupsFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[_builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetConfigurationsFilterArgsDict(TypedDict):
        name: _builtins.str
        values: Sequence[_builtins.str]
        regex: NotRequired[_builtins.bool]
elif False:
    GetConfigurationsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetConfigurationsFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[_builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetDbSystemsFilterArgsDict(TypedDict):
        name: _builtins.str
        values: Sequence[_builtins.str]
        regex: NotRequired[_builtins.bool]
elif False:
    GetDbSystemsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetDbSystemsFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[_builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetDefaultConfigurationsFilterArgsDict(TypedDict):
        name: _builtins.str
        values: Sequence[_builtins.str]
        regex: NotRequired[_builtins.bool]
elif False:
    GetDefaultConfigurationsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetDefaultConfigurationsFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[_builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetShapesFilterArgsDict(TypedDict):
        name: _builtins.str
        values: Sequence[_builtins.str]
        regex: NotRequired[_builtins.bool]
elif False:
    GetShapesFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetShapesFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[_builtins.bool]):
        pulumi.set(self, "regex", value)


