# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetShapesResult',
    'AwaitableGetShapesResult',
    'get_shapes',
    'get_shapes_output',
]

@pulumi.output_type
class GetShapesResult:
    """
    A collection of values returned by getShapes.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, shape_collections=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if shape_collections and not isinstance(shape_collections, list):
            raise TypeError("Expected argument 'shape_collections' to be a list")
        pulumi.set(__self__, "shape_collections", shape_collections)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetShapesFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        A unique identifier for the shape.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="shapeCollections")
    def shape_collections(self) -> Sequence['outputs.GetShapesShapeCollectionResult']:
        """
        The list of shape_collection.
        """
        return pulumi.get(self, "shape_collections")


class AwaitableGetShapesResult(GetShapesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetShapesResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            shape_collections=self.shape_collections)


def get_shapes(compartment_id: Optional[_builtins.str] = None,
               filters: Optional[Sequence[Union['GetShapesFilterArgs', 'GetShapesFilterArgsDict']]] = None,
               id: Optional[_builtins.str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetShapesResult:
    """
    This data source provides the list of Shapes in Oracle Cloud Infrastructure Psql service.

    Returns the list of shapes allowed in the region.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_shapes = oci.Psql.get_shapes(compartment_id=compartment_id,
        id=shape_id)
    ```


    :param _builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param _builtins.str id: A filter to return the feature by the shape name.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Psql/getShapes:getShapes', __args__, opts=opts, typ=GetShapesResult).value

    return AwaitableGetShapesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        shape_collections=pulumi.get(__ret__, 'shape_collections'))
def get_shapes_output(compartment_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      filters: Optional[pulumi.Input[Optional[Sequence[Union['GetShapesFilterArgs', 'GetShapesFilterArgsDict']]]]] = None,
                      id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetShapesResult]:
    """
    This data source provides the list of Shapes in Oracle Cloud Infrastructure Psql service.

    Returns the list of shapes allowed in the region.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_shapes = oci.Psql.get_shapes(compartment_id=compartment_id,
        id=shape_id)
    ```


    :param _builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param _builtins.str id: A filter to return the feature by the shape name.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Psql/getShapes:getShapes', __args__, opts=opts, typ=GetShapesResult)
    return __ret__.apply(lambda __response__: GetShapesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        shape_collections=pulumi.get(__response__, 'shape_collections')))
