# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetProtectedDatabasesResult',
    'AwaitableGetProtectedDatabasesResult',
    'get_protected_databases',
    'get_protected_databases_output',
]

@pulumi.output_type
class GetProtectedDatabasesResult:
    """
    A collection of values returned by getProtectedDatabases.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, protected_database_collections=None, protection_policy_id=None, recovery_service_subnet_id=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if protected_database_collections and not isinstance(protected_database_collections, list):
            raise TypeError("Expected argument 'protected_database_collections' to be a list")
        pulumi.set(__self__, "protected_database_collections", protected_database_collections)
        if protection_policy_id and not isinstance(protection_policy_id, str):
            raise TypeError("Expected argument 'protection_policy_id' to be a str")
        pulumi.set(__self__, "protection_policy_id", protection_policy_id)
        if recovery_service_subnet_id and not isinstance(recovery_service_subnet_id, str):
            raise TypeError("Expected argument 'recovery_service_subnet_id' to be a str")
        pulumi.set(__self__, "recovery_service_subnet_id", recovery_service_subnet_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the compartment that contains the protected database.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        The protected database name. You can change the displayName. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetProtectedDatabasesFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The OCID of the protected database.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="protectedDatabaseCollections")
    def protected_database_collections(self) -> Sequence['outputs.GetProtectedDatabasesProtectedDatabaseCollectionResult']:
        """
        The list of protected_database_collection.
        """
        return pulumi.get(self, "protected_database_collections")

    @_builtins.property
    @pulumi.getter(name="protectionPolicyId")
    def protection_policy_id(self) -> Optional[_builtins.str]:
        """
        The OCID of the protection policy associated with the protected database.
        """
        return pulumi.get(self, "protection_policy_id")

    @_builtins.property
    @pulumi.getter(name="recoveryServiceSubnetId")
    def recovery_service_subnet_id(self) -> Optional[_builtins.str]:
        """
        Recovery Service Subnet Identifier.
        """
        return pulumi.get(self, "recovery_service_subnet_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current state of the Protected Database.
        """
        return pulumi.get(self, "state")


class AwaitableGetProtectedDatabasesResult(GetProtectedDatabasesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProtectedDatabasesResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            protected_database_collections=self.protected_database_collections,
            protection_policy_id=self.protection_policy_id,
            recovery_service_subnet_id=self.recovery_service_subnet_id,
            state=self.state)


def get_protected_databases(compartment_id: Optional[_builtins.str] = None,
                            display_name: Optional[_builtins.str] = None,
                            filters: Optional[Sequence[Union['GetProtectedDatabasesFilterArgs', 'GetProtectedDatabasesFilterArgsDict']]] = None,
                            id: Optional[_builtins.str] = None,
                            protection_policy_id: Optional[_builtins.str] = None,
                            recovery_service_subnet_id: Optional[_builtins.str] = None,
                            state: Optional[_builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProtectedDatabasesResult:
    """
    This data source provides the list of Protected Databases in Oracle Cloud Infrastructure Recovery service.

    Lists the protected databases based on the specified parameters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_protected_databases = oci.RecoveryMod.get_protected_databases(compartment_id=compartment_id,
        display_name=protected_database_display_name,
        id=protected_database_id,
        protection_policy_id=test_protection_policy["id"],
        recovery_service_subnet_id=test_recovery_service_subnet["id"],
        state=protected_database_state)
    ```


    :param _builtins.str compartment_id: The compartment OCID.
    :param _builtins.str display_name: A filter to return only resources that match the entire 'displayname' given.
    :param _builtins.str id: The protected database OCID.
    :param _builtins.str protection_policy_id: The protection policy OCID.
    :param _builtins.str recovery_service_subnet_id: The recovery service subnet OCID.
    :param _builtins.str state: A filter to return only the resources that match the specified lifecycle state.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['protectionPolicyId'] = protection_policy_id
    __args__['recoveryServiceSubnetId'] = recovery_service_subnet_id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:RecoveryMod/getProtectedDatabases:getProtectedDatabases', __args__, opts=opts, typ=GetProtectedDatabasesResult).value

    return AwaitableGetProtectedDatabasesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        protected_database_collections=pulumi.get(__ret__, 'protected_database_collections'),
        protection_policy_id=pulumi.get(__ret__, 'protection_policy_id'),
        recovery_service_subnet_id=pulumi.get(__ret__, 'recovery_service_subnet_id'),
        state=pulumi.get(__ret__, 'state'))
def get_protected_databases_output(compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                   display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   filters: Optional[pulumi.Input[Optional[Sequence[Union['GetProtectedDatabasesFilterArgs', 'GetProtectedDatabasesFilterArgsDict']]]]] = None,
                                   id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   protection_policy_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   recovery_service_subnet_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetProtectedDatabasesResult]:
    """
    This data source provides the list of Protected Databases in Oracle Cloud Infrastructure Recovery service.

    Lists the protected databases based on the specified parameters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_protected_databases = oci.RecoveryMod.get_protected_databases(compartment_id=compartment_id,
        display_name=protected_database_display_name,
        id=protected_database_id,
        protection_policy_id=test_protection_policy["id"],
        recovery_service_subnet_id=test_recovery_service_subnet["id"],
        state=protected_database_state)
    ```


    :param _builtins.str compartment_id: The compartment OCID.
    :param _builtins.str display_name: A filter to return only resources that match the entire 'displayname' given.
    :param _builtins.str id: The protected database OCID.
    :param _builtins.str protection_policy_id: The protection policy OCID.
    :param _builtins.str recovery_service_subnet_id: The recovery service subnet OCID.
    :param _builtins.str state: A filter to return only the resources that match the specified lifecycle state.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['protectionPolicyId'] = protection_policy_id
    __args__['recoveryServiceSubnetId'] = recovery_service_subnet_id
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:RecoveryMod/getProtectedDatabases:getProtectedDatabases', __args__, opts=opts, typ=GetProtectedDatabasesResult)
    return __ret__.apply(lambda __response__: GetProtectedDatabasesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        protected_database_collections=pulumi.get(__response__, 'protected_database_collections'),
        protection_policy_id=pulumi.get(__response__, 'protection_policy_id'),
        recovery_service_subnet_id=pulumi.get(__response__, 'recovery_service_subnet_id'),
        state=pulumi.get(__response__, 'state')))
