# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetOciCacheUsersResult',
    'AwaitableGetOciCacheUsersResult',
    'get_oci_cache_users',
    'get_oci_cache_users_output',
]

@pulumi.output_type
class GetOciCacheUsersResult:
    """
    A collection of values returned by getOciCacheUsers.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, name=None, oci_cache_user_collections=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if oci_cache_user_collections and not isinstance(oci_cache_user_collections, list):
            raise TypeError("Expected argument 'oci_cache_user_collections' to be a list")
        pulumi.set(__self__, "oci_cache_user_collections", oci_cache_user_collections)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[_builtins.str]:
        """
        Oracle Cloud Infrastructure Cache user compartment ID.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetOciCacheUsersFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Oracle Cloud Infrastructure Cache user name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="ociCacheUserCollections")
    def oci_cache_user_collections(self) -> Sequence['outputs.GetOciCacheUsersOciCacheUserCollectionResult']:
        """
        The list of oci_cache_user_collection.
        """
        return pulumi.get(self, "oci_cache_user_collections")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        Oracle Cloud Infrastructure Cache user lifecycle state.
        """
        return pulumi.get(self, "state")


class AwaitableGetOciCacheUsersResult(GetOciCacheUsersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOciCacheUsersResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            name=self.name,
            oci_cache_user_collections=self.oci_cache_user_collections,
            state=self.state)


def get_oci_cache_users(compartment_id: Optional[_builtins.str] = None,
                        filters: Optional[Sequence[Union['GetOciCacheUsersFilterArgs', 'GetOciCacheUsersFilterArgsDict']]] = None,
                        name: Optional[_builtins.str] = None,
                        state: Optional[_builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOciCacheUsersResult:
    """
    This data source provides the list of Oci Cache Users in Oracle Cloud Infrastructure Redis service.

    Lists the Oracle Cloud Infrastructure Cache users based on the supplied parameters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_oci_cache_users = oci.Redis.get_oci_cache_users(compartment_id=compartment_id,
        name=oci_cache_user_name,
        state=oci_cache_user_state)
    ```


    :param _builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param _builtins.str name: A filter to return the resources that match with the given Oracle Cloud Infrastructure cache user name.
    :param _builtins.str state: A filter to return the resources, whose lifecycleState matches with the given lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Redis/getOciCacheUsers:getOciCacheUsers', __args__, opts=opts, typ=GetOciCacheUsersResult).value

    return AwaitableGetOciCacheUsersResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        oci_cache_user_collections=pulumi.get(__ret__, 'oci_cache_user_collections'),
        state=pulumi.get(__ret__, 'state'))
def get_oci_cache_users_output(compartment_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               filters: Optional[pulumi.Input[Optional[Sequence[Union['GetOciCacheUsersFilterArgs', 'GetOciCacheUsersFilterArgsDict']]]]] = None,
                               name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetOciCacheUsersResult]:
    """
    This data source provides the list of Oci Cache Users in Oracle Cloud Infrastructure Redis service.

    Lists the Oracle Cloud Infrastructure Cache users based on the supplied parameters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_oci_cache_users = oci.Redis.get_oci_cache_users(compartment_id=compartment_id,
        name=oci_cache_user_name,
        state=oci_cache_user_state)
    ```


    :param _builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param _builtins.str name: A filter to return the resources that match with the given Oracle Cloud Infrastructure cache user name.
    :param _builtins.str state: A filter to return the resources, whose lifecycleState matches with the given lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Redis/getOciCacheUsers:getOciCacheUsers', __args__, opts=opts, typ=GetOciCacheUsersResult)
    return __ret__.apply(lambda __response__: GetOciCacheUsersResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        oci_cache_user_collections=pulumi.get(__response__, 'oci_cache_user_collections'),
        state=pulumi.get(__response__, 'state')))
