# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RedisClusterGetOciCacheUserArgs', 'RedisClusterGetOciCacheUser']

@pulumi.input_type
class RedisClusterGetOciCacheUserArgs:
    def __init__(__self__, *,
                 redis_cluster_id: pulumi.Input[_builtins.str],
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a RedisClusterGetOciCacheUser resource.
        :param pulumi.Input[_builtins.str] redis_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle) of the cluster.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] compartment_id: The ID of the compartment in which to list resources.
        :param pulumi.Input[_builtins.str] display_name: A filter to return only resources that match the entire display name given.
        """
        pulumi.set(__self__, "redis_cluster_id", redis_cluster_id)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)

    @_builtins.property
    @pulumi.getter(name="redisClusterId")
    def redis_cluster_id(self) -> pulumi.Input[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle) of the cluster.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "redis_cluster_id")

    @redis_cluster_id.setter
    def redis_cluster_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "redis_cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)


@pulumi.input_type
class _RedisClusterGetOciCacheUserState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 oci_cache_users: Optional[pulumi.Input[Sequence[pulumi.Input['RedisClusterGetOciCacheUserOciCacheUserArgs']]]] = None,
                 redis_cluster_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RedisClusterGetOciCacheUser resources.
        :param pulumi.Input[_builtins.str] compartment_id: The ID of the compartment in which to list resources.
        :param pulumi.Input[_builtins.str] display_name: A filter to return only resources that match the entire display name given.
        :param pulumi.Input[_builtins.str] redis_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle) of the cluster.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if oci_cache_users is not None:
            pulumi.set(__self__, "oci_cache_users", oci_cache_users)
        if redis_cluster_id is not None:
            pulumi.set(__self__, "redis_cluster_id", redis_cluster_id)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="ociCacheUsers")
    def oci_cache_users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RedisClusterGetOciCacheUserOciCacheUserArgs']]]]:
        return pulumi.get(self, "oci_cache_users")

    @oci_cache_users.setter
    def oci_cache_users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RedisClusterGetOciCacheUserOciCacheUserArgs']]]]):
        pulumi.set(self, "oci_cache_users", value)

    @_builtins.property
    @pulumi.getter(name="redisClusterId")
    def redis_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle) of the cluster.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "redis_cluster_id")

    @redis_cluster_id.setter
    def redis_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "redis_cluster_id", value)


@pulumi.type_token("oci:Redis/redisClusterGetOciCacheUser:RedisClusterGetOciCacheUser")
class RedisClusterGetOciCacheUser(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 redis_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Redis Cluster Get Oci Cache User resource in Oracle Cloud Infrastructure Redis service.

        Gets a list of associated Oracle Cloud Infrastructure cache users for a redis cluster.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_redis_cluster_get_oci_cache_user = oci.redis.RedisClusterGetOciCacheUser("test_redis_cluster_get_oci_cache_user",
            redis_cluster_id=test_redis_cluster["id"],
            compartment_id=compartment_id,
            display_name=redis_cluster_get_oci_cache_user_display_name)
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: The ID of the compartment in which to list resources.
        :param pulumi.Input[_builtins.str] display_name: A filter to return only resources that match the entire display name given.
        :param pulumi.Input[_builtins.str] redis_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle) of the cluster.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RedisClusterGetOciCacheUserArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Redis Cluster Get Oci Cache User resource in Oracle Cloud Infrastructure Redis service.

        Gets a list of associated Oracle Cloud Infrastructure cache users for a redis cluster.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_redis_cluster_get_oci_cache_user = oci.redis.RedisClusterGetOciCacheUser("test_redis_cluster_get_oci_cache_user",
            redis_cluster_id=test_redis_cluster["id"],
            compartment_id=compartment_id,
            display_name=redis_cluster_get_oci_cache_user_display_name)
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param RedisClusterGetOciCacheUserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RedisClusterGetOciCacheUserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 redis_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RedisClusterGetOciCacheUserArgs.__new__(RedisClusterGetOciCacheUserArgs)

            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["display_name"] = display_name
            if redis_cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'redis_cluster_id'")
            __props__.__dict__["redis_cluster_id"] = redis_cluster_id
            __props__.__dict__["oci_cache_users"] = None
        super(RedisClusterGetOciCacheUser, __self__).__init__(
            'oci:Redis/redisClusterGetOciCacheUser:RedisClusterGetOciCacheUser',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            oci_cache_users: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RedisClusterGetOciCacheUserOciCacheUserArgs', 'RedisClusterGetOciCacheUserOciCacheUserArgsDict']]]]] = None,
            redis_cluster_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'RedisClusterGetOciCacheUser':
        """
        Get an existing RedisClusterGetOciCacheUser resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: The ID of the compartment in which to list resources.
        :param pulumi.Input[_builtins.str] display_name: A filter to return only resources that match the entire display name given.
        :param pulumi.Input[_builtins.str] redis_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle) of the cluster.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RedisClusterGetOciCacheUserState.__new__(_RedisClusterGetOciCacheUserState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["oci_cache_users"] = oci_cache_users
        __props__.__dict__["redis_cluster_id"] = redis_cluster_id
        return RedisClusterGetOciCacheUser(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="ociCacheUsers")
    def oci_cache_users(self) -> pulumi.Output[Sequence['outputs.RedisClusterGetOciCacheUserOciCacheUser']]:
        return pulumi.get(self, "oci_cache_users")

    @_builtins.property
    @pulumi.getter(name="redisClusterId")
    def redis_cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle) of the cluster.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "redis_cluster_id")

