# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSchedulesResult',
    'AwaitableGetSchedulesResult',
    'get_schedules',
    'get_schedules_output',
]

@pulumi.output_type
class GetSchedulesResult:
    """
    A collection of values returned by getSchedules.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, resource_id=None, schedule_collections=None, schedule_id=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if resource_id and not isinstance(resource_id, str):
            raise TypeError("Expected argument 'resource_id' to be a str")
        pulumi.set(__self__, "resource_id", resource_id)
        if schedule_collections and not isinstance(schedule_collections, list):
            raise TypeError("Expected argument 'schedule_collections' to be a list")
        pulumi.set(__self__, "schedule_collections", schedule_collections)
        if schedule_id and not isinstance(schedule_id, str):
            raise TypeError("Expected argument 'schedule_id' to be a str")
        pulumi.set(__self__, "schedule_id", schedule_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which the schedule is created
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        This is a user-friendly name for the schedule. It does not have to be unique, and it's changeable.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetSchedulesFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter(name="scheduleCollections")
    def schedule_collections(self) -> Sequence['outputs.GetSchedulesScheduleCollectionResult']:
        """
        The list of schedule_collection.
        """
        return pulumi.get(self, "schedule_collections")

    @_builtins.property
    @pulumi.getter(name="scheduleId")
    def schedule_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "schedule_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        This is the current state of a schedule.
        """
        return pulumi.get(self, "state")


class AwaitableGetSchedulesResult(GetSchedulesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSchedulesResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            resource_id=self.resource_id,
            schedule_collections=self.schedule_collections,
            schedule_id=self.schedule_id,
            state=self.state)


def get_schedules(compartment_id: Optional[_builtins.str] = None,
                  display_name: Optional[_builtins.str] = None,
                  filters: Optional[Sequence[Union['GetSchedulesFilterArgs', 'GetSchedulesFilterArgsDict']]] = None,
                  resource_id: Optional[_builtins.str] = None,
                  schedule_id: Optional[_builtins.str] = None,
                  state: Optional[_builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSchedulesResult:
    """
    This data source provides the list of Schedules in Oracle Cloud Infrastructure Resource Scheduler service.

    This API gets a list of schedules. You must provide either a compartmentId or a scheduleId or both. You can list resources in this compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). This is required unless a specific schedule ID is passed.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_schedules = oci.ResourceScheduler.get_schedules(compartment_id=compartment_id,
        display_name=schedule_display_name,
        resource_id=test_resource["id"])
    ```


    :param _builtins.str compartment_id: This is the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources. You need to at least provide either `compartment_id` or `schedule_id` or both.
    :param _builtins.str display_name: This is a filter to return only resources that match the given display name exactly.
    :param _builtins.str resource_id: This is the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the resource affected by the work request.
    :param _builtins.str schedule_id: This is the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the schedule.  You need to at least provide either `compartment_id` or `schedule_id` or both.
    :param _builtins.str state: This is a filter to return only resources that match the given lifecycle state. The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['resourceId'] = resource_id
    __args__['scheduleId'] = schedule_id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ResourceScheduler/getSchedules:getSchedules', __args__, opts=opts, typ=GetSchedulesResult).value

    return AwaitableGetSchedulesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        resource_id=pulumi.get(__ret__, 'resource_id'),
        schedule_collections=pulumi.get(__ret__, 'schedule_collections'),
        schedule_id=pulumi.get(__ret__, 'schedule_id'),
        state=pulumi.get(__ret__, 'state'))
def get_schedules_output(compartment_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         filters: Optional[pulumi.Input[Optional[Sequence[Union['GetSchedulesFilterArgs', 'GetSchedulesFilterArgsDict']]]]] = None,
                         resource_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         schedule_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSchedulesResult]:
    """
    This data source provides the list of Schedules in Oracle Cloud Infrastructure Resource Scheduler service.

    This API gets a list of schedules. You must provide either a compartmentId or a scheduleId or both. You can list resources in this compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). This is required unless a specific schedule ID is passed.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_schedules = oci.ResourceScheduler.get_schedules(compartment_id=compartment_id,
        display_name=schedule_display_name,
        resource_id=test_resource["id"])
    ```


    :param _builtins.str compartment_id: This is the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources. You need to at least provide either `compartment_id` or `schedule_id` or both.
    :param _builtins.str display_name: This is a filter to return only resources that match the given display name exactly.
    :param _builtins.str resource_id: This is the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the resource affected by the work request.
    :param _builtins.str schedule_id: This is the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the schedule.  You need to at least provide either `compartment_id` or `schedule_id` or both.
    :param _builtins.str state: This is a filter to return only resources that match the given lifecycle state. The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['resourceId'] = resource_id
    __args__['scheduleId'] = schedule_id
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:ResourceScheduler/getSchedules:getSchedules', __args__, opts=opts, typ=GetSchedulesResult)
    return __ret__.apply(lambda __response__: GetSchedulesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        resource_id=pulumi.get(__response__, 'resource_id'),
        schedule_collections=pulumi.get(__response__, 'schedule_collections'),
        schedule_id=pulumi.get(__response__, 'schedule_id'),
        state=pulumi.get(__response__, 'state')))
