# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetServiceCatalogAssociationResult',
    'AwaitableGetServiceCatalogAssociationResult',
    'get_service_catalog_association',
    'get_service_catalog_association_output',
]

@pulumi.output_type
class GetServiceCatalogAssociationResult:
    """
    A collection of values returned by getServiceCatalogAssociation.
    """
    def __init__(__self__, entity_id=None, entity_type=None, id=None, service_catalog_association_id=None, service_catalog_id=None, time_created=None):
        if entity_id and not isinstance(entity_id, str):
            raise TypeError("Expected argument 'entity_id' to be a str")
        pulumi.set(__self__, "entity_id", entity_id)
        if entity_type and not isinstance(entity_type, str):
            raise TypeError("Expected argument 'entity_type' to be a str")
        pulumi.set(__self__, "entity_type", entity_type)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if service_catalog_association_id and not isinstance(service_catalog_association_id, str):
            raise TypeError("Expected argument 'service_catalog_association_id' to be a str")
        pulumi.set(__self__, "service_catalog_association_id", service_catalog_association_id)
        if service_catalog_id and not isinstance(service_catalog_id, str):
            raise TypeError("Expected argument 'service_catalog_id' to be a str")
        pulumi.set(__self__, "service_catalog_id", service_catalog_id)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)

    @_builtins.property
    @pulumi.getter(name="entityId")
    def entity_id(self) -> _builtins.str:
        """
        Identifier of the entity being associated with service catalog.
        """
        return pulumi.get(self, "entity_id")

    @_builtins.property
    @pulumi.getter(name="entityType")
    def entity_type(self) -> _builtins.str:
        """
        The type of the entity that is associated with the service catalog.
        """
        return pulumi.get(self, "entity_type")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Identifier of the association.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="serviceCatalogAssociationId")
    def service_catalog_association_id(self) -> _builtins.str:
        return pulumi.get(self, "service_catalog_association_id")

    @_builtins.property
    @pulumi.getter(name="serviceCatalogId")
    def service_catalog_id(self) -> _builtins.str:
        """
        Identifier of the service catalog.
        """
        return pulumi.get(self, "service_catalog_id")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        Timestamp of when the resource was associated with service catalog.
        """
        return pulumi.get(self, "time_created")


class AwaitableGetServiceCatalogAssociationResult(GetServiceCatalogAssociationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServiceCatalogAssociationResult(
            entity_id=self.entity_id,
            entity_type=self.entity_type,
            id=self.id,
            service_catalog_association_id=self.service_catalog_association_id,
            service_catalog_id=self.service_catalog_id,
            time_created=self.time_created)


def get_service_catalog_association(service_catalog_association_id: Optional[_builtins.str] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServiceCatalogAssociationResult:
    """
    This data source provides details about a specific Service Catalog Association resource in Oracle Cloud Infrastructure Service Catalog service.

    Gets detailed information about specific service catalog association.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_service_catalog_association = oci.ServiceCatalog.get_service_catalog_association(service_catalog_association_id=test_service_catalog_association_oci_service_catalog_service_catalog_association["id"])
    ```


    :param _builtins.str service_catalog_association_id: The unique identifier of the service catalog association.
    """
    __args__ = dict()
    __args__['serviceCatalogAssociationId'] = service_catalog_association_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ServiceCatalog/getServiceCatalogAssociation:getServiceCatalogAssociation', __args__, opts=opts, typ=GetServiceCatalogAssociationResult).value

    return AwaitableGetServiceCatalogAssociationResult(
        entity_id=pulumi.get(__ret__, 'entity_id'),
        entity_type=pulumi.get(__ret__, 'entity_type'),
        id=pulumi.get(__ret__, 'id'),
        service_catalog_association_id=pulumi.get(__ret__, 'service_catalog_association_id'),
        service_catalog_id=pulumi.get(__ret__, 'service_catalog_id'),
        time_created=pulumi.get(__ret__, 'time_created'))
def get_service_catalog_association_output(service_catalog_association_id: Optional[pulumi.Input[_builtins.str]] = None,
                                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetServiceCatalogAssociationResult]:
    """
    This data source provides details about a specific Service Catalog Association resource in Oracle Cloud Infrastructure Service Catalog service.

    Gets detailed information about specific service catalog association.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_service_catalog_association = oci.ServiceCatalog.get_service_catalog_association(service_catalog_association_id=test_service_catalog_association_oci_service_catalog_service_catalog_association["id"])
    ```


    :param _builtins.str service_catalog_association_id: The unique identifier of the service catalog association.
    """
    __args__ = dict()
    __args__['serviceCatalogAssociationId'] = service_catalog_association_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:ServiceCatalog/getServiceCatalogAssociation:getServiceCatalogAssociation', __args__, opts=opts, typ=GetServiceCatalogAssociationResult)
    return __ret__.apply(lambda __response__: GetServiceCatalogAssociationResult(
        entity_id=pulumi.get(__response__, 'entity_id'),
        entity_type=pulumi.get(__response__, 'entity_type'),
        id=pulumi.get(__response__, 'id'),
        service_catalog_association_id=pulumi.get(__response__, 'service_catalog_association_id'),
        service_catalog_id=pulumi.get(__response__, 'service_catalog_id'),
        time_created=pulumi.get(__response__, 'time_created')))
