# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetServiceCatalogAssociationsResult',
    'AwaitableGetServiceCatalogAssociationsResult',
    'get_service_catalog_associations',
    'get_service_catalog_associations_output',
]

@pulumi.output_type
class GetServiceCatalogAssociationsResult:
    """
    A collection of values returned by getServiceCatalogAssociations.
    """
    def __init__(__self__, entity_id=None, entity_type=None, filters=None, id=None, service_catalog_association_collections=None, service_catalog_association_id=None, service_catalog_id=None):
        if entity_id and not isinstance(entity_id, str):
            raise TypeError("Expected argument 'entity_id' to be a str")
        pulumi.set(__self__, "entity_id", entity_id)
        if entity_type and not isinstance(entity_type, str):
            raise TypeError("Expected argument 'entity_type' to be a str")
        pulumi.set(__self__, "entity_type", entity_type)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if service_catalog_association_collections and not isinstance(service_catalog_association_collections, list):
            raise TypeError("Expected argument 'service_catalog_association_collections' to be a list")
        pulumi.set(__self__, "service_catalog_association_collections", service_catalog_association_collections)
        if service_catalog_association_id and not isinstance(service_catalog_association_id, str):
            raise TypeError("Expected argument 'service_catalog_association_id' to be a str")
        pulumi.set(__self__, "service_catalog_association_id", service_catalog_association_id)
        if service_catalog_id and not isinstance(service_catalog_id, str):
            raise TypeError("Expected argument 'service_catalog_id' to be a str")
        pulumi.set(__self__, "service_catalog_id", service_catalog_id)

    @_builtins.property
    @pulumi.getter(name="entityId")
    def entity_id(self) -> Optional[_builtins.str]:
        """
        Identifier of the entity being associated with service catalog.
        """
        return pulumi.get(self, "entity_id")

    @_builtins.property
    @pulumi.getter(name="entityType")
    def entity_type(self) -> Optional[_builtins.str]:
        """
        The type of the entity that is associated with the service catalog.
        """
        return pulumi.get(self, "entity_type")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetServiceCatalogAssociationsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="serviceCatalogAssociationCollections")
    def service_catalog_association_collections(self) -> Sequence['outputs.GetServiceCatalogAssociationsServiceCatalogAssociationCollectionResult']:
        """
        The list of service_catalog_association_collection.
        """
        return pulumi.get(self, "service_catalog_association_collections")

    @_builtins.property
    @pulumi.getter(name="serviceCatalogAssociationId")
    def service_catalog_association_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "service_catalog_association_id")

    @_builtins.property
    @pulumi.getter(name="serviceCatalogId")
    def service_catalog_id(self) -> Optional[_builtins.str]:
        """
        Identifier of the service catalog.
        """
        return pulumi.get(self, "service_catalog_id")


class AwaitableGetServiceCatalogAssociationsResult(GetServiceCatalogAssociationsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServiceCatalogAssociationsResult(
            entity_id=self.entity_id,
            entity_type=self.entity_type,
            filters=self.filters,
            id=self.id,
            service_catalog_association_collections=self.service_catalog_association_collections,
            service_catalog_association_id=self.service_catalog_association_id,
            service_catalog_id=self.service_catalog_id)


def get_service_catalog_associations(entity_id: Optional[_builtins.str] = None,
                                     entity_type: Optional[_builtins.str] = None,
                                     filters: Optional[Sequence[Union['GetServiceCatalogAssociationsFilterArgs', 'GetServiceCatalogAssociationsFilterArgsDict']]] = None,
                                     service_catalog_association_id: Optional[_builtins.str] = None,
                                     service_catalog_id: Optional[_builtins.str] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServiceCatalogAssociationsResult:
    """
    This data source provides the list of Service Catalog Associations in Oracle Cloud Infrastructure Service Catalog service.

    Lists all the resource associations for a specific service catalog.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_service_catalog_associations = oci.ServiceCatalog.get_service_catalog_associations(entity_id=test_entity["id"],
        entity_type=service_catalog_association_entity_type,
        service_catalog_association_id=test_service_catalog_association["id"],
        service_catalog_id=test_service_catalog["id"])
    ```


    :param _builtins.str entity_id: The unique identifier of the entity associated with service catalog.
    :param _builtins.str entity_type: The type of the application in the service catalog.
    :param _builtins.str service_catalog_association_id: The unique identifier for the service catalog association.
    :param _builtins.str service_catalog_id: The unique identifier for the service catalog.
    """
    __args__ = dict()
    __args__['entityId'] = entity_id
    __args__['entityType'] = entity_type
    __args__['filters'] = filters
    __args__['serviceCatalogAssociationId'] = service_catalog_association_id
    __args__['serviceCatalogId'] = service_catalog_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ServiceCatalog/getServiceCatalogAssociations:getServiceCatalogAssociations', __args__, opts=opts, typ=GetServiceCatalogAssociationsResult).value

    return AwaitableGetServiceCatalogAssociationsResult(
        entity_id=pulumi.get(__ret__, 'entity_id'),
        entity_type=pulumi.get(__ret__, 'entity_type'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        service_catalog_association_collections=pulumi.get(__ret__, 'service_catalog_association_collections'),
        service_catalog_association_id=pulumi.get(__ret__, 'service_catalog_association_id'),
        service_catalog_id=pulumi.get(__ret__, 'service_catalog_id'))
def get_service_catalog_associations_output(entity_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                            entity_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                            filters: Optional[pulumi.Input[Optional[Sequence[Union['GetServiceCatalogAssociationsFilterArgs', 'GetServiceCatalogAssociationsFilterArgsDict']]]]] = None,
                                            service_catalog_association_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                            service_catalog_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetServiceCatalogAssociationsResult]:
    """
    This data source provides the list of Service Catalog Associations in Oracle Cloud Infrastructure Service Catalog service.

    Lists all the resource associations for a specific service catalog.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_service_catalog_associations = oci.ServiceCatalog.get_service_catalog_associations(entity_id=test_entity["id"],
        entity_type=service_catalog_association_entity_type,
        service_catalog_association_id=test_service_catalog_association["id"],
        service_catalog_id=test_service_catalog["id"])
    ```


    :param _builtins.str entity_id: The unique identifier of the entity associated with service catalog.
    :param _builtins.str entity_type: The type of the application in the service catalog.
    :param _builtins.str service_catalog_association_id: The unique identifier for the service catalog association.
    :param _builtins.str service_catalog_id: The unique identifier for the service catalog.
    """
    __args__ = dict()
    __args__['entityId'] = entity_id
    __args__['entityType'] = entity_type
    __args__['filters'] = filters
    __args__['serviceCatalogAssociationId'] = service_catalog_association_id
    __args__['serviceCatalogId'] = service_catalog_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:ServiceCatalog/getServiceCatalogAssociations:getServiceCatalogAssociations', __args__, opts=opts, typ=GetServiceCatalogAssociationsResult)
    return __ret__.apply(lambda __response__: GetServiceCatalogAssociationsResult(
        entity_id=pulumi.get(__response__, 'entity_id'),
        entity_type=pulumi.get(__response__, 'entity_type'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        service_catalog_association_collections=pulumi.get(__response__, 'service_catalog_association_collections'),
        service_catalog_association_id=pulumi.get(__response__, 'service_catalog_association_id'),
        service_catalog_id=pulumi.get(__response__, 'service_catalog_id')))
