# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetBaselineableMetricResult',
    'AwaitableGetBaselineableMetricResult',
    'get_baselineable_metric',
    'get_baselineable_metric_output',
]

@pulumi.output_type
class GetBaselineableMetricResult:
    """
    A collection of values returned by getBaselineableMetric.
    """
    def __init__(__self__, baselineable_metric_id=None, column=None, compartment_id=None, created_by=None, defined_tags=None, freeform_tags=None, id=None, is_out_of_box=None, last_updated_by=None, name=None, namespace=None, resource_group=None, resource_type=None, state=None, system_tags=None, tenancy_id=None, time_created=None, time_last_updated=None):
        if baselineable_metric_id and not isinstance(baselineable_metric_id, str):
            raise TypeError("Expected argument 'baselineable_metric_id' to be a str")
        pulumi.set(__self__, "baselineable_metric_id", baselineable_metric_id)
        if column and not isinstance(column, str):
            raise TypeError("Expected argument 'column' to be a str")
        pulumi.set(__self__, "column", column)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if created_by and not isinstance(created_by, str):
            raise TypeError("Expected argument 'created_by' to be a str")
        pulumi.set(__self__, "created_by", created_by)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_out_of_box and not isinstance(is_out_of_box, bool):
            raise TypeError("Expected argument 'is_out_of_box' to be a bool")
        pulumi.set(__self__, "is_out_of_box", is_out_of_box)
        if last_updated_by and not isinstance(last_updated_by, str):
            raise TypeError("Expected argument 'last_updated_by' to be a str")
        pulumi.set(__self__, "last_updated_by", last_updated_by)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if resource_group and not isinstance(resource_group, str):
            raise TypeError("Expected argument 'resource_group' to be a str")
        pulumi.set(__self__, "resource_group", resource_group)
        if resource_type and not isinstance(resource_type, str):
            raise TypeError("Expected argument 'resource_type' to be a str")
        pulumi.set(__self__, "resource_type", resource_type)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if tenancy_id and not isinstance(tenancy_id, str):
            raise TypeError("Expected argument 'tenancy_id' to be a str")
        pulumi.set(__self__, "tenancy_id", tenancy_id)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_last_updated and not isinstance(time_last_updated, str):
            raise TypeError("Expected argument 'time_last_updated' to be a str")
        pulumi.set(__self__, "time_last_updated", time_last_updated)

    @_builtins.property
    @pulumi.getter(name="baselineableMetricId")
    def baselineable_metric_id(self) -> _builtins.str:
        return pulumi.get(self, "baselineable_metric_id")

    @_builtins.property
    @pulumi.getter
    def column(self) -> _builtins.str:
        """
        metric column name
        """
        return pulumi.get(self, "column")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        OCID of the compartment
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> _builtins.str:
        """
        Created user id
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        OCID of the metric
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isOutOfBox")
    def is_out_of_box(self) -> _builtins.bool:
        """
        Is the metric created out of box, default false
        """
        return pulumi.get(self, "is_out_of_box")

    @_builtins.property
    @pulumi.getter(name="lastUpdatedBy")
    def last_updated_by(self) -> _builtins.str:
        """
        last Updated user id
        """
        return pulumi.get(self, "last_updated_by")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        name of the metric
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        """
        namespace of the metric
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> _builtins.str:
        """
        Resource group of the metric
        """
        return pulumi.get(self, "resource_group")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> _builtins.str:
        """
        Resource type of the metric
        """
        return pulumi.get(self, "resource_type")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current lifecycle state of the metric extension
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="tenancyId")
    def tenancy_id(self) -> _builtins.str:
        """
        OCID of the tenancy
        """
        return pulumi.get(self, "tenancy_id")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        creation date
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeLastUpdated")
    def time_last_updated(self) -> _builtins.str:
        """
        last updated time
        """
        return pulumi.get(self, "time_last_updated")


class AwaitableGetBaselineableMetricResult(GetBaselineableMetricResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBaselineableMetricResult(
            baselineable_metric_id=self.baselineable_metric_id,
            column=self.column,
            compartment_id=self.compartment_id,
            created_by=self.created_by,
            defined_tags=self.defined_tags,
            freeform_tags=self.freeform_tags,
            id=self.id,
            is_out_of_box=self.is_out_of_box,
            last_updated_by=self.last_updated_by,
            name=self.name,
            namespace=self.namespace,
            resource_group=self.resource_group,
            resource_type=self.resource_type,
            state=self.state,
            system_tags=self.system_tags,
            tenancy_id=self.tenancy_id,
            time_created=self.time_created,
            time_last_updated=self.time_last_updated)


def get_baselineable_metric(baselineable_metric_id: Optional[_builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBaselineableMetricResult:
    """
    This data source provides details about a specific Baselineable Metric resource in Oracle Cloud Infrastructure Stack Monitoring service.

    Get the Baseline-able metric for the given id

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_baselineable_metric = oci.StackMonitoring.get_baselineable_metric(baselineable_metric_id=test_baselineable_metric_oci_stack_monitoring_baselineable_metric["id"])
    ```


    :param _builtins.str baselineable_metric_id: Identifier for the metric
    """
    __args__ = dict()
    __args__['baselineableMetricId'] = baselineable_metric_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:StackMonitoring/getBaselineableMetric:getBaselineableMetric', __args__, opts=opts, typ=GetBaselineableMetricResult).value

    return AwaitableGetBaselineableMetricResult(
        baselineable_metric_id=pulumi.get(__ret__, 'baselineable_metric_id'),
        column=pulumi.get(__ret__, 'column'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        created_by=pulumi.get(__ret__, 'created_by'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        is_out_of_box=pulumi.get(__ret__, 'is_out_of_box'),
        last_updated_by=pulumi.get(__ret__, 'last_updated_by'),
        name=pulumi.get(__ret__, 'name'),
        namespace=pulumi.get(__ret__, 'namespace'),
        resource_group=pulumi.get(__ret__, 'resource_group'),
        resource_type=pulumi.get(__ret__, 'resource_type'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        tenancy_id=pulumi.get(__ret__, 'tenancy_id'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_last_updated=pulumi.get(__ret__, 'time_last_updated'))
def get_baselineable_metric_output(baselineable_metric_id: Optional[pulumi.Input[_builtins.str]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBaselineableMetricResult]:
    """
    This data source provides details about a specific Baselineable Metric resource in Oracle Cloud Infrastructure Stack Monitoring service.

    Get the Baseline-able metric for the given id

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_baselineable_metric = oci.StackMonitoring.get_baselineable_metric(baselineable_metric_id=test_baselineable_metric_oci_stack_monitoring_baselineable_metric["id"])
    ```


    :param _builtins.str baselineable_metric_id: Identifier for the metric
    """
    __args__ = dict()
    __args__['baselineableMetricId'] = baselineable_metric_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:StackMonitoring/getBaselineableMetric:getBaselineableMetric', __args__, opts=opts, typ=GetBaselineableMetricResult)
    return __ret__.apply(lambda __response__: GetBaselineableMetricResult(
        baselineable_metric_id=pulumi.get(__response__, 'baselineable_metric_id'),
        column=pulumi.get(__response__, 'column'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        created_by=pulumi.get(__response__, 'created_by'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        is_out_of_box=pulumi.get(__response__, 'is_out_of_box'),
        last_updated_by=pulumi.get(__response__, 'last_updated_by'),
        name=pulumi.get(__response__, 'name'),
        namespace=pulumi.get(__response__, 'namespace'),
        resource_group=pulumi.get(__response__, 'resource_group'),
        resource_type=pulumi.get(__response__, 'resource_type'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        tenancy_id=pulumi.get(__response__, 'tenancy_id'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_last_updated=pulumi.get(__response__, 'time_last_updated')))
