# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetConfigResult',
    'AwaitableGetConfigResult',
    'get_config',
    'get_config_output',
]

@pulumi.output_type
class GetConfigResult:
    """
    A collection of values returned by getConfig.
    """
    def __init__(__self__, additional_configurations=None, compartment_id=None, config_id=None, config_type=None, defined_tags=None, display_name=None, dynamic_groups=None, freeform_tags=None, id=None, is_enabled=None, is_manually_onboarded=None, license=None, policy_names=None, resource_type=None, state=None, system_tags=None, time_created=None, time_updated=None, user_groups=None, version=None):
        if additional_configurations and not isinstance(additional_configurations, list):
            raise TypeError("Expected argument 'additional_configurations' to be a list")
        pulumi.set(__self__, "additional_configurations", additional_configurations)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if config_id and not isinstance(config_id, str):
            raise TypeError("Expected argument 'config_id' to be a str")
        pulumi.set(__self__, "config_id", config_id)
        if config_type and not isinstance(config_type, str):
            raise TypeError("Expected argument 'config_type' to be a str")
        pulumi.set(__self__, "config_type", config_type)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if dynamic_groups and not isinstance(dynamic_groups, list):
            raise TypeError("Expected argument 'dynamic_groups' to be a list")
        pulumi.set(__self__, "dynamic_groups", dynamic_groups)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_enabled and not isinstance(is_enabled, bool):
            raise TypeError("Expected argument 'is_enabled' to be a bool")
        pulumi.set(__self__, "is_enabled", is_enabled)
        if is_manually_onboarded and not isinstance(is_manually_onboarded, bool):
            raise TypeError("Expected argument 'is_manually_onboarded' to be a bool")
        pulumi.set(__self__, "is_manually_onboarded", is_manually_onboarded)
        if license and not isinstance(license, str):
            raise TypeError("Expected argument 'license' to be a str")
        pulumi.set(__self__, "license", license)
        if policy_names and not isinstance(policy_names, list):
            raise TypeError("Expected argument 'policy_names' to be a list")
        pulumi.set(__self__, "policy_names", policy_names)
        if resource_type and not isinstance(resource_type, str):
            raise TypeError("Expected argument 'resource_type' to be a str")
        pulumi.set(__self__, "resource_type", resource_type)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if user_groups and not isinstance(user_groups, list):
            raise TypeError("Expected argument 'user_groups' to be a list")
        pulumi.set(__self__, "user_groups", user_groups)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="additionalConfigurations")
    def additional_configurations(self) -> Sequence['outputs.GetConfigAdditionalConfigurationResult']:
        """
        Property Details
        """
        return pulumi.get(self, "additional_configurations")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the compartment containing the configuration.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> _builtins.str:
        return pulumi.get(self, "config_id")

    @_builtins.property
    @pulumi.getter(name="configType")
    def config_type(self) -> _builtins.str:
        """
        The type of configuration.
        """
        return pulumi.get(self, "config_type")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="dynamicGroups")
    def dynamic_groups(self) -> Sequence['outputs.GetConfigDynamicGroupResult']:
        """
        List of dynamic groups dedicated for Stack Monitoring.
        """
        return pulumi.get(self, "dynamic_groups")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The Unique Oracle ID (OCID) that is immutable on creation.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> _builtins.bool:
        """
        True if automatic activation of the Management Agent plugin, automatic promotion or enterprise extensibility is enabled, false if it is not enabled.
        """
        return pulumi.get(self, "is_enabled")

    @_builtins.property
    @pulumi.getter(name="isManuallyOnboarded")
    def is_manually_onboarded(self) -> _builtins.bool:
        """
        True if customer decides marks configuration as manually configured.
        """
        return pulumi.get(self, "is_manually_onboarded")

    @_builtins.property
    @pulumi.getter
    def license(self) -> _builtins.str:
        """
        License edition.
        """
        return pulumi.get(self, "license")

    @_builtins.property
    @pulumi.getter(name="policyNames")
    def policy_names(self) -> Sequence[_builtins.str]:
        """
        List of policy names assigned for onboarding
        """
        return pulumi.get(self, "policy_names")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> _builtins.str:
        """
        The type of resource to configure for automatic promotion.
        """
        return pulumi.get(self, "resource_type")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the configuration.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The time the configuration was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The time the Config was updated.
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter(name="userGroups")
    def user_groups(self) -> Sequence['outputs.GetConfigUserGroupResult']:
        """
        List of user groups dedicated for Stack Monitoring.
        """
        return pulumi.get(self, "user_groups")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        Assigned version to given onboard configuration.
        """
        return pulumi.get(self, "version")


class AwaitableGetConfigResult(GetConfigResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetConfigResult(
            additional_configurations=self.additional_configurations,
            compartment_id=self.compartment_id,
            config_id=self.config_id,
            config_type=self.config_type,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            dynamic_groups=self.dynamic_groups,
            freeform_tags=self.freeform_tags,
            id=self.id,
            is_enabled=self.is_enabled,
            is_manually_onboarded=self.is_manually_onboarded,
            license=self.license,
            policy_names=self.policy_names,
            resource_type=self.resource_type,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated,
            user_groups=self.user_groups,
            version=self.version)


def get_config(config_id: Optional[_builtins.str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetConfigResult:
    """
    This data source provides details about a specific Config resource in Oracle Cloud Infrastructure Stack Monitoring service.

    Gets the details of a configuration.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_config = oci.StackMonitoring.get_config(config_id=test_config_oci_stack_monitoring_config["id"])
    ```


    :param _builtins.str config_id: Unique Config identifier.
    """
    __args__ = dict()
    __args__['configId'] = config_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:StackMonitoring/getConfig:getConfig', __args__, opts=opts, typ=GetConfigResult).value

    return AwaitableGetConfigResult(
        additional_configurations=pulumi.get(__ret__, 'additional_configurations'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        config_id=pulumi.get(__ret__, 'config_id'),
        config_type=pulumi.get(__ret__, 'config_type'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        dynamic_groups=pulumi.get(__ret__, 'dynamic_groups'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        is_enabled=pulumi.get(__ret__, 'is_enabled'),
        is_manually_onboarded=pulumi.get(__ret__, 'is_manually_onboarded'),
        license=pulumi.get(__ret__, 'license'),
        policy_names=pulumi.get(__ret__, 'policy_names'),
        resource_type=pulumi.get(__ret__, 'resource_type'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        user_groups=pulumi.get(__ret__, 'user_groups'),
        version=pulumi.get(__ret__, 'version'))
def get_config_output(config_id: Optional[pulumi.Input[_builtins.str]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetConfigResult]:
    """
    This data source provides details about a specific Config resource in Oracle Cloud Infrastructure Stack Monitoring service.

    Gets the details of a configuration.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_config = oci.StackMonitoring.get_config(config_id=test_config_oci_stack_monitoring_config["id"])
    ```


    :param _builtins.str config_id: Unique Config identifier.
    """
    __args__ = dict()
    __args__['configId'] = config_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:StackMonitoring/getConfig:getConfig', __args__, opts=opts, typ=GetConfigResult)
    return __ret__.apply(lambda __response__: GetConfigResult(
        additional_configurations=pulumi.get(__response__, 'additional_configurations'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        config_id=pulumi.get(__response__, 'config_id'),
        config_type=pulumi.get(__response__, 'config_type'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        dynamic_groups=pulumi.get(__response__, 'dynamic_groups'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        is_enabled=pulumi.get(__response__, 'is_enabled'),
        is_manually_onboarded=pulumi.get(__response__, 'is_manually_onboarded'),
        license=pulumi.get(__response__, 'license'),
        policy_names=pulumi.get(__response__, 'policy_names'),
        resource_type=pulumi.get(__response__, 'resource_type'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        user_groups=pulumi.get(__response__, 'user_groups'),
        version=pulumi.get(__response__, 'version')))
