# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetLinkResult',
    'AwaitableGetLinkResult',
    'get_link',
    'get_link_output',
]

@pulumi.output_type
class GetLinkResult:
    """
    A collection of values returned by getLink.
    """
    def __init__(__self__, child_tenancy_id=None, id=None, link_id=None, parent_tenancy_id=None, state=None, time_created=None, time_terminated=None, time_updated=None):
        if child_tenancy_id and not isinstance(child_tenancy_id, str):
            raise TypeError("Expected argument 'child_tenancy_id' to be a str")
        pulumi.set(__self__, "child_tenancy_id", child_tenancy_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if link_id and not isinstance(link_id, str):
            raise TypeError("Expected argument 'link_id' to be a str")
        pulumi.set(__self__, "link_id", link_id)
        if parent_tenancy_id and not isinstance(parent_tenancy_id, str):
            raise TypeError("Expected argument 'parent_tenancy_id' to be a str")
        pulumi.set(__self__, "parent_tenancy_id", parent_tenancy_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_terminated and not isinstance(time_terminated, str):
            raise TypeError("Expected argument 'time_terminated' to be a str")
        pulumi.set(__self__, "time_terminated", time_terminated)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="childTenancyId")
    def child_tenancy_id(self) -> _builtins.str:
        """
        OCID of the child tenancy.
        """
        return pulumi.get(self, "child_tenancy_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="linkId")
    def link_id(self) -> _builtins.str:
        return pulumi.get(self, "link_id")

    @_builtins.property
    @pulumi.getter(name="parentTenancyId")
    def parent_tenancy_id(self) -> _builtins.str:
        """
        OCID of the parent tenancy.
        """
        return pulumi.get(self, "parent_tenancy_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        Lifecycle state of the link.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        Date-time when this link was created.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeTerminated")
    def time_terminated(self) -> _builtins.str:
        """
        Date-time when this link was terminated.
        """
        return pulumi.get(self, "time_terminated")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        Date-time when this link was last updated.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetLinkResult(GetLinkResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLinkResult(
            child_tenancy_id=self.child_tenancy_id,
            id=self.id,
            link_id=self.link_id,
            parent_tenancy_id=self.parent_tenancy_id,
            state=self.state,
            time_created=self.time_created,
            time_terminated=self.time_terminated,
            time_updated=self.time_updated)


def get_link(link_id: Optional[_builtins.str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLinkResult:
    """
    This data source provides details about a specific Link resource in Oracle Cloud Infrastructure Tenantmanagercontrolplane service.

    Gets information about the link.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_link = oci.Tenantmanagercontrolplane.get_link(link_id=test_link_oci_tenantmanagercontrolplane_link["id"])
    ```


    :param _builtins.str link_id: OCID of the link to retrieve.
    """
    __args__ = dict()
    __args__['linkId'] = link_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Tenantmanagercontrolplane/getLink:getLink', __args__, opts=opts, typ=GetLinkResult).value

    return AwaitableGetLinkResult(
        child_tenancy_id=pulumi.get(__ret__, 'child_tenancy_id'),
        id=pulumi.get(__ret__, 'id'),
        link_id=pulumi.get(__ret__, 'link_id'),
        parent_tenancy_id=pulumi.get(__ret__, 'parent_tenancy_id'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_terminated=pulumi.get(__ret__, 'time_terminated'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_link_output(link_id: Optional[pulumi.Input[_builtins.str]] = None,
                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLinkResult]:
    """
    This data source provides details about a specific Link resource in Oracle Cloud Infrastructure Tenantmanagercontrolplane service.

    Gets information about the link.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_link = oci.Tenantmanagercontrolplane.get_link(link_id=test_link_oci_tenantmanagercontrolplane_link["id"])
    ```


    :param _builtins.str link_id: OCID of the link to retrieve.
    """
    __args__ = dict()
    __args__['linkId'] = link_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Tenantmanagercontrolplane/getLink:getLink', __args__, opts=opts, typ=GetLinkResult)
    return __ret__.apply(lambda __response__: GetLinkResult(
        child_tenancy_id=pulumi.get(__response__, 'child_tenancy_id'),
        id=pulumi.get(__response__, 'id'),
        link_id=pulumi.get(__response__, 'link_id'),
        parent_tenancy_id=pulumi.get(__response__, 'parent_tenancy_id'),
        state=pulumi.get(__response__, 'state'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_terminated=pulumi.get(__response__, 'time_terminated'),
        time_updated=pulumi.get(__response__, 'time_updated')))
