# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'SecretReplicationConfig',
    'SecretReplicationConfigReplicationTarget',
    'SecretRotationConfig',
    'SecretRotationConfigTargetSystemDetails',
    'SecretSecretContent',
    'SecretSecretGenerationContext',
    'SecretSecretRule',
    'SecretSourceRegionInformation',
    'GetSecretReplicationConfigResult',
    'GetSecretReplicationConfigReplicationTargetResult',
    'GetSecretRotationConfigResult',
    'GetSecretRotationConfigTargetSystemDetailResult',
    'GetSecretSecretContentResult',
    'GetSecretSecretGenerationContextResult',
    'GetSecretSecretRuleResult',
    'GetSecretSourceRegionInformationResult',
    'GetSecretsFilterResult',
    'GetSecretsSecretResult',
    'GetSecretsSecretReplicationConfigResult',
    'GetSecretsSecretReplicationConfigReplicationTargetResult',
    'GetSecretsSecretRotationConfigResult',
    'GetSecretsSecretRotationConfigTargetSystemDetailResult',
    'GetSecretsSecretSecretContentResult',
    'GetSecretsSecretSecretGenerationContextResult',
    'GetSecretsSecretSecretRuleResult',
    'GetSecretsSecretSourceRegionInformationResult',
]

@pulumi.output_type
class SecretReplicationConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "replicationTargets":
            suggest = "replication_targets"
        elif key == "isWriteForwardEnabled":
            suggest = "is_write_forward_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretReplicationConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretReplicationConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretReplicationConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 replication_targets: Sequence['outputs.SecretReplicationConfigReplicationTarget'],
                 is_write_forward_enabled: Optional[_builtins.bool] = None):
        """
        :param Sequence['SecretReplicationConfigReplicationTargetArgs'] replication_targets: (Updatable) List of the secret replication targets. By default, a maximum of 3 targets is allowed. To configure more than 3 targets, an override is required.
        :param _builtins.bool is_write_forward_enabled: (Updatable) (Optional) A Boolean value to enable forwarding of write requests from replicated secrets to the source secrets. The default value of false disables this option.
        """
        pulumi.set(__self__, "replication_targets", replication_targets)
        if is_write_forward_enabled is not None:
            pulumi.set(__self__, "is_write_forward_enabled", is_write_forward_enabled)

    @_builtins.property
    @pulumi.getter(name="replicationTargets")
    def replication_targets(self) -> Sequence['outputs.SecretReplicationConfigReplicationTarget']:
        """
        (Updatable) List of the secret replication targets. By default, a maximum of 3 targets is allowed. To configure more than 3 targets, an override is required.
        """
        return pulumi.get(self, "replication_targets")

    @_builtins.property
    @pulumi.getter(name="isWriteForwardEnabled")
    def is_write_forward_enabled(self) -> Optional[_builtins.bool]:
        """
        (Updatable) (Optional) A Boolean value to enable forwarding of write requests from replicated secrets to the source secrets. The default value of false disables this option.
        """
        return pulumi.get(self, "is_write_forward_enabled")


@pulumi.output_type
class SecretReplicationConfigReplicationTarget(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetKeyId":
            suggest = "target_key_id"
        elif key == "targetRegion":
            suggest = "target_region"
        elif key == "targetVaultId":
            suggest = "target_vault_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretReplicationConfigReplicationTarget. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretReplicationConfigReplicationTarget.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretReplicationConfigReplicationTarget.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_key_id: _builtins.str,
                 target_region: _builtins.str,
                 target_vault_id: _builtins.str):
        """
        :param _builtins.str target_key_id: (Updatable) The OCID of the target region KMS key.
        :param _builtins.str target_region: (Updatable) The name of the target's region.
        :param _builtins.str target_vault_id: (Updatable) The OCID of the target region's Vault.
        """
        pulumi.set(__self__, "target_key_id", target_key_id)
        pulumi.set(__self__, "target_region", target_region)
        pulumi.set(__self__, "target_vault_id", target_vault_id)

    @_builtins.property
    @pulumi.getter(name="targetKeyId")
    def target_key_id(self) -> _builtins.str:
        """
        (Updatable) The OCID of the target region KMS key.
        """
        return pulumi.get(self, "target_key_id")

    @_builtins.property
    @pulumi.getter(name="targetRegion")
    def target_region(self) -> _builtins.str:
        """
        (Updatable) The name of the target's region.
        """
        return pulumi.get(self, "target_region")

    @_builtins.property
    @pulumi.getter(name="targetVaultId")
    def target_vault_id(self) -> _builtins.str:
        """
        (Updatable) The OCID of the target region's Vault.
        """
        return pulumi.get(self, "target_vault_id")


@pulumi.output_type
class SecretRotationConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetSystemDetails":
            suggest = "target_system_details"
        elif key == "isScheduledRotationEnabled":
            suggest = "is_scheduled_rotation_enabled"
        elif key == "rotationInterval":
            suggest = "rotation_interval"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretRotationConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretRotationConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretRotationConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_system_details: 'outputs.SecretRotationConfigTargetSystemDetails',
                 is_scheduled_rotation_enabled: Optional[_builtins.bool] = None,
                 rotation_interval: Optional[_builtins.str] = None):
        """
        :param 'SecretRotationConfigTargetSystemDetailsArgs' target_system_details: (Updatable) The TargetSystemDetails provides the targetSystem type and type-specific connection metadata
        :param _builtins.bool is_scheduled_rotation_enabled: (Updatable) Enables auto rotation, when set to true rotationInterval must be set.
        :param _builtins.str rotation_interval: (Updatable) The time interval that indicates the frequency for rotating secret data, as described in ISO 8601 format. The minimum value is 1 day and maximum value is 360 days. For example, if you want to set the time interval for rotating a secret data as 30 days, the duration is expressed as "P30D."
        """
        pulumi.set(__self__, "target_system_details", target_system_details)
        if is_scheduled_rotation_enabled is not None:
            pulumi.set(__self__, "is_scheduled_rotation_enabled", is_scheduled_rotation_enabled)
        if rotation_interval is not None:
            pulumi.set(__self__, "rotation_interval", rotation_interval)

    @_builtins.property
    @pulumi.getter(name="targetSystemDetails")
    def target_system_details(self) -> 'outputs.SecretRotationConfigTargetSystemDetails':
        """
        (Updatable) The TargetSystemDetails provides the targetSystem type and type-specific connection metadata
        """
        return pulumi.get(self, "target_system_details")

    @_builtins.property
    @pulumi.getter(name="isScheduledRotationEnabled")
    def is_scheduled_rotation_enabled(self) -> Optional[_builtins.bool]:
        """
        (Updatable) Enables auto rotation, when set to true rotationInterval must be set.
        """
        return pulumi.get(self, "is_scheduled_rotation_enabled")

    @_builtins.property
    @pulumi.getter(name="rotationInterval")
    def rotation_interval(self) -> Optional[_builtins.str]:
        """
        (Updatable) The time interval that indicates the frequency for rotating secret data, as described in ISO 8601 format. The minimum value is 1 day and maximum value is 360 days. For example, if you want to set the time interval for rotating a secret data as 30 days, the duration is expressed as "P30D."
        """
        return pulumi.get(self, "rotation_interval")


@pulumi.output_type
class SecretRotationConfigTargetSystemDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetSystemType":
            suggest = "target_system_type"
        elif key == "adbId":
            suggest = "adb_id"
        elif key == "functionId":
            suggest = "function_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretRotationConfigTargetSystemDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretRotationConfigTargetSystemDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretRotationConfigTargetSystemDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_system_type: _builtins.str,
                 adb_id: Optional[_builtins.str] = None,
                 function_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str target_system_type: (Updatable) Unique identifier of the target system that Vault Secret connects to.
        :param _builtins.str adb_id: (Updatable) The unique identifier (OCID) for the autonomous database that Vault Secret connects to.
        :param _builtins.str function_id: (Updatable) The unique identifier (OCID) of the Oracle Cloud Infrastructure Functions that vault secret connects to.
        """
        pulumi.set(__self__, "target_system_type", target_system_type)
        if adb_id is not None:
            pulumi.set(__self__, "adb_id", adb_id)
        if function_id is not None:
            pulumi.set(__self__, "function_id", function_id)

    @_builtins.property
    @pulumi.getter(name="targetSystemType")
    def target_system_type(self) -> _builtins.str:
        """
        (Updatable) Unique identifier of the target system that Vault Secret connects to.
        """
        return pulumi.get(self, "target_system_type")

    @_builtins.property
    @pulumi.getter(name="adbId")
    def adb_id(self) -> Optional[_builtins.str]:
        """
        (Updatable) The unique identifier (OCID) for the autonomous database that Vault Secret connects to.
        """
        return pulumi.get(self, "adb_id")

    @_builtins.property
    @pulumi.getter(name="functionId")
    def function_id(self) -> Optional[_builtins.str]:
        """
        (Updatable) The unique identifier (OCID) of the Oracle Cloud Infrastructure Functions that vault secret connects to.
        """
        return pulumi.get(self, "function_id")


@pulumi.output_type
class SecretSecretContent(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentType":
            suggest = "content_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretSecretContent. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretSecretContent.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretSecretContent.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content_type: _builtins.str,
                 content: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 stage: Optional[_builtins.str] = None):
        """
        :param _builtins.str content_type: (Updatable) The base64-encoded content of the secret.
        :param _builtins.str content: (Updatable) The base64-encoded content of the secret.
        :param _builtins.str name: (Updatable) Names should be unique within a secret. Valid characters are uppercase or lowercase letters, numbers, hyphens, underscores, and periods.
        :param _builtins.str stage: (Updatable) The rotation state of the secret content. The default is `CURRENT`, meaning that the secret is currently in use. A secret version that you mark as `PENDING` is staged and available for use, but you don't yet want to rotate it into current, active use. For example, you might create or update a secret and mark its rotation state as `PENDING` if you haven't yet updated the secret on the target system. When creating a secret, only the value `CURRENT` is applicable, although the value `LATEST` is also automatically applied. When updating a secret, you can specify a version's rotation state as either `CURRENT` or `PENDING`.
        """
        pulumi.set(__self__, "content_type", content_type)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if stage is not None:
            pulumi.set(__self__, "stage", stage)

    @_builtins.property
    @pulumi.getter(name="contentType")
    def content_type(self) -> _builtins.str:
        """
        (Updatable) The base64-encoded content of the secret.
        """
        return pulumi.get(self, "content_type")

    @_builtins.property
    @pulumi.getter
    def content(self) -> Optional[_builtins.str]:
        """
        (Updatable) The base64-encoded content of the secret.
        """
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        (Updatable) Names should be unique within a secret. Valid characters are uppercase or lowercase letters, numbers, hyphens, underscores, and periods.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def stage(self) -> Optional[_builtins.str]:
        """
        (Updatable) The rotation state of the secret content. The default is `CURRENT`, meaning that the secret is currently in use. A secret version that you mark as `PENDING` is staged and available for use, but you don't yet want to rotate it into current, active use. For example, you might create or update a secret and mark its rotation state as `PENDING` if you haven't yet updated the secret on the target system. When creating a secret, only the value `CURRENT` is applicable, although the value `LATEST` is also automatically applied. When updating a secret, you can specify a version's rotation state as either `CURRENT` or `PENDING`.
        """
        return pulumi.get(self, "stage")


@pulumi.output_type
class SecretSecretGenerationContext(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "generationTemplate":
            suggest = "generation_template"
        elif key == "generationType":
            suggest = "generation_type"
        elif key == "passphraseLength":
            suggest = "passphrase_length"
        elif key == "secretTemplate":
            suggest = "secret_template"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretSecretGenerationContext. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretSecretGenerationContext.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretSecretGenerationContext.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 generation_template: _builtins.str,
                 generation_type: _builtins.str,
                 passphrase_length: Optional[_builtins.int] = None,
                 secret_template: Optional[_builtins.str] = None):
        """
        :param _builtins.str generation_template: (Updatable) Name of random bytes generation template for generating random byte type secret.
        :param _builtins.str generation_type: (Updatable) Name of the predefined secret generation type.
        :param _builtins.int passphrase_length: (Updatable) Length of the passphrase to be generated
        :param _builtins.str secret_template: (Updatable) SecretTemplate captures structure in which customer wants to store secrets. This is optional and a default structure is available for each secret type.  The template can have any structure with static values that are not generated. Within the template, you can insert predefined placeholders to store secrets.  These placeholders are later replaced with the generated content and saved as a Base64 encoded content.
        """
        pulumi.set(__self__, "generation_template", generation_template)
        pulumi.set(__self__, "generation_type", generation_type)
        if passphrase_length is not None:
            pulumi.set(__self__, "passphrase_length", passphrase_length)
        if secret_template is not None:
            pulumi.set(__self__, "secret_template", secret_template)

    @_builtins.property
    @pulumi.getter(name="generationTemplate")
    def generation_template(self) -> _builtins.str:
        """
        (Updatable) Name of random bytes generation template for generating random byte type secret.
        """
        return pulumi.get(self, "generation_template")

    @_builtins.property
    @pulumi.getter(name="generationType")
    def generation_type(self) -> _builtins.str:
        """
        (Updatable) Name of the predefined secret generation type.
        """
        return pulumi.get(self, "generation_type")

    @_builtins.property
    @pulumi.getter(name="passphraseLength")
    def passphrase_length(self) -> Optional[_builtins.int]:
        """
        (Updatable) Length of the passphrase to be generated
        """
        return pulumi.get(self, "passphrase_length")

    @_builtins.property
    @pulumi.getter(name="secretTemplate")
    def secret_template(self) -> Optional[_builtins.str]:
        """
        (Updatable) SecretTemplate captures structure in which customer wants to store secrets. This is optional and a default structure is available for each secret type.  The template can have any structure with static values that are not generated. Within the template, you can insert predefined placeholders to store secrets.  These placeholders are later replaced with the generated content and saved as a Base64 encoded content.
        """
        return pulumi.get(self, "secret_template")


@pulumi.output_type
class SecretSecretRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ruleType":
            suggest = "rule_type"
        elif key == "isEnforcedOnDeletedSecretVersions":
            suggest = "is_enforced_on_deleted_secret_versions"
        elif key == "isSecretContentRetrievalBlockedOnExpiry":
            suggest = "is_secret_content_retrieval_blocked_on_expiry"
        elif key == "secretVersionExpiryInterval":
            suggest = "secret_version_expiry_interval"
        elif key == "timeOfAbsoluteExpiry":
            suggest = "time_of_absolute_expiry"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretSecretRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretSecretRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretSecretRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rule_type: _builtins.str,
                 is_enforced_on_deleted_secret_versions: Optional[_builtins.bool] = None,
                 is_secret_content_retrieval_blocked_on_expiry: Optional[_builtins.bool] = None,
                 secret_version_expiry_interval: Optional[_builtins.str] = None,
                 time_of_absolute_expiry: Optional[_builtins.str] = None):
        """
        :param _builtins.str rule_type: (Updatable) The type of rule, which either controls when the secret contents expire or whether they can be reused.
        :param _builtins.bool is_enforced_on_deleted_secret_versions: (Updatable) A property indicating whether the rule is applied even if the secret version with the content you are trying to reuse was deleted.
        :param _builtins.bool is_secret_content_retrieval_blocked_on_expiry: (Updatable) A property indicating whether to block retrieval of the secret content, on expiry. The default is false. If the secret has already expired and you would like to retrieve the secret contents, you need to edit the secret rule to disable this property, to allow reading the secret content.
        :param _builtins.str secret_version_expiry_interval: (Updatable) A property indicating how long the secret contents will be considered valid, expressed in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601#Time_intervals) format. The secret needs to be updated when the secret content expires. The timer resets after you update the secret contents. The minimum value is 1 day and the maximum value is 90 days for this property. Currently, only intervals expressed in days are supported. For example, pass `P3D` to have the secret version expire every 3 days.
        :param _builtins.str time_of_absolute_expiry: (Updatable) An optional property indicating the absolute time when this secret will expire, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. The minimum number of days from current time is 1 day and the maximum number of days from current time is 365 days. Example: `2019-04-03T21:10:29.600Z`
        """
        pulumi.set(__self__, "rule_type", rule_type)
        if is_enforced_on_deleted_secret_versions is not None:
            pulumi.set(__self__, "is_enforced_on_deleted_secret_versions", is_enforced_on_deleted_secret_versions)
        if is_secret_content_retrieval_blocked_on_expiry is not None:
            pulumi.set(__self__, "is_secret_content_retrieval_blocked_on_expiry", is_secret_content_retrieval_blocked_on_expiry)
        if secret_version_expiry_interval is not None:
            pulumi.set(__self__, "secret_version_expiry_interval", secret_version_expiry_interval)
        if time_of_absolute_expiry is not None:
            pulumi.set(__self__, "time_of_absolute_expiry", time_of_absolute_expiry)

    @_builtins.property
    @pulumi.getter(name="ruleType")
    def rule_type(self) -> _builtins.str:
        """
        (Updatable) The type of rule, which either controls when the secret contents expire or whether they can be reused.
        """
        return pulumi.get(self, "rule_type")

    @_builtins.property
    @pulumi.getter(name="isEnforcedOnDeletedSecretVersions")
    def is_enforced_on_deleted_secret_versions(self) -> Optional[_builtins.bool]:
        """
        (Updatable) A property indicating whether the rule is applied even if the secret version with the content you are trying to reuse was deleted.
        """
        return pulumi.get(self, "is_enforced_on_deleted_secret_versions")

    @_builtins.property
    @pulumi.getter(name="isSecretContentRetrievalBlockedOnExpiry")
    def is_secret_content_retrieval_blocked_on_expiry(self) -> Optional[_builtins.bool]:
        """
        (Updatable) A property indicating whether to block retrieval of the secret content, on expiry. The default is false. If the secret has already expired and you would like to retrieve the secret contents, you need to edit the secret rule to disable this property, to allow reading the secret content.
        """
        return pulumi.get(self, "is_secret_content_retrieval_blocked_on_expiry")

    @_builtins.property
    @pulumi.getter(name="secretVersionExpiryInterval")
    def secret_version_expiry_interval(self) -> Optional[_builtins.str]:
        """
        (Updatable) A property indicating how long the secret contents will be considered valid, expressed in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601#Time_intervals) format. The secret needs to be updated when the secret content expires. The timer resets after you update the secret contents. The minimum value is 1 day and the maximum value is 90 days for this property. Currently, only intervals expressed in days are supported. For example, pass `P3D` to have the secret version expire every 3 days.
        """
        return pulumi.get(self, "secret_version_expiry_interval")

    @_builtins.property
    @pulumi.getter(name="timeOfAbsoluteExpiry")
    def time_of_absolute_expiry(self) -> Optional[_builtins.str]:
        """
        (Updatable) An optional property indicating the absolute time when this secret will expire, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. The minimum number of days from current time is 1 day and the maximum number of days from current time is 365 days. Example: `2019-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_of_absolute_expiry")


@pulumi.output_type
class SecretSourceRegionInformation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceKeyId":
            suggest = "source_key_id"
        elif key == "sourceRegion":
            suggest = "source_region"
        elif key == "sourceVaultId":
            suggest = "source_vault_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretSourceRegionInformation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretSourceRegionInformation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretSourceRegionInformation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_key_id: Optional[_builtins.str] = None,
                 source_region: Optional[_builtins.str] = None,
                 source_vault_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str source_key_id: The OCID of the source region KMS key.
        :param _builtins.str source_region: The name of the source's region.
        :param _builtins.str source_vault_id: The OCID of the source region's Vault.
        """
        if source_key_id is not None:
            pulumi.set(__self__, "source_key_id", source_key_id)
        if source_region is not None:
            pulumi.set(__self__, "source_region", source_region)
        if source_vault_id is not None:
            pulumi.set(__self__, "source_vault_id", source_vault_id)

    @_builtins.property
    @pulumi.getter(name="sourceKeyId")
    def source_key_id(self) -> Optional[_builtins.str]:
        """
        The OCID of the source region KMS key.
        """
        return pulumi.get(self, "source_key_id")

    @_builtins.property
    @pulumi.getter(name="sourceRegion")
    def source_region(self) -> Optional[_builtins.str]:
        """
        The name of the source's region.
        """
        return pulumi.get(self, "source_region")

    @_builtins.property
    @pulumi.getter(name="sourceVaultId")
    def source_vault_id(self) -> Optional[_builtins.str]:
        """
        The OCID of the source region's Vault.
        """
        return pulumi.get(self, "source_vault_id")


@pulumi.output_type
class GetSecretReplicationConfigResult(dict):
    def __init__(__self__, *,
                 is_write_forward_enabled: _builtins.bool,
                 replication_targets: Sequence['outputs.GetSecretReplicationConfigReplicationTargetResult']):
        """
        :param _builtins.bool is_write_forward_enabled: (Optional) A Boolean value to enable forwarding of write requests from replicated secrets to the source secrets. The default value of false disables this option.
        :param Sequence['GetSecretReplicationConfigReplicationTargetArgs'] replication_targets: List of the secret replication targets. By default, a maximum of 3 targets is allowed. To configure more than 3 targets, an override is required.
        """
        pulumi.set(__self__, "is_write_forward_enabled", is_write_forward_enabled)
        pulumi.set(__self__, "replication_targets", replication_targets)

    @_builtins.property
    @pulumi.getter(name="isWriteForwardEnabled")
    def is_write_forward_enabled(self) -> _builtins.bool:
        """
        (Optional) A Boolean value to enable forwarding of write requests from replicated secrets to the source secrets. The default value of false disables this option.
        """
        return pulumi.get(self, "is_write_forward_enabled")

    @_builtins.property
    @pulumi.getter(name="replicationTargets")
    def replication_targets(self) -> Sequence['outputs.GetSecretReplicationConfigReplicationTargetResult']:
        """
        List of the secret replication targets. By default, a maximum of 3 targets is allowed. To configure more than 3 targets, an override is required.
        """
        return pulumi.get(self, "replication_targets")


@pulumi.output_type
class GetSecretReplicationConfigReplicationTargetResult(dict):
    def __init__(__self__, *,
                 target_key_id: _builtins.str,
                 target_region: _builtins.str,
                 target_vault_id: _builtins.str):
        """
        :param _builtins.str target_key_id: The OCID of the target region KMS key.
        :param _builtins.str target_region: The name of the target's region.
        :param _builtins.str target_vault_id: The OCID of the target region's Vault.
        """
        pulumi.set(__self__, "target_key_id", target_key_id)
        pulumi.set(__self__, "target_region", target_region)
        pulumi.set(__self__, "target_vault_id", target_vault_id)

    @_builtins.property
    @pulumi.getter(name="targetKeyId")
    def target_key_id(self) -> _builtins.str:
        """
        The OCID of the target region KMS key.
        """
        return pulumi.get(self, "target_key_id")

    @_builtins.property
    @pulumi.getter(name="targetRegion")
    def target_region(self) -> _builtins.str:
        """
        The name of the target's region.
        """
        return pulumi.get(self, "target_region")

    @_builtins.property
    @pulumi.getter(name="targetVaultId")
    def target_vault_id(self) -> _builtins.str:
        """
        The OCID of the target region's Vault.
        """
        return pulumi.get(self, "target_vault_id")


@pulumi.output_type
class GetSecretRotationConfigResult(dict):
    def __init__(__self__, *,
                 is_scheduled_rotation_enabled: _builtins.bool,
                 rotation_interval: _builtins.str,
                 target_system_details: Sequence['outputs.GetSecretRotationConfigTargetSystemDetailResult']):
        """
        :param _builtins.bool is_scheduled_rotation_enabled: Enables auto rotation, when set to true rotationInterval must be set.
        :param _builtins.str rotation_interval: The time interval that indicates the frequency for rotating secret data, as described in ISO 8601 format. The minimum value is 1 day and maximum value is 360 days. For example, if you want to set the time interval for rotating a secret data as 30 days, the duration is expressed as "P30D."
        :param Sequence['GetSecretRotationConfigTargetSystemDetailArgs'] target_system_details: The TargetSystemDetails provides the targetSystem type and type-specific connection metadata
        """
        pulumi.set(__self__, "is_scheduled_rotation_enabled", is_scheduled_rotation_enabled)
        pulumi.set(__self__, "rotation_interval", rotation_interval)
        pulumi.set(__self__, "target_system_details", target_system_details)

    @_builtins.property
    @pulumi.getter(name="isScheduledRotationEnabled")
    def is_scheduled_rotation_enabled(self) -> _builtins.bool:
        """
        Enables auto rotation, when set to true rotationInterval must be set.
        """
        return pulumi.get(self, "is_scheduled_rotation_enabled")

    @_builtins.property
    @pulumi.getter(name="rotationInterval")
    def rotation_interval(self) -> _builtins.str:
        """
        The time interval that indicates the frequency for rotating secret data, as described in ISO 8601 format. The minimum value is 1 day and maximum value is 360 days. For example, if you want to set the time interval for rotating a secret data as 30 days, the duration is expressed as "P30D."
        """
        return pulumi.get(self, "rotation_interval")

    @_builtins.property
    @pulumi.getter(name="targetSystemDetails")
    def target_system_details(self) -> Sequence['outputs.GetSecretRotationConfigTargetSystemDetailResult']:
        """
        The TargetSystemDetails provides the targetSystem type and type-specific connection metadata
        """
        return pulumi.get(self, "target_system_details")


@pulumi.output_type
class GetSecretRotationConfigTargetSystemDetailResult(dict):
    def __init__(__self__, *,
                 adb_id: _builtins.str,
                 function_id: _builtins.str,
                 target_system_type: _builtins.str):
        """
        :param _builtins.str adb_id: The unique identifier (OCID) for the autonomous database that Vault Secret connects to.
        :param _builtins.str function_id: The unique identifier (OCID) of the Oracle Cloud Infrastructure Functions that vault secret connects to.
        :param _builtins.str target_system_type: Unique identifier of the target system that Vault Secret connects to.
        """
        pulumi.set(__self__, "adb_id", adb_id)
        pulumi.set(__self__, "function_id", function_id)
        pulumi.set(__self__, "target_system_type", target_system_type)

    @_builtins.property
    @pulumi.getter(name="adbId")
    def adb_id(self) -> _builtins.str:
        """
        The unique identifier (OCID) for the autonomous database that Vault Secret connects to.
        """
        return pulumi.get(self, "adb_id")

    @_builtins.property
    @pulumi.getter(name="functionId")
    def function_id(self) -> _builtins.str:
        """
        The unique identifier (OCID) of the Oracle Cloud Infrastructure Functions that vault secret connects to.
        """
        return pulumi.get(self, "function_id")

    @_builtins.property
    @pulumi.getter(name="targetSystemType")
    def target_system_type(self) -> _builtins.str:
        """
        Unique identifier of the target system that Vault Secret connects to.
        """
        return pulumi.get(self, "target_system_type")


@pulumi.output_type
class GetSecretSecretContentResult(dict):
    def __init__(__self__, *,
                 content: _builtins.str,
                 content_type: _builtins.str,
                 name: _builtins.str,
                 stage: _builtins.str):
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "content_type", content_type)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "stage", stage)

    @_builtins.property
    @pulumi.getter
    def content(self) -> _builtins.str:
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter(name="contentType")
    def content_type(self) -> _builtins.str:
        return pulumi.get(self, "content_type")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def stage(self) -> _builtins.str:
        return pulumi.get(self, "stage")


@pulumi.output_type
class GetSecretSecretGenerationContextResult(dict):
    def __init__(__self__, *,
                 generation_template: _builtins.str,
                 generation_type: _builtins.str,
                 passphrase_length: _builtins.int,
                 secret_template: _builtins.str):
        """
        :param _builtins.str generation_template: Name of random bytes generation template for generating random byte type secret.
        :param _builtins.str generation_type: Name of the predefined secret generation type.
        :param _builtins.int passphrase_length: Length of the passphrase to be generated
        :param _builtins.str secret_template: SecretTemplate captures structure in which customer wants to store secrets. This is optional and a default structure is available for each secret type.  The template can have any structure with static values that are not generated. Within the template, you can insert predefined placeholders to store secrets.  These placeholders are later replaced with the generated content and saved as a Base64 encoded content.
        """
        pulumi.set(__self__, "generation_template", generation_template)
        pulumi.set(__self__, "generation_type", generation_type)
        pulumi.set(__self__, "passphrase_length", passphrase_length)
        pulumi.set(__self__, "secret_template", secret_template)

    @_builtins.property
    @pulumi.getter(name="generationTemplate")
    def generation_template(self) -> _builtins.str:
        """
        Name of random bytes generation template for generating random byte type secret.
        """
        return pulumi.get(self, "generation_template")

    @_builtins.property
    @pulumi.getter(name="generationType")
    def generation_type(self) -> _builtins.str:
        """
        Name of the predefined secret generation type.
        """
        return pulumi.get(self, "generation_type")

    @_builtins.property
    @pulumi.getter(name="passphraseLength")
    def passphrase_length(self) -> _builtins.int:
        """
        Length of the passphrase to be generated
        """
        return pulumi.get(self, "passphrase_length")

    @_builtins.property
    @pulumi.getter(name="secretTemplate")
    def secret_template(self) -> _builtins.str:
        """
        SecretTemplate captures structure in which customer wants to store secrets. This is optional and a default structure is available for each secret type.  The template can have any structure with static values that are not generated. Within the template, you can insert predefined placeholders to store secrets.  These placeholders are later replaced with the generated content and saved as a Base64 encoded content.
        """
        return pulumi.get(self, "secret_template")


@pulumi.output_type
class GetSecretSecretRuleResult(dict):
    def __init__(__self__, *,
                 is_enforced_on_deleted_secret_versions: _builtins.bool,
                 is_secret_content_retrieval_blocked_on_expiry: _builtins.bool,
                 rule_type: _builtins.str,
                 secret_version_expiry_interval: _builtins.str,
                 time_of_absolute_expiry: _builtins.str):
        """
        :param _builtins.bool is_enforced_on_deleted_secret_versions: A property indicating whether the rule is applied even if the secret version with the content you are trying to reuse was deleted.
        :param _builtins.bool is_secret_content_retrieval_blocked_on_expiry: A property indicating whether to block retrieval of the secret content, on expiry. The default is false. If the secret has already expired and you would like to retrieve the secret contents, you need to edit the secret rule to disable this property, to allow reading the secret content.
        :param _builtins.str rule_type: The type of rule, which either controls when the secret contents expire or whether they can be reused.
        :param _builtins.str secret_version_expiry_interval: A property indicating how long the secret contents will be considered valid, expressed in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601#Time_intervals) format. The secret needs to be updated when the secret content expires. The timer resets after you update the secret contents. The minimum value is 1 day and the maximum value is 90 days for this property. Currently, only intervals expressed in days are supported. For example, pass `P3D` to have the secret version expire every 3 days.
        :param _builtins.str time_of_absolute_expiry: An optional property indicating the absolute time when this secret will expire, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. The minimum number of days from current time is 1 day and the maximum number of days from current time is 365 days. Example: `2019-04-03T21:10:29.600Z`
        """
        pulumi.set(__self__, "is_enforced_on_deleted_secret_versions", is_enforced_on_deleted_secret_versions)
        pulumi.set(__self__, "is_secret_content_retrieval_blocked_on_expiry", is_secret_content_retrieval_blocked_on_expiry)
        pulumi.set(__self__, "rule_type", rule_type)
        pulumi.set(__self__, "secret_version_expiry_interval", secret_version_expiry_interval)
        pulumi.set(__self__, "time_of_absolute_expiry", time_of_absolute_expiry)

    @_builtins.property
    @pulumi.getter(name="isEnforcedOnDeletedSecretVersions")
    def is_enforced_on_deleted_secret_versions(self) -> _builtins.bool:
        """
        A property indicating whether the rule is applied even if the secret version with the content you are trying to reuse was deleted.
        """
        return pulumi.get(self, "is_enforced_on_deleted_secret_versions")

    @_builtins.property
    @pulumi.getter(name="isSecretContentRetrievalBlockedOnExpiry")
    def is_secret_content_retrieval_blocked_on_expiry(self) -> _builtins.bool:
        """
        A property indicating whether to block retrieval of the secret content, on expiry. The default is false. If the secret has already expired and you would like to retrieve the secret contents, you need to edit the secret rule to disable this property, to allow reading the secret content.
        """
        return pulumi.get(self, "is_secret_content_retrieval_blocked_on_expiry")

    @_builtins.property
    @pulumi.getter(name="ruleType")
    def rule_type(self) -> _builtins.str:
        """
        The type of rule, which either controls when the secret contents expire or whether they can be reused.
        """
        return pulumi.get(self, "rule_type")

    @_builtins.property
    @pulumi.getter(name="secretVersionExpiryInterval")
    def secret_version_expiry_interval(self) -> _builtins.str:
        """
        A property indicating how long the secret contents will be considered valid, expressed in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601#Time_intervals) format. The secret needs to be updated when the secret content expires. The timer resets after you update the secret contents. The minimum value is 1 day and the maximum value is 90 days for this property. Currently, only intervals expressed in days are supported. For example, pass `P3D` to have the secret version expire every 3 days.
        """
        return pulumi.get(self, "secret_version_expiry_interval")

    @_builtins.property
    @pulumi.getter(name="timeOfAbsoluteExpiry")
    def time_of_absolute_expiry(self) -> _builtins.str:
        """
        An optional property indicating the absolute time when this secret will expire, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. The minimum number of days from current time is 1 day and the maximum number of days from current time is 365 days. Example: `2019-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_of_absolute_expiry")


@pulumi.output_type
class GetSecretSourceRegionInformationResult(dict):
    def __init__(__self__, *,
                 source_key_id: _builtins.str,
                 source_region: _builtins.str,
                 source_vault_id: _builtins.str):
        """
        :param _builtins.str source_key_id: The OCID of the source region KMS key.
        :param _builtins.str source_region: The name of the source's region.
        :param _builtins.str source_vault_id: The OCID of the source region's Vault.
        """
        pulumi.set(__self__, "source_key_id", source_key_id)
        pulumi.set(__self__, "source_region", source_region)
        pulumi.set(__self__, "source_vault_id", source_vault_id)

    @_builtins.property
    @pulumi.getter(name="sourceKeyId")
    def source_key_id(self) -> _builtins.str:
        """
        The OCID of the source region KMS key.
        """
        return pulumi.get(self, "source_key_id")

    @_builtins.property
    @pulumi.getter(name="sourceRegion")
    def source_region(self) -> _builtins.str:
        """
        The name of the source's region.
        """
        return pulumi.get(self, "source_region")

    @_builtins.property
    @pulumi.getter(name="sourceVaultId")
    def source_vault_id(self) -> _builtins.str:
        """
        The OCID of the source region's Vault.
        """
        return pulumi.get(self, "source_vault_id")


@pulumi.output_type
class GetSecretsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: The secret name.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The secret name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetSecretsSecretResult(dict):
    def __init__(__self__, *,
                 compartment_id: _builtins.str,
                 current_version_number: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 description: _builtins.str,
                 enable_auto_generation: _builtins.bool,
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 is_auto_generation_enabled: _builtins.bool,
                 is_replica: _builtins.bool,
                 key_id: _builtins.str,
                 last_rotation_time: _builtins.str,
                 lifecycle_details: _builtins.str,
                 metadata: Mapping[str, _builtins.str],
                 next_rotation_time: _builtins.str,
                 replication_configs: Sequence['outputs.GetSecretsSecretReplicationConfigResult'],
                 rotation_configs: Sequence['outputs.GetSecretsSecretRotationConfigResult'],
                 rotation_status: _builtins.str,
                 secret_contents: Sequence['outputs.GetSecretsSecretSecretContentResult'],
                 secret_generation_contexts: Sequence['outputs.GetSecretsSecretSecretGenerationContextResult'],
                 secret_name: _builtins.str,
                 secret_rules: Sequence['outputs.GetSecretsSecretSecretRuleResult'],
                 source_region_informations: Sequence['outputs.GetSecretsSecretSourceRegionInformationResult'],
                 state: _builtins.str,
                 time_created: _builtins.str,
                 time_of_current_version_expiry: _builtins.str,
                 time_of_deletion: _builtins.str,
                 vault_id: _builtins.str):
        """
        :param _builtins.str compartment_id: The OCID of the compartment.
        :param _builtins.str current_version_number: The version number of the secret version that's currently in use.
        :param Mapping[str, _builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param _builtins.str description: A brief description of the secret. Avoid entering confidential information.
        :param Mapping[str, _builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param _builtins.str id: The OCID of the secret.
        :param _builtins.bool is_auto_generation_enabled: The value of this flag determines whether or not secret content will be generated automatically.
        :param _builtins.bool is_replica: A Boolean value that indicates whether the secret is a source or replica secret.
        :param _builtins.str key_id: The OCID of the master encryption key that is used to encrypt the secret. You must specify a symmetric key to encrypt the secret during import to the vault. You cannot encrypt secrets with asymmetric keys. Furthermore, the key must exist in the vault that you specify.
        :param _builtins.str last_rotation_time: A property indicating when the secret was last rotated successfully, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        :param _builtins.str lifecycle_details: Additional information about the current lifecycle state of the secret.
        :param Mapping[str, _builtins.str] metadata: Additional metadata that you can use to provide context about how to use the secret or during rotation or other administrative tasks. For example, for a secret that you use to connect to a database, the additional metadata might specify the connection endpoint and the connection string. Provide additional metadata as key-value pairs.
        :param _builtins.str next_rotation_time: A property indicating when the secret is scheduled to be rotated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        :param Sequence['GetSecretsSecretReplicationConfigArgs'] replication_configs: Defines the configuration that enables cross-region secret replication.
        :param Sequence['GetSecretsSecretRotationConfigArgs'] rotation_configs: Defines the frequency of the rotation and the information about the target system
        :param _builtins.str rotation_status: Additional information about the status of the secret rotation
        :param Sequence['GetSecretsSecretSecretGenerationContextArgs'] secret_generation_contexts: Captures a configurable set of secret generation rules such as length, base characters, additional characters, and so on.
        :param _builtins.str secret_name: The user-friendly name of the secret. Avoid entering confidential information.
        :param Sequence['GetSecretsSecretSecretRuleArgs'] secret_rules: A list of rules that control how the secret is used and managed.
        :param Sequence['GetSecretsSecretSourceRegionInformationArgs'] source_region_informations: Details for the source that the source secret has.
        :param _builtins.str state: A filter that returns only resources that match the specified lifecycle state. The state value is case-insensitive.
        :param _builtins.str time_created: A property indicating when the secret was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        :param _builtins.str time_of_current_version_expiry: An optional property indicating when the current secret version will expire, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        :param _builtins.str time_of_deletion: An optional property indicating when to delete the secret, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        :param _builtins.str vault_id: The OCID of the vault.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "current_version_number", current_version_number)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "enable_auto_generation", enable_auto_generation)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_auto_generation_enabled", is_auto_generation_enabled)
        pulumi.set(__self__, "is_replica", is_replica)
        pulumi.set(__self__, "key_id", key_id)
        pulumi.set(__self__, "last_rotation_time", last_rotation_time)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "metadata", metadata)
        pulumi.set(__self__, "next_rotation_time", next_rotation_time)
        pulumi.set(__self__, "replication_configs", replication_configs)
        pulumi.set(__self__, "rotation_configs", rotation_configs)
        pulumi.set(__self__, "rotation_status", rotation_status)
        pulumi.set(__self__, "secret_contents", secret_contents)
        pulumi.set(__self__, "secret_generation_contexts", secret_generation_contexts)
        pulumi.set(__self__, "secret_name", secret_name)
        pulumi.set(__self__, "secret_rules", secret_rules)
        pulumi.set(__self__, "source_region_informations", source_region_informations)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_of_current_version_expiry", time_of_current_version_expiry)
        pulumi.set(__self__, "time_of_deletion", time_of_deletion)
        pulumi.set(__self__, "vault_id", vault_id)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="currentVersionNumber")
    def current_version_number(self) -> _builtins.str:
        """
        The version number of the secret version that's currently in use.
        """
        return pulumi.get(self, "current_version_number")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        A brief description of the secret. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="enableAutoGeneration")
    def enable_auto_generation(self) -> _builtins.bool:
        return pulumi.get(self, "enable_auto_generation")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The OCID of the secret.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isAutoGenerationEnabled")
    def is_auto_generation_enabled(self) -> _builtins.bool:
        """
        The value of this flag determines whether or not secret content will be generated automatically.
        """
        return pulumi.get(self, "is_auto_generation_enabled")

    @_builtins.property
    @pulumi.getter(name="isReplica")
    def is_replica(self) -> _builtins.bool:
        """
        A Boolean value that indicates whether the secret is a source or replica secret.
        """
        return pulumi.get(self, "is_replica")

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> _builtins.str:
        """
        The OCID of the master encryption key that is used to encrypt the secret. You must specify a symmetric key to encrypt the secret during import to the vault. You cannot encrypt secrets with asymmetric keys. Furthermore, the key must exist in the vault that you specify.
        """
        return pulumi.get(self, "key_id")

    @_builtins.property
    @pulumi.getter(name="lastRotationTime")
    def last_rotation_time(self) -> _builtins.str:
        """
        A property indicating when the secret was last rotated successfully, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "last_rotation_time")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        Additional information about the current lifecycle state of the secret.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Mapping[str, _builtins.str]:
        """
        Additional metadata that you can use to provide context about how to use the secret or during rotation or other administrative tasks. For example, for a secret that you use to connect to a database, the additional metadata might specify the connection endpoint and the connection string. Provide additional metadata as key-value pairs.
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter(name="nextRotationTime")
    def next_rotation_time(self) -> _builtins.str:
        """
        A property indicating when the secret is scheduled to be rotated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "next_rotation_time")

    @_builtins.property
    @pulumi.getter(name="replicationConfigs")
    def replication_configs(self) -> Sequence['outputs.GetSecretsSecretReplicationConfigResult']:
        """
        Defines the configuration that enables cross-region secret replication.
        """
        return pulumi.get(self, "replication_configs")

    @_builtins.property
    @pulumi.getter(name="rotationConfigs")
    def rotation_configs(self) -> Sequence['outputs.GetSecretsSecretRotationConfigResult']:
        """
        Defines the frequency of the rotation and the information about the target system
        """
        return pulumi.get(self, "rotation_configs")

    @_builtins.property
    @pulumi.getter(name="rotationStatus")
    def rotation_status(self) -> _builtins.str:
        """
        Additional information about the status of the secret rotation
        """
        return pulumi.get(self, "rotation_status")

    @_builtins.property
    @pulumi.getter(name="secretContents")
    def secret_contents(self) -> Sequence['outputs.GetSecretsSecretSecretContentResult']:
        return pulumi.get(self, "secret_contents")

    @_builtins.property
    @pulumi.getter(name="secretGenerationContexts")
    def secret_generation_contexts(self) -> Sequence['outputs.GetSecretsSecretSecretGenerationContextResult']:
        """
        Captures a configurable set of secret generation rules such as length, base characters, additional characters, and so on.
        """
        return pulumi.get(self, "secret_generation_contexts")

    @_builtins.property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> _builtins.str:
        """
        The user-friendly name of the secret. Avoid entering confidential information.
        """
        return pulumi.get(self, "secret_name")

    @_builtins.property
    @pulumi.getter(name="secretRules")
    def secret_rules(self) -> Sequence['outputs.GetSecretsSecretSecretRuleResult']:
        """
        A list of rules that control how the secret is used and managed.
        """
        return pulumi.get(self, "secret_rules")

    @_builtins.property
    @pulumi.getter(name="sourceRegionInformations")
    def source_region_informations(self) -> Sequence['outputs.GetSecretsSecretSourceRegionInformationResult']:
        """
        Details for the source that the source secret has.
        """
        return pulumi.get(self, "source_region_informations")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        A filter that returns only resources that match the specified lifecycle state. The state value is case-insensitive.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        A property indicating when the secret was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeOfCurrentVersionExpiry")
    def time_of_current_version_expiry(self) -> _builtins.str:
        """
        An optional property indicating when the current secret version will expire, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_of_current_version_expiry")

    @_builtins.property
    @pulumi.getter(name="timeOfDeletion")
    def time_of_deletion(self) -> _builtins.str:
        """
        An optional property indicating when to delete the secret, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_of_deletion")

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> _builtins.str:
        """
        The OCID of the vault.
        """
        return pulumi.get(self, "vault_id")


@pulumi.output_type
class GetSecretsSecretReplicationConfigResult(dict):
    def __init__(__self__, *,
                 is_write_forward_enabled: _builtins.bool,
                 replication_targets: Sequence['outputs.GetSecretsSecretReplicationConfigReplicationTargetResult']):
        """
        :param _builtins.bool is_write_forward_enabled: (Optional) A Boolean value to enable forwarding of write requests from replicated secrets to the source secrets. The default value of false disables this option.
        :param Sequence['GetSecretsSecretReplicationConfigReplicationTargetArgs'] replication_targets: List of the secret replication targets. By default, a maximum of 3 targets is allowed. To configure more than 3 targets, an override is required.
        """
        pulumi.set(__self__, "is_write_forward_enabled", is_write_forward_enabled)
        pulumi.set(__self__, "replication_targets", replication_targets)

    @_builtins.property
    @pulumi.getter(name="isWriteForwardEnabled")
    def is_write_forward_enabled(self) -> _builtins.bool:
        """
        (Optional) A Boolean value to enable forwarding of write requests from replicated secrets to the source secrets. The default value of false disables this option.
        """
        return pulumi.get(self, "is_write_forward_enabled")

    @_builtins.property
    @pulumi.getter(name="replicationTargets")
    def replication_targets(self) -> Sequence['outputs.GetSecretsSecretReplicationConfigReplicationTargetResult']:
        """
        List of the secret replication targets. By default, a maximum of 3 targets is allowed. To configure more than 3 targets, an override is required.
        """
        return pulumi.get(self, "replication_targets")


@pulumi.output_type
class GetSecretsSecretReplicationConfigReplicationTargetResult(dict):
    def __init__(__self__, *,
                 target_key_id: _builtins.str,
                 target_region: _builtins.str,
                 target_vault_id: _builtins.str):
        """
        :param _builtins.str target_key_id: The OCID of the target region KMS key.
        :param _builtins.str target_region: The name of the target's region.
        :param _builtins.str target_vault_id: The OCID of the target region's Vault.
        """
        pulumi.set(__self__, "target_key_id", target_key_id)
        pulumi.set(__self__, "target_region", target_region)
        pulumi.set(__self__, "target_vault_id", target_vault_id)

    @_builtins.property
    @pulumi.getter(name="targetKeyId")
    def target_key_id(self) -> _builtins.str:
        """
        The OCID of the target region KMS key.
        """
        return pulumi.get(self, "target_key_id")

    @_builtins.property
    @pulumi.getter(name="targetRegion")
    def target_region(self) -> _builtins.str:
        """
        The name of the target's region.
        """
        return pulumi.get(self, "target_region")

    @_builtins.property
    @pulumi.getter(name="targetVaultId")
    def target_vault_id(self) -> _builtins.str:
        """
        The OCID of the target region's Vault.
        """
        return pulumi.get(self, "target_vault_id")


@pulumi.output_type
class GetSecretsSecretRotationConfigResult(dict):
    def __init__(__self__, *,
                 is_scheduled_rotation_enabled: _builtins.bool,
                 rotation_interval: _builtins.str,
                 target_system_details: Sequence['outputs.GetSecretsSecretRotationConfigTargetSystemDetailResult']):
        """
        :param _builtins.bool is_scheduled_rotation_enabled: Enables auto rotation, when set to true rotationInterval must be set.
        :param _builtins.str rotation_interval: The time interval that indicates the frequency for rotating secret data, as described in ISO 8601 format. The minimum value is 1 day and maximum value is 360 days. For example, if you want to set the time interval for rotating a secret data as 30 days, the duration is expressed as "P30D."
        :param Sequence['GetSecretsSecretRotationConfigTargetSystemDetailArgs'] target_system_details: The TargetSystemDetails provides the targetSystem type and type-specific connection metadata
        """
        pulumi.set(__self__, "is_scheduled_rotation_enabled", is_scheduled_rotation_enabled)
        pulumi.set(__self__, "rotation_interval", rotation_interval)
        pulumi.set(__self__, "target_system_details", target_system_details)

    @_builtins.property
    @pulumi.getter(name="isScheduledRotationEnabled")
    def is_scheduled_rotation_enabled(self) -> _builtins.bool:
        """
        Enables auto rotation, when set to true rotationInterval must be set.
        """
        return pulumi.get(self, "is_scheduled_rotation_enabled")

    @_builtins.property
    @pulumi.getter(name="rotationInterval")
    def rotation_interval(self) -> _builtins.str:
        """
        The time interval that indicates the frequency for rotating secret data, as described in ISO 8601 format. The minimum value is 1 day and maximum value is 360 days. For example, if you want to set the time interval for rotating a secret data as 30 days, the duration is expressed as "P30D."
        """
        return pulumi.get(self, "rotation_interval")

    @_builtins.property
    @pulumi.getter(name="targetSystemDetails")
    def target_system_details(self) -> Sequence['outputs.GetSecretsSecretRotationConfigTargetSystemDetailResult']:
        """
        The TargetSystemDetails provides the targetSystem type and type-specific connection metadata
        """
        return pulumi.get(self, "target_system_details")


@pulumi.output_type
class GetSecretsSecretRotationConfigTargetSystemDetailResult(dict):
    def __init__(__self__, *,
                 adb_id: _builtins.str,
                 function_id: _builtins.str,
                 target_system_type: _builtins.str):
        """
        :param _builtins.str adb_id: The unique identifier (OCID) for the autonomous database that Vault Secret connects to.
        :param _builtins.str function_id: The unique identifier (OCID) of the Oracle Cloud Infrastructure Functions that vault secret connects to.
        :param _builtins.str target_system_type: Unique identifier of the target system that Vault Secret connects to.
        """
        pulumi.set(__self__, "adb_id", adb_id)
        pulumi.set(__self__, "function_id", function_id)
        pulumi.set(__self__, "target_system_type", target_system_type)

    @_builtins.property
    @pulumi.getter(name="adbId")
    def adb_id(self) -> _builtins.str:
        """
        The unique identifier (OCID) for the autonomous database that Vault Secret connects to.
        """
        return pulumi.get(self, "adb_id")

    @_builtins.property
    @pulumi.getter(name="functionId")
    def function_id(self) -> _builtins.str:
        """
        The unique identifier (OCID) of the Oracle Cloud Infrastructure Functions that vault secret connects to.
        """
        return pulumi.get(self, "function_id")

    @_builtins.property
    @pulumi.getter(name="targetSystemType")
    def target_system_type(self) -> _builtins.str:
        """
        Unique identifier of the target system that Vault Secret connects to.
        """
        return pulumi.get(self, "target_system_type")


@pulumi.output_type
class GetSecretsSecretSecretContentResult(dict):
    def __init__(__self__, *,
                 content: _builtins.str,
                 content_type: _builtins.str,
                 name: _builtins.str,
                 stage: _builtins.str):
        """
        :param _builtins.str name: The secret name.
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "content_type", content_type)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "stage", stage)

    @_builtins.property
    @pulumi.getter
    def content(self) -> _builtins.str:
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter(name="contentType")
    def content_type(self) -> _builtins.str:
        return pulumi.get(self, "content_type")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The secret name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def stage(self) -> _builtins.str:
        return pulumi.get(self, "stage")


@pulumi.output_type
class GetSecretsSecretSecretGenerationContextResult(dict):
    def __init__(__self__, *,
                 generation_template: _builtins.str,
                 generation_type: _builtins.str,
                 passphrase_length: _builtins.int,
                 secret_template: _builtins.str):
        """
        :param _builtins.str generation_template: Name of random bytes generation template for generating random byte type secret.
        :param _builtins.str generation_type: Name of the predefined secret generation type.
        :param _builtins.int passphrase_length: Length of the passphrase to be generated
        :param _builtins.str secret_template: SecretTemplate captures structure in which customer wants to store secrets. This is optional and a default structure is available for each secret type.  The template can have any structure with static values that are not generated. Within the template, you can insert predefined placeholders to store secrets.  These placeholders are later replaced with the generated content and saved as a Base64 encoded content.
        """
        pulumi.set(__self__, "generation_template", generation_template)
        pulumi.set(__self__, "generation_type", generation_type)
        pulumi.set(__self__, "passphrase_length", passphrase_length)
        pulumi.set(__self__, "secret_template", secret_template)

    @_builtins.property
    @pulumi.getter(name="generationTemplate")
    def generation_template(self) -> _builtins.str:
        """
        Name of random bytes generation template for generating random byte type secret.
        """
        return pulumi.get(self, "generation_template")

    @_builtins.property
    @pulumi.getter(name="generationType")
    def generation_type(self) -> _builtins.str:
        """
        Name of the predefined secret generation type.
        """
        return pulumi.get(self, "generation_type")

    @_builtins.property
    @pulumi.getter(name="passphraseLength")
    def passphrase_length(self) -> _builtins.int:
        """
        Length of the passphrase to be generated
        """
        return pulumi.get(self, "passphrase_length")

    @_builtins.property
    @pulumi.getter(name="secretTemplate")
    def secret_template(self) -> _builtins.str:
        """
        SecretTemplate captures structure in which customer wants to store secrets. This is optional and a default structure is available for each secret type.  The template can have any structure with static values that are not generated. Within the template, you can insert predefined placeholders to store secrets.  These placeholders are later replaced with the generated content and saved as a Base64 encoded content.
        """
        return pulumi.get(self, "secret_template")


@pulumi.output_type
class GetSecretsSecretSecretRuleResult(dict):
    def __init__(__self__, *,
                 is_enforced_on_deleted_secret_versions: _builtins.bool,
                 is_secret_content_retrieval_blocked_on_expiry: _builtins.bool,
                 rule_type: _builtins.str,
                 secret_version_expiry_interval: _builtins.str,
                 time_of_absolute_expiry: _builtins.str):
        """
        :param _builtins.bool is_enforced_on_deleted_secret_versions: A property indicating whether the rule is applied even if the secret version with the content you are trying to reuse was deleted.
        :param _builtins.bool is_secret_content_retrieval_blocked_on_expiry: A property indicating whether to block retrieval of the secret content, on expiry. The default is false. If the secret has already expired and you would like to retrieve the secret contents, you need to edit the secret rule to disable this property, to allow reading the secret content.
        :param _builtins.str rule_type: The type of rule, which either controls when the secret contents expire or whether they can be reused.
        :param _builtins.str secret_version_expiry_interval: A property indicating how long the secret contents will be considered valid, expressed in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601#Time_intervals) format. The secret needs to be updated when the secret content expires. The timer resets after you update the secret contents. The minimum value is 1 day and the maximum value is 90 days for this property. Currently, only intervals expressed in days are supported. For example, pass `P3D` to have the secret version expire every 3 days.
        :param _builtins.str time_of_absolute_expiry: An optional property indicating the absolute time when this secret will expire, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. The minimum number of days from current time is 1 day and the maximum number of days from current time is 365 days. Example: `2019-04-03T21:10:29.600Z`
        """
        pulumi.set(__self__, "is_enforced_on_deleted_secret_versions", is_enforced_on_deleted_secret_versions)
        pulumi.set(__self__, "is_secret_content_retrieval_blocked_on_expiry", is_secret_content_retrieval_blocked_on_expiry)
        pulumi.set(__self__, "rule_type", rule_type)
        pulumi.set(__self__, "secret_version_expiry_interval", secret_version_expiry_interval)
        pulumi.set(__self__, "time_of_absolute_expiry", time_of_absolute_expiry)

    @_builtins.property
    @pulumi.getter(name="isEnforcedOnDeletedSecretVersions")
    def is_enforced_on_deleted_secret_versions(self) -> _builtins.bool:
        """
        A property indicating whether the rule is applied even if the secret version with the content you are trying to reuse was deleted.
        """
        return pulumi.get(self, "is_enforced_on_deleted_secret_versions")

    @_builtins.property
    @pulumi.getter(name="isSecretContentRetrievalBlockedOnExpiry")
    def is_secret_content_retrieval_blocked_on_expiry(self) -> _builtins.bool:
        """
        A property indicating whether to block retrieval of the secret content, on expiry. The default is false. If the secret has already expired and you would like to retrieve the secret contents, you need to edit the secret rule to disable this property, to allow reading the secret content.
        """
        return pulumi.get(self, "is_secret_content_retrieval_blocked_on_expiry")

    @_builtins.property
    @pulumi.getter(name="ruleType")
    def rule_type(self) -> _builtins.str:
        """
        The type of rule, which either controls when the secret contents expire or whether they can be reused.
        """
        return pulumi.get(self, "rule_type")

    @_builtins.property
    @pulumi.getter(name="secretVersionExpiryInterval")
    def secret_version_expiry_interval(self) -> _builtins.str:
        """
        A property indicating how long the secret contents will be considered valid, expressed in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601#Time_intervals) format. The secret needs to be updated when the secret content expires. The timer resets after you update the secret contents. The minimum value is 1 day and the maximum value is 90 days for this property. Currently, only intervals expressed in days are supported. For example, pass `P3D` to have the secret version expire every 3 days.
        """
        return pulumi.get(self, "secret_version_expiry_interval")

    @_builtins.property
    @pulumi.getter(name="timeOfAbsoluteExpiry")
    def time_of_absolute_expiry(self) -> _builtins.str:
        """
        An optional property indicating the absolute time when this secret will expire, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. The minimum number of days from current time is 1 day and the maximum number of days from current time is 365 days. Example: `2019-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_of_absolute_expiry")


@pulumi.output_type
class GetSecretsSecretSourceRegionInformationResult(dict):
    def __init__(__self__, *,
                 source_key_id: _builtins.str,
                 source_region: _builtins.str,
                 source_vault_id: _builtins.str):
        """
        :param _builtins.str source_key_id: The OCID of the source region KMS key.
        :param _builtins.str source_region: The name of the source's region.
        :param _builtins.str source_vault_id: The OCID of the source region's Vault.
        """
        pulumi.set(__self__, "source_key_id", source_key_id)
        pulumi.set(__self__, "source_region", source_region)
        pulumi.set(__self__, "source_vault_id", source_vault_id)

    @_builtins.property
    @pulumi.getter(name="sourceKeyId")
    def source_key_id(self) -> _builtins.str:
        """
        The OCID of the source region KMS key.
        """
        return pulumi.get(self, "source_key_id")

    @_builtins.property
    @pulumi.getter(name="sourceRegion")
    def source_region(self) -> _builtins.str:
        """
        The name of the source's region.
        """
        return pulumi.get(self, "source_region")

    @_builtins.property
    @pulumi.getter(name="sourceVaultId")
    def source_vault_id(self) -> _builtins.str:
        """
        The OCID of the source region's Vault.
        """
        return pulumi.get(self, "source_vault_id")


