# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetHostScanRecipesResult',
    'AwaitableGetHostScanRecipesResult',
    'get_host_scan_recipes',
    'get_host_scan_recipes_output',
]

@pulumi.output_type
class GetHostScanRecipesResult:
    """
    A collection of values returned by getHostScanRecipes.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, host_scan_recipe_summary_collections=None, id=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if host_scan_recipe_summary_collections and not isinstance(host_scan_recipe_summary_collections, list):
            raise TypeError("Expected argument 'host_scan_recipe_summary_collections' to be a list")
        pulumi.set(__self__, "host_scan_recipe_summary_collections", host_scan_recipe_summary_collections)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        Compartment ID of the scan recipe
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        Recipe identifier, which can be renamed
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetHostScanRecipesFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter(name="hostScanRecipeSummaryCollections")
    def host_scan_recipe_summary_collections(self) -> Sequence['outputs.GetHostScanRecipesHostScanRecipeSummaryCollectionResult']:
        """
        The list of host_scan_recipe_summary_collection.
        """
        return pulumi.get(self, "host_scan_recipe_summary_collections")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current state of the config.
        """
        return pulumi.get(self, "state")


class AwaitableGetHostScanRecipesResult(GetHostScanRecipesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetHostScanRecipesResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            host_scan_recipe_summary_collections=self.host_scan_recipe_summary_collections,
            id=self.id,
            state=self.state)


def get_host_scan_recipes(compartment_id: Optional[_builtins.str] = None,
                          display_name: Optional[_builtins.str] = None,
                          filters: Optional[Sequence[Union['GetHostScanRecipesFilterArgs', 'GetHostScanRecipesFilterArgsDict']]] = None,
                          state: Optional[_builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetHostScanRecipesResult:
    """
    This data source provides the list of Host Scan Recipes in Oracle Cloud Infrastructure Vulnerability Scanning service.

    Retrieves a list of HostScanRecipeSummary objects in a compartment. A recipe determines the types of security issues that you want scanned, and how often to scan.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_host_scan_recipes = oci.VulnerabilityScanning.get_host_scan_recipes(compartment_id=compartment_id,
        display_name=host_scan_recipe_display_name,
        state=host_scan_recipe_state)
    ```


    :param _builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param _builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param _builtins.str state: A filter to return only resources whose lifecycleState matches the given lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:VulnerabilityScanning/getHostScanRecipes:getHostScanRecipes', __args__, opts=opts, typ=GetHostScanRecipesResult).value

    return AwaitableGetHostScanRecipesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        host_scan_recipe_summary_collections=pulumi.get(__ret__, 'host_scan_recipe_summary_collections'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'))
def get_host_scan_recipes_output(compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                 display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 filters: Optional[pulumi.Input[Optional[Sequence[Union['GetHostScanRecipesFilterArgs', 'GetHostScanRecipesFilterArgsDict']]]]] = None,
                                 state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetHostScanRecipesResult]:
    """
    This data source provides the list of Host Scan Recipes in Oracle Cloud Infrastructure Vulnerability Scanning service.

    Retrieves a list of HostScanRecipeSummary objects in a compartment. A recipe determines the types of security issues that you want scanned, and how often to scan.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_host_scan_recipes = oci.VulnerabilityScanning.get_host_scan_recipes(compartment_id=compartment_id,
        display_name=host_scan_recipe_display_name,
        state=host_scan_recipe_state)
    ```


    :param _builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param _builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param _builtins.str state: A filter to return only resources whose lifecycleState matches the given lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:VulnerabilityScanning/getHostScanRecipes:getHostScanRecipes', __args__, opts=opts, typ=GetHostScanRecipesResult)
    return __ret__.apply(lambda __response__: GetHostScanRecipesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        host_scan_recipe_summary_collections=pulumi.get(__response__, 'host_scan_recipe_summary_collections'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state')))
