# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CertificateArgs', 'Certificate']

@pulumi.input_type
class CertificateArgs:
    def __init__(__self__, *,
                 certificate_data: pulumi.Input[_builtins.str],
                 compartment_id: pulumi.Input[_builtins.str],
                 private_key_data: pulumi.Input[_builtins.str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 is_trust_verification_disabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a Certificate resource.
        :param pulumi.Input[_builtins.str] certificate_data: The data of the SSL certificate.
               
               **Note:** Many SSL certificate providers require an intermediate certificate chain to ensure a trusted status. If your SSL certificate requires an intermediate certificate chain, please append the intermediate certificate key in the `certificateData` field after the leaf certificate issued by the SSL certificate provider. If you are unsure if your certificate requires an intermediate certificate chain, see your certificate provider's documentation.
               
               The example below shows an intermediate certificate appended to a leaf certificate.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to create the SSL certificate.
        :param pulumi.Input[_builtins.str] private_key_data: The private key of the SSL certificate.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name for the SSL certificate. The name can be changed and does not need to be unique.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.bool] is_trust_verification_disabled: Set to `true` if the SSL certificate is self-signed.
        """
        pulumi.set(__self__, "certificate_data", certificate_data)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "private_key_data", private_key_data)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_trust_verification_disabled is not None:
            pulumi.set(__self__, "is_trust_verification_disabled", is_trust_verification_disabled)

    @_builtins.property
    @pulumi.getter(name="certificateData")
    def certificate_data(self) -> pulumi.Input[_builtins.str]:
        """
        The data of the SSL certificate.

        **Note:** Many SSL certificate providers require an intermediate certificate chain to ensure a trusted status. If your SSL certificate requires an intermediate certificate chain, please append the intermediate certificate key in the `certificateData` field after the leaf certificate issued by the SSL certificate provider. If you are unsure if your certificate requires an intermediate certificate chain, see your certificate provider's documentation.

        The example below shows an intermediate certificate appended to a leaf certificate.
        """
        return pulumi.get(self, "certificate_data")

    @certificate_data.setter
    def certificate_data(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "certificate_data", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to create the SSL certificate.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="privateKeyData")
    def private_key_data(self) -> pulumi.Input[_builtins.str]:
        """
        The private key of the SSL certificate.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "private_key_data")

    @private_key_data.setter
    def private_key_data(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "private_key_data", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A user-friendly name for the SSL certificate. The name can be changed and does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="isTrustVerificationDisabled")
    def is_trust_verification_disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set to `true` if the SSL certificate is self-signed.
        """
        return pulumi.get(self, "is_trust_verification_disabled")

    @is_trust_verification_disabled.setter
    def is_trust_verification_disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_trust_verification_disabled", value)


@pulumi.input_type
class _CertificateState:
    def __init__(__self__, *,
                 certificate_data: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 extensions: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateExtensionArgs']]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 is_trust_verification_disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 issued_by: Optional[pulumi.Input[_builtins.str]] = None,
                 issuer_names: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateIssuerNameArgs']]]] = None,
                 private_key_data: Optional[pulumi.Input[_builtins.str]] = None,
                 public_key_infos: Optional[pulumi.Input[Sequence[pulumi.Input['CertificatePublicKeyInfoArgs']]]] = None,
                 serial_number: Optional[pulumi.Input[_builtins.str]] = None,
                 signature_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 subject_names: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateSubjectNameArgs']]]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_not_valid_after: Optional[pulumi.Input[_builtins.str]] = None,
                 time_not_valid_before: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering Certificate resources.
        :param pulumi.Input[_builtins.str] certificate_data: The data of the SSL certificate.
               
               **Note:** Many SSL certificate providers require an intermediate certificate chain to ensure a trusted status. If your SSL certificate requires an intermediate certificate chain, please append the intermediate certificate key in the `certificateData` field after the leaf certificate issued by the SSL certificate provider. If you are unsure if your certificate requires an intermediate certificate chain, see your certificate provider's documentation.
               
               The example below shows an intermediate certificate appended to a leaf certificate.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to create the SSL certificate.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name for the SSL certificate. The name can be changed and does not need to be unique.
        :param pulumi.Input[Sequence[pulumi.Input['CertificateExtensionArgs']]] extensions: Additional attributes associated with users or public keys for managing relationships between Certificate Authorities.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.bool] is_trust_verification_disabled: Set to `true` if the SSL certificate is self-signed.
        :param pulumi.Input[Sequence[pulumi.Input['CertificateIssuerNameArgs']]] issuer_names: The issuer of the certificate.
        :param pulumi.Input[_builtins.str] private_key_data: The private key of the SSL certificate.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Sequence[pulumi.Input['CertificatePublicKeyInfoArgs']]] public_key_infos: Information about the public key and the algorithm used by the public key.
        :param pulumi.Input[_builtins.str] serial_number: A unique, positive integer assigned by the Certificate Authority (CA). The issuer name and serial number identify a unique certificate.
        :param pulumi.Input[_builtins.str] signature_algorithm: The identifier for the cryptographic algorithm used by the Certificate Authority (CA) to sign this certificate.
        :param pulumi.Input[_builtins.str] state: The current lifecycle state of the SSL certificate.
        :param pulumi.Input[Sequence[pulumi.Input['CertificateSubjectNameArgs']]] subject_names: The entity to be secured by the certificate.
        :param pulumi.Input[_builtins.str] time_created: The date and time the certificate was created, expressed in RFC 3339 timestamp format.
        :param pulumi.Input[_builtins.str] time_not_valid_after: The date and time the certificate will expire, expressed in RFC 3339 timestamp format.
        :param pulumi.Input[_builtins.str] time_not_valid_before: The date and time the certificate will become valid, expressed in RFC 3339 timestamp format.
        :param pulumi.Input[_builtins.int] version: The version of the encoded certificate.
        """
        if certificate_data is not None:
            pulumi.set(__self__, "certificate_data", certificate_data)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if extensions is not None:
            pulumi.set(__self__, "extensions", extensions)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_trust_verification_disabled is not None:
            pulumi.set(__self__, "is_trust_verification_disabled", is_trust_verification_disabled)
        if issued_by is not None:
            pulumi.set(__self__, "issued_by", issued_by)
        if issuer_names is not None:
            pulumi.set(__self__, "issuer_names", issuer_names)
        if private_key_data is not None:
            pulumi.set(__self__, "private_key_data", private_key_data)
        if public_key_infos is not None:
            pulumi.set(__self__, "public_key_infos", public_key_infos)
        if serial_number is not None:
            pulumi.set(__self__, "serial_number", serial_number)
        if signature_algorithm is not None:
            pulumi.set(__self__, "signature_algorithm", signature_algorithm)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if subject_names is not None:
            pulumi.set(__self__, "subject_names", subject_names)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_not_valid_after is not None:
            pulumi.set(__self__, "time_not_valid_after", time_not_valid_after)
        if time_not_valid_before is not None:
            pulumi.set(__self__, "time_not_valid_before", time_not_valid_before)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="certificateData")
    def certificate_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The data of the SSL certificate.

        **Note:** Many SSL certificate providers require an intermediate certificate chain to ensure a trusted status. If your SSL certificate requires an intermediate certificate chain, please append the intermediate certificate key in the `certificateData` field after the leaf certificate issued by the SSL certificate provider. If you are unsure if your certificate requires an intermediate certificate chain, see your certificate provider's documentation.

        The example below shows an intermediate certificate appended to a leaf certificate.
        """
        return pulumi.get(self, "certificate_data")

    @certificate_data.setter
    def certificate_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate_data", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to create the SSL certificate.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A user-friendly name for the SSL certificate. The name can be changed and does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def extensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CertificateExtensionArgs']]]]:
        """
        Additional attributes associated with users or public keys for managing relationships between Certificate Authorities.
        """
        return pulumi.get(self, "extensions")

    @extensions.setter
    def extensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateExtensionArgs']]]]):
        pulumi.set(self, "extensions", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="isTrustVerificationDisabled")
    def is_trust_verification_disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set to `true` if the SSL certificate is self-signed.
        """
        return pulumi.get(self, "is_trust_verification_disabled")

    @is_trust_verification_disabled.setter
    def is_trust_verification_disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_trust_verification_disabled", value)

    @_builtins.property
    @pulumi.getter(name="issuedBy")
    def issued_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "issued_by")

    @issued_by.setter
    def issued_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "issued_by", value)

    @_builtins.property
    @pulumi.getter(name="issuerNames")
    def issuer_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CertificateIssuerNameArgs']]]]:
        """
        The issuer of the certificate.
        """
        return pulumi.get(self, "issuer_names")

    @issuer_names.setter
    def issuer_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateIssuerNameArgs']]]]):
        pulumi.set(self, "issuer_names", value)

    @_builtins.property
    @pulumi.getter(name="privateKeyData")
    def private_key_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private key of the SSL certificate.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "private_key_data")

    @private_key_data.setter
    def private_key_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key_data", value)

    @_builtins.property
    @pulumi.getter(name="publicKeyInfos")
    def public_key_infos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CertificatePublicKeyInfoArgs']]]]:
        """
        Information about the public key and the algorithm used by the public key.
        """
        return pulumi.get(self, "public_key_infos")

    @public_key_infos.setter
    def public_key_infos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CertificatePublicKeyInfoArgs']]]]):
        pulumi.set(self, "public_key_infos", value)

    @_builtins.property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A unique, positive integer assigned by the Certificate Authority (CA). The issuer name and serial number identify a unique certificate.
        """
        return pulumi.get(self, "serial_number")

    @serial_number.setter
    def serial_number(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "serial_number", value)

    @_builtins.property
    @pulumi.getter(name="signatureAlgorithm")
    def signature_algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the cryptographic algorithm used by the Certificate Authority (CA) to sign this certificate.
        """
        return pulumi.get(self, "signature_algorithm")

    @signature_algorithm.setter
    def signature_algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "signature_algorithm", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current lifecycle state of the SSL certificate.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="subjectNames")
    def subject_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CertificateSubjectNameArgs']]]]:
        """
        The entity to be secured by the certificate.
        """
        return pulumi.get(self, "subject_names")

    @subject_names.setter
    def subject_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateSubjectNameArgs']]]]):
        pulumi.set(self, "subject_names", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the certificate was created, expressed in RFC 3339 timestamp format.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeNotValidAfter")
    def time_not_valid_after(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the certificate will expire, expressed in RFC 3339 timestamp format.
        """
        return pulumi.get(self, "time_not_valid_after")

    @time_not_valid_after.setter
    def time_not_valid_after(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_not_valid_after", value)

    @_builtins.property
    @pulumi.getter(name="timeNotValidBefore")
    def time_not_valid_before(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the certificate will become valid, expressed in RFC 3339 timestamp format.
        """
        return pulumi.get(self, "time_not_valid_before")

    @time_not_valid_before.setter
    def time_not_valid_before(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_not_valid_before", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The version of the encoded certificate.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("oci:Waas/certificate:Certificate")
class Certificate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_data: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 is_trust_verification_disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 private_key_data: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Certificate resource in Oracle Cloud Infrastructure Web Application Acceleration and Security service.

        Allows an SSL certificate to be added to a WAAS policy. The Web Application Firewall terminates SSL connections to inspect requests in runtime, and then re-encrypts requests before sending them to the origin for fulfillment.

        For more information, see [WAF Settings](https://docs.cloud.oracle.com/iaas/Content/WAF/Tasks/wafsettings.htm).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_certificate = oci.waas.Certificate("test_certificate",
            certificate_data=certificate_certificate_data,
            compartment_id=compartment_id,
            private_key_data=certificate_private_key_data,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=certificate_display_name,
            freeform_tags={
                "Department": "Finance",
            },
            is_trust_verification_disabled=certificate_is_trust_verification_disabled)
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] certificate_data: The data of the SSL certificate.
               
               **Note:** Many SSL certificate providers require an intermediate certificate chain to ensure a trusted status. If your SSL certificate requires an intermediate certificate chain, please append the intermediate certificate key in the `certificateData` field after the leaf certificate issued by the SSL certificate provider. If you are unsure if your certificate requires an intermediate certificate chain, see your certificate provider's documentation.
               
               The example below shows an intermediate certificate appended to a leaf certificate.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to create the SSL certificate.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name for the SSL certificate. The name can be changed and does not need to be unique.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.bool] is_trust_verification_disabled: Set to `true` if the SSL certificate is self-signed.
        :param pulumi.Input[_builtins.str] private_key_data: The private key of the SSL certificate.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CertificateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Certificate resource in Oracle Cloud Infrastructure Web Application Acceleration and Security service.

        Allows an SSL certificate to be added to a WAAS policy. The Web Application Firewall terminates SSL connections to inspect requests in runtime, and then re-encrypts requests before sending them to the origin for fulfillment.

        For more information, see [WAF Settings](https://docs.cloud.oracle.com/iaas/Content/WAF/Tasks/wafsettings.htm).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_certificate = oci.waas.Certificate("test_certificate",
            certificate_data=certificate_certificate_data,
            compartment_id=compartment_id,
            private_key_data=certificate_private_key_data,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=certificate_display_name,
            freeform_tags={
                "Department": "Finance",
            },
            is_trust_verification_disabled=certificate_is_trust_verification_disabled)
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param CertificateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CertificateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_data: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 is_trust_verification_disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 private_key_data: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CertificateArgs.__new__(CertificateArgs)

            if certificate_data is None and not opts.urn:
                raise TypeError("Missing required property 'certificate_data'")
            __props__.__dict__["certificate_data"] = certificate_data
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["is_trust_verification_disabled"] = is_trust_verification_disabled
            if private_key_data is None and not opts.urn:
                raise TypeError("Missing required property 'private_key_data'")
            __props__.__dict__["private_key_data"] = None if private_key_data is None else pulumi.Output.secret(private_key_data)
            __props__.__dict__["extensions"] = None
            __props__.__dict__["issued_by"] = None
            __props__.__dict__["issuer_names"] = None
            __props__.__dict__["public_key_infos"] = None
            __props__.__dict__["serial_number"] = None
            __props__.__dict__["signature_algorithm"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["subject_names"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_not_valid_after"] = None
            __props__.__dict__["time_not_valid_before"] = None
            __props__.__dict__["version"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["privateKeyData"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Certificate, __self__).__init__(
            'oci:Waas/certificate:Certificate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            certificate_data: Optional[pulumi.Input[_builtins.str]] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            extensions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CertificateExtensionArgs', 'CertificateExtensionArgsDict']]]]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            is_trust_verification_disabled: Optional[pulumi.Input[_builtins.bool]] = None,
            issued_by: Optional[pulumi.Input[_builtins.str]] = None,
            issuer_names: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CertificateIssuerNameArgs', 'CertificateIssuerNameArgsDict']]]]] = None,
            private_key_data: Optional[pulumi.Input[_builtins.str]] = None,
            public_key_infos: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CertificatePublicKeyInfoArgs', 'CertificatePublicKeyInfoArgsDict']]]]] = None,
            serial_number: Optional[pulumi.Input[_builtins.str]] = None,
            signature_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            subject_names: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CertificateSubjectNameArgs', 'CertificateSubjectNameArgsDict']]]]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_not_valid_after: Optional[pulumi.Input[_builtins.str]] = None,
            time_not_valid_before: Optional[pulumi.Input[_builtins.str]] = None,
            version: Optional[pulumi.Input[_builtins.int]] = None) -> 'Certificate':
        """
        Get an existing Certificate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] certificate_data: The data of the SSL certificate.
               
               **Note:** Many SSL certificate providers require an intermediate certificate chain to ensure a trusted status. If your SSL certificate requires an intermediate certificate chain, please append the intermediate certificate key in the `certificateData` field after the leaf certificate issued by the SSL certificate provider. If you are unsure if your certificate requires an intermediate certificate chain, see your certificate provider's documentation.
               
               The example below shows an intermediate certificate appended to a leaf certificate.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to create the SSL certificate.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name for the SSL certificate. The name can be changed and does not need to be unique.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CertificateExtensionArgs', 'CertificateExtensionArgsDict']]]] extensions: Additional attributes associated with users or public keys for managing relationships between Certificate Authorities.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.bool] is_trust_verification_disabled: Set to `true` if the SSL certificate is self-signed.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CertificateIssuerNameArgs', 'CertificateIssuerNameArgsDict']]]] issuer_names: The issuer of the certificate.
        :param pulumi.Input[_builtins.str] private_key_data: The private key of the SSL certificate.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Sequence[pulumi.Input[Union['CertificatePublicKeyInfoArgs', 'CertificatePublicKeyInfoArgsDict']]]] public_key_infos: Information about the public key and the algorithm used by the public key.
        :param pulumi.Input[_builtins.str] serial_number: A unique, positive integer assigned by the Certificate Authority (CA). The issuer name and serial number identify a unique certificate.
        :param pulumi.Input[_builtins.str] signature_algorithm: The identifier for the cryptographic algorithm used by the Certificate Authority (CA) to sign this certificate.
        :param pulumi.Input[_builtins.str] state: The current lifecycle state of the SSL certificate.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CertificateSubjectNameArgs', 'CertificateSubjectNameArgsDict']]]] subject_names: The entity to be secured by the certificate.
        :param pulumi.Input[_builtins.str] time_created: The date and time the certificate was created, expressed in RFC 3339 timestamp format.
        :param pulumi.Input[_builtins.str] time_not_valid_after: The date and time the certificate will expire, expressed in RFC 3339 timestamp format.
        :param pulumi.Input[_builtins.str] time_not_valid_before: The date and time the certificate will become valid, expressed in RFC 3339 timestamp format.
        :param pulumi.Input[_builtins.int] version: The version of the encoded certificate.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CertificateState.__new__(_CertificateState)

        __props__.__dict__["certificate_data"] = certificate_data
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["extensions"] = extensions
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["is_trust_verification_disabled"] = is_trust_verification_disabled
        __props__.__dict__["issued_by"] = issued_by
        __props__.__dict__["issuer_names"] = issuer_names
        __props__.__dict__["private_key_data"] = private_key_data
        __props__.__dict__["public_key_infos"] = public_key_infos
        __props__.__dict__["serial_number"] = serial_number
        __props__.__dict__["signature_algorithm"] = signature_algorithm
        __props__.__dict__["state"] = state
        __props__.__dict__["subject_names"] = subject_names
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_not_valid_after"] = time_not_valid_after
        __props__.__dict__["time_not_valid_before"] = time_not_valid_before
        __props__.__dict__["version"] = version
        return Certificate(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="certificateData")
    def certificate_data(self) -> pulumi.Output[_builtins.str]:
        """
        The data of the SSL certificate.

        **Note:** Many SSL certificate providers require an intermediate certificate chain to ensure a trusted status. If your SSL certificate requires an intermediate certificate chain, please append the intermediate certificate key in the `certificateData` field after the leaf certificate issued by the SSL certificate provider. If you are unsure if your certificate requires an intermediate certificate chain, see your certificate provider's documentation.

        The example below shows an intermediate certificate appended to a leaf certificate.
        """
        return pulumi.get(self, "certificate_data")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to create the SSL certificate.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) A user-friendly name for the SSL certificate. The name can be changed and does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def extensions(self) -> pulumi.Output[Sequence['outputs.CertificateExtension']]:
        """
        Additional attributes associated with users or public keys for managing relationships between Certificate Authorities.
        """
        return pulumi.get(self, "extensions")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="isTrustVerificationDisabled")
    def is_trust_verification_disabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Set to `true` if the SSL certificate is self-signed.
        """
        return pulumi.get(self, "is_trust_verification_disabled")

    @_builtins.property
    @pulumi.getter(name="issuedBy")
    def issued_by(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "issued_by")

    @_builtins.property
    @pulumi.getter(name="issuerNames")
    def issuer_names(self) -> pulumi.Output[Sequence['outputs.CertificateIssuerName']]:
        """
        The issuer of the certificate.
        """
        return pulumi.get(self, "issuer_names")

    @_builtins.property
    @pulumi.getter(name="privateKeyData")
    def private_key_data(self) -> pulumi.Output[_builtins.str]:
        """
        The private key of the SSL certificate.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "private_key_data")

    @_builtins.property
    @pulumi.getter(name="publicKeyInfos")
    def public_key_infos(self) -> pulumi.Output[Sequence['outputs.CertificatePublicKeyInfo']]:
        """
        Information about the public key and the algorithm used by the public key.
        """
        return pulumi.get(self, "public_key_infos")

    @_builtins.property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> pulumi.Output[_builtins.str]:
        """
        A unique, positive integer assigned by the Certificate Authority (CA). The issuer name and serial number identify a unique certificate.
        """
        return pulumi.get(self, "serial_number")

    @_builtins.property
    @pulumi.getter(name="signatureAlgorithm")
    def signature_algorithm(self) -> pulumi.Output[_builtins.str]:
        """
        The identifier for the cryptographic algorithm used by the Certificate Authority (CA) to sign this certificate.
        """
        return pulumi.get(self, "signature_algorithm")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current lifecycle state of the SSL certificate.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="subjectNames")
    def subject_names(self) -> pulumi.Output[Sequence['outputs.CertificateSubjectName']]:
        """
        The entity to be secured by the certificate.
        """
        return pulumi.get(self, "subject_names")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the certificate was created, expressed in RFC 3339 timestamp format.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeNotValidAfter")
    def time_not_valid_after(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the certificate will expire, expressed in RFC 3339 timestamp format.
        """
        return pulumi.get(self, "time_not_valid_after")

    @_builtins.property
    @pulumi.getter(name="timeNotValidBefore")
    def time_not_valid_before(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the certificate will become valid, expressed in RFC 3339 timestamp format.
        """
        return pulumi.get(self, "time_not_valid_before")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.int]:
        """
        The version of the encoded certificate.
        """
        return pulumi.get(self, "version")

