# coding: utf-8

"""
    REST API

    Rockset's REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.  All requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example: ``` Authorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT ```  All endpoints are only accessible via https.  Build something awesome!  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from rockset.swagger_client.api_client import ApiClient


class QueriesApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def query(self, body, **kwargs):  # noqa: E501
        """Query  # noqa: E501

        Make a SQL query to Rockset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query(body, async=True)
        >>> result = thread.get()

        :param async_req bool
        :param QueryRequest body: JSON object (required)
        :return: QueryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.query_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.query_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def query_with_http_info(self, body, **kwargs):  # noqa: E501
        """Query  # noqa: E501

        Make a SQL query to Rockset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.query_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param QueryRequest body: JSON object (required)
        :return: QueryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method query" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `query`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = 'application/json' # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = 'application/json'  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/orgs/self/queries', 'POST',
            body_params,
            path_params,
            query_params,
            header_params,
            post_params=form_params,
            files=local_var_files,
            response_type='QueryResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def validate(self, body, **kwargs):  # noqa: E501
        """Validate Query  # noqa: E501

        Validate a SQL query with Rockset's parser and planner.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.validate(body, async=True)
        >>> result = thread.get()

        :param async_req bool
        :param QueryRequest body: JSON object (required)
        :param bool parameters:
        :return: ValidateQueryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.validate_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.validate_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def validate_with_http_info(self, body, **kwargs):  # noqa: E501
        """Validate Query  # noqa: E501

        Validate a SQL query with Rockset's parser and planner.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.validate_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param QueryRequest body: JSON object (required)
        :param bool parameters:
        :return: ValidateQueryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'parameters']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method validate" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `validate`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'parameters' in params:
            query_params.append(('parameters', params['parameters']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = 'application/json' # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = 'application/json'  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/orgs/self/queries/validations', 'POST',
            body_params,
            path_params,
            query_params,
            header_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ValidateQueryResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
