# coding: utf-8

"""
    REST API

    Rockset's REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.  All requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example: ``` Authorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT ```  All endpoints are only accessible via https.  Build something awesome!  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from rockset.swagger_client.api_client import ApiClient


class QueryLambdasApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create(self, workspace, body, **kwargs):  # noqa: E501
        """Create Query Lambda  # noqa: E501

        Create a Query Lambda in given workspace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create(workspace, body, async=True)
        >>> result = thread.get()

        :param async_req bool
        :param str workspace: name of the workspace (required)
        :param CreateQueryLambdaRequest body: JSON object (required)
        :return: QueryLambdaVersionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_with_http_info(workspace, body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_with_http_info(workspace, body, **kwargs)  # noqa: E501
            return data

    def create_with_http_info(self, workspace, body, **kwargs):  # noqa: E501
        """Create Query Lambda  # noqa: E501

        Create a Query Lambda in given workspace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_with_http_info(workspace, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str workspace: name of the workspace (required)
        :param CreateQueryLambdaRequest body: JSON object (required)
        :return: QueryLambdaVersionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workspace', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workspace' is set
        if ('workspace' not in params or
                params['workspace'] is None):
            raise ValueError("Missing the required parameter `workspace` when calling `create`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workspace' in params:
            path_params['workspace'] = params['workspace']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = 'application/json' # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = 'application/json'  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/orgs/self/ws/{workspace}/lambdas', 'POST',
            body_params,
            path_params,
            query_params,
            header_params,
            post_params=form_params,
            files=local_var_files,
            response_type='QueryLambdaVersionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_0(self, workspace, query_lambda, body, **kwargs):  # noqa: E501
        """Create Query Lambda Tag  # noqa: E501

        Create a tag for a specific Query Lambda version, or update that tag if it already exists.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_0(workspace, query_lambda, body, async=True)
        >>> result = thread.get()

        :param async_req bool
        :param str workspace: name of the workspace (required)
        :param str query_lambda: name of the Query Lambda (required)
        :param CreateQueryLambdaTagRequest body: JSON object (required)
        :return: QueryLambdaTagResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_0_with_http_info(workspace, query_lambda, body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_0_with_http_info(workspace, query_lambda, body, **kwargs)  # noqa: E501
            return data

    def create_0_with_http_info(self, workspace, query_lambda, body, **kwargs):  # noqa: E501
        """Create Query Lambda Tag  # noqa: E501

        Create a tag for a specific Query Lambda version, or update that tag if it already exists.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_0_with_http_info(workspace, query_lambda, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str workspace: name of the workspace (required)
        :param str query_lambda: name of the Query Lambda (required)
        :param CreateQueryLambdaTagRequest body: JSON object (required)
        :return: QueryLambdaTagResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workspace', 'query_lambda', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_0" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workspace' is set
        if ('workspace' not in params or
                params['workspace'] is None):
            raise ValueError("Missing the required parameter `workspace` when calling `create_0`")  # noqa: E501
        # verify the required parameter 'query_lambda' is set
        if ('query_lambda' not in params or
                params['query_lambda'] is None):
            raise ValueError("Missing the required parameter `query_lambda` when calling `create_0`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_0`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workspace' in params:
            path_params['workspace'] = params['workspace']  # noqa: E501
        if 'query_lambda' in params:
            path_params['queryLambda'] = params['query_lambda']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = 'application/json' # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = 'application/json'  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/orgs/self/ws/{workspace}/lambdas/{queryLambda}/tags', 'POST',
            body_params,
            path_params,
            query_params,
            header_params,
            post_params=form_params,
            files=local_var_files,
            response_type='QueryLambdaTagResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete(self, workspace, query_lambda, **kwargs):  # noqa: E501
        """Delete Query Lambda  # noqa: E501

        Delete a Query Lambda.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete(workspace, query_lambda, async=True)
        >>> result = thread.get()

        :param async_req bool
        :param str workspace: name of the workspace (required)
        :param str query_lambda: name of the Query Lambda (required)
        :return: DeleteQueryLambdaResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_with_http_info(workspace, query_lambda, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_with_http_info(workspace, query_lambda, **kwargs)  # noqa: E501
            return data

    def delete_with_http_info(self, workspace, query_lambda, **kwargs):  # noqa: E501
        """Delete Query Lambda  # noqa: E501

        Delete a Query Lambda.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_with_http_info(workspace, query_lambda, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str workspace: name of the workspace (required)
        :param str query_lambda: name of the Query Lambda (required)
        :return: DeleteQueryLambdaResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workspace', 'query_lambda']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workspace' is set
        if ('workspace' not in params or
                params['workspace'] is None):
            raise ValueError("Missing the required parameter `workspace` when calling `delete`")  # noqa: E501
        # verify the required parameter 'query_lambda' is set
        if ('query_lambda' not in params or
                params['query_lambda'] is None):
            raise ValueError("Missing the required parameter `query_lambda` when calling `delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workspace' in params:
            path_params['workspace'] = params['workspace']  # noqa: E501
        if 'query_lambda' in params:
            path_params['queryLambda'] = params['query_lambda']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = 'application/json' # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = 'application/json'  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/orgs/self/ws/{workspace}/lambdas/{queryLambda}', 'DELETE',
            body_params,
            path_params,
            query_params,
            header_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeleteQueryLambdaResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_0(self, workspace, query_lambda, tag, **kwargs):  # noqa: E501
        """Delete Query Lambda Tag Version  # noqa: E501

        Delete a tag for a specific Query Lambda  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_0(workspace, query_lambda, tag, async=True)
        >>> result = thread.get()

        :param async_req bool
        :param str workspace: name of the workspace (required)
        :param str query_lambda: name of the Query Lambda (required)
        :param str tag: name of the tag (required)
        :return: QueryLambdaTagResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_0_with_http_info(workspace, query_lambda, tag, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_0_with_http_info(workspace, query_lambda, tag, **kwargs)  # noqa: E501
            return data

    def delete_0_with_http_info(self, workspace, query_lambda, tag, **kwargs):  # noqa: E501
        """Delete Query Lambda Tag Version  # noqa: E501

        Delete a tag for a specific Query Lambda  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_0_with_http_info(workspace, query_lambda, tag, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str workspace: name of the workspace (required)
        :param str query_lambda: name of the Query Lambda (required)
        :param str tag: name of the tag (required)
        :return: QueryLambdaTagResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workspace', 'query_lambda', 'tag']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_0" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workspace' is set
        if ('workspace' not in params or
                params['workspace'] is None):
            raise ValueError("Missing the required parameter `workspace` when calling `delete_0`")  # noqa: E501
        # verify the required parameter 'query_lambda' is set
        if ('query_lambda' not in params or
                params['query_lambda'] is None):
            raise ValueError("Missing the required parameter `query_lambda` when calling `delete_0`")  # noqa: E501
        # verify the required parameter 'tag' is set
        if ('tag' not in params or
                params['tag'] is None):
            raise ValueError("Missing the required parameter `tag` when calling `delete_0`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workspace' in params:
            path_params['workspace'] = params['workspace']  # noqa: E501
        if 'query_lambda' in params:
            path_params['queryLambda'] = params['query_lambda']  # noqa: E501
        if 'tag' in params:
            path_params['tag'] = params['tag']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = 'application/json' # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = 'application/json'  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/orgs/self/ws/{workspace}/lambdas/{queryLambda}/tags/{tag}', 'DELETE',
            body_params,
            path_params,
            query_params,
            header_params,
            post_params=form_params,
            files=local_var_files,
            response_type='QueryLambdaTagResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_1(self, workspace, query_lambda, version, **kwargs):  # noqa: E501
        """Delete Query Lambda Version  # noqa: E501

        Delete a Query Lambda version.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_1(workspace, query_lambda, version, async=True)
        >>> result = thread.get()

        :param async_req bool
        :param str workspace: name of the workspace (required)
        :param str query_lambda: name of the Query Lambda (required)
        :param str version: version (required)
        :return: QueryLambdaVersionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_1_with_http_info(workspace, query_lambda, version, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_1_with_http_info(workspace, query_lambda, version, **kwargs)  # noqa: E501
            return data

    def delete_1_with_http_info(self, workspace, query_lambda, version, **kwargs):  # noqa: E501
        """Delete Query Lambda Version  # noqa: E501

        Delete a Query Lambda version.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_1_with_http_info(workspace, query_lambda, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str workspace: name of the workspace (required)
        :param str query_lambda: name of the Query Lambda (required)
        :param str version: version (required)
        :return: QueryLambdaVersionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workspace', 'query_lambda', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_1" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workspace' is set
        if ('workspace' not in params or
                params['workspace'] is None):
            raise ValueError("Missing the required parameter `workspace` when calling `delete_1`")  # noqa: E501
        # verify the required parameter 'query_lambda' is set
        if ('query_lambda' not in params or
                params['query_lambda'] is None):
            raise ValueError("Missing the required parameter `query_lambda` when calling `delete_1`")  # noqa: E501
        # verify the required parameter 'version' is set
        if ('version' not in params or
                params['version'] is None):
            raise ValueError("Missing the required parameter `version` when calling `delete_1`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workspace' in params:
            path_params['workspace'] = params['workspace']  # noqa: E501
        if 'query_lambda' in params:
            path_params['queryLambda'] = params['query_lambda']  # noqa: E501
        if 'version' in params:
            path_params['version'] = params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = 'application/json' # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = 'application/json'  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/orgs/self/ws/{workspace}/lambdas/{queryLambda}/version/{version}', 'DELETE',
            body_params,
            path_params,
            query_params,
            header_params,
            post_params=form_params,
            files=local_var_files,
            response_type='QueryLambdaVersionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def execute(self, workspace, query_lambda, tag, **kwargs):  # noqa: E501
        """Execute Query Lambda By Tag  # noqa: E501

        Execute the Query Lambda version associated with a given tag.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.execute(workspace, query_lambda, tag, async=True)
        >>> result = thread.get()

        :param async_req bool
        :param str workspace: name of the workspace (required)
        :param str query_lambda: name of the Query Lambda (required)
        :param str tag: tag (required)
        :param ExecuteQueryLambdaRequest body: JSON object
        :return: QueryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.execute_with_http_info(workspace, query_lambda, tag, **kwargs)  # noqa: E501
        else:
            (data) = self.execute_with_http_info(workspace, query_lambda, tag, **kwargs)  # noqa: E501
            return data

    def execute_with_http_info(self, workspace, query_lambda, tag, **kwargs):  # noqa: E501
        """Execute Query Lambda By Tag  # noqa: E501

        Execute the Query Lambda version associated with a given tag.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.execute_with_http_info(workspace, query_lambda, tag, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str workspace: name of the workspace (required)
        :param str query_lambda: name of the Query Lambda (required)
        :param str tag: tag (required)
        :param ExecuteQueryLambdaRequest body: JSON object
        :return: QueryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workspace', 'query_lambda', 'tag', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method execute" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workspace' is set
        if ('workspace' not in params or
                params['workspace'] is None):
            raise ValueError("Missing the required parameter `workspace` when calling `execute`")  # noqa: E501
        # verify the required parameter 'query_lambda' is set
        if ('query_lambda' not in params or
                params['query_lambda'] is None):
            raise ValueError("Missing the required parameter `query_lambda` when calling `execute`")  # noqa: E501
        # verify the required parameter 'tag' is set
        if ('tag' not in params or
                params['tag'] is None):
            raise ValueError("Missing the required parameter `tag` when calling `execute`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workspace' in params:
            path_params['workspace'] = params['workspace']  # noqa: E501
        if 'query_lambda' in params:
            path_params['queryLambda'] = params['query_lambda']  # noqa: E501
        if 'tag' in params:
            path_params['tag'] = params['tag']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = 'application/json' # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = 'application/json'  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/orgs/self/ws/{workspace}/lambdas/{queryLambda}/tags/{tag}', 'POST',
            body_params,
            path_params,
            query_params,
            header_params,
            post_params=form_params,
            files=local_var_files,
            response_type='QueryResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def execute_0(self, workspace, query_lambda, version, **kwargs):  # noqa: E501
        """Execute Query Lambda  # noqa: E501

        Execute a particular version of a Query Lambda.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.execute_0(workspace, query_lambda, version, async=True)
        >>> result = thread.get()

        :param async_req bool
        :param str workspace: name of the workspace (required)
        :param str query_lambda: name of the Query Lambda (required)
        :param str version: version (required)
        :param ExecuteQueryLambdaRequest body: JSON object
        :return: QueryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.execute_0_with_http_info(workspace, query_lambda, version, **kwargs)  # noqa: E501
        else:
            (data) = self.execute_0_with_http_info(workspace, query_lambda, version, **kwargs)  # noqa: E501
            return data

    def execute_0_with_http_info(self, workspace, query_lambda, version, **kwargs):  # noqa: E501
        """Execute Query Lambda  # noqa: E501

        Execute a particular version of a Query Lambda.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.execute_0_with_http_info(workspace, query_lambda, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str workspace: name of the workspace (required)
        :param str query_lambda: name of the Query Lambda (required)
        :param str version: version (required)
        :param ExecuteQueryLambdaRequest body: JSON object
        :return: QueryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workspace', 'query_lambda', 'version', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method execute_0" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workspace' is set
        if ('workspace' not in params or
                params['workspace'] is None):
            raise ValueError("Missing the required parameter `workspace` when calling `execute_0`")  # noqa: E501
        # verify the required parameter 'query_lambda' is set
        if ('query_lambda' not in params or
                params['query_lambda'] is None):
            raise ValueError("Missing the required parameter `query_lambda` when calling `execute_0`")  # noqa: E501
        # verify the required parameter 'version' is set
        if ('version' not in params or
                params['version'] is None):
            raise ValueError("Missing the required parameter `version` when calling `execute_0`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workspace' in params:
            path_params['workspace'] = params['workspace']  # noqa: E501
        if 'query_lambda' in params:
            path_params['queryLambda'] = params['query_lambda']  # noqa: E501
        if 'version' in params:
            path_params['version'] = params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = 'application/json' # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = 'application/json'  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/orgs/self/ws/{workspace}/lambdas/{queryLambda}/versions/{version}', 'POST',
            body_params,
            path_params,
            query_params,
            header_params,
            post_params=form_params,
            files=local_var_files,
            response_type='QueryResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get(self, workspace, query_lambda, tag, **kwargs):  # noqa: E501
        """Get Query Lambda Tag  # noqa: E501

        Get the Query Lambda version associated with a given tag.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get(workspace, query_lambda, tag, async=True)
        >>> result = thread.get()

        :param async_req bool
        :param str workspace: name of the workspace (required)
        :param str query_lambda: name of the Query Lambda (required)
        :param str tag: name of the tag (required)
        :return: QueryLambdaTagResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_with_http_info(workspace, query_lambda, tag, **kwargs)  # noqa: E501
        else:
            (data) = self.get_with_http_info(workspace, query_lambda, tag, **kwargs)  # noqa: E501
            return data

    def get_with_http_info(self, workspace, query_lambda, tag, **kwargs):  # noqa: E501
        """Get Query Lambda Tag  # noqa: E501

        Get the Query Lambda version associated with a given tag.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_with_http_info(workspace, query_lambda, tag, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str workspace: name of the workspace (required)
        :param str query_lambda: name of the Query Lambda (required)
        :param str tag: name of the tag (required)
        :return: QueryLambdaTagResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workspace', 'query_lambda', 'tag']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workspace' is set
        if ('workspace' not in params or
                params['workspace'] is None):
            raise ValueError("Missing the required parameter `workspace` when calling `get`")  # noqa: E501
        # verify the required parameter 'query_lambda' is set
        if ('query_lambda' not in params or
                params['query_lambda'] is None):
            raise ValueError("Missing the required parameter `query_lambda` when calling `get`")  # noqa: E501
        # verify the required parameter 'tag' is set
        if ('tag' not in params or
                params['tag'] is None):
            raise ValueError("Missing the required parameter `tag` when calling `get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workspace' in params:
            path_params['workspace'] = params['workspace']  # noqa: E501
        if 'query_lambda' in params:
            path_params['queryLambda'] = params['query_lambda']  # noqa: E501
        if 'tag' in params:
            path_params['tag'] = params['tag']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = 'application/json' # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = 'application/json'  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/orgs/self/ws/{workspace}/lambdas/{queryLambda}/tags/{tag}', 'GET',
            body_params,
            path_params,
            query_params,
            header_params,
            post_params=form_params,
            files=local_var_files,
            response_type='QueryLambdaTagResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_0(self, workspace, query_lambda, version, **kwargs):  # noqa: E501
        """Get Query Lambda Version  # noqa: E501

        Get details for a specified version of a Query Lambda.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_0(workspace, query_lambda, version, async=True)
        >>> result = thread.get()

        :param async_req bool
        :param str workspace: name of the workspace (required)
        :param str query_lambda: name of the Query Lambda (required)
        :param str version: version (required)
        :return: QueryLambdaVersionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_0_with_http_info(workspace, query_lambda, version, **kwargs)  # noqa: E501
        else:
            (data) = self.get_0_with_http_info(workspace, query_lambda, version, **kwargs)  # noqa: E501
            return data

    def get_0_with_http_info(self, workspace, query_lambda, version, **kwargs):  # noqa: E501
        """Get Query Lambda Version  # noqa: E501

        Get details for a specified version of a Query Lambda.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_0_with_http_info(workspace, query_lambda, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str workspace: name of the workspace (required)
        :param str query_lambda: name of the Query Lambda (required)
        :param str version: version (required)
        :return: QueryLambdaVersionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workspace', 'query_lambda', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_0" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workspace' is set
        if ('workspace' not in params or
                params['workspace'] is None):
            raise ValueError("Missing the required parameter `workspace` when calling `get_0`")  # noqa: E501
        # verify the required parameter 'query_lambda' is set
        if ('query_lambda' not in params or
                params['query_lambda'] is None):
            raise ValueError("Missing the required parameter `query_lambda` when calling `get_0`")  # noqa: E501
        # verify the required parameter 'version' is set
        if ('version' not in params or
                params['version'] is None):
            raise ValueError("Missing the required parameter `version` when calling `get_0`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workspace' in params:
            path_params['workspace'] = params['workspace']  # noqa: E501
        if 'query_lambda' in params:
            path_params['queryLambda'] = params['query_lambda']  # noqa: E501
        if 'version' in params:
            path_params['version'] = params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = 'application/json' # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = 'application/json'  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/orgs/self/ws/{workspace}/lambdas/{queryLambda}/versions/{version}', 'GET',
            body_params,
            path_params,
            query_params,
            header_params,
            post_params=form_params,
            files=local_var_files,
            response_type='QueryLambdaVersionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list(self, **kwargs):  # noqa: E501
        """List Query Lambdas  # noqa: E501

        List all Query Lambdas in an organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list(async=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ListQueryLambdasResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_with_http_info(self, **kwargs):  # noqa: E501
        """List Query Lambdas  # noqa: E501

        List all Query Lambdas in an organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ListQueryLambdasResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = 'application/json' # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = 'application/json'  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/orgs/self/lambdas', 'GET',
            body_params,
            path_params,
            query_params,
            header_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ListQueryLambdasResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_0(self, **kwargs):  # noqa: E501
        """List All Query Lambda Tags  # noqa: E501

        List all distinct Query Lambda tags in an organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_0(async=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ListQueryLambdaTagsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_0_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_0_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_0_with_http_info(self, **kwargs):  # noqa: E501
        """List All Query Lambda Tags  # noqa: E501

        List all distinct Query Lambda tags in an organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.list_0_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ListQueryLambdaTagsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_0" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = 'application/json' # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = 'application/json'  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/orgs/self/lambdas/tags', 'GET',
            body_params,
            path_params,
            query_params,
            header_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ListQueryLambdaTagsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_1(self, tag, **kwargs):  # noqa: E501
        """List Query Lambda Tag Versions  # noqa: E501

        List all Query Lambda versions associated with a given tag.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_1(tag, async=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tag: name of the tag (required)
        :return: ListQueryLambdaVersionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_1_with_http_info(tag, **kwargs)  # noqa: E501
        else:
            (data) = self.list_1_with_http_info(tag, **kwargs)  # noqa: E501
            return data

    def list_1_with_http_info(self, tag, **kwargs):  # noqa: E501
        """List Query Lambda Tag Versions  # noqa: E501

        List all Query Lambda versions associated with a given tag.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.list_1_with_http_info(tag, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tag: name of the tag (required)
        :return: ListQueryLambdaVersionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['tag']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_1" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'tag' is set
        if ('tag' not in params or
                params['tag'] is None):
            raise ValueError("Missing the required parameter `tag` when calling `list_1`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tag' in params:
            path_params['tag'] = params['tag']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = 'application/json' # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = 'application/json'  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/orgs/self/lambdas/tags/{tag}', 'GET',
            body_params,
            path_params,
            query_params,
            header_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ListQueryLambdaVersionsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_2(self, workspace, **kwargs):  # noqa: E501
        """List Query Lambdas in Workspace  # noqa: E501

        List all Query Lambdas under given workspace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_2(workspace, async=True)
        >>> result = thread.get()

        :param async_req bool
        :param str workspace: name of the workspace (required)
        :return: ListQueryLambdasResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_2_with_http_info(workspace, **kwargs)  # noqa: E501
        else:
            (data) = self.list_2_with_http_info(workspace, **kwargs)  # noqa: E501
            return data

    def list_2_with_http_info(self, workspace, **kwargs):  # noqa: E501
        """List Query Lambdas in Workspace  # noqa: E501

        List all Query Lambdas under given workspace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.list_2_with_http_info(workspace, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str workspace: name of the workspace (required)
        :return: ListQueryLambdasResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workspace']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_2" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workspace' is set
        if ('workspace' not in params or
                params['workspace'] is None):
            raise ValueError("Missing the required parameter `workspace` when calling `list_2`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workspace' in params:
            path_params['workspace'] = params['workspace']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = 'application/json' # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = 'application/json'  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/orgs/self/ws/{workspace}/lambdas', 'GET',
            body_params,
            path_params,
            query_params,
            header_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ListQueryLambdasResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_3(self, workspace, query_lambda, **kwargs):  # noqa: E501
        """List Query Lambda Tags  # noqa: E501

        List all tags associated with a Query Lambda  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_3(workspace, query_lambda, async=True)
        >>> result = thread.get()

        :param async_req bool
        :param str workspace: name of the workspace (required)
        :param str query_lambda: name of the Query Lambda (required)
        :return: ListQueryLambdaTagsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_3_with_http_info(workspace, query_lambda, **kwargs)  # noqa: E501
        else:
            (data) = self.list_3_with_http_info(workspace, query_lambda, **kwargs)  # noqa: E501
            return data

    def list_3_with_http_info(self, workspace, query_lambda, **kwargs):  # noqa: E501
        """List Query Lambda Tags  # noqa: E501

        List all tags associated with a Query Lambda  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.list_3_with_http_info(workspace, query_lambda, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str workspace: name of the workspace (required)
        :param str query_lambda: name of the Query Lambda (required)
        :return: ListQueryLambdaTagsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workspace', 'query_lambda']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_3" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workspace' is set
        if ('workspace' not in params or
                params['workspace'] is None):
            raise ValueError("Missing the required parameter `workspace` when calling `list_3`")  # noqa: E501
        # verify the required parameter 'query_lambda' is set
        if ('query_lambda' not in params or
                params['query_lambda'] is None):
            raise ValueError("Missing the required parameter `query_lambda` when calling `list_3`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workspace' in params:
            path_params['workspace'] = params['workspace']  # noqa: E501
        if 'query_lambda' in params:
            path_params['queryLambda'] = params['query_lambda']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = 'application/json' # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = 'application/json'  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/orgs/self/ws/{workspace}/lambdas/{queryLambda}/tags', 'GET',
            body_params,
            path_params,
            query_params,
            header_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ListQueryLambdaTagsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_4(self, workspace, query_lambda, **kwargs):  # noqa: E501
        """List Query Lambda Versions  # noqa: E501

        List all versions of a Query Lambda.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_4(workspace, query_lambda, async=True)
        >>> result = thread.get()

        :param async_req bool
        :param str workspace: name of the workspace (required)
        :param str query_lambda: name of the Query Lambda (required)
        :return: ListQueryLambdaVersionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_4_with_http_info(workspace, query_lambda, **kwargs)  # noqa: E501
        else:
            (data) = self.list_4_with_http_info(workspace, query_lambda, **kwargs)  # noqa: E501
            return data

    def list_4_with_http_info(self, workspace, query_lambda, **kwargs):  # noqa: E501
        """List Query Lambda Versions  # noqa: E501

        List all versions of a Query Lambda.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.list_4_with_http_info(workspace, query_lambda, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str workspace: name of the workspace (required)
        :param str query_lambda: name of the Query Lambda (required)
        :return: ListQueryLambdaVersionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workspace', 'query_lambda']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_4" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workspace' is set
        if ('workspace' not in params or
                params['workspace'] is None):
            raise ValueError("Missing the required parameter `workspace` when calling `list_4`")  # noqa: E501
        # verify the required parameter 'query_lambda' is set
        if ('query_lambda' not in params or
                params['query_lambda'] is None):
            raise ValueError("Missing the required parameter `query_lambda` when calling `list_4`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workspace' in params:
            path_params['workspace'] = params['workspace']  # noqa: E501
        if 'query_lambda' in params:
            path_params['queryLambda'] = params['query_lambda']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = 'application/json' # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = 'application/json'  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/orgs/self/ws/{workspace}/lambdas/{queryLambda}/versions', 'GET',
            body_params,
            path_params,
            query_params,
            header_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ListQueryLambdaVersionsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update(self, workspace, query_lambda, body, **kwargs):  # noqa: E501
        """Update Query Lambda  # noqa: E501

        Create a new version of a Query Lambda in given workspace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update(workspace, query_lambda, body, async=True)
        >>> result = thread.get()

        :param async_req bool
        :param str workspace: name of the workspace (required)
        :param str query_lambda: name of the Query Lambda (required)
        :param UpdateQueryLambdaRequest body: JSON object (required)
        :param bool create:
        :return: QueryLambdaVersionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_with_http_info(workspace, query_lambda, body, **kwargs)  # noqa: E501
        else:
            (data) = self.update_with_http_info(workspace, query_lambda, body, **kwargs)  # noqa: E501
            return data

    def update_with_http_info(self, workspace, query_lambda, body, **kwargs):  # noqa: E501
        """Update Query Lambda  # noqa: E501

        Create a new version of a Query Lambda in given workspace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_with_http_info(workspace, query_lambda, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str workspace: name of the workspace (required)
        :param str query_lambda: name of the Query Lambda (required)
        :param UpdateQueryLambdaRequest body: JSON object (required)
        :param bool create:
        :return: QueryLambdaVersionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workspace', 'query_lambda', 'body', 'create']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workspace' is set
        if ('workspace' not in params or
                params['workspace'] is None):
            raise ValueError("Missing the required parameter `workspace` when calling `update`")  # noqa: E501
        # verify the required parameter 'query_lambda' is set
        if ('query_lambda' not in params or
                params['query_lambda'] is None):
            raise ValueError("Missing the required parameter `query_lambda` when calling `update`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workspace' in params:
            path_params['workspace'] = params['workspace']  # noqa: E501
        if 'query_lambda' in params:
            path_params['queryLambda'] = params['query_lambda']  # noqa: E501

        query_params = []
        if 'create' in params:
            query_params.append(('create', params['create']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = 'application/json' # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = 'application/json'  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/orgs/self/ws/{workspace}/lambdas/{queryLambda}/versions', 'POST',
            body_params,
            path_params,
            query_params,
            header_params,
            post_params=form_params,
            files=local_var_files,
            response_type='QueryLambdaVersionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
