# coding: utf-8

"""
    REST API

    Rockset's REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.  All requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example: ``` Authorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT ```  All endpoints are only accessible via https.  Build something awesome!  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from rockset.swagger_client.api_client import ApiClient


class VirtualInstancesApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get(self, virtual_instance_id, **kwargs):  # noqa: E501
        """Get Virtual Instance  # noqa: E501

        Get details about a virtual instance.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get(virtual_instance_id, async=True)
        >>> result = thread.get()

        :param async_req bool
        :param str virtual_instance_id: uuid of the virtual instance (required)
        :return: GetVirtualInstanceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_with_http_info(virtual_instance_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_with_http_info(virtual_instance_id, **kwargs)  # noqa: E501
            return data

    def get_with_http_info(self, virtual_instance_id, **kwargs):  # noqa: E501
        """Get Virtual Instance  # noqa: E501

        Get details about a virtual instance.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_with_http_info(virtual_instance_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str virtual_instance_id: uuid of the virtual instance (required)
        :return: GetVirtualInstanceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['virtual_instance_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'virtual_instance_id' is set
        if ('virtual_instance_id' not in params or
                params['virtual_instance_id'] is None):
            raise ValueError("Missing the required parameter `virtual_instance_id` when calling `get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'virtual_instance_id' in params:
            path_params['virtualInstanceId'] = params['virtual_instance_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = 'application/json' # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = 'application/json'  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/orgs/self/virtualinstances/{virtualInstanceId}', 'GET',
            body_params,
            path_params,
            query_params,
            header_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetVirtualInstanceResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list(self, **kwargs):  # noqa: E501
        """List Virtual Instances  # noqa: E501

        Retrieve all virtual instances in an organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list(async=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ListVirtualInstancesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_with_http_info(self, **kwargs):  # noqa: E501
        """List Virtual Instances  # noqa: E501

        Retrieve all virtual instances in an organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ListVirtualInstancesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = 'application/json' # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = 'application/json'  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/orgs/self/virtualinstances', 'GET',
            body_params,
            path_params,
            query_params,
            header_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ListVirtualInstancesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set(self, virtual_instance_id, body, **kwargs):  # noqa: E501
        """Update Virtual Instance  # noqa: E501

        Update the size of a virtual instance.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set(virtual_instance_id, body, async=True)
        >>> result = thread.get()

        :param async_req bool
        :param str virtual_instance_id: uuid of the virtual instance (required)
        :param UpdateVirtualInstanceRequest body: JSON object (required)
        :return: UpdateVirtualInstanceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.set_with_http_info(virtual_instance_id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.set_with_http_info(virtual_instance_id, body, **kwargs)  # noqa: E501
            return data

    def set_with_http_info(self, virtual_instance_id, body, **kwargs):  # noqa: E501
        """Update Virtual Instance  # noqa: E501

        Update the size of a virtual instance.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.set_with_http_info(virtual_instance_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str virtual_instance_id: uuid of the virtual instance (required)
        :param UpdateVirtualInstanceRequest body: JSON object (required)
        :return: UpdateVirtualInstanceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['virtual_instance_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'virtual_instance_id' is set
        if ('virtual_instance_id' not in params or
                params['virtual_instance_id'] is None):
            raise ValueError("Missing the required parameter `virtual_instance_id` when calling `set`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `set`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'virtual_instance_id' in params:
            path_params['virtualInstanceId'] = params['virtual_instance_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = 'application/json' # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = 'application/json'  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/orgs/self/virtualinstances/{virtualInstanceId}', 'POST',
            body_params,
            path_params,
            query_params,
            header_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UpdateVirtualInstanceResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
