# coding: utf-8

"""
    REST API

    Rockset's REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.  All requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example: ``` Authorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT ```  All endpoints are only accessible via https.  Build something awesome!  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class Cluster(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'cluster_type': 'str',
        'aws_region': 'str',
        'domain': 'str',
        'top_level_domain': 'str',
        'apiserver_url': 'str'
    }

    attribute_map = {
        'id': 'id',
        'cluster_type': 'cluster_type',
        'aws_region': 'aws_region',
        'domain': 'domain',
        'top_level_domain': 'top_level_domain',
        'apiserver_url': 'apiserver_url'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """Cluster - a model defined in Swagger"""  # noqa: E501

        self._id = None
        self._cluster_type = None
        self._aws_region = None
        self._domain = None
        self._top_level_domain = None
        self._apiserver_url = None
        self.discriminator = None

        self.id = kwargs.pop('id', None)
        self.cluster_type = kwargs.pop('cluster_type', None)
        self.aws_region = kwargs.pop('aws_region', None)
        self.domain = kwargs.pop('domain', None)
        self.top_level_domain = kwargs.pop('top_level_domain', None)
        self.apiserver_url = kwargs.pop('apiserver_url', None)

    @property
    def id(self):
        """Gets the id of this Cluster.  # noqa: E501

        unique identifier for the cluster  # noqa: E501

        :return: The id of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Cluster.

        unique identifier for the cluster  # noqa: E501

        :param id: The id of this Cluster.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def cluster_type(self):
        """Gets the cluster_type of this Cluster.  # noqa: E501

        cluster type  # noqa: E501

        :return: The cluster_type of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._cluster_type

    @cluster_type.setter
    def cluster_type(self, cluster_type):
        """Sets the cluster_type of this Cluster.

        cluster type  # noqa: E501

        :param cluster_type: The cluster_type of this Cluster.  # noqa: E501
        :type: str
        """

        self._cluster_type = cluster_type

    @property
    def aws_region(self):
        """Gets the aws_region of this Cluster.  # noqa: E501

        aws region  # noqa: E501

        :return: The aws_region of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._aws_region

    @aws_region.setter
    def aws_region(self, aws_region):
        """Sets the aws_region of this Cluster.

        aws region  # noqa: E501

        :param aws_region: The aws_region of this Cluster.  # noqa: E501
        :type: str
        """

        self._aws_region = aws_region

    @property
    def domain(self):
        """Gets the domain of this Cluster.  # noqa: E501

        domain of org using cluster  # noqa: E501

        :return: The domain of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._domain

    @domain.setter
    def domain(self, domain):
        """Sets the domain of this Cluster.

        domain of org using cluster  # noqa: E501

        :param domain: The domain of this Cluster.  # noqa: E501
        :type: str
        """

        self._domain = domain

    @property
    def top_level_domain(self):
        """Gets the top_level_domain of this Cluster.  # noqa: E501

        top level domain of org using cluster  # noqa: E501

        :return: The top_level_domain of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._top_level_domain

    @top_level_domain.setter
    def top_level_domain(self, top_level_domain):
        """Sets the top_level_domain of this Cluster.

        top level domain of org using cluster  # noqa: E501

        :param top_level_domain: The top_level_domain of this Cluster.  # noqa: E501
        :type: str
        """

        self._top_level_domain = top_level_domain

    @property
    def apiserver_url(self):
        """Gets the apiserver_url of this Cluster.  # noqa: E501

        api server url for cluster  # noqa: E501

        :return: The apiserver_url of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._apiserver_url

    @apiserver_url.setter
    def apiserver_url(self, apiserver_url):
        """Sets the apiserver_url of this Cluster.

        api server url for cluster  # noqa: E501

        :param apiserver_url: The apiserver_url of this Cluster.  # noqa: E501
        :type: str
        """

        self._apiserver_url = apiserver_url

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Cluster, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Cluster):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

    def __getitem__(self, item):
        return getattr(self, item)

    def get(self, item):
        return getattr(self, item)

    def items(self):
        return self.to_dict().items()

    def __setitem__(self, item, value):
        return seattr(self, item, value)
