# coding: utf-8

"""
    REST API

    Rockset's REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.  All requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example: ``` Authorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT ```  All endpoints are only accessible via https.  Build something awesome!  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from rockset.swagger_client.models.event_time_info import EventTimeInfo  # noqa: F401,E501
from rockset.swagger_client.models.field_mapping_v2 import FieldMappingV2  # noqa: F401,E501
from rockset.swagger_client.models.field_partition import FieldPartition  # noqa: F401,E501
from rockset.swagger_client.models.field_schema import FieldSchema  # noqa: F401,E501
from rockset.swagger_client.models.inverted_index_group_encoding_options import InvertedIndexGroupEncodingOptions  # noqa: F401,E501
from rockset.swagger_client.models.source import Source  # noqa: F401,E501


class CreateCollectionRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'description': 'str',
        'sources': 'list[Source]',
        'retention_secs': 'int',
        'event_time_info': 'EventTimeInfo',
        'field_mappings': 'list[FieldMappingV2]',
        'clustering_key': 'list[FieldPartition]',
        'field_schemas': 'list[FieldSchema]',
        'inverted_index_group_encoding_options': 'InvertedIndexGroupEncodingOptions'
    }

    attribute_map = {
        'name': 'name',
        'description': 'description',
        'sources': 'sources',
        'retention_secs': 'retention_secs',
        'event_time_info': 'event_time_info',
        'field_mappings': 'field_mappings',
        'clustering_key': 'clustering_key',
        'field_schemas': 'field_schemas',
        'inverted_index_group_encoding_options': 'inverted_index_group_encoding_options'
    }

    def __init__(self, name, **kwargs):  # noqa: E501
        """CreateCollectionRequest - a model defined in Swagger"""  # noqa: E501

        self._name = None
        self._description = None
        self._sources = None
        self._retention_secs = None
        self._event_time_info = None
        self._field_mappings = None
        self._clustering_key = None
        self._field_schemas = None
        self._inverted_index_group_encoding_options = None
        self.discriminator = None

        self.name = name
        self.description = kwargs.pop('description', None)
        self.sources = kwargs.pop('sources', None)
        self.retention_secs = kwargs.pop('retention_secs', None)
        self.event_time_info = kwargs.pop('event_time_info', None)
        self.field_mappings = kwargs.pop('field_mappings', None)
        self.clustering_key = kwargs.pop('clustering_key', None)
        self.field_schemas = kwargs.pop('field_schemas', None)
        self.inverted_index_group_encoding_options = kwargs.pop('inverted_index_group_encoding_options', None)

    @property
    def name(self):
        """Gets the name of this CreateCollectionRequest.  # noqa: E501

        unique identifier for collection, can contain alphanumeric or dash characters  # noqa: E501

        :return: The name of this CreateCollectionRequest.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this CreateCollectionRequest.

        unique identifier for collection, can contain alphanumeric or dash characters  # noqa: E501

        :param name: The name of this CreateCollectionRequest.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def description(self):
        """Gets the description of this CreateCollectionRequest.  # noqa: E501

        text describing the collection  # noqa: E501

        :return: The description of this CreateCollectionRequest.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this CreateCollectionRequest.

        text describing the collection  # noqa: E501

        :param description: The description of this CreateCollectionRequest.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def sources(self):
        """Gets the sources of this CreateCollectionRequest.  # noqa: E501

        list of sources from which to ingest data  # noqa: E501

        :return: The sources of this CreateCollectionRequest.  # noqa: E501
        :rtype: list[Source]
        """
        return self._sources

    @sources.setter
    def sources(self, sources):
        """Sets the sources of this CreateCollectionRequest.

        list of sources from which to ingest data  # noqa: E501

        :param sources: The sources of this CreateCollectionRequest.  # noqa: E501
        :type: list[Source]
        """

        self._sources = sources

    @property
    def retention_secs(self):
        """Gets the retention_secs of this CreateCollectionRequest.  # noqa: E501

        number of seconds after which data is purged, based on event time  # noqa: E501

        :return: The retention_secs of this CreateCollectionRequest.  # noqa: E501
        :rtype: int
        """
        return self._retention_secs

    @retention_secs.setter
    def retention_secs(self, retention_secs):
        """Sets the retention_secs of this CreateCollectionRequest.

        number of seconds after which data is purged, based on event time  # noqa: E501

        :param retention_secs: The retention_secs of this CreateCollectionRequest.  # noqa: E501
        :type: int
        """

        self._retention_secs = retention_secs

    @property
    def event_time_info(self):
        """Gets the event_time_info of this CreateCollectionRequest.  # noqa: E501

        configuration for event data  # noqa: E501

        :return: The event_time_info of this CreateCollectionRequest.  # noqa: E501
        :rtype: EventTimeInfo
        """
        return self._event_time_info

    @event_time_info.setter
    def event_time_info(self, event_time_info):
        """Sets the event_time_info of this CreateCollectionRequest.

        configuration for event data  # noqa: E501

        :param event_time_info: The event_time_info of this CreateCollectionRequest.  # noqa: E501
        :type: EventTimeInfo
        """

        self._event_time_info = event_time_info

    @property
    def field_mappings(self):
        """Gets the field_mappings of this CreateCollectionRequest.  # noqa: E501

        list of mappings  # noqa: E501

        :return: The field_mappings of this CreateCollectionRequest.  # noqa: E501
        :rtype: list[FieldMappingV2]
        """
        return self._field_mappings

    @field_mappings.setter
    def field_mappings(self, field_mappings):
        """Sets the field_mappings of this CreateCollectionRequest.

        list of mappings  # noqa: E501

        :param field_mappings: The field_mappings of this CreateCollectionRequest.  # noqa: E501
        :type: list[FieldMappingV2]
        """

        self._field_mappings = field_mappings

    @property
    def clustering_key(self):
        """Gets the clustering_key of this CreateCollectionRequest.  # noqa: E501

        list of clustering fields  # noqa: E501

        :return: The clustering_key of this CreateCollectionRequest.  # noqa: E501
        :rtype: list[FieldPartition]
        """
        return self._clustering_key

    @clustering_key.setter
    def clustering_key(self, clustering_key):
        """Sets the clustering_key of this CreateCollectionRequest.

        list of clustering fields  # noqa: E501

        :param clustering_key: The clustering_key of this CreateCollectionRequest.  # noqa: E501
        :type: list[FieldPartition]
        """

        self._clustering_key = clustering_key

    @property
    def field_schemas(self):
        """Gets the field_schemas of this CreateCollectionRequest.  # noqa: E501

        list of field schemas  # noqa: E501

        :return: The field_schemas of this CreateCollectionRequest.  # noqa: E501
        :rtype: list[FieldSchema]
        """
        return self._field_schemas

    @field_schemas.setter
    def field_schemas(self, field_schemas):
        """Sets the field_schemas of this CreateCollectionRequest.

        list of field schemas  # noqa: E501

        :param field_schemas: The field_schemas of this CreateCollectionRequest.  # noqa: E501
        :type: list[FieldSchema]
        """

        self._field_schemas = field_schemas

    @property
    def inverted_index_group_encoding_options(self):
        """Gets the inverted_index_group_encoding_options of this CreateCollectionRequest.  # noqa: E501

        inverted index group encoding options  # noqa: E501

        :return: The inverted_index_group_encoding_options of this CreateCollectionRequest.  # noqa: E501
        :rtype: InvertedIndexGroupEncodingOptions
        """
        return self._inverted_index_group_encoding_options

    @inverted_index_group_encoding_options.setter
    def inverted_index_group_encoding_options(self, inverted_index_group_encoding_options):
        """Sets the inverted_index_group_encoding_options of this CreateCollectionRequest.

        inverted index group encoding options  # noqa: E501

        :param inverted_index_group_encoding_options: The inverted_index_group_encoding_options of this CreateCollectionRequest.  # noqa: E501
        :type: InvertedIndexGroupEncodingOptions
        """

        self._inverted_index_group_encoding_options = inverted_index_group_encoding_options

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(CreateCollectionRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CreateCollectionRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

    def __getitem__(self, item):
        return getattr(self, item)

    def get(self, item):
        return getattr(self, item)

    def items(self):
        return self.to_dict().items()

    def __setitem__(self, item, value):
        return seattr(self, item, value)
