# coding: utf-8

"""
    REST API

    Rockset's REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.  All requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example: ``` Authorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT ```  All endpoints are only accessible via https.  Build something awesome!  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class CsvParams(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'first_line_as_column_names': 'bool',
        'separator': 'str',
        'encoding': 'str',
        'column_names': 'list[str]',
        'column_types': 'list[str]',
        'quote_char': 'str',
        'escape_char': 'str'
    }

    attribute_map = {
        'first_line_as_column_names': 'firstLineAsColumnNames',
        'separator': 'separator',
        'encoding': 'encoding',
        'column_names': 'columnNames',
        'column_types': 'columnTypes',
        'quote_char': 'quoteChar',
        'escape_char': 'escapeChar'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """CsvParams - a model defined in Swagger"""  # noqa: E501

        self._first_line_as_column_names = None
        self._separator = None
        self._encoding = None
        self._column_names = None
        self._column_types = None
        self._quote_char = None
        self._escape_char = None
        self.discriminator = None

        self.first_line_as_column_names = kwargs.pop('first_line_as_column_names', None)
        self.separator = kwargs.pop('separator', None)
        self.encoding = kwargs.pop('encoding', None)
        self.column_names = kwargs.pop('column_names', None)
        self.column_types = kwargs.pop('column_types', None)
        self.quote_char = kwargs.pop('quote_char', None)
        self.escape_char = kwargs.pop('escape_char', None)

    @property
    def first_line_as_column_names(self):
        """Gets the first_line_as_column_names of this CsvParams.  # noqa: E501

        If the first line in every object specifies the column names  # noqa: E501

        :return: The first_line_as_column_names of this CsvParams.  # noqa: E501
        :rtype: bool
        """
        return self._first_line_as_column_names

    @first_line_as_column_names.setter
    def first_line_as_column_names(self, first_line_as_column_names):
        """Sets the first_line_as_column_names of this CsvParams.

        If the first line in every object specifies the column names  # noqa: E501

        :param first_line_as_column_names: The first_line_as_column_names of this CsvParams.  # noqa: E501
        :type: bool
        """

        self._first_line_as_column_names = first_line_as_column_names

    @property
    def separator(self):
        """Gets the separator of this CsvParams.  # noqa: E501

        a single character that is the column separator  # noqa: E501

        :return: The separator of this CsvParams.  # noqa: E501
        :rtype: str
        """
        return self._separator

    @separator.setter
    def separator(self, separator):
        """Sets the separator of this CsvParams.

        a single character that is the column separator  # noqa: E501

        :param separator: The separator of this CsvParams.  # noqa: E501
        :type: str
        """

        self._separator = separator

    @property
    def encoding(self):
        """Gets the encoding of this CsvParams.  # noqa: E501

        can be one of: UTF-8, ISO_8859_1, UTF-16  # noqa: E501

        :return: The encoding of this CsvParams.  # noqa: E501
        :rtype: str
        """
        return self._encoding

    @encoding.setter
    def encoding(self, encoding):
        """Sets the encoding of this CsvParams.

        can be one of: UTF-8, ISO_8859_1, UTF-16  # noqa: E501

        :param encoding: The encoding of this CsvParams.  # noqa: E501
        :type: str
        """

        self._encoding = encoding

    @property
    def column_names(self):
        """Gets the column_names of this CsvParams.  # noqa: E501

        names of columns  # noqa: E501

        :return: The column_names of this CsvParams.  # noqa: E501
        :rtype: list[str]
        """
        return self._column_names

    @column_names.setter
    def column_names(self, column_names):
        """Sets the column_names of this CsvParams.

        names of columns  # noqa: E501

        :param column_names: The column_names of this CsvParams.  # noqa: E501
        :type: list[str]
        """

        self._column_names = column_names

    @property
    def column_types(self):
        """Gets the column_types of this CsvParams.  # noqa: E501

        names of columns  # noqa: E501

        :return: The column_types of this CsvParams.  # noqa: E501
        :rtype: list[str]
        """
        return self._column_types

    @column_types.setter
    def column_types(self, column_types):
        """Sets the column_types of this CsvParams.

        names of columns  # noqa: E501

        :param column_types: The column_types of this CsvParams.  # noqa: E501
        :type: list[str]
        """

        self._column_types = column_types

    @property
    def quote_char(self):
        """Gets the quote_char of this CsvParams.  # noqa: E501

        character within which a cell value is enclosed,null character if no such character, default is '\"'  # noqa: E501

        :return: The quote_char of this CsvParams.  # noqa: E501
        :rtype: str
        """
        return self._quote_char

    @quote_char.setter
    def quote_char(self, quote_char):
        """Sets the quote_char of this CsvParams.

        character within which a cell value is enclosed,null character if no such character, default is '\"'  # noqa: E501

        :param quote_char: The quote_char of this CsvParams.  # noqa: E501
        :type: str
        """

        self._quote_char = quote_char

    @property
    def escape_char(self):
        """Gets the escape_char of this CsvParams.  # noqa: E501

        escape character removes any special meaning from the following character,default is '\\'  # noqa: E501

        :return: The escape_char of this CsvParams.  # noqa: E501
        :rtype: str
        """
        return self._escape_char

    @escape_char.setter
    def escape_char(self, escape_char):
        """Sets the escape_char of this CsvParams.

        escape character removes any special meaning from the following character,default is '\\'  # noqa: E501

        :param escape_char: The escape_char of this CsvParams.  # noqa: E501
        :type: str
        """

        self._escape_char = escape_char

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(CsvParams, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CsvParams):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

    def __getitem__(self, item):
        return getattr(self, item)

    def get(self, item):
        return getattr(self, item)

    def items(self):
        return self.to_dict().items()

    def __setitem__(self, item, value):
        return seattr(self, item, value)
