# coding: utf-8

"""
    REST API

    Rockset's REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.  All requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example: ``` Authorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT ```  All endpoints are only accessible via https.  Build something awesome!  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from rockset.swagger_client.models.error_model import ErrorModel  # noqa: F401,E501


class DocumentStatus(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'collection': 'str',
        'error': 'ErrorModel',
        'id': 'str',
        'status': 'str',
        'patch_id': 'str'
    }

    attribute_map = {
        'collection': '_collection',
        'error': 'error',
        'id': '_id',
        'status': 'status',
        'patch_id': 'patch_id'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """DocumentStatus - a model defined in Swagger"""  # noqa: E501

        self._collection = None
        self._error = None
        self._id = None
        self._status = None
        self._patch_id = None
        self.discriminator = None

        self.collection = kwargs.pop('collection', None)
        self.error = kwargs.pop('error', None)
        self.id = kwargs.pop('id', None)
        self.status = kwargs.pop('status', None)
        self.patch_id = kwargs.pop('patch_id', None)

    @property
    def collection(self):
        """Gets the collection of this DocumentStatus.  # noqa: E501

        collection name  # noqa: E501

        :return: The collection of this DocumentStatus.  # noqa: E501
        :rtype: str
        """
        return self._collection

    @collection.setter
    def collection(self, collection):
        """Sets the collection of this DocumentStatus.

        collection name  # noqa: E501

        :param collection: The collection of this DocumentStatus.  # noqa: E501
        :type: str
        """

        self._collection = collection

    @property
    def error(self):
        """Gets the error of this DocumentStatus.  # noqa: E501

        error message, if any  # noqa: E501

        :return: The error of this DocumentStatus.  # noqa: E501
        :rtype: ErrorModel
        """
        return self._error

    @error.setter
    def error(self, error):
        """Sets the error of this DocumentStatus.

        error message, if any  # noqa: E501

        :param error: The error of this DocumentStatus.  # noqa: E501
        :type: ErrorModel
        """

        self._error = error

    @property
    def id(self):
        """Gets the id of this DocumentStatus.  # noqa: E501

        unique document ID  # noqa: E501

        :return: The id of this DocumentStatus.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this DocumentStatus.

        unique document ID  # noqa: E501

        :param id: The id of this DocumentStatus.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def status(self):
        """Gets the status of this DocumentStatus.  # noqa: E501

        status, one of ADDED, REPLACED, DELETED, ERROR  # noqa: E501

        :return: The status of this DocumentStatus.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this DocumentStatus.

        status, one of ADDED, REPLACED, DELETED, ERROR  # noqa: E501

        :param status: The status of this DocumentStatus.  # noqa: E501
        :type: str
        """

        self._status = status

    @property
    def patch_id(self):
        """Gets the patch_id of this DocumentStatus.  # noqa: E501

        unique id used to represent each patch request  # noqa: E501

        :return: The patch_id of this DocumentStatus.  # noqa: E501
        :rtype: str
        """
        return self._patch_id

    @patch_id.setter
    def patch_id(self, patch_id):
        """Sets the patch_id of this DocumentStatus.

        unique id used to represent each patch request  # noqa: E501

        :param patch_id: The patch_id of this DocumentStatus.  # noqa: E501
        :type: str
        """

        self._patch_id = patch_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(DocumentStatus, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DocumentStatus):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

    def __getitem__(self, item):
        return getattr(self, item)

    def get(self, item):
        return getattr(self, item)

    def items(self):
        return self.to_dict().items()

    def __setitem__(self, item, value):
        return seattr(self, item, value)
