# coding: utf-8

"""
    REST API

    Rockset's REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.  All requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example: ``` Authorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT ```  All endpoints are only accessible via https.  Build something awesome!  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class ErrorModel(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'message': 'str',
        'type': 'str',
        'line': 'int',
        'column': 'int',
        'trace_id': 'str',
        'error_id': 'str'
    }

    attribute_map = {
        'message': 'message',
        'type': 'type',
        'line': 'line',
        'column': 'column',
        'trace_id': 'trace_id',
        'error_id': 'error_id'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """ErrorModel - a model defined in Swagger"""  # noqa: E501

        self._message = None
        self._type = None
        self._line = None
        self._column = None
        self._trace_id = None
        self._error_id = None
        self.discriminator = None

        self.message = kwargs.pop('message', None)
        self.type = kwargs.pop('type', None)
        self.line = kwargs.pop('line', None)
        self.column = kwargs.pop('column', None)
        self.trace_id = kwargs.pop('trace_id', None)
        self.error_id = kwargs.pop('error_id', None)

    @property
    def message(self):
        """Gets the message of this ErrorModel.  # noqa: E501

        descriptive message about the error  # noqa: E501

        :return: The message of this ErrorModel.  # noqa: E501
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """Sets the message of this ErrorModel.

        descriptive message about the error  # noqa: E501

        :param message: The message of this ErrorModel.  # noqa: E501
        :type: str
        """

        self._message = message

    @property
    def type(self):
        """Gets the type of this ErrorModel.  # noqa: E501

        category of the error  # noqa: E501

        :return: The type of this ErrorModel.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this ErrorModel.

        category of the error  # noqa: E501

        :param type: The type of this ErrorModel.  # noqa: E501
        :type: str
        """

        self._type = type

    @property
    def line(self):
        """Gets the line of this ErrorModel.  # noqa: E501

        Line where the error happened (if applicable)  # noqa: E501

        :return: The line of this ErrorModel.  # noqa: E501
        :rtype: int
        """
        return self._line

    @line.setter
    def line(self, line):
        """Sets the line of this ErrorModel.

        Line where the error happened (if applicable)  # noqa: E501

        :param line: The line of this ErrorModel.  # noqa: E501
        :type: int
        """

        self._line = line

    @property
    def column(self):
        """Gets the column of this ErrorModel.  # noqa: E501

        Column where the error happened (if applicable)  # noqa: E501

        :return: The column of this ErrorModel.  # noqa: E501
        :rtype: int
        """
        return self._column

    @column.setter
    def column(self, column):
        """Sets the column of this ErrorModel.

        Column where the error happened (if applicable)  # noqa: E501

        :param column: The column of this ErrorModel.  # noqa: E501
        :type: int
        """

        self._column = column

    @property
    def trace_id(self):
        """Gets the trace_id of this ErrorModel.  # noqa: E501

        Internal trace ID to help with debugging  # noqa: E501

        :return: The trace_id of this ErrorModel.  # noqa: E501
        :rtype: str
        """
        return self._trace_id

    @trace_id.setter
    def trace_id(self, trace_id):
        """Sets the trace_id of this ErrorModel.

        Internal trace ID to help with debugging  # noqa: E501

        :param trace_id: The trace_id of this ErrorModel.  # noqa: E501
        :type: str
        """

        self._trace_id = trace_id

    @property
    def error_id(self):
        """Gets the error_id of this ErrorModel.  # noqa: E501

        ID of the error  # noqa: E501

        :return: The error_id of this ErrorModel.  # noqa: E501
        :rtype: str
        """
        return self._error_id

    @error_id.setter
    def error_id(self, error_id):
        """Sets the error_id of this ErrorModel.

        ID of the error  # noqa: E501

        :param error_id: The error_id of this ErrorModel.  # noqa: E501
        :type: str
        """

        self._error_id = error_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ErrorModel, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ErrorModel):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

    def __getitem__(self, item):
        return getattr(self, item)

    def get(self, item):
        return getattr(self, item)

    def items(self):
        return self.to_dict().items()

    def __setitem__(self, item, value):
        return seattr(self, item, value)
