# coding: utf-8

"""
    REST API

    Rockset's REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.  All requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example: ``` Authorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT ```  All endpoints are only accessible via https.  Build something awesome!  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class FieldOptions(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'index_mode': 'str',
        'range_index_mode': 'str',
        'type_index_mode': 'str',
        'column_index_mode': 'str'
    }

    attribute_map = {
        'index_mode': 'index_mode',
        'range_index_mode': 'range_index_mode',
        'type_index_mode': 'type_index_mode',
        'column_index_mode': 'column_index_mode'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """FieldOptions - a model defined in Swagger"""  # noqa: E501

        self._index_mode = None
        self._range_index_mode = None
        self._type_index_mode = None
        self._column_index_mode = None
        self.discriminator = None

        self.index_mode = kwargs.pop('index_mode', None)
        self.range_index_mode = kwargs.pop('range_index_mode', None)
        self.type_index_mode = kwargs.pop('type_index_mode', None)
        self.column_index_mode = kwargs.pop('column_index_mode', None)

    @property
    def index_mode(self):
        """Gets the index_mode of this FieldOptions.  # noqa: E501

         index or no_index  # noqa: E501

        :return: The index_mode of this FieldOptions.  # noqa: E501
        :rtype: str
        """
        return self._index_mode

    @index_mode.setter
    def index_mode(self, index_mode):
        """Sets the index_mode of this FieldOptions.

         index or no_index  # noqa: E501

        :param index_mode: The index_mode of this FieldOptions.  # noqa: E501
        :type: str
        """

        self._index_mode = index_mode

    @property
    def range_index_mode(self):
        """Gets the range_index_mode of this FieldOptions.  # noqa: E501

         v1_index or no_index  # noqa: E501

        :return: The range_index_mode of this FieldOptions.  # noqa: E501
        :rtype: str
        """
        return self._range_index_mode

    @range_index_mode.setter
    def range_index_mode(self, range_index_mode):
        """Sets the range_index_mode of this FieldOptions.

         v1_index or no_index  # noqa: E501

        :param range_index_mode: The range_index_mode of this FieldOptions.  # noqa: E501
        :type: str
        """

        self._range_index_mode = range_index_mode

    @property
    def type_index_mode(self):
        """Gets the type_index_mode of this FieldOptions.  # noqa: E501

         index or no_index  # noqa: E501

        :return: The type_index_mode of this FieldOptions.  # noqa: E501
        :rtype: str
        """
        return self._type_index_mode

    @type_index_mode.setter
    def type_index_mode(self, type_index_mode):
        """Sets the type_index_mode of this FieldOptions.

         index or no_index  # noqa: E501

        :param type_index_mode: The type_index_mode of this FieldOptions.  # noqa: E501
        :type: str
        """

        self._type_index_mode = type_index_mode

    @property
    def column_index_mode(self):
        """Gets the column_index_mode of this FieldOptions.  # noqa: E501

         store or no_store  # noqa: E501

        :return: The column_index_mode of this FieldOptions.  # noqa: E501
        :rtype: str
        """
        return self._column_index_mode

    @column_index_mode.setter
    def column_index_mode(self, column_index_mode):
        """Sets the column_index_mode of this FieldOptions.

         store or no_store  # noqa: E501

        :param column_index_mode: The column_index_mode of this FieldOptions.  # noqa: E501
        :type: str
        """

        self._column_index_mode = column_index_mode

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(FieldOptions, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, FieldOptions):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

    def __getitem__(self, item):
        return getattr(self, item)

    def get(self, item):
        return getattr(self, item)

    def items(self):
        return self.to_dict().items()

    def __setitem__(self, item, value):
        return seattr(self, item, value)
