# coding: utf-8

"""
    REST API

    Rockset's REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.  All requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example: ``` Authorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT ```  All endpoints are only accessible via https.  Build something awesome!  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from rockset.swagger_client.models.status_kafka import StatusKafka  # noqa: F401,E501


class KafkaIntegration(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'kafka_topic_names': 'list[str]',
        'source_status_by_topic': 'dict(str, StatusKafka)',
        'kafka_data_format': 'str',
        'connection_string': 'str'
    }

    attribute_map = {
        'kafka_topic_names': 'kafka_topic_names',
        'source_status_by_topic': 'source_status_by_topic',
        'kafka_data_format': 'kafka_data_format',
        'connection_string': 'connection_string'
    }

    def __init__(self, kafka_topic_names, kafka_data_format, **kwargs):  # noqa: E501
        """KafkaIntegration - a model defined in Swagger"""  # noqa: E501

        self._kafka_topic_names = None
        self._source_status_by_topic = None
        self._kafka_data_format = None
        self._connection_string = None
        self.discriminator = None

        self.kafka_topic_names = kafka_topic_names
        self.source_status_by_topic = kwargs.pop('source_status_by_topic', None)
        self.kafka_data_format = kafka_data_format
        self.connection_string = kwargs.pop('connection_string', None)

    @property
    def kafka_topic_names(self):
        """Gets the kafka_topic_names of this KafkaIntegration.  # noqa: E501

        Kafka topics to tail  # noqa: E501

        :return: The kafka_topic_names of this KafkaIntegration.  # noqa: E501
        :rtype: list[str]
        """
        return self._kafka_topic_names

    @kafka_topic_names.setter
    def kafka_topic_names(self, kafka_topic_names):
        """Sets the kafka_topic_names of this KafkaIntegration.

        Kafka topics to tail  # noqa: E501

        :param kafka_topic_names: The kafka_topic_names of this KafkaIntegration.  # noqa: E501
        :type: list[str]
        """

        self._kafka_topic_names = kafka_topic_names

    @property
    def source_status_by_topic(self):
        """Gets the source_status_by_topic of this KafkaIntegration.  # noqa: E501

        The status of the Kafka source by topic  # noqa: E501

        :return: The source_status_by_topic of this KafkaIntegration.  # noqa: E501
        :rtype: dict(str, StatusKafka)
        """
        return self._source_status_by_topic

    @source_status_by_topic.setter
    def source_status_by_topic(self, source_status_by_topic):
        """Sets the source_status_by_topic of this KafkaIntegration.

        The status of the Kafka source by topic  # noqa: E501

        :param source_status_by_topic: The source_status_by_topic of this KafkaIntegration.  # noqa: E501
        :type: dict(str, StatusKafka)
        """

        self._source_status_by_topic = source_status_by_topic

    @property
    def kafka_data_format(self):
        """Gets the kafka_data_format of this KafkaIntegration.  # noqa: E501

        The format of the Kafka topics being tailed  # noqa: E501

        :return: The kafka_data_format of this KafkaIntegration.  # noqa: E501
        :rtype: str
        """
        return self._kafka_data_format

    @kafka_data_format.setter
    def kafka_data_format(self, kafka_data_format):
        """Sets the kafka_data_format of this KafkaIntegration.

        The format of the Kafka topics being tailed  # noqa: E501

        :param kafka_data_format: The kafka_data_format of this KafkaIntegration.  # noqa: E501
        :type: str
        """

        self._kafka_data_format = kafka_data_format

    @property
    def connection_string(self):
        """Gets the connection_string of this KafkaIntegration.  # noqa: E501

        kafka connection string  # noqa: E501

        :return: The connection_string of this KafkaIntegration.  # noqa: E501
        :rtype: str
        """
        return self._connection_string

    @connection_string.setter
    def connection_string(self, connection_string):
        """Sets the connection_string of this KafkaIntegration.

        kafka connection string  # noqa: E501

        :param connection_string: The connection_string of this KafkaIntegration.  # noqa: E501
        :type: str
        """

        self._connection_string = connection_string

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(KafkaIntegration, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, KafkaIntegration):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

    def __getitem__(self, item):
        return getattr(self, item)

    def get(self, item):
        return getattr(self, item)

    def items(self):
        return self.to_dict().items()

    def __setitem__(self, item, value):
        return seattr(self, item, value)
