# coding: utf-8

"""
    REST API

    Rockset's REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.  All requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example: ``` Authorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT ```  All endpoints are only accessible via https.  Build something awesome!  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from rockset.swagger_client.models.organization import Organization  # noqa: F401,E501


class OrgMembership(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'organization': 'Organization',
        'roles': 'list[str]',
        'invite_state': 'str',
        'invited_by': 'str',
        'email': 'str',
        'expires_at': 'str',
        'created_at': 'str'
    }

    attribute_map = {
        'organization': 'organization',
        'roles': 'roles',
        'invite_state': 'invite_state',
        'invited_by': 'invited_by',
        'email': 'email',
        'expires_at': 'expires_at',
        'created_at': 'created_at'
    }

    def __init__(self, organization, roles, invite_state, invited_by, expires_at, created_at, **kwargs):  # noqa: E501
        """OrgMembership - a model defined in Swagger"""  # noqa: E501

        self._organization = None
        self._roles = None
        self._invite_state = None
        self._invited_by = None
        self._email = None
        self._expires_at = None
        self._created_at = None
        self.discriminator = None

        self.organization = organization
        self.roles = roles
        self.invite_state = invite_state
        self.invited_by = invited_by
        self.email = kwargs.pop('email', None)
        self.expires_at = expires_at
        self.created_at = created_at

    @property
    def organization(self):
        """Gets the organization of this OrgMembership.  # noqa: E501


        :return: The organization of this OrgMembership.  # noqa: E501
        :rtype: Organization
        """
        return self._organization

    @organization.setter
    def organization(self, organization):
        """Sets the organization of this OrgMembership.


        :param organization: The organization of this OrgMembership.  # noqa: E501
        :type: Organization
        """

        self._organization = organization

    @property
    def roles(self):
        """Gets the roles of this OrgMembership.  # noqa: E501


        :return: The roles of this OrgMembership.  # noqa: E501
        :rtype: list[str]
        """
        return self._roles

    @roles.setter
    def roles(self, roles):
        """Sets the roles of this OrgMembership.


        :param roles: The roles of this OrgMembership.  # noqa: E501
        :type: list[str]
        """

        self._roles = roles

    @property
    def invite_state(self):
        """Gets the invite_state of this OrgMembership.  # noqa: E501


        :return: The invite_state of this OrgMembership.  # noqa: E501
        :rtype: str
        """
        return self._invite_state

    @invite_state.setter
    def invite_state(self, invite_state):
        """Sets the invite_state of this OrgMembership.


        :param invite_state: The invite_state of this OrgMembership.  # noqa: E501
        :type: str
        """

        self._invite_state = invite_state

    @property
    def invited_by(self):
        """Gets the invited_by of this OrgMembership.  # noqa: E501


        :return: The invited_by of this OrgMembership.  # noqa: E501
        :rtype: str
        """
        return self._invited_by

    @invited_by.setter
    def invited_by(self, invited_by):
        """Sets the invited_by of this OrgMembership.


        :param invited_by: The invited_by of this OrgMembership.  # noqa: E501
        :type: str
        """

        self._invited_by = invited_by

    @property
    def email(self):
        """Gets the email of this OrgMembership.  # noqa: E501

        email of the user  # noqa: E501

        :return: The email of this OrgMembership.  # noqa: E501
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """Sets the email of this OrgMembership.

        email of the user  # noqa: E501

        :param email: The email of this OrgMembership.  # noqa: E501
        :type: str
        """

        self._email = email

    @property
    def expires_at(self):
        """Gets the expires_at of this OrgMembership.  # noqa: E501

        ISO-8601 date  # noqa: E501

        :return: The expires_at of this OrgMembership.  # noqa: E501
        :rtype: str
        """
        return self._expires_at

    @expires_at.setter
    def expires_at(self, expires_at):
        """Sets the expires_at of this OrgMembership.

        ISO-8601 date  # noqa: E501

        :param expires_at: The expires_at of this OrgMembership.  # noqa: E501
        :type: str
        """

        self._expires_at = expires_at

    @property
    def created_at(self):
        """Gets the created_at of this OrgMembership.  # noqa: E501

        ISO-8601 date  # noqa: E501

        :return: The created_at of this OrgMembership.  # noqa: E501
        :rtype: str
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this OrgMembership.

        ISO-8601 date  # noqa: E501

        :param created_at: The created_at of this OrgMembership.  # noqa: E501
        :type: str
        """

        self._created_at = created_at

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(OrgMembership, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OrgMembership):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

    def __getitem__(self, item):
        return getattr(self, item)

    def get(self, item):
        return getattr(self, item)

    def items(self):
        return self.to_dict().items()

    def __setitem__(self, item, value):
        return seattr(self, item, value)
