# coding: utf-8

"""
    REST API

    Rockset's REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.  All requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example: ``` Authorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT ```  All endpoints are only accessible via https.  Build something awesome!  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class QueryLambdaStats(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'last_executed': 'str',
        'last_executed_by': 'str',
        'last_execution_error': 'str',
        'last_execution_error_message': 'str'
    }

    attribute_map = {
        'last_executed': 'last_executed',
        'last_executed_by': 'last_executed_by',
        'last_execution_error': 'last_execution_error',
        'last_execution_error_message': 'last_execution_error_message'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """QueryLambdaStats - a model defined in Swagger"""  # noqa: E501

        self._last_executed = None
        self._last_executed_by = None
        self._last_execution_error = None
        self._last_execution_error_message = None
        self.discriminator = None

        self.last_executed = kwargs.pop('last_executed', None)
        self.last_executed_by = kwargs.pop('last_executed_by', None)
        self.last_execution_error = kwargs.pop('last_execution_error', None)
        self.last_execution_error_message = kwargs.pop('last_execution_error_message', None)

    @property
    def last_executed(self):
        """Gets the last_executed of this QueryLambdaStats.  # noqa: E501

        ISO-8601 date  # noqa: E501

        :return: The last_executed of this QueryLambdaStats.  # noqa: E501
        :rtype: str
        """
        return self._last_executed

    @last_executed.setter
    def last_executed(self, last_executed):
        """Sets the last_executed of this QueryLambdaStats.

        ISO-8601 date  # noqa: E501

        :param last_executed: The last_executed of this QueryLambdaStats.  # noqa: E501
        :type: str
        """

        self._last_executed = last_executed

    @property
    def last_executed_by(self):
        """Gets the last_executed_by of this QueryLambdaStats.  # noqa: E501

        user who last executed Query Lambda  # noqa: E501

        :return: The last_executed_by of this QueryLambdaStats.  # noqa: E501
        :rtype: str
        """
        return self._last_executed_by

    @last_executed_by.setter
    def last_executed_by(self, last_executed_by):
        """Sets the last_executed_by of this QueryLambdaStats.

        user who last executed Query Lambda  # noqa: E501

        :param last_executed_by: The last_executed_by of this QueryLambdaStats.  # noqa: E501
        :type: str
        """

        self._last_executed_by = last_executed_by

    @property
    def last_execution_error(self):
        """Gets the last_execution_error of this QueryLambdaStats.  # noqa: E501

        ISO-8601 date of last execution failure  # noqa: E501

        :return: The last_execution_error of this QueryLambdaStats.  # noqa: E501
        :rtype: str
        """
        return self._last_execution_error

    @last_execution_error.setter
    def last_execution_error(self, last_execution_error):
        """Sets the last_execution_error of this QueryLambdaStats.

        ISO-8601 date of last execution failure  # noqa: E501

        :param last_execution_error: The last_execution_error of this QueryLambdaStats.  # noqa: E501
        :type: str
        """

        self._last_execution_error = last_execution_error

    @property
    def last_execution_error_message(self):
        """Gets the last_execution_error_message of this QueryLambdaStats.  # noqa: E501

        error message associated with last failed execution  # noqa: E501

        :return: The last_execution_error_message of this QueryLambdaStats.  # noqa: E501
        :rtype: str
        """
        return self._last_execution_error_message

    @last_execution_error_message.setter
    def last_execution_error_message(self, last_execution_error_message):
        """Sets the last_execution_error_message of this QueryLambdaStats.

        error message associated with last failed execution  # noqa: E501

        :param last_execution_error_message: The last_execution_error_message of this QueryLambdaStats.  # noqa: E501
        :type: str
        """

        self._last_execution_error_message = last_execution_error_message

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(QueryLambdaStats, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QueryLambdaStats):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

    def __getitem__(self, item):
        return getattr(self, item)

    def get(self, item):
        return getattr(self, item)

    def items(self):
        return self.to_dict().items()

    def __setitem__(self, item, value):
        return seattr(self, item, value)
