# coding: utf-8

"""
    REST API

    Rockset's REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.  All requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example: ``` Authorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT ```  All endpoints are only accessible via https.  Build something awesome!  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from rockset.swagger_client.models.query_error import QueryError  # noqa: F401,E501
from rockset.swagger_client.models.query_field_type import QueryFieldType  # noqa: F401,E501
from rockset.swagger_client.models.query_response_stats import QueryResponseStats  # noqa: F401,E501


class QueryResponse(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'query_id': 'str',
        'collections': 'list[str]',
        'results': 'list[object]',
        'stats': 'QueryResponseStats',
        'warnings': 'list[str]',
        'query_errors': 'list[QueryError]',
        'column_fields': 'list[QueryFieldType]'
    }

    attribute_map = {
        'query_id': 'query_id',
        'collections': 'collections',
        'results': 'results',
        'stats': 'stats',
        'warnings': 'warnings',
        'query_errors': 'query_errors',
        'column_fields': 'column_fields'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """QueryResponse - a model defined in Swagger"""  # noqa: E501

        self._query_id = None
        self._collections = None
        self._results = None
        self._stats = None
        self._warnings = None
        self._query_errors = None
        self._column_fields = None
        self.discriminator = None

        self.query_id = kwargs.pop('query_id', None)
        self.collections = kwargs.pop('collections', None)
        self.results = kwargs.pop('results', None)
        self.stats = kwargs.pop('stats', None)
        self.warnings = kwargs.pop('warnings', None)
        self.query_errors = kwargs.pop('query_errors', None)
        self.column_fields = kwargs.pop('column_fields', None)

    @property
    def query_id(self):
        """Gets the query_id of this QueryResponse.  # noqa: E501

        unique id for this query  # noqa: E501

        :return: The query_id of this QueryResponse.  # noqa: E501
        :rtype: str
        """
        return self._query_id

    @query_id.setter
    def query_id(self, query_id):
        """Sets the query_id of this QueryResponse.

        unique id for this query  # noqa: E501

        :param query_id: The query_id of this QueryResponse.  # noqa: E501
        :type: str
        """

        self._query_id = query_id

    @property
    def collections(self):
        """Gets the collections of this QueryResponse.  # noqa: E501

        list of collections queried by the query  # noqa: E501

        :return: The collections of this QueryResponse.  # noqa: E501
        :rtype: list[str]
        """
        return self._collections

    @collections.setter
    def collections(self, collections):
        """Sets the collections of this QueryResponse.

        list of collections queried by the query  # noqa: E501

        :param collections: The collections of this QueryResponse.  # noqa: E501
        :type: list[str]
        """

        self._collections = collections

    @property
    def results(self):
        """Gets the results of this QueryResponse.  # noqa: E501

        list of objects returned by the query  # noqa: E501

        :return: The results of this QueryResponse.  # noqa: E501
        :rtype: list[object]
        """
        return self._results

    @results.setter
    def results(self, results):
        """Sets the results of this QueryResponse.

        list of objects returned by the query  # noqa: E501

        :param results: The results of this QueryResponse.  # noqa: E501
        :type: list[object]
        """

        self._results = results

    @property
    def stats(self):
        """Gets the stats of this QueryResponse.  # noqa: E501

        meta information about the query  # noqa: E501

        :return: The stats of this QueryResponse.  # noqa: E501
        :rtype: QueryResponseStats
        """
        return self._stats

    @stats.setter
    def stats(self, stats):
        """Sets the stats of this QueryResponse.

        meta information about the query  # noqa: E501

        :param stats: The stats of this QueryResponse.  # noqa: E501
        :type: QueryResponseStats
        """

        self._stats = stats

    @property
    def warnings(self):
        """Gets the warnings of this QueryResponse.  # noqa: E501

        warnings received from the query  # noqa: E501

        :return: The warnings of this QueryResponse.  # noqa: E501
        :rtype: list[str]
        """
        return self._warnings

    @warnings.setter
    def warnings(self, warnings):
        """Sets the warnings of this QueryResponse.

        warnings received from the query  # noqa: E501

        :param warnings: The warnings of this QueryResponse.  # noqa: E501
        :type: list[str]
        """

        self._warnings = warnings

    @property
    def query_errors(self):
        """Gets the query_errors of this QueryResponse.  # noqa: E501

        errors encountered while streaming the query  # noqa: E501

        :return: The query_errors of this QueryResponse.  # noqa: E501
        :rtype: list[QueryError]
        """
        return self._query_errors

    @query_errors.setter
    def query_errors(self, query_errors):
        """Sets the query_errors of this QueryResponse.

        errors encountered while streaming the query  # noqa: E501

        :param query_errors: The query_errors of this QueryResponse.  # noqa: E501
        :type: list[QueryError]
        """

        self._query_errors = query_errors

    @property
    def column_fields(self):
        """Gets the column_fields of this QueryResponse.  # noqa: E501

        meta information about each column in the result set  # noqa: E501

        :return: The column_fields of this QueryResponse.  # noqa: E501
        :rtype: list[QueryFieldType]
        """
        return self._column_fields

    @column_fields.setter
    def column_fields(self, column_fields):
        """Sets the column_fields of this QueryResponse.

        meta information about each column in the result set  # noqa: E501

        :param column_fields: The column_fields of this QueryResponse.  # noqa: E501
        :type: list[QueryFieldType]
        """

        self._column_fields = column_fields

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(QueryResponse, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QueryResponse):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

    def __getitem__(self, item):
        return getattr(self, item)

    def get(self, item):
        return getattr(self, item)

    def items(self):
        return self.to_dict().items()

    def __setitem__(self, item, value):
        return seattr(self, item, value)
