# coding: utf-8

"""
    REST API

    Rockset's REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.  All requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example: ``` Authorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT ```  All endpoints are only accessible via https.  Build something awesome!  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class QueryResponseStats(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'elapsed_time_ms': 'int',
        'throttled_time_micros': 'int'
    }

    attribute_map = {
        'elapsed_time_ms': 'elapsed_time_ms',
        'throttled_time_micros': 'throttled_time_micros'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """QueryResponseStats - a model defined in Swagger"""  # noqa: E501

        self._elapsed_time_ms = None
        self._throttled_time_micros = None
        self.discriminator = None

        self.elapsed_time_ms = kwargs.pop('elapsed_time_ms', None)
        self.throttled_time_micros = kwargs.pop('throttled_time_micros', None)

    @property
    def elapsed_time_ms(self):
        """Gets the elapsed_time_ms of this QueryResponseStats.  # noqa: E501

        query time in milliseconds  # noqa: E501

        :return: The elapsed_time_ms of this QueryResponseStats.  # noqa: E501
        :rtype: int
        """
        return self._elapsed_time_ms

    @elapsed_time_ms.setter
    def elapsed_time_ms(self, elapsed_time_ms):
        """Sets the elapsed_time_ms of this QueryResponseStats.

        query time in milliseconds  # noqa: E501

        :param elapsed_time_ms: The elapsed_time_ms of this QueryResponseStats.  # noqa: E501
        :type: int
        """

        self._elapsed_time_ms = elapsed_time_ms

    @property
    def throttled_time_micros(self):
        """Gets the throttled_time_micros of this QueryResponseStats.  # noqa: E501

        time query was throttled by admission control  # noqa: E501

        :return: The throttled_time_micros of this QueryResponseStats.  # noqa: E501
        :rtype: int
        """
        return self._throttled_time_micros

    @throttled_time_micros.setter
    def throttled_time_micros(self, throttled_time_micros):
        """Sets the throttled_time_micros of this QueryResponseStats.

        time query was throttled by admission control  # noqa: E501

        :param throttled_time_micros: The throttled_time_micros of this QueryResponseStats.  # noqa: E501
        :type: int
        """

        self._throttled_time_micros = throttled_time_micros

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(QueryResponseStats, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QueryResponseStats):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

    def __getitem__(self, item):
        return getattr(self, item)

    def get(self, item):
        return getattr(self, item)

    def items(self):
        return self.to_dict().items()

    def __setitem__(self, item, value):
        return seattr(self, item, value)
