# coding: utf-8

"""
    REST API

    Rockset's REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.  All requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example: ``` Authorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT ```  All endpoints are only accessible via https.  Build something awesome!  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from rockset.swagger_client.models.aws_access_key import AwsAccessKey  # noqa: F401,E501


class RedshiftIntegration(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'aws_access_key': 'AwsAccessKey',
        'username': 'str',
        'password': 'str',
        'host': 'str',
        'port': 'int',
        's3_bucket_path': 'str'
    }

    attribute_map = {
        'aws_access_key': 'aws_access_key',
        'username': 'username',
        'password': 'password',
        'host': 'host',
        'port': 'port',
        's3_bucket_path': 's3_bucket_path'
    }

    def __init__(self, username, password, host, port, s3_bucket_path, **kwargs):  # noqa: E501
        """RedshiftIntegration - a model defined in Swagger"""  # noqa: E501

        self._aws_access_key = None
        self._username = None
        self._password = None
        self._host = None
        self._port = None
        self._s3_bucket_path = None
        self.discriminator = None

        self.aws_access_key = kwargs.pop('aws_access_key', None)
        self.username = username
        self.password = password
        self.host = host
        self.port = port
        self.s3_bucket_path = s3_bucket_path

    @property
    def aws_access_key(self):
        """Gets the aws_access_key of this RedshiftIntegration.  # noqa: E501

        AWS access key credentials  # noqa: E501

        :return: The aws_access_key of this RedshiftIntegration.  # noqa: E501
        :rtype: AwsAccessKey
        """
        return self._aws_access_key

    @aws_access_key.setter
    def aws_access_key(self, aws_access_key):
        """Sets the aws_access_key of this RedshiftIntegration.

        AWS access key credentials  # noqa: E501

        :param aws_access_key: The aws_access_key of this RedshiftIntegration.  # noqa: E501
        :type: AwsAccessKey
        """

        self._aws_access_key = aws_access_key

    @property
    def username(self):
        """Gets the username of this RedshiftIntegration.  # noqa: E501

        Username associated with Redshift cluster  # noqa: E501

        :return: The username of this RedshiftIntegration.  # noqa: E501
        :rtype: str
        """
        return self._username

    @username.setter
    def username(self, username):
        """Sets the username of this RedshiftIntegration.

        Username associated with Redshift cluster  # noqa: E501

        :param username: The username of this RedshiftIntegration.  # noqa: E501
        :type: str
        """

        self._username = username

    @property
    def password(self):
        """Gets the password of this RedshiftIntegration.  # noqa: E501

        Password associated with Redshift cluster  # noqa: E501

        :return: The password of this RedshiftIntegration.  # noqa: E501
        :rtype: str
        """
        return self._password

    @password.setter
    def password(self, password):
        """Sets the password of this RedshiftIntegration.

        Password associated with Redshift cluster  # noqa: E501

        :param password: The password of this RedshiftIntegration.  # noqa: E501
        :type: str
        """

        self._password = password

    @property
    def host(self):
        """Gets the host of this RedshiftIntegration.  # noqa: E501

        Redshift Cluster host  # noqa: E501

        :return: The host of this RedshiftIntegration.  # noqa: E501
        :rtype: str
        """
        return self._host

    @host.setter
    def host(self, host):
        """Sets the host of this RedshiftIntegration.

        Redshift Cluster host  # noqa: E501

        :param host: The host of this RedshiftIntegration.  # noqa: E501
        :type: str
        """

        self._host = host

    @property
    def port(self):
        """Gets the port of this RedshiftIntegration.  # noqa: E501

        Redshift Cluster port  # noqa: E501

        :return: The port of this RedshiftIntegration.  # noqa: E501
        :rtype: int
        """
        return self._port

    @port.setter
    def port(self, port):
        """Sets the port of this RedshiftIntegration.

        Redshift Cluster port  # noqa: E501

        :param port: The port of this RedshiftIntegration.  # noqa: E501
        :type: int
        """

        self._port = port

    @property
    def s3_bucket_path(self):
        """Gets the s3_bucket_path of this RedshiftIntegration.  # noqa: E501

        unload S3 bucket path  # noqa: E501

        :return: The s3_bucket_path of this RedshiftIntegration.  # noqa: E501
        :rtype: str
        """
        return self._s3_bucket_path

    @s3_bucket_path.setter
    def s3_bucket_path(self, s3_bucket_path):
        """Sets the s3_bucket_path of this RedshiftIntegration.

        unload S3 bucket path  # noqa: E501

        :param s3_bucket_path: The s3_bucket_path of this RedshiftIntegration.  # noqa: E501
        :type: str
        """

        self._s3_bucket_path = s3_bucket_path

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(RedshiftIntegration, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RedshiftIntegration):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

    def __getitem__(self, item):
        return getattr(self, item)

    def get(self, item):
        return getattr(self, item)

    def items(self):
        return self.to_dict().items()

    def __setitem__(self, item, value):
        return seattr(self, item, value)
