# coding: utf-8

"""
    REST API

    Rockset's REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.  All requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example: ``` Authorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT ```  All endpoints are only accessible via https.  Build something awesome!  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class SourceFileUpload(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'file_name': 'str',
        'file_size': 'int',
        'file_upload_time': 'str'
    }

    attribute_map = {
        'file_name': 'file_name',
        'file_size': 'file_size',
        'file_upload_time': 'file_upload_time'
    }

    def __init__(self, file_name, file_size, file_upload_time, **kwargs):  # noqa: E501
        """SourceFileUpload - a model defined in Swagger"""  # noqa: E501

        self._file_name = None
        self._file_size = None
        self._file_upload_time = None
        self.discriminator = None

        self.file_name = file_name
        self.file_size = file_size
        self.file_upload_time = file_upload_time

    @property
    def file_name(self):
        """Gets the file_name of this SourceFileUpload.  # noqa: E501

        name of the file  # noqa: E501

        :return: The file_name of this SourceFileUpload.  # noqa: E501
        :rtype: str
        """
        return self._file_name

    @file_name.setter
    def file_name(self, file_name):
        """Sets the file_name of this SourceFileUpload.

        name of the file  # noqa: E501

        :param file_name: The file_name of this SourceFileUpload.  # noqa: E501
        :type: str
        """

        self._file_name = file_name

    @property
    def file_size(self):
        """Gets the file_size of this SourceFileUpload.  # noqa: E501

        size of the file in bytes  # noqa: E501

        :return: The file_size of this SourceFileUpload.  # noqa: E501
        :rtype: int
        """
        return self._file_size

    @file_size.setter
    def file_size(self, file_size):
        """Sets the file_size of this SourceFileUpload.

        size of the file in bytes  # noqa: E501

        :param file_size: The file_size of this SourceFileUpload.  # noqa: E501
        :type: int
        """

        self._file_size = file_size

    @property
    def file_upload_time(self):
        """Gets the file_upload_time of this SourceFileUpload.  # noqa: E501

        time of file upload  # noqa: E501

        :return: The file_upload_time of this SourceFileUpload.  # noqa: E501
        :rtype: str
        """
        return self._file_upload_time

    @file_upload_time.setter
    def file_upload_time(self, file_upload_time):
        """Sets the file_upload_time of this SourceFileUpload.

        time of file upload  # noqa: E501

        :param file_upload_time: The file_upload_time of this SourceFileUpload.  # noqa: E501
        :type: str
        """

        self._file_upload_time = file_upload_time

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(SourceFileUpload, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SourceFileUpload):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

    def __getitem__(self, item):
        return getattr(self, item)

    def get(self, item):
        return getattr(self, item)

    def items(self):
        return self.to_dict().items()

    def __setitem__(self, item, value):
        return seattr(self, item, value)
