# coding: utf-8

"""
    REST API

    Rockset's REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.  All requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example: ``` Authorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT ```  All endpoints are only accessible via https.  Build something awesome!  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class SourceKinesis(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'stream_name': 'str',
        'aws_region': 'str'
    }

    attribute_map = {
        'stream_name': 'stream_name',
        'aws_region': 'aws_region'
    }

    def __init__(self, stream_name, **kwargs):  # noqa: E501
        """SourceKinesis - a model defined in Swagger"""  # noqa: E501

        self._stream_name = None
        self._aws_region = None
        self.discriminator = None

        self.stream_name = stream_name
        self.aws_region = kwargs.pop('aws_region', None)

    @property
    def stream_name(self):
        """Gets the stream_name of this SourceKinesis.  # noqa: E501

        name of kinesis stream  # noqa: E501

        :return: The stream_name of this SourceKinesis.  # noqa: E501
        :rtype: str
        """
        return self._stream_name

    @stream_name.setter
    def stream_name(self, stream_name):
        """Sets the stream_name of this SourceKinesis.

        name of kinesis stream  # noqa: E501

        :param stream_name: The stream_name of this SourceKinesis.  # noqa: E501
        :type: str
        """

        self._stream_name = stream_name

    @property
    def aws_region(self):
        """Gets the aws_region of this SourceKinesis.  # noqa: E501

        AWS region name of Kinesis stream, by default us-west-2 is used  # noqa: E501

        :return: The aws_region of this SourceKinesis.  # noqa: E501
        :rtype: str
        """
        return self._aws_region

    @aws_region.setter
    def aws_region(self, aws_region):
        """Sets the aws_region of this SourceKinesis.

        AWS region name of Kinesis stream, by default us-west-2 is used  # noqa: E501

        :param aws_region: The aws_region of this SourceKinesis.  # noqa: E501
        :type: str
        """

        self._aws_region = aws_region

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(SourceKinesis, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SourceKinesis):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

    def __getitem__(self, item):
        return getattr(self, item)

    def get(self, item):
        return getattr(self, item)

    def items(self):
        return self.to_dict().items()

    def __setitem__(self, item, value):
        return seattr(self, item, value)
