# coding: utf-8

"""
    REST API

    Rockset's REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.  All requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example: ``` Authorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT ```  All endpoints are only accessible via https.  Build something awesome!  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class Status(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'state': 'str',
        'since': 'str',
        'message': 'str',
        'last_processed_at': 'str',
        'last_processed_item': 'str',
        'total_processed_items': 'int',
        'last_error_at': 'str',
        'last_error_item': 'str',
        'last_error_reason': 'str',
        'total_error_items': 'int'
    }

    attribute_map = {
        'state': 'state',
        'since': 'since',
        'message': 'message',
        'last_processed_at': 'last_processed_at',
        'last_processed_item': 'last_processed_item',
        'total_processed_items': 'total_processed_items',
        'last_error_at': 'last_error_at',
        'last_error_item': 'last_error_item',
        'last_error_reason': 'last_error_reason',
        'total_error_items': 'total_error_items'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """Status - a model defined in Swagger"""  # noqa: E501

        self._state = None
        self._since = None
        self._message = None
        self._last_processed_at = None
        self._last_processed_item = None
        self._total_processed_items = None
        self._last_error_at = None
        self._last_error_item = None
        self._last_error_reason = None
        self._total_error_items = None
        self.discriminator = None

        self.state = kwargs.pop('state', None)
        self.since = kwargs.pop('since', None)
        self.message = kwargs.pop('message', None)
        self.last_processed_at = kwargs.pop('last_processed_at', None)
        self.last_processed_item = kwargs.pop('last_processed_item', None)
        self.total_processed_items = kwargs.pop('total_processed_items', None)
        self.last_error_at = kwargs.pop('last_error_at', None)
        self.last_error_item = kwargs.pop('last_error_item', None)
        self.last_error_reason = kwargs.pop('last_error_reason', None)
        self.total_error_items = kwargs.pop('total_error_items', None)

    @property
    def state(self):
        """Gets the state of this Status.  # noqa: E501

        Status of the Source's ingestion, one of: INITIALIZING, WATCHING, PROCESSING, COMPLETED, ERROR  # noqa: E501

        :return: The state of this Status.  # noqa: E501
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this Status.

        Status of the Source's ingestion, one of: INITIALIZING, WATCHING, PROCESSING, COMPLETED, ERROR  # noqa: E501

        :param state: The state of this Status.  # noqa: E501
        :type: str
        """

        self._state = state

    @property
    def since(self):
        """Gets the since of this Status.  # noqa: E501

        ISO-8601 date when state was triggered  # noqa: E501

        :return: The since of this Status.  # noqa: E501
        :rtype: str
        """
        return self._since

    @since.setter
    def since(self, since):
        """Sets the since of this Status.

        ISO-8601 date when state was triggered  # noqa: E501

        :param since: The since of this Status.  # noqa: E501
        :type: str
        """

        self._since = since

    @property
    def message(self):
        """Gets the message of this Status.  # noqa: E501

        state message  # noqa: E501

        :return: The message of this Status.  # noqa: E501
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """Sets the message of this Status.

        state message  # noqa: E501

        :param message: The message of this Status.  # noqa: E501
        :type: str
        """

        self._message = message

    @property
    def last_processed_at(self):
        """Gets the last_processed_at of this Status.  # noqa: E501

        ISO-8601 date when source was last processed  # noqa: E501

        :return: The last_processed_at of this Status.  # noqa: E501
        :rtype: str
        """
        return self._last_processed_at

    @last_processed_at.setter
    def last_processed_at(self, last_processed_at):
        """Sets the last_processed_at of this Status.

        ISO-8601 date when source was last processed  # noqa: E501

        :param last_processed_at: The last_processed_at of this Status.  # noqa: E501
        :type: str
        """

        self._last_processed_at = last_processed_at

    @property
    def last_processed_item(self):
        """Gets the last_processed_item of this Status.  # noqa: E501

        last source item processed by ingester  # noqa: E501

        :return: The last_processed_item of this Status.  # noqa: E501
        :rtype: str
        """
        return self._last_processed_item

    @last_processed_item.setter
    def last_processed_item(self, last_processed_item):
        """Sets the last_processed_item of this Status.

        last source item processed by ingester  # noqa: E501

        :param last_processed_item: The last_processed_item of this Status.  # noqa: E501
        :type: str
        """

        self._last_processed_item = last_processed_item

    @property
    def total_processed_items(self):
        """Gets the total_processed_items of this Status.  # noqa: E501

        Total items processed of source  # noqa: E501

        :return: The total_processed_items of this Status.  # noqa: E501
        :rtype: int
        """
        return self._total_processed_items

    @total_processed_items.setter
    def total_processed_items(self, total_processed_items):
        """Sets the total_processed_items of this Status.

        Total items processed of source  # noqa: E501

        :param total_processed_items: The total_processed_items of this Status.  # noqa: E501
        :type: int
        """

        self._total_processed_items = total_processed_items

    @property
    def last_error_at(self):
        """Gets the last_error_at of this Status.  # noqa: E501

        ISO-8601 date when last error occurred  # noqa: E501

        :return: The last_error_at of this Status.  # noqa: E501
        :rtype: str
        """
        return self._last_error_at

    @last_error_at.setter
    def last_error_at(self, last_error_at):
        """Sets the last_error_at of this Status.

        ISO-8601 date when last error occurred  # noqa: E501

        :param last_error_at: The last_error_at of this Status.  # noqa: E501
        :type: str
        """

        self._last_error_at = last_error_at

    @property
    def last_error_item(self):
        """Gets the last_error_item of this Status.  # noqa: E501

        last source item that errored  # noqa: E501

        :return: The last_error_item of this Status.  # noqa: E501
        :rtype: str
        """
        return self._last_error_item

    @last_error_item.setter
    def last_error_item(self, last_error_item):
        """Sets the last_error_item of this Status.

        last source item that errored  # noqa: E501

        :param last_error_item: The last_error_item of this Status.  # noqa: E501
        :type: str
        """

        self._last_error_item = last_error_item

    @property
    def last_error_reason(self):
        """Gets the last_error_reason of this Status.  # noqa: E501

        reason for the last error  # noqa: E501

        :return: The last_error_reason of this Status.  # noqa: E501
        :rtype: str
        """
        return self._last_error_reason

    @last_error_reason.setter
    def last_error_reason(self, last_error_reason):
        """Sets the last_error_reason of this Status.

        reason for the last error  # noqa: E501

        :param last_error_reason: The last_error_reason of this Status.  # noqa: E501
        :type: str
        """

        self._last_error_reason = last_error_reason

    @property
    def total_error_items(self):
        """Gets the total_error_items of this Status.  # noqa: E501

        Total items that errored  # noqa: E501

        :return: The total_error_items of this Status.  # noqa: E501
        :rtype: int
        """
        return self._total_error_items

    @total_error_items.setter
    def total_error_items(self, total_error_items):
        """Sets the total_error_items of this Status.

        Total items that errored  # noqa: E501

        :param total_error_items: The total_error_items of this Status.  # noqa: E501
        :type: int
        """

        self._total_error_items = total_error_items

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Status, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Status):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

    def __getitem__(self, item):
        return getattr(self, item)

    def get(self, item):
        return getattr(self, item)

    def items(self):
        return self.to_dict().items()

    def __setitem__(self, item, value):
        return seattr(self, item, value)
