# coding: utf-8

"""
    REST API

    Rockset's REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.  All requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example: ``` Authorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT ```  All endpoints are only accessible via https.  Build something awesome!  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class StatusKafkaPartition(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'partition_number': 'int',
        'num_documents_processed': 'int'
    }

    attribute_map = {
        'partition_number': 'partition_number',
        'num_documents_processed': 'num_documents_processed'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """StatusKafkaPartition - a model defined in Swagger"""  # noqa: E501

        self._partition_number = None
        self._num_documents_processed = None
        self.discriminator = None

        self.partition_number = kwargs.pop('partition_number', None)
        self.num_documents_processed = kwargs.pop('num_documents_processed', None)

    @property
    def partition_number(self):
        """Gets the partition_number of this StatusKafkaPartition.  # noqa: E501

        The number of this partition  # noqa: E501

        :return: The partition_number of this StatusKafkaPartition.  # noqa: E501
        :rtype: int
        """
        return self._partition_number

    @partition_number.setter
    def partition_number(self, partition_number):
        """Sets the partition_number of this StatusKafkaPartition.

        The number of this partition  # noqa: E501

        :param partition_number: The partition_number of this StatusKafkaPartition.  # noqa: E501
        :type: int
        """

        self._partition_number = partition_number

    @property
    def num_documents_processed(self):
        """Gets the num_documents_processed of this StatusKafkaPartition.  # noqa: E501

        Number of documents consumed by this partition  # noqa: E501

        :return: The num_documents_processed of this StatusKafkaPartition.  # noqa: E501
        :rtype: int
        """
        return self._num_documents_processed

    @num_documents_processed.setter
    def num_documents_processed(self, num_documents_processed):
        """Sets the num_documents_processed of this StatusKafkaPartition.

        Number of documents consumed by this partition  # noqa: E501

        :param num_documents_processed: The num_documents_processed of this StatusKafkaPartition.  # noqa: E501
        :type: int
        """

        self._num_documents_processed = num_documents_processed

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(StatusKafkaPartition, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, StatusKafkaPartition):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

    def __getitem__(self, item):
        return getattr(self, item)

    def get(self, item):
        return getattr(self, item)

    def items(self):
        return self.to_dict().items()

    def __setitem__(self, item, value):
        return seattr(self, item, value)
