# coding: utf-8

"""
    REST API

    Rockset's REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.  All requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example: ``` Authorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT ```  All endpoints are only accessible via https.  Build something awesome!  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class VirtualInstance(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'state': 'str',
        'current_type': 'str',
        'desired_type': 'str',
        'current_size': 'str',
        'desired_size': 'str',
        'default_pod_count': 'int',
        'scaled_pod_count': 'int',
        'id': 'str'
    }

    attribute_map = {
        'state': 'state',
        'current_type': 'current_type',
        'desired_type': 'desired_type',
        'current_size': 'current_size',
        'desired_size': 'desired_size',
        'default_pod_count': 'default_pod_count',
        'scaled_pod_count': 'scaled_pod_count',
        'id': 'id'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """VirtualInstance - a model defined in Swagger"""  # noqa: E501

        self._state = None
        self._current_type = None
        self._desired_type = None
        self._current_size = None
        self._desired_size = None
        self._default_pod_count = None
        self._scaled_pod_count = None
        self._id = None
        self.discriminator = None

        self.state = kwargs.pop('state', None)
        self.current_type = kwargs.pop('current_type', None)
        self.desired_type = kwargs.pop('desired_type', None)
        self.current_size = kwargs.pop('current_size', None)
        self.desired_size = kwargs.pop('desired_size', None)
        self.default_pod_count = kwargs.pop('default_pod_count', None)
        self.scaled_pod_count = kwargs.pop('scaled_pod_count', None)
        self.id = kwargs.pop('id', None)

    @property
    def state(self):
        """Gets the state of this VirtualInstance.  # noqa: E501

        virtual instance state  # noqa: E501

        :return: The state of this VirtualInstance.  # noqa: E501
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this VirtualInstance.

        virtual instance state  # noqa: E501

        :param state: The state of this VirtualInstance.  # noqa: E501
        :type: str
        """

        self._state = state

    @property
    def current_type(self):
        """Gets the current_type of this VirtualInstance.  # noqa: E501


        :return: The current_type of this VirtualInstance.  # noqa: E501
        :rtype: str
        """
        return self._current_type

    @current_type.setter
    def current_type(self, current_type):
        """Sets the current_type of this VirtualInstance.


        :param current_type: The current_type of this VirtualInstance.  # noqa: E501
        :type: str
        """

        self._current_type = current_type

    @property
    def desired_type(self):
        """Gets the desired_type of this VirtualInstance.  # noqa: E501


        :return: The desired_type of this VirtualInstance.  # noqa: E501
        :rtype: str
        """
        return self._desired_type

    @desired_type.setter
    def desired_type(self, desired_type):
        """Sets the desired_type of this VirtualInstance.


        :param desired_type: The desired_type of this VirtualInstance.  # noqa: E501
        :type: str
        """

        self._desired_type = desired_type

    @property
    def current_size(self):
        """Gets the current_size of this VirtualInstance.  # noqa: E501

        virtual instance current size  # noqa: E501

        :return: The current_size of this VirtualInstance.  # noqa: E501
        :rtype: str
        """
        return self._current_size

    @current_size.setter
    def current_size(self, current_size):
        """Sets the current_size of this VirtualInstance.

        virtual instance current size  # noqa: E501

        :param current_size: The current_size of this VirtualInstance.  # noqa: E501
        :type: str
        """

        self._current_size = current_size

    @property
    def desired_size(self):
        """Gets the desired_size of this VirtualInstance.  # noqa: E501

        virtual instance desired size  # noqa: E501

        :return: The desired_size of this VirtualInstance.  # noqa: E501
        :rtype: str
        """
        return self._desired_size

    @desired_size.setter
    def desired_size(self, desired_size):
        """Sets the desired_size of this VirtualInstance.

        virtual instance desired size  # noqa: E501

        :param desired_size: The desired_size of this VirtualInstance.  # noqa: E501
        :type: str
        """

        self._desired_size = desired_size

    @property
    def default_pod_count(self):
        """Gets the default_pod_count of this VirtualInstance.  # noqa: E501


        :return: The default_pod_count of this VirtualInstance.  # noqa: E501
        :rtype: int
        """
        return self._default_pod_count

    @default_pod_count.setter
    def default_pod_count(self, default_pod_count):
        """Sets the default_pod_count of this VirtualInstance.


        :param default_pod_count: The default_pod_count of this VirtualInstance.  # noqa: E501
        :type: int
        """

        self._default_pod_count = default_pod_count

    @property
    def scaled_pod_count(self):
        """Gets the scaled_pod_count of this VirtualInstance.  # noqa: E501


        :return: The scaled_pod_count of this VirtualInstance.  # noqa: E501
        :rtype: int
        """
        return self._scaled_pod_count

    @scaled_pod_count.setter
    def scaled_pod_count(self, scaled_pod_count):
        """Sets the scaled_pod_count of this VirtualInstance.


        :param scaled_pod_count: The scaled_pod_count of this VirtualInstance.  # noqa: E501
        :type: int
        """

        self._scaled_pod_count = scaled_pod_count

    @property
    def id(self):
        """Gets the id of this VirtualInstance.  # noqa: E501

        unique identifier for virtual instance  # noqa: E501

        :return: The id of this VirtualInstance.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this VirtualInstance.

        unique identifier for virtual instance  # noqa: E501

        :param id: The id of this VirtualInstance.  # noqa: E501
        :type: str
        """

        self._id = id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(VirtualInstance, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VirtualInstance):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

    def __getitem__(self, item):
        return getattr(self, item)

    def get(self, item):
        return getattr(self, item)

    def items(self):
        return self.to_dict().items()

    def __setitem__(self, item, value):
        return seattr(self, item, value)
