************************************************************************
      SUBROUTINE SFmodel_Liang(QQ,WW,R,F2,F1,FL)
************************************************************************
*                                                                      *
*     This SUBROUTINE calculates structure functions R, F2, F1 and     *
*     FL for inclusive electron-proton scattering in the resonance     *
*     region.  The reliable kinematic range  of this fitting model     *
*     is at 1.15 < W^2 < 3.9 GeV^2  and  0.3 < Q^2 < 5.0 (GeV/c)^2     *
*     For a complete discussion see Liang's Ph.D. thesis. 1/03 YGL     *
*                                                                      *
*     QQ is 4-momentum transfer squared in (GeV/c)^2, WW is  inva-     *
*     riant  squared mass of the hadronic final state in GeV^2.        *
*                                                                      *
************************************************************************

         LOGICAL*2 TEST
c        LOGICAL*2 goodfit
         INTEGER I,J,J1,I1,TMP
         REAL*8 QQ,WW,X,WW1,WW2,R,F2,F1,FL,NU,MP,MP2,R1,F21,R2,F22,Q4,
     #           Q6,Q8,XX,FAC,RLOG,TMP1,TMP2,Q,QTH,DQ,Y,F2TH,LIN,
     #           BINDING,SCB,QUAD
c           REAL dr

         REAL RP(276), F2P(552)

         COMMON/MODEL_LIANG/RP,F2P
         COMMON/MODEL_LIANG1/TEST

         MP = 0.9382727
         MP2= MP*MP
         X  = QQ/(QQ+WW-MP2)
         NU = (QQ+WW-MP2)*5.0d-01/MP
         IF (WW.LT.1.15.or.WW.gt.3.9) THEN
           PRINT *, 'Out of Liang fit range'; stop                       tmp [V.A. Naumov's comment]
c          R  = 0.0
c          F2 = 0.0
c          F1 = 0.0
c          FL = 0.0
c          call f2glob(x,qq,'H',12,f2)
c          call r1990(x,qq,r,dr,goodfit)
c          call r1998(x,qq,r,dr,goodfit)
           F1 = MP*F2*(1.0+NU*NU/QQ)/(1.0+R)/NU
           FL = 2*X*F1*R
                                      ELSE
           IF (.NOT.TEST) THEN
             TEST=.TRUE.
c            write(*,*) 'Reading parameters for Liang model'
             DATA RP/
     #       0.33129, 1.32645,-0.79900, -3.11559,   2.5681, -1.82534,
     #       0.28813, 0.90973,-0.54869, -3.76651,   3.4846, -2.02225,
     #       0.56382, 0.43268, 0.08276, 23.37011, -25.4063, 13.71927,
     #       0.67816,-0.09742, 1.91168, 51.09415, -61.0272, 17.29566,
     #       0.64090, 0.51581, 0.28952,-69.99436, -98.0096,133.50420,
     #       0.46245,-0.02240, 0.31779, -3.26504,  77.9481, 14.49329,
     #       0.39436,-0.02232, 0.34328, 24.69035,  50.0479, 13.91268,
     #       0.39805, 0.03919, 0.07716,  3.75484,  10.3324,  8.08673,
     #       0.38997, 0.00900, 0.15343, 16.36940,   4.9903,  7.44212,
     #       0.29674, 0.02783, 0.06118, 27.36369, -17.4484,  4.32732,
     #       0.35439,-0.01126, 0.23150, 53.46022, -18.2759,  7.18313,
     #       0.31987, 0.01455, 0.23862, 81.55396, -74.7982,  5.96615,
     #       0.31163,-0.00699, 0.12995, 51.23706,  18.1217,  4.82674,
     #       0.32176, 0.12831, 0.00514, 68.39391, -73.3401,  3.86676,
     #       0.32514, 0.20568, 0.02398, 31.46726, -34.1291,  3.42527,
     #       0.48734, 0.32263, 0.07471, 42.71339, -49.2712,  7.19561,
     #       0.38366, 0.16378, 0.00110, 26.58418, -29.0223,  3.80760,
     #       0.52817,-0.37320,10.22177, 44.87227, -53.3864, 15.03388,
     #       0.34971, 0.24432, 0.03942, 15.46841, -17.0274,  2.87509,
     #       0.32309, 0.05971, 0.23399, 81.18824, -85.6957,  4.59427,
     #       0.48408, 0.14606,-0.12127, 78.59016, -92.2077,  2.15488,
     #       0.44745, 0.08725,-0.07341, 96.91505,-113.3328,  1.61255,
     #       0.17621, 0.00267, 0.16446,290.88310,-284.5832,  4.78794,
     #       0.19235, 0.03305, 0.26250, 86.32166, -86.1215,  4.45001,
     #       0.25966, 0.02309, 0.06332, 54.29687, -49.3171,  3.33319,
     #       0.35243, 0.02105,-0.18868,110.69520,-226.4427,  4.95000,
     #       0.36534,-0.21314, 2.81021,-59.05300, -37.7424, 31.42299,
     #       0.28897,-5.27934,62.75448, 15.15152,   5.7736, 29.82406,
     #       0.31192,-0.03546, 0.09286, 19.06862, -33.4685,  1.56198,
     #       0.35713,-0.20097, 2.05940,436.08360,-517.4285, 14.75464,
     #       0.32423, 0.05549, 0.04984, 74.70284, -85.5771,  3.61358,
     #       0.26321, 0.02532, 0.04165,291.81850,-330.3480,  3.42817,
     #       0.19235,-0.00521, 0.30864,262.23130,-271.3294,  4.52254,
     #       0.17858,-0.00018, 0.28614,195.28650,-195.6441,  3.92928,
     #       0.14180, 0.00801, 0.21545,131.05210,-121.0251,  3.20372,
     #       0.19810, 0.00240, 0.29005,122.32390,-121.0733,  3.60232,
     #       0.24832,-0.00999, 0.46397, 81.22332, -85.5181,  3.40233,
     #       0.31740, 0.12344, 0.07026, 53.01398, -64.9467,  3.08821,
     #       0.32739,-0.06064, 0.79821,104.36790,-124.3242,  4.74774,
     #       0.34597, 0.11624,-0.04088, 50.29695, -64.8436,  2.35262,
     #       0.33840, 0.11035, 0.03128, 39.27810, -51.3317,  2.38903,
     #       0.38341, 0.12239,-0.12886, 59.12659, -80.0135,  1.94849,
     #       0.34759,-0.06730, 0.99427, 87.77917,-116.0158,  4.31371,
     #       0.35035, 0.13825, 0.05372, 37.00152, -51.0832,  2.35058,
     #       0.31877, 0.09654, 0.12551, 70.29255, -93.9217,  2.72640,
     #       0.32985, 0.25111,-0.24644, 11.54706, -17.2718,  1.00506/
             DATA F2P/
     #   0.00270,  -0.02563,   0.06438,   0.13288,  -0.18442,  59.57852,
     # 126.68970,-156.52300,  259.6862,  45.71608,  51.94866,-337.30260,
     #  -0.01266,   0.53825,  -1.14310,  -1.10755,   2.67523, -96.68052,
     # -65.71029, 144.62170, -350.7377,  61.76398, 116.55460, 172.52990,
     #  -0.00820,   0.30865,  -0.10750,  -0.79825,   1.01081, -37.89112,
     # -99.42540, 120.79090, -161.3490, -27.73087, -37.25240, 223.31690,
     #  -0.01626,   0.68263,  -2.08330,   0.93416,   7.66115, -20.34949,
     # -89.79055, 100.32260,  -89.9365, -81.08472,  33.33122, 139.55320,
     #   0.10085,  -0.39180,   4.39375,   2.96299,  -9.43805,   5.53277,
     # -49.30489,  43.73740,   12.3122,-123.36040, 117.44570,  -2.55460,
     #   0.16801,   1.66346,  -3.58292,  -1.43295,   6.54949,   9.59234,
     # -15.43190,   7.56539,   32.3811, -79.52365,  79.85619, -30.67446,
     #   0.24036,   0.66839,  -1.02483,   2.73454,  -3.12791,   4.67220,
     #  -1.94161,  -1.02171,   14.8272, -21.21147,  20.23464, -11.97409,
     #   0.14395,  -0.24303,   0.47600,   5.20955,   4.07727,  -6.50083,
     # -59.81225,  63.16642,  -30.5782, -70.20249,  50.86131,  55.80522,
     #   0.19595,   0.49078,   0.09058,   2.08639,   0.61890,   3.84467,
     #  30.61177, -30.33699,   17.4414,  32.96692, -20.06578, -29.88399,
     #   0.16363,   0.21846,   0.20264,   2.53441,  -0.76028,   3.90782,
     #  36.58707, -35.68809,   18.2261,  40.25367, -24.84555, -33.50865,
     #   0.11976,  -0.45730,   1.08627,   2.63121,  -0.58440,  -5.72117,
     # -53.80934,  57.73899,  -25.7978, -52.77444,  37.38223,  48.12931,
     #   0.03129,   0.08877,   0.31201,   0.52214,   0.56099,   9.45694,
     #  80.42830, -77.88046,   41.7567,  69.77966, -24.70381, -89.21936,
     #   0.04149,   0.05422,   0.14645,   0.46049,   0.70058,   7.52857,
     #  73.36507, -69.99093,   33.8845,  68.44820, -34.26609, -69.93432,
     #   0.03743,   0.05538,   0.06989,   0.42875,   0.74432,   9.91687,
     #  99.10915, -95.21824,   44.3231,  88.44396, -44.56128, -92.21440,
     #   0.04214,   0.07361,  -0.05129,   0.40464,   1.03509,   8.78332,
     #  90.67270, -86.53600,   39.0777,  79.55918, -42.40906, -79.76051,
     #   0.02977,   0.24989,  -0.36480,   0.43282,   1.66379,  10.58702,
     #  99.35179, -95.66632,   45.5028,  74.12631, -26.76438, -97.86623,
     #   0.04183,   0.17483,  -0.23191,   0.45452,   1.41034,   8.17936,
     #  74.28743, -69.96535,   34.5675,  50.35936, -11.35428, -76.36961,
     #   0.05173,   0.04448,   0.13424,   0.38647,   0.54959,   6.16662,
     #  51.08549, -46.36961,   25.3451,  28.23540,   3.70411, -58.01252,
     #   0.08047,   0.07636,  -0.05934,   0.34274,   0.77572,   4.27257,
     #  38.90837, -35.54622,   17.7386,  24.76801,  -9.17321, -33.32258,
     #   0.08916,   0.08720,  -0.04772,   0.36316,   0.77081,   4.10228,
     #  40.26231, -37.09061,   17.1693,  26.59951, -14.07698, -29.96852,
     #   0.02688,   0.20865,   0.24902,   0.19521,   0.37927,  -0.57453,
     #  -9.00651,  14.38374,   -2.4497,  -6.51968,   9.73428,   3.89960,
     #   0.04139,   0.15301,   0.32248,   0.36027,   0.17856,   3.32167,
     #  28.88752, -23.90850,   13.4160,  12.82948,   3.90580, -29.60664,
     #   0.05169,  -0.19792,   0.70477,   0.98245,   0.19970,   1.07366,
     #  -0.96632,  13.46862,    3.5916, -10.17772,  41.48280, -29.53078,
     #   0.04810,  -0.14599,   0.44319,   0.86999,   0.59196,   2.37207,
     #  16.49698,  -3.58537,    9.1814,   2.29473,  31.25257, -39.15542,
     #   0.04731,  -0.14069,   0.33899,   0.74002,   0.62827,  -0.83045,
     # -17.17104,  32.13834,   -3.8414, -13.50958,  37.48258, -11.74448,
     #   0.05221,  -0.11177,   0.27687,   0.68277,   0.62925,   2.10930,
     #  13.86561,  -1.66573,    7.9977,   0.35896,  27.99104, -32.29613,
     #   0.06442,  -0.07257,   0.11952,   0.50396,   0.53317,   4.29581,
     #  44.07500, -35.61928,   17.2312,  19.12265,   0.86142, -37.08731,
     #   0.07351,  -0.10911,   0.12156,   0.46602,   0.48331,   5.17804,
     #  58.31429, -50.40657,   21.0203,  27.73335, -10.71966, -39.46624,
     #   0.06943,  -0.07336,   0.15002,   0.46675,   0.51645,   3.31844,
     #  37.30048, -28.68561,   13.4842,  17.16954,  -2.77701, -26.91567,
     #   0.05361,  -0.02633,   0.19376,   0.44691,   0.44814,   2.88220,
     #  29.95785, -19.93872,   11.4738,  10.83239,   7.47675, -28.12408,
     #   0.03795,  -0.04353,   0.30496,   0.53973,   0.44511,   1.82131,
     #  14.62905,  -0.35599,    6.9752,   1.48548,  24.99437, -29.88984,
     #   0.04790,   0.05632,   0.20660,   0.39304,   0.45673,   4.19462,
     #  47.41709, -39.83233,   16.6487,  17.18184,  -2.52659, -32.65720,
     #   0.05140,   0.11201,   0.19756,   0.26992,   0.30311,   3.20459,
     #  37.47848, -31.60155,   12.7851,  13.97016,  -8.18266, -18.63125,
     #   0.04703,   0.17203,   0.21807,   0.23841,   0.26405,   1.17976,
     #  10.84169,  -4.87255,    4.5850,   2.60271,  -1.08836,  -2.73421,
     #   0.09651,  -0.07097,  -0.01140,   0.41291,   0.67944,   8.63177,
     # 116.48230,-115.22170,   34.6775,  50.71781, -62.71606, -31.72991,
     #   0.05407,  -0.01853,   0.18484,   0.39172,   0.39883,   4.54709,
     #  57.66357, -47.37784,   18.0009,  22.01861, -16.19442, -25.28908,
     #   0.05646,  -0.02226,   0.19051,   0.38210,   0.35937,   2.35732,
     #  31.71869, -21.30330,    9.5296,  14.48209, -14.30969,  -7.90519,
     #   0.04477,   0.00480,   0.15076,   0.29189,   0.31529,   3.12081,
     #  41.81401, -31.97399,   12.4581,  15.71344, -15.68024, -13.09181,
     #   0.03143,   0.06733,   0.18032,   0.27882,   0.27721,   1.09240,
     #  15.14939,  -7.18577,    4.4895,   7.48708, -11.64642,   1.23596,
     #   0.09641,  -0.07037,  -0.04597,   0.26390,   0.48362,   3.68185,
     #  61.90438, -66.11752,   15.0943,  29.88299, -76.76054,  30.73642,
     #   0.05348,  -0.06567,   0.26431,   0.51672,  -0.39508,  -0.17103,
     #   0.38781,   9.77783,   -0.2076,   3.74785, -13.89592,  15.93324,
     #   0.01978,   0.02381,   0.16282,   0.27720,   0.28227,   1.10671,
     #  19.57988,  -8.77431,    4.6923,  10.90089, -21.92500,   4.82789,
     #   0.02816,   0.08035,   0.15177,   0.19596,   0.20729,   0.16046,
     #   4.85393,   1.60025,    0.9924,   6.34038, -23.91168,  19.81668,
     #   0.00810,   0.06904,   0.19159,   0.22518,   0.16841,   0.22909,
     #   4.46808,  -1.67027,    1.1692,   4.17188, -22.18001,  13.56817,
     #  -0.00459,   0.08266,   0.20067,   0.22163,   0.15112,   0.67785,
     #  10.03290, -23.97605,    2.8133,   1.49803, -32.05834,  14.49983,
     #  -0.00869,   0.07988,   0.20642,   0.23439,   0.16011,   1.58356,
     #  23.98258, -56.34460,    6.2639,  -0.04471, -43.27986,  13.87953/
          endIF
             IF (WW.lt.1.200) THEN
               WW1=1.175
               TMP=0
         ELSEIF (WW.lt.3.000) THEN
               TMP=INT((WW-1.150)/0.050)
               WW1=1.175+TMP*0.050
                            ELSE
               TMP=INT((WW-3.000)/0.100)
               WW1=3.050+TMP*0.100
               TMP=TMP+37
          endIF
             J      =(TMP+1)*6 - 5
             J1     =(TMP+1)*12-11
             Q4     =QQ*QQ
             Q6     =QQ*QQ*QQ
             Q8     =Q4*Q4
             TMP1   =12.000*(QQ/(1.0+QQ))
             TMP2   =log(QQ/0.040)
             XX     =QQ/(QQ+WW1-MP2)
             FAC    =1+TMP1*(0.125**2/(XX**2+0.125**2))
             RLOG   =FAC/TMP2
             R1     =RP(J)*RLOG +(RP(J+1)/QQ+RP(J+2)/(Q4+0.300**2))*
     #               (1.0+RP(J+3)*xx+RP(J+4)*(xx**2))*(xx**RP(J+5))
             BINDING=1.0
             Q      =log(QQ)
             QTH    =0.200+3.200*XX
             DQ     =Q-QTH
             Y      =1.0-XX
             F2TH   =F2P(J1)*Y**1+F2P(J1+1)*Y**2+F2P(J1+2)*Y**3+
     #               F2P(J1+3)*Y**4+F2P(J1+4)*Y**5
             QUAD   =(F2P(J1+5)+F2P(J1+6)*XX+F2P(J1+ 7)*XX**2)*DQ**2
             LIN    =(F2P(J1+8)+F2P(J1+9)*XX+F2P(J1+10)*XX**2+
     #               F2P(J1+11)*XX**3)*DQ
             IF (Q.gt.QTH) QUAD=0.0
             SCB    =(1.0+LIN+QUAD)
             F21    =F2TH*SCB*BINDING
             IF (WW.le.1.200 .or. abs(WW-WW1).le.0.001) THEN
               R =R1
               F2=F21
                                                        ELSE
               IF (WW.gt.WW1) THEN
                 I =J + 6
                 I1=J1+12
                 IF (    WW1       .lt.1.200) THEN; WW2=    1.225
             ELSEIF (    WW1       .lt.2.975) THEN; WW2=WW1+0.050
             ELSEIF (abs(WW1-2.975).lt.0.010) THEN; WW2=    3.050
             ELSEIF (abs(WW1-3.850).lt.0.010) THEN; WW2=    3.750
                                                    I  =J - 6
                                                    I1 =J1-12
                                              ELSE; WW2=WW1+0.100
              endIF
                              ELSE
                 I =J - 6
                 I1=J1-12
                 IF (    WW1       .lt.1.250) THEN; WW2=    1.175
             ELSEIF (    WW1       .lt.3.050) THEN; WW2=WW1-0.050
             ELSEIF (abs(WW1-3.050).lt.0.010) THEN; WW2=    2.975
                                              ELSE; WW2=WW1-0.100
              endIF
            endIF
               XX  =QQ/(QQ+WW2-MP2)
               FAC =1+TMP1*(0.125**2/(XX**2+0.125**2))
               RLOG=FAC/TMP2
               R2  =RP(I)*RLOG+(RP(I+1)/QQ+RP(I+2)/(Q4+0.300**2))*
     #              (1.0+RP(I+3)*XX+RP(I+4)*(XX**2))*(XX**RP(I+5))
               Q   =log(QQ)
               QTH =0.200+3.200*XX
               DQ  =Q-QTH
               Y   =1.0-XX
               F2TH=F2P(I1)*Y**1+F2P(I1+1)*Y**2+F2P(I1+2)*Y**3+
     #              F2P(I1+3)*Y**4+F2P(I1+4)*Y**5
               QUAD=(F2P(I1+5)+F2P(I1+6)*XX+F2P(I1+ 7)*XX**2)*DQ**2
               LIN =(F2P(I1+8)+F2P(I1+9)*XX+F2P(I1+10)*XX**2+
     #              F2P(I1+11)*XX**3)*DQ
               IF (Q.gt.QTH) QUAD=0.0
               SCB =(1.0+LIN+QUAD)
               F22 =F2TH*SCB*BINDING
               R   =R1 +(WW-WW1)*(R2 -R1 )/(WW2-WW1)
               F2  =F21+(WW-WW1)*(F22-F21)/(WW2-WW1)
          endIF
             IF (F2.lt.0) THEN; F2=0.0
         ELSEIF (R .lt.0) THEN; R =0.0
                          ELSE
          endIF
             F1=MP*F2*(1.0+NU*NU/QQ)/(1.0+R)/NU
             FL=2*X*F1*R
        endIF

         RETURN
      END SUBROUTINE SFmodel_Liang
