"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FileSubmissionDialog = void 0;
const jsx_runtime_1 = require("react/jsx-runtime");
const React = __importStar(require("react"));
const PipelineService_1 = require("./PipelineService");
const utils_1 = __importDefault(require("./utils"));
const EnvForm = ({ env }) => {
    if (env.length > 0) {
        return (jsx_runtime_1.jsxs(jsx_runtime_1.Fragment, { children: [jsx_runtime_1.jsx("br", {}, void 0),
                jsx_runtime_1.jsx("br", {}, void 0),
                jsx_runtime_1.jsx("div", { children: "Environment Variables:" }, void 0),
                jsx_runtime_1.jsx("br", {}, void 0),
                utils_1.default.chunkArray(env, 4).map((col, i) => (jsx_runtime_1.jsx("div", { children: col.map(envVar => (jsx_runtime_1.jsxs("div", { children: [jsx_runtime_1.jsxs("label", Object.assign({ htmlFor: envVar }, { children: [envVar, ":"] }), void 0),
                            jsx_runtime_1.jsx("br", {}, void 0),
                            jsx_runtime_1.jsx("input", { type: "text", id: envVar, className: "envVar", name: envVar, size: 30 }, void 0)] }, envVar))) }, i)))] }, void 0));
    }
    return null;
};
class FileSubmissionDialog extends React.Component {
    constructor() {
        super(...arguments);
        this.state = {
            displayedRuntimeOptions: new Array(),
            includeDependency: true,
            selectedRuntimePlatform: '',
            validSchemas: new Array()
        };
        this.handleCheck = (event) => {
            this.setState({
                includeDependency: !this.state.includeDependency
            });
        };
        this.handleUpdate = (event) => {
            const selectedPlatform = event.target.value;
            this.setState({
                displayedRuntimeOptions: this.updateRuntimeOptions(selectedPlatform),
                selectedRuntimePlatform: selectedPlatform
            });
        };
        this.updateRuntimeOptions = (platformSelection) => {
            const filteredRuntimeOptions = PipelineService_1.PipelineService.filterRuntimes(this.props.runtimes, platformSelection);
            PipelineService_1.PipelineService.sortRuntimesByDisplayName(filteredRuntimeOptions);
            return filteredRuntimeOptions;
        };
    }
    componentDidMount() {
        const { schema, runtimes } = this.props;
        const validSchemas = PipelineService_1.PipelineService.filterValidSchema(runtimes, schema);
        const selectedRuntimePlatform = validSchemas[0] && validSchemas[0].name;
        const displayedRuntimeOptions = this.updateRuntimeOptions(selectedRuntimePlatform);
        this.setState({
            displayedRuntimeOptions: displayedRuntimeOptions,
            selectedRuntimePlatform: selectedRuntimePlatform,
            validSchemas: validSchemas
        });
    }
    render() {
        const { env, images, dependencyFileExtension } = this.props;
        const { displayedRuntimeOptions, includeDependency, validSchemas } = this.state;
        const fileDependencyContent = includeDependency ? (jsx_runtime_1.jsxs("div", { children: [jsx_runtime_1.jsx("br", {}, void 0),
                jsx_runtime_1.jsx("input", { type: "text", id: "dependencies", className: "jp-mod-styled", name: "dependencies", placeholder: `*${dependencyFileExtension}`, defaultValue: `*${dependencyFileExtension}`, size: 30 }, void 0)] }, "dependencies")) : null;
        return (jsx_runtime_1.jsxs("form", Object.assign({ className: "elyra-dialog-form" }, { children: [jsx_runtime_1.jsx("label", Object.assign({ htmlFor: "runtime_platform" }, { children: "Runtime Platform:" }), void 0),
                jsx_runtime_1.jsx("br", {}, void 0),
                jsx_runtime_1.jsx("select", Object.assign({ id: "runtime_platform", name: "runtime_platform", className: "elyra-form-runtime-platform", onChange: this.handleUpdate }, { children: validSchemas.map(schema => (jsx_runtime_1.jsx("option", Object.assign({ value: schema.name }, { children: schema.display_name }), schema.name))) }), void 0),
                jsx_runtime_1.jsx("label", Object.assign({ htmlFor: "runtime_config" }, { children: "Runtime Configuration:" }), void 0),
                jsx_runtime_1.jsx("br", {}, void 0),
                jsx_runtime_1.jsx("select", Object.assign({ id: "runtime_config", name: "runtime_config", className: "elyra-form-runtime-config" }, { children: displayedRuntimeOptions.map(runtime => (jsx_runtime_1.jsx("option", Object.assign({ value: runtime.name }, { children: runtime.display_name }), runtime.name))) }), void 0),
                jsx_runtime_1.jsx("label", Object.assign({ htmlFor: "framework" }, { children: "Runtime Image:" }), void 0),
                jsx_runtime_1.jsx("br", {}, void 0),
                jsx_runtime_1.jsx("select", Object.assign({ id: "framework", name: "framework", className: "elyra-form-framework" }, { children: Object.entries(images).map(([key, val]) => (jsx_runtime_1.jsx("option", Object.assign({ value: key }, { children: val }), key))) }), void 0),
                jsx_runtime_1.jsx("br", {}, void 0),
                jsx_runtime_1.jsxs("div", Object.assign({ className: "elyra-resourcesWrapper" }, { children: [jsx_runtime_1.jsxs("div", Object.assign({ className: "elyra-resourceInput" }, { children: [jsx_runtime_1.jsx("label", Object.assign({ htmlFor: "cpu" }, { children: " CPU:" }), void 0),
                                jsx_runtime_1.jsx("input", { id: "cpu", type: "number", name: "cpu" }, void 0)] }), void 0),
                        jsx_runtime_1.jsxs("div", Object.assign({ className: "elyra-resourceInput" }, { children: [jsx_runtime_1.jsx("label", Object.assign({ htmlFor: "gpu" }, { children: " GPU:" }), void 0),
                                jsx_runtime_1.jsx("input", { id: "gpu", type: "number", name: "gpu" }, void 0)] }), void 0),
                        jsx_runtime_1.jsxs("div", Object.assign({ className: "elyra-resourceInput" }, { children: [jsx_runtime_1.jsx("label", Object.assign({ htmlFor: "memory" }, { children: " RAM (GB):" }), void 0),
                                jsx_runtime_1.jsx("input", { id: "memory", type: "number", name: "memory" }, void 0)] }), void 0)] }), void 0),
                jsx_runtime_1.jsx("br", {}, void 0),
                jsx_runtime_1.jsx("input", { type: "checkbox", className: "elyra-Dialog-checkbox", id: "dependency_include", name: "dependency_include", size: 20, checked: this.state.includeDependency, onChange: this.handleCheck }, void 0),
                jsx_runtime_1.jsx("label", Object.assign({ htmlFor: "dependency_include" }, { children: "Include File Dependencies:" }), void 0),
                jsx_runtime_1.jsx("br", {}, void 0), fileDependencyContent, jsx_runtime_1.jsx(EnvForm, { env: env }, void 0)] }), void 0));
    }
}
exports.FileSubmissionDialog = FileSubmissionDialog;
//# sourceMappingURL=FileSubmissionDialog.js.map