import { DocumentRegistry, DocumentWidget } from '@jupyterlab/docregistry';
import { FileEditor } from '@jupyterlab/fileeditor';
import { IDisposable } from '@lumino/disposable';
/**
 * Submit script button extension
 *  - Attach button to FileEditor toolbar and launch a dialog requesting
 *  information where submit the script for execution
 */
export declare class SubmitScriptButtonExtension implements DocumentRegistry.IWidgetExtension<DocumentWidget<FileEditor, DocumentRegistry.ICodeModel>, DocumentRegistry.ICodeModel> {
    showWidget: (editor: DocumentWidget<FileEditor, DocumentRegistry.ICodeModel>) => Promise<void>;
    createNew(editor: DocumentWidget<FileEditor, DocumentRegistry.ICodeModel>, context: DocumentRegistry.IContext<DocumentRegistry.ICodeModel>): IDisposable;
}
