# This file was auto-generated by zetup
#
# https://bitbucket.org/userzimmermann/zetup.py


from __future__ import absolute_import

import sys
import os
from collections import OrderedDict

from zetup.version import Version
from zetup.dist import Distribution
from zetup.requires import Requirements
from zetup.extras import Extras
from zetup.package import Packages, Package
from zetup.notebook import Notebook



zfg = sys.modules[__name__]

DISTRIBUTION = Distribution('robotframework-tools', 'robottools', '0.1a129')

KEYWORDS = ['robottools', 'robot', 'framework', 'robotframework', 'tools', 'test', 'automation', 'testautomation', 'testlibrary', 'testcase', 'keyword', 'pybot', 'robotshell', 'ipython', 'python3']

PYTHON = ['2.7', '3.3', '3.4']

MODULES = ['ToolsLibrary']

REQUIRES = Requirements("""
zetup >= 0.2.16
six >= 1.9
path.py >= 7.5 #import path
moretools >= 0.1.7
modeled >= 0.1.3
#py2 robotframework >= 2.8 #import robot
#py3 robotframework-python3 #import robot

""", zfg=zfg)

VERSION = Version('0.1a129')

PACKAGES = Packages([

Package('robottools',
  sources=[
    '__init__.py'
    ],
  subpackages=[
    
Package('robottools.libdoc',
  sources=[
    'html.py',
    '__init__.py'
    ],
  subpackages=[
    
    ],
  )
,
    
Package('robottools.library',
  sources=[
    'base.py',
    '__init__.py'
    ],
  subpackages=[
    
Package('robottools.library.context',
  sources=[
    'method.py',
    '__init__.py'
    ],
  subpackages=[
    
    ],
  )
,
    
Package('robottools.library.inspector',
  sources=[
    'arguments.py',
    'keyword.py',
    'multi.py',
    '__init__.py'
    ],
  subpackages=[
    
    ],
  )
,
    
Package('robottools.library.keywords',
  sources=[
    'deco.py',
    'errors.py',
    'utils.py',
    '__init__.py'
    ],
  subpackages=[
    
    ],
  )
,
    
Package('robottools.library.session',
  sources=[
    'meta.py',
    'metaoptions.py',
    '__init__.py'
    ],
  subpackages=[
    
    ],
  )

    ],
  )
,
    
Package('robottools.remote',
  sources=[
    'keywords.py',
    'library.py',
    '__init__.py'
    ],
  subpackages=[
    
    ],
  )
,
    
Package('robottools.testrobot',
  sources=[
    'context.py',
    'highlighting.py',
    'keyword.py',
    'library.py',
    'output.py',
    'result.py',
    'variables.py',
    '__init__.py'
    ],
  subpackages=[
    
    ],
  )
,
    
Package('robottools.utils',
  sources=[
    'normbool.py',
    'normdict.py',
    'normstr.py',
    '__init__.py'
    ],
  subpackages=[
    
    ],
  )

    ],
  )
,
  
Package('robotshell',
  sources=[
    'base.py',
    'extension.py',
    'library.py',
    'result.py',
    'shell.py',
    '__init__.py'
    ],
  subpackages=[
    
Package('robotshell.magic',
  sources=[
    'base.py',
    'keyword.py',
    'robot.py',
    'variable.py',
    '__init__.py'
    ],
  subpackages=[
    
    ],
  )

    ],
  )

  ], root=os.path.dirname(os.path.dirname(os.path.realpath(__file__))))

AUTHOR = 'Stefan Zimmermann'

EMAIL = 'zimmermann.code@gmail.com'

CLASSIFIERS = ['Development Status :: 3 - Alpha', 'Intended Audience :: Developers', 'License :: OSI Approved :: GNU General Public License (GPL)', 'Operating System :: OS Independent', 'Topic :: Software Development', 'Topic :: Utilities', 'Programming Language :: Python', 'Programming Language :: Python :: 2.7', 'Programming Language :: Python :: 3.3', 'Programming Language :: Python :: 3.4']

SETUP_HOOKS = []

EXTRAS = Extras([
('remote', Requirements("""
robotremoteserver

""")),
('robotshell', Requirements("""
ipython >= 3.0 #import IPython

"""))
], zfg=zfg)

SETUP_REQUIRES = None

DESCRIPTION = 'Python Tools for Robot Framework and Test Libraries.'

LICENSE = 'GPLv3'

TITLE = 'robotframework-tools'

NAME = 'robotframework-tools'

URL = 'http://bitbucket.org/userzimmermann/robotframework-tools'