# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetReplicationStatusResult',
    'AwaitableGetReplicationStatusResult',
    'get_replication_status',
    'get_replication_status_output',
]

@pulumi.output_type
class GetReplicationStatusResult:
    """
    A collection of values returned by getReplicationStatus.
    """
    def __init__(__self__, id=None, management_endpoint=None, replica_details=None, replication_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if management_endpoint and not isinstance(management_endpoint, str):
            raise TypeError("Expected argument 'management_endpoint' to be a str")
        pulumi.set(__self__, "management_endpoint", management_endpoint)
        if replica_details and not isinstance(replica_details, list):
            raise TypeError("Expected argument 'replica_details' to be a list")
        pulumi.set(__self__, "replica_details", replica_details)
        if replication_id and not isinstance(replication_id, str):
            raise TypeError("Expected argument 'replication_id' to be a str")
        pulumi.set(__self__, "replication_id", replication_id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="managementEndpoint")
    def management_endpoint(self) -> str:
        return pulumi.get(self, "management_endpoint")

    @property
    @pulumi.getter(name="replicaDetails")
    def replica_details(self) -> Sequence['outputs.GetReplicationStatusReplicaDetailResult']:
        """
        Replica Details.
        """
        return pulumi.get(self, "replica_details")

    @property
    @pulumi.getter(name="replicationId")
    def replication_id(self) -> str:
        return pulumi.get(self, "replication_id")


class AwaitableGetReplicationStatusResult(GetReplicationStatusResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetReplicationStatusResult(
            id=self.id,
            management_endpoint=self.management_endpoint,
            replica_details=self.replica_details,
            replication_id=self.replication_id)


def get_replication_status(management_endpoint: Optional[str] = None,
                           replication_id: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetReplicationStatusResult:
    """
    This data source provides details about a specific Replication Status resource in Oracle Cloud Infrastructure Kms service.

    When a vault has a replica, each operation on the vault or its resources, such as
    keys, is replicated and has an associated replicationId. Replication status provides
    details about whether the operation associated with the given replicationId has been
    successfully applied across replicas.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_replication_status = oci.Kms.get_replication_status(replication_id=oci_kms_replication["test_replication"]["id"],
        management_endpoint=var["replication_status_management_endpoint"])
    ```


    :param str management_endpoint: The service endpoint to perform management operations against. See Vault Management endpoint.
    :param str replication_id: replicationId associated with an operation on a resource
    """
    __args__ = dict()
    __args__['managementEndpoint'] = management_endpoint
    __args__['replicationId'] = replication_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Kms/getReplicationStatus:getReplicationStatus', __args__, opts=opts, typ=GetReplicationStatusResult).value

    return AwaitableGetReplicationStatusResult(
        id=pulumi.get(__ret__, 'id'),
        management_endpoint=pulumi.get(__ret__, 'management_endpoint'),
        replica_details=pulumi.get(__ret__, 'replica_details'),
        replication_id=pulumi.get(__ret__, 'replication_id'))


@_utilities.lift_output_func(get_replication_status)
def get_replication_status_output(management_endpoint: Optional[pulumi.Input[str]] = None,
                                  replication_id: Optional[pulumi.Input[str]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetReplicationStatusResult]:
    """
    This data source provides details about a specific Replication Status resource in Oracle Cloud Infrastructure Kms service.

    When a vault has a replica, each operation on the vault or its resources, such as
    keys, is replicated and has an associated replicationId. Replication status provides
    details about whether the operation associated with the given replicationId has been
    successfully applied across replicas.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_replication_status = oci.Kms.get_replication_status(replication_id=oci_kms_replication["test_replication"]["id"],
        management_endpoint=var["replication_status_management_endpoint"])
    ```


    :param str management_endpoint: The service endpoint to perform management operations against. See Vault Management endpoint.
    :param str replication_id: replicationId associated with an operation on a resource
    """
    ...
