#!/usr/bin/env python
# -*- coding: utf-8 -*-

#
# Generated Fri Nov 19 06:59:45 2021 by generateDS.py version 2.40.5.
# Python 3.8.6 (v3.8.6:db455296be, Sep 23 2020, 13:31:39)  [Clang 6.0 (clang-600.0.57)]
#
# Command line options:
#   ('--no-namespace-defs', '')
#   ('-o', './dhl_poland_lib/services.py')
#
# Command line arguments:
#   ./schemas/webapi2.xsd
#
# Command line:
#   /Users/danielkobina/Workspace/project/karrio/.venv/karrio/bin/generateDS --no-namespace-defs -o "./dhl_poland_lib/services.py" ./schemas/webapi2.xsd
#
# Current working directory (os.getcwd()):
#   dhl_poland
#

import sys

try:
    ModulenotfoundExp_ = ModuleNotFoundError
except NameError:
    ModulenotfoundExp_ = ImportError
from six.moves import zip_longest
import os
import re as re_
import base64
import datetime as datetime_
import decimal as decimal_
from lxml import etree as etree_


Validate_simpletypes_ = True
SaveElementTreeNode = True
if sys.version_info.major == 2:
    BaseStrType_ = basestring
else:
    BaseStrType_ = str


def parsexml_(infile, parser=None, **kwargs):
    if parser is None:
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        try:
            parser = etree_.ETCompatXMLParser()
        except AttributeError:
            # fallback to xml.etree
            parser = etree_.XMLParser()
    try:
        if isinstance(infile, os.PathLike):
            infile = os.path.join(infile)
    except AttributeError:
        pass
    doc = etree_.parse(infile, parser=parser, **kwargs)
    return doc


def parsexmlstring_(instring, parser=None, **kwargs):
    if parser is None:
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        try:
            parser = etree_.ETCompatXMLParser()
        except AttributeError:
            # fallback to xml.etree
            parser = etree_.XMLParser()
    element = etree_.fromstring(instring, parser=parser, **kwargs)
    return element


#
# Namespace prefix definition table (and other attributes, too)
#
# The module generatedsnamespaces, if it is importable, must contain
# a dictionary named GeneratedsNamespaceDefs.  This Python dictionary
# should map element type names (strings) to XML schema namespace prefix
# definitions.  The export method for any class for which there is
# a namespace prefix definition, will export that definition in the
# XML representation of that element.  See the export method of
# any generated element type class for an example of the use of this
# table.
# A sample table is:
#
#     # File: generatedsnamespaces.py
#
#     GenerateDSNamespaceDefs = {
#         "ElementtypeA": "http://www.xxx.com/namespaceA",
#         "ElementtypeB": "http://www.xxx.com/namespaceB",
#     }
#
# Additionally, the generatedsnamespaces module can contain a python
# dictionary named GenerateDSNamespaceTypePrefixes that associates element
# types with the namespace prefixes that are to be added to the
# "xsi:type" attribute value.  See the _exportAttributes method of
# any generated element type and the generation of "xsi:type" for an
# example of the use of this table.
# An example table:
#
#     # File: generatedsnamespaces.py
#
#     GenerateDSNamespaceTypePrefixes = {
#         "ElementtypeC": "aaa:",
#         "ElementtypeD": "bbb:",
#     }
#

try:
    from generatedsnamespaces import GenerateDSNamespaceDefs as GenerateDSNamespaceDefs_
except ModulenotfoundExp_:
    GenerateDSNamespaceDefs_ = {}
try:
    from generatedsnamespaces import (
        GenerateDSNamespaceTypePrefixes as GenerateDSNamespaceTypePrefixes_,
    )
except ModulenotfoundExp_:
    GenerateDSNamespaceTypePrefixes_ = {}

#
# You can replace the following class definition by defining an
# importable module named "generatedscollector" containing a class
# named "GdsCollector".  See the default class definition below for
# clues about the possible content of that class.
#
try:
    from generatedscollector import GdsCollector as GdsCollector_
except ModulenotfoundExp_:

    class GdsCollector_(object):
        def __init__(self, messages=None):
            if messages is None:
                self.messages = []
            else:
                self.messages = messages

        def add_message(self, msg):
            self.messages.append(msg)

        def get_messages(self):
            return self.messages

        def clear_messages(self):
            self.messages = []

        def print_messages(self):
            for msg in self.messages:
                print("Warning: {}".format(msg))

        def write_messages(self, outstream):
            for msg in self.messages:
                outstream.write("Warning: {}\n".format(msg))


#
# The super-class for enum types
#

try:
    from enum import Enum
except ModulenotfoundExp_:
    Enum = object

#
# The root super-class for element type classes
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ModulenotfoundExp_ as exp:
    try:
        from generatedssupersuper import GeneratedsSuperSuper
    except ModulenotfoundExp_ as exp:

        class GeneratedsSuperSuper(object):
            pass

    class GeneratedsSuper(GeneratedsSuperSuper):
        __hash__ = object.__hash__
        tzoff_pattern = re_.compile(r"(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$")

        class _FixedOffsetTZ(datetime_.tzinfo):
            def __init__(self, offset, name):
                self.__offset = datetime_.timedelta(minutes=offset)
                self.__name = name

            def utcoffset(self, dt):
                return self.__offset

            def tzname(self, dt):
                return self.__name

            def dst(self, dt):
                return None

        def __str__(self):
            settings = {
                "str_pretty_print": True,
                "str_indent_level": 0,
                "str_namespaceprefix": "",
                "str_name": None,
                "str_namespacedefs": "",
            }
            for n in settings:
                if hasattr(self, n):
                    setattr(settings[n], self[n])
            from io import StringIO

            output = StringIO()
            self.export(
                output,
                settings["str_indent_level"],
                pretty_print=settings["str_pretty_print"],
                namespaceprefix_=settings["str_namespaceprefix"],
                name_=settings["str_name"],
                namespacedef_=settings["str_namespacedefs"],
            )
            strval = output.getvalue()
            output.close()
            return strval

        def gds_format_string(self, input_data, input_name=""):
            return input_data

        def gds_parse_string(self, input_data, node=None, input_name=""):
            return input_data

        def gds_validate_string(self, input_data, node=None, input_name=""):
            if not input_data:
                return ""
            else:
                return input_data

        def gds_format_base64(self, input_data, input_name=""):
            return base64.b64encode(input_data).decode("ascii")

        def gds_validate_base64(self, input_data, node=None, input_name=""):
            return input_data

        def gds_format_integer(self, input_data, input_name=""):
            return "%d" % int(input_data)

        def gds_parse_integer(self, input_data, node=None, input_name=""):
            try:
                ival = int(input_data)
            except (TypeError, ValueError) as exp:
                raise_parse_error(node, "Requires integer value: %s" % exp)
            return ival

        def gds_validate_integer(self, input_data, node=None, input_name=""):
            try:
                value = int(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, "Requires integer value")
            return value

        def gds_format_integer_list(self, input_data, input_name=""):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return "%s" % " ".join(input_data)

        def gds_validate_integer_list(self, input_data, node=None, input_name=""):
            values = input_data.split()
            for value in values:
                try:
                    int(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, "Requires sequence of integer values")
            return values

        def gds_format_float(self, input_data, input_name=""):
            return ("%.15f" % float(input_data)).rstrip("0")

        def gds_parse_float(self, input_data, node=None, input_name=""):
            try:
                fval_ = float(input_data)
            except (TypeError, ValueError) as exp:
                raise_parse_error(node, "Requires float or double value: %s" % exp)
            return fval_

        def gds_validate_float(self, input_data, node=None, input_name=""):
            try:
                value = float(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, "Requires float value")
            return value

        def gds_format_float_list(self, input_data, input_name=""):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return "%s" % " ".join(input_data)

        def gds_validate_float_list(self, input_data, node=None, input_name=""):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, "Requires sequence of float values")
            return values

        def gds_format_decimal(self, input_data, input_name=""):
            return_value = "%s" % input_data
            if "." in return_value:
                return_value = return_value.rstrip("0")
                if return_value.endswith("."):
                    return_value = return_value.rstrip(".")
            return return_value

        def gds_parse_decimal(self, input_data, node=None, input_name=""):
            try:
                decimal_value = decimal_.Decimal(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, "Requires decimal value")
            return decimal_value

        def gds_validate_decimal(self, input_data, node=None, input_name=""):
            try:
                value = decimal_.Decimal(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, "Requires decimal value")
            return value

        def gds_format_decimal_list(self, input_data, input_name=""):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return " ".join([self.gds_format_decimal(item) for item in input_data])

        def gds_validate_decimal_list(self, input_data, node=None, input_name=""):
            values = input_data.split()
            for value in values:
                try:
                    decimal_.Decimal(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, "Requires sequence of decimal values")
            return values

        def gds_format_double(self, input_data, input_name=""):
            return "%s" % input_data

        def gds_parse_double(self, input_data, node=None, input_name=""):
            try:
                fval_ = float(input_data)
            except (TypeError, ValueError) as exp:
                raise_parse_error(node, "Requires double or float value: %s" % exp)
            return fval_

        def gds_validate_double(self, input_data, node=None, input_name=""):
            try:
                value = float(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, "Requires double or float value")
            return value

        def gds_format_double_list(self, input_data, input_name=""):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return "%s" % " ".join(input_data)

        def gds_validate_double_list(self, input_data, node=None, input_name=""):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(
                        node, "Requires sequence of double or float values"
                    )
            return values

        def gds_format_boolean(self, input_data, input_name=""):
            return ("%s" % input_data).lower()

        def gds_parse_boolean(self, input_data, node=None, input_name=""):
            if input_data in ("true", "1"):
                bval = True
            elif input_data in ("false", "0"):
                bval = False
            else:
                raise_parse_error(node, "Requires boolean value")
            return bval

        def gds_validate_boolean(self, input_data, node=None, input_name=""):
            if input_data not in (
                True,
                1,
                False,
                0,
            ):
                raise_parse_error(
                    node, "Requires boolean value " "(one of True, 1, False, 0)"
                )
            return input_data

        def gds_format_boolean_list(self, input_data, input_name=""):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return "%s" % " ".join(input_data)

        def gds_validate_boolean_list(self, input_data, node=None, input_name=""):
            values = input_data.split()
            for value in values:
                value = self.gds_parse_boolean(value, node, input_name)
                if value not in (
                    True,
                    1,
                    False,
                    0,
                ):
                    raise_parse_error(
                        node,
                        "Requires sequence of boolean values "
                        "(one of True, 1, False, 0)",
                    )
            return values

        def gds_validate_datetime(self, input_data, node=None, input_name=""):
            return input_data

        def gds_format_datetime(self, input_data, input_name=""):
            if input_data.microsecond == 0:
                _svalue = "%04d-%02d-%02dT%02d:%02d:%02d" % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = "%04d-%02d-%02dT%02d:%02d:%02d.%s" % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ("%f" % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += "Z"
                    else:
                        if total_seconds < 0:
                            _svalue += "-"
                            total_seconds *= -1
                        else:
                            _svalue += "+"
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += "{0:02d}:{1:02d}".format(hours, minutes)
            return _svalue

        @classmethod
        def gds_parse_datetime(cls, input_data):
            tz = None
            if input_data[-1] == "Z":
                tz = GeneratedsSuper._FixedOffsetTZ(0, "UTC")
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(":")
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == "-":
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(tzoff, results.group(0))
                    input_data = input_data[:-6]
            time_parts = input_data.split(".")
            if len(time_parts) > 1:
                micro_seconds = int(float("0." + time_parts[1]) * 1000000)
                input_data = "%s.%s" % (
                    time_parts[0],
                    "{}".format(micro_seconds).rjust(6, "0"),
                )
                dt = datetime_.datetime.strptime(input_data, "%Y-%m-%dT%H:%M:%S.%f")
            else:
                dt = datetime_.datetime.strptime(input_data, "%Y-%m-%dT%H:%M:%S")
            dt = dt.replace(tzinfo=tz)
            return dt

        def gds_validate_date(self, input_data, node=None, input_name=""):
            return input_data

        def gds_format_date(self, input_data, input_name=""):
            _svalue = "%04d-%02d-%02d" % (
                input_data.year,
                input_data.month,
                input_data.day,
            )
            try:
                if input_data.tzinfo is not None:
                    tzoff = input_data.tzinfo.utcoffset(input_data)
                    if tzoff is not None:
                        total_seconds = tzoff.seconds + (86400 * tzoff.days)
                        if total_seconds == 0:
                            _svalue += "Z"
                        else:
                            if total_seconds < 0:
                                _svalue += "-"
                                total_seconds *= -1
                            else:
                                _svalue += "+"
                            hours = total_seconds // 3600
                            minutes = (total_seconds - (hours * 3600)) // 60
                            _svalue += "{0:02d}:{1:02d}".format(hours, minutes)
            except AttributeError:
                pass
            return _svalue

        @classmethod
        def gds_parse_date(cls, input_data):
            tz = None
            if input_data[-1] == "Z":
                tz = GeneratedsSuper._FixedOffsetTZ(0, "UTC")
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(":")
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == "-":
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(tzoff, results.group(0))
                    input_data = input_data[:-6]
            dt = datetime_.datetime.strptime(input_data, "%Y-%m-%d")
            dt = dt.replace(tzinfo=tz)
            return dt.date()

        def gds_validate_time(self, input_data, node=None, input_name=""):
            return input_data

        def gds_format_time(self, input_data, input_name=""):
            if input_data.microsecond == 0:
                _svalue = "%02d:%02d:%02d" % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = "%02d:%02d:%02d.%s" % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ("%f" % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += "Z"
                    else:
                        if total_seconds < 0:
                            _svalue += "-"
                            total_seconds *= -1
                        else:
                            _svalue += "+"
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += "{0:02d}:{1:02d}".format(hours, minutes)
            return _svalue

        def gds_validate_simple_patterns(self, patterns, target):
            # pat is a list of lists of strings/patterns.
            # The target value must match at least one of the patterns
            # in order for the test to succeed.
            found1 = True
            for patterns1 in patterns:
                found2 = False
                for patterns2 in patterns1:
                    mo = re_.search(patterns2, target)
                    if mo is not None and len(mo.group(0)) == len(target):
                        found2 = True
                        break
                if not found2:
                    found1 = False
                    break
            return found1

        @classmethod
        def gds_parse_time(cls, input_data):
            tz = None
            if input_data[-1] == "Z":
                tz = GeneratedsSuper._FixedOffsetTZ(0, "UTC")
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(":")
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == "-":
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split(".")) > 1:
                dt = datetime_.datetime.strptime(input_data, "%H:%M:%S.%f")
            else:
                dt = datetime_.datetime.strptime(input_data, "%H:%M:%S")
            dt = dt.replace(tzinfo=tz)
            return dt.time()

        def gds_check_cardinality_(
            self, value, input_name, min_occurs=0, max_occurs=1, required=None
        ):
            if value is None:
                length = 0
            elif isinstance(value, list):
                length = len(value)
            else:
                length = 1
            if required is not None:
                if required and length < 1:
                    self.gds_collector_.add_message(
                        "Required value {}{} is missing".format(
                            input_name, self.gds_get_node_lineno_()
                        )
                    )
            if length < min_occurs:
                self.gds_collector_.add_message(
                    "Number of values for {}{} is below "
                    "the minimum allowed, "
                    "expected at least {}, found {}".format(
                        input_name, self.gds_get_node_lineno_(), min_occurs, length
                    )
                )
            elif length > max_occurs:
                self.gds_collector_.add_message(
                    "Number of values for {}{} is above "
                    "the maximum allowed, "
                    "expected at most {}, found {}".format(
                        input_name, self.gds_get_node_lineno_(), max_occurs, length
                    )
                )

        def gds_validate_builtin_ST_(
            self,
            validator,
            value,
            input_name,
            min_occurs=None,
            max_occurs=None,
            required=None,
        ):
            if value is not None:
                try:
                    validator(value, input_name=input_name)
                except GDSParseError as parse_error:
                    self.gds_collector_.add_message(str(parse_error))

        def gds_validate_defined_ST_(
            self,
            validator,
            value,
            input_name,
            min_occurs=None,
            max_occurs=None,
            required=None,
        ):
            if value is not None:
                try:
                    validator(value)
                except GDSParseError as parse_error:
                    self.gds_collector_.add_message(str(parse_error))

        def gds_str_lower(self, instring):
            return instring.lower()

        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = "/".join(path_list)
            return path

        Tag_strip_pattern_ = re_.compile(r"\{.*\}")

        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub("", node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)

        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if "xsi" in node.nsmap:
                classname = node.get("{%s}type" % node.nsmap["xsi"])
                if classname is not None:
                    names = classname.split(":")
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1

        def gds_build_any(self, node, type_name=None):
            # provide default value in case option --disable-xml is used.
            content = ""
            content = etree_.tostring(node, encoding="unicode")
            return content

        @classmethod
        def gds_reverse_node_mapping(cls, mapping):
            return dict(((v, k) for k, v in mapping.items()))

        @staticmethod
        def gds_encode(instring):
            if sys.version_info.major == 2:
                if ExternalEncoding:
                    encoding = ExternalEncoding
                else:
                    encoding = "utf-8"
                return instring.encode(encoding)
            else:
                return instring

        @staticmethod
        def convert_unicode(instring):
            if isinstance(instring, str):
                result = quote_xml(instring)
            elif sys.version_info.major == 2 and isinstance(instring, unicode):
                result = quote_xml(instring).encode("utf8")
            else:
                result = GeneratedsSuper.gds_encode(str(instring))
            return result

        def __eq__(self, other):
            def excl_select_objs_(obj):
                return obj[0] != "parent_object_" and obj[0] != "gds_collector_"

            if type(self) != type(other):
                return False
            return all(
                x == y
                for x, y in zip_longest(
                    filter(excl_select_objs_, self.__dict__.items()),
                    filter(excl_select_objs_, other.__dict__.items()),
                )
            )

        def __ne__(self, other):
            return not self.__eq__(other)

        # Django ETL transform hooks.
        def gds_djo_etl_transform(self):
            pass

        def gds_djo_etl_transform_db_obj(self, dbobj):
            pass

        # SQLAlchemy ETL transform hooks.
        def gds_sqa_etl_transform(self):
            return 0, None

        def gds_sqa_etl_transform_db_obj(self, dbobj):
            pass

        def gds_get_node_lineno_(self):
            if (
                hasattr(self, "gds_elementtree_node_")
                and self.gds_elementtree_node_ is not None
            ):
                return " near line {}".format(self.gds_elementtree_node_.sourceline)
            else:
                return ""

    def getSubclassFromModule_(module, class_):
        """Get the subclass of a class from a specific module."""
        name = class_.__name__ + "Sub"
        if hasattr(module, name):
            return getattr(module, name)
        else:
            return None


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = ""
# Set this to false in order to deactivate during export, the use of
# name space prefixes captured from the input document.
UseCapturedNS_ = True
CapturedNsmap_ = {}
Tag_pattern_ = re_.compile(r"({.*})?(.*)")
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r"{(.*)}(.*)")
CDATA_pattern_ = re_.compile(r"<!\[CDATA\[.*?\]\]>", re_.DOTALL)

# Change this to redirect the generated superclass module to use a
# specific subclass module.
CurrentSubclassModule_ = None

#
# Support/utility functions.
#


def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write("    ")


def quote_xml(inStr):
    "Escape markup chars, but do not modify CDATA sections."
    if not inStr:
        return ""
    s1 = isinstance(inStr, BaseStrType_) and inStr or "%s" % inStr
    s2 = ""
    pos = 0
    matchobjects = CDATA_pattern_.finditer(s1)
    for mo in matchobjects:
        s3 = s1[pos : mo.start()]
        s2 += quote_xml_aux(s3)
        s2 += s1[mo.start() : mo.end()]
        pos = mo.end()
    s3 = s1[pos:]
    s2 += quote_xml_aux(s3)
    return s2


def quote_xml_aux(inStr):
    s1 = inStr.replace("&", "&amp;")
    s1 = s1.replace("<", "&lt;")
    s1 = s1.replace(">", "&gt;")
    return s1


def quote_attrib(inStr):
    s1 = isinstance(inStr, BaseStrType_) and inStr or "%s" % inStr
    s1 = s1.replace("&", "&amp;")
    s1 = s1.replace("<", "&lt;")
    s1 = s1.replace(">", "&gt;")
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1


def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find("\n") == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find("\n") == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1


def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ""
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text


def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(":")
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        if prefix == "xml":
            namespace = "http://www.w3.org/XML/1998/namespace"
        else:
            namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get(
                "{%s}%s"
                % (
                    namespace,
                    name,
                )
            )
    return value


def encode_str_2_3(instr):
    return instr


class GDSParseError(Exception):
    pass


def raise_parse_error(node, msg):
    if node is not None:
        msg = "%s (element %s/line %d)" % (
            msg,
            node.tag,
            node.sourceline,
        )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8

    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value

    def getCategory(self):
        return self.category

    def getContenttype(self, content_type):
        return self.content_type

    def getValue(self):
        return self.value

    def getName(self):
        return self.name

    def export(self, outfile, level, name, namespace, pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:  # category == MixedContainer.CategoryComplex
            self.value.export(
                outfile, level, namespace, name_=name, pretty_print=pretty_print
            )

    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write("<%s>%s</%s>" % (self.name, self.value, self.name))
        elif (
            self.content_type == MixedContainer.TypeInteger
            or self.content_type == MixedContainer.TypeBoolean
        ):
            outfile.write("<%s>%d</%s>" % (self.name, self.value, self.name))
        elif (
            self.content_type == MixedContainer.TypeFloat
            or self.content_type == MixedContainer.TypeDecimal
        ):
            outfile.write("<%s>%f</%s>" % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write("<%s>%g</%s>" % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write(
                "<%s>%s</%s>" % (self.name, base64.b64encode(self.value), self.name)
            )

    def to_etree(self, element, mapping_=None, reverse_mapping_=None, nsmap_=None):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                if len(element) > 0:
                    if element[-1].tail is None:
                        element[-1].tail = self.value
                    else:
                        element[-1].tail += self.value
                else:
                    if element.text is None:
                        element.text = self.value
                    else:
                        element.text += self.value
        elif self.category == MixedContainer.CategorySimple:
            subelement = etree_.SubElement(element, "%s" % self.name)
            subelement.text = self.to_etree_simple()
        else:  # category == MixedContainer.CategoryComplex
            self.value.to_etree(element)

    def to_etree_simple(self, mapping_=None, reverse_mapping_=None, nsmap_=None):
        if self.content_type == MixedContainer.TypeString:
            text = self.value
        elif (
            self.content_type == MixedContainer.TypeInteger
            or self.content_type == MixedContainer.TypeBoolean
        ):
            text = "%d" % self.value
        elif (
            self.content_type == MixedContainer.TypeFloat
            or self.content_type == MixedContainer.TypeDecimal
        ):
            text = "%f" % self.value
        elif self.content_type == MixedContainer.TypeDouble:
            text = "%g" % self.value
        elif self.content_type == MixedContainer.TypeBase64:
            text = "%s" % base64.b64encode(self.value)
        return text

    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n'
                % (self.category, self.content_type, self.name, self.value)
            )
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n'
                % (self.category, self.content_type, self.name, self.value)
            )
        else:  # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s",\n'
                % (
                    self.category,
                    self.content_type,
                    self.name,
                )
            )
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(")\n")


class MemberSpec_(object):
    def __init__(
        self,
        name="",
        data_type="",
        container=0,
        optional=0,
        child_attrs=None,
        choice=None,
    ):
        self.name = name
        self.data_type = data_type
        self.container = container
        self.child_attrs = child_attrs
        self.choice = choice
        self.optional = optional

    def set_name(self, name):
        self.name = name

    def get_name(self):
        return self.name

    def set_data_type(self, data_type):
        self.data_type = data_type

    def get_data_type_chain(self):
        return self.data_type

    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return "xs:string"
        else:
            return self.data_type

    def set_container(self, container):
        self.container = container

    def get_container(self):
        return self.container

    def set_child_attrs(self, child_attrs):
        self.child_attrs = child_attrs

    def get_child_attrs(self):
        return self.child_attrs

    def set_choice(self, choice):
        self.choice = choice

    def get_choice(self):
        return self.choice

    def set_optional(self, optional):
        self.optional = optional

    def get_optional(self):
        return self.optional


def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)


#
# Data representation classes.
#


class getVersion(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, getVersion)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getVersion.subclass:
            return getVersion.subclass(*args_, **kwargs_)
        else:
            return getVersion(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def _hasContent(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="getVersion",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("getVersion")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "getVersion":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="getVersion"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="getVersion",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="getVersion"
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="getVersion",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        pass


# end class getVersion


class getVersionResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, getVersionResult=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.getVersionResult = getVersionResult
        self.getVersionResult_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, getVersionResponse
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getVersionResponse.subclass:
            return getVersionResponse.subclass(*args_, **kwargs_)
        else:
            return getVersionResponse(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_getVersionResult(self):
        return self.getVersionResult

    def set_getVersionResult(self, getVersionResult):
        self.getVersionResult = getVersionResult

    def _hasContent(self):
        if self.getVersionResult is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="getVersionResponse",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("getVersionResponse")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "getVersionResponse":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="getVersionResponse",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="getVersionResponse",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="getVersionResponse",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="getVersionResponse",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.getVersionResult is not None:
            namespaceprefix_ = (
                self.getVersionResult_nsprefix_ + ":"
                if (UseCapturedNS_ and self.getVersionResult_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sgetVersionResult>%s</%sgetVersionResult>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.getVersionResult),
                            input_name="getVersionResult",
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "getVersionResult":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "getVersionResult")
            value_ = self.gds_validate_string(value_, node, "getVersionResult")
            self.getVersionResult = value_
            self.getVersionResult_nsprefix_ = child_.prefix


# end class getVersionResponse


class AuthData(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, username=None, password=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.username = username
        self.username_nsprefix_ = None
        self.password = password
        self.password_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, AuthData)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AuthData.subclass:
            return AuthData.subclass(*args_, **kwargs_)
        else:
            return AuthData(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_username(self):
        return self.username

    def set_username(self, username):
        self.username = username

    def get_password(self):
        return self.password

    def set_password(self, password):
        self.password = password

    def _hasContent(self):
        if self.username is not None or self.password is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="AuthData",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("AuthData")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "AuthData":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="AuthData"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="AuthData",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="AuthData"
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="AuthData",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.username is not None:
            namespaceprefix_ = (
                self.username_nsprefix_ + ":"
                if (UseCapturedNS_ and self.username_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%susername>%s</%susername>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.username), input_name="username"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.password is not None:
            namespaceprefix_ = (
                self.password_nsprefix_ + ":"
                if (UseCapturedNS_ and self.password_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%spassword>%s</%spassword>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.password), input_name="password"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "username":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "username")
            value_ = self.gds_validate_string(value_, node, "username")
            self.username = value_
            self.username_nsprefix_ = child_.prefix
        elif nodeName_ == "password":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "password")
            value_ = self.gds_validate_string(value_, node, "password")
            self.password = value_
            self.password_nsprefix_ = child_.prefix


# end class AuthData


class AddressData(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(
        self,
        name=None,
        postalCode=None,
        city=None,
        street=None,
        houseNumber=None,
        apartmentNumber=None,
        contactPerson=None,
        contactPhone=None,
        contactEmail=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.name = name
        self.name_nsprefix_ = None
        self.postalCode = postalCode
        self.postalCode_nsprefix_ = None
        self.city = city
        self.city_nsprefix_ = None
        self.street = street
        self.street_nsprefix_ = None
        self.houseNumber = houseNumber
        self.houseNumber_nsprefix_ = None
        self.apartmentNumber = apartmentNumber
        self.apartmentNumber_nsprefix_ = None
        self.contactPerson = contactPerson
        self.contactPerson_nsprefix_ = None
        self.contactPhone = contactPhone
        self.contactPhone_nsprefix_ = None
        self.contactEmail = contactEmail
        self.contactEmail_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, AddressData)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AddressData.subclass:
            return AddressData.subclass(*args_, **kwargs_)
        else:
            return AddressData(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_name(self):
        return self.name

    def set_name(self, name):
        self.name = name

    def get_postalCode(self):
        return self.postalCode

    def set_postalCode(self, postalCode):
        self.postalCode = postalCode

    def get_city(self):
        return self.city

    def set_city(self, city):
        self.city = city

    def get_street(self):
        return self.street

    def set_street(self, street):
        self.street = street

    def get_houseNumber(self):
        return self.houseNumber

    def set_houseNumber(self, houseNumber):
        self.houseNumber = houseNumber

    def get_apartmentNumber(self):
        return self.apartmentNumber

    def set_apartmentNumber(self, apartmentNumber):
        self.apartmentNumber = apartmentNumber

    def get_contactPerson(self):
        return self.contactPerson

    def set_contactPerson(self, contactPerson):
        self.contactPerson = contactPerson

    def get_contactPhone(self):
        return self.contactPhone

    def set_contactPhone(self, contactPhone):
        self.contactPhone = contactPhone

    def get_contactEmail(self):
        return self.contactEmail

    def set_contactEmail(self, contactEmail):
        self.contactEmail = contactEmail

    def _hasContent(self):
        if (
            self.name is not None
            or self.postalCode is not None
            or self.city is not None
            or self.street is not None
            or self.houseNumber is not None
            or self.apartmentNumber is not None
            or self.contactPerson is not None
            or self.contactPhone is not None
            or self.contactEmail is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="AddressData",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("AddressData")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "AddressData":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="AddressData"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="AddressData",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="AddressData",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="AddressData",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.name is not None:
            namespaceprefix_ = (
                self.name_nsprefix_ + ":"
                if (UseCapturedNS_ and self.name_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sname>%s</%sname>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(quote_xml(self.name), input_name="name")
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.postalCode is not None:
            namespaceprefix_ = (
                self.postalCode_nsprefix_ + ":"
                if (UseCapturedNS_ and self.postalCode_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%spostalCode>%s</%spostalCode>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.postalCode), input_name="postalCode"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.city is not None:
            namespaceprefix_ = (
                self.city_nsprefix_ + ":"
                if (UseCapturedNS_ and self.city_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%scity>%s</%scity>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(quote_xml(self.city), input_name="city")
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.street is not None:
            namespaceprefix_ = (
                self.street_nsprefix_ + ":"
                if (UseCapturedNS_ and self.street_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sstreet>%s</%sstreet>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.street), input_name="street"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.houseNumber is not None:
            namespaceprefix_ = (
                self.houseNumber_nsprefix_ + ":"
                if (UseCapturedNS_ and self.houseNumber_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%shouseNumber>%s</%shouseNumber>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.houseNumber), input_name="houseNumber"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.apartmentNumber is not None:
            namespaceprefix_ = (
                self.apartmentNumber_nsprefix_ + ":"
                if (UseCapturedNS_ and self.apartmentNumber_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sapartmentNumber>%s</%sapartmentNumber>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.apartmentNumber),
                            input_name="apartmentNumber",
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.contactPerson is not None:
            namespaceprefix_ = (
                self.contactPerson_nsprefix_ + ":"
                if (UseCapturedNS_ and self.contactPerson_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%scontactPerson>%s</%scontactPerson>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.contactPerson), input_name="contactPerson"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.contactPhone is not None:
            namespaceprefix_ = (
                self.contactPhone_nsprefix_ + ":"
                if (UseCapturedNS_ and self.contactPhone_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%scontactPhone>%s</%scontactPhone>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.contactPhone), input_name="contactPhone"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.contactEmail is not None:
            namespaceprefix_ = (
                self.contactEmail_nsprefix_ + ":"
                if (UseCapturedNS_ and self.contactEmail_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%scontactEmail>%s</%scontactEmail>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.contactEmail), input_name="contactEmail"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "name":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "name")
            value_ = self.gds_validate_string(value_, node, "name")
            self.name = value_
            self.name_nsprefix_ = child_.prefix
        elif nodeName_ == "postalCode":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "postalCode")
            value_ = self.gds_validate_string(value_, node, "postalCode")
            self.postalCode = value_
            self.postalCode_nsprefix_ = child_.prefix
        elif nodeName_ == "city":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "city")
            value_ = self.gds_validate_string(value_, node, "city")
            self.city = value_
            self.city_nsprefix_ = child_.prefix
        elif nodeName_ == "street":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "street")
            value_ = self.gds_validate_string(value_, node, "street")
            self.street = value_
            self.street_nsprefix_ = child_.prefix
        elif nodeName_ == "houseNumber":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "houseNumber")
            value_ = self.gds_validate_string(value_, node, "houseNumber")
            self.houseNumber = value_
            self.houseNumber_nsprefix_ = child_.prefix
        elif nodeName_ == "apartmentNumber":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "apartmentNumber")
            value_ = self.gds_validate_string(value_, node, "apartmentNumber")
            self.apartmentNumber = value_
            self.apartmentNumber_nsprefix_ = child_.prefix
        elif nodeName_ == "contactPerson":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "contactPerson")
            value_ = self.gds_validate_string(value_, node, "contactPerson")
            self.contactPerson = value_
            self.contactPerson_nsprefix_ = child_.prefix
        elif nodeName_ == "contactPhone":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "contactPhone")
            value_ = self.gds_validate_string(value_, node, "contactPhone")
            self.contactPhone = value_
            self.contactPhone_nsprefix_ = child_.prefix
        elif nodeName_ == "contactEmail":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "contactEmail")
            value_ = self.gds_validate_string(value_, node, "contactEmail")
            self.contactEmail = value_
            self.contactEmail_nsprefix_ = child_.prefix


# end class AddressData


class ReceiverAddressData(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(
        self,
        country=None,
        isPackstation=None,
        isPostfiliale=None,
        postnummer=None,
        addressType=None,
        name=None,
        postalCode=None,
        city=None,
        street=None,
        houseNumber=None,
        apartmentNumber=None,
        contactPerson=None,
        contactPhone=None,
        contactEmail=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.country = country
        self.country_nsprefix_ = None
        self.isPackstation = isPackstation
        self.isPackstation_nsprefix_ = None
        self.isPostfiliale = isPostfiliale
        self.isPostfiliale_nsprefix_ = None
        self.postnummer = postnummer
        self.postnummer_nsprefix_ = None
        self.addressType = addressType
        self.addressType_nsprefix_ = None
        self.name = name
        self.name_nsprefix_ = None
        self.postalCode = postalCode
        self.postalCode_nsprefix_ = None
        self.city = city
        self.city_nsprefix_ = None
        self.street = street
        self.street_nsprefix_ = None
        self.houseNumber = houseNumber
        self.houseNumber_nsprefix_ = None
        self.apartmentNumber = apartmentNumber
        self.apartmentNumber_nsprefix_ = None
        self.contactPerson = contactPerson
        self.contactPerson_nsprefix_ = None
        self.contactPhone = contactPhone
        self.contactPhone_nsprefix_ = None
        self.contactEmail = contactEmail
        self.contactEmail_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ReceiverAddressData
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ReceiverAddressData.subclass:
            return ReceiverAddressData.subclass(*args_, **kwargs_)
        else:
            return ReceiverAddressData(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_country(self):
        return self.country

    def set_country(self, country):
        self.country = country

    def get_isPackstation(self):
        return self.isPackstation

    def set_isPackstation(self, isPackstation):
        self.isPackstation = isPackstation

    def get_isPostfiliale(self):
        return self.isPostfiliale

    def set_isPostfiliale(self, isPostfiliale):
        self.isPostfiliale = isPostfiliale

    def get_postnummer(self):
        return self.postnummer

    def set_postnummer(self, postnummer):
        self.postnummer = postnummer

    def get_addressType(self):
        return self.addressType

    def set_addressType(self, addressType):
        self.addressType = addressType

    def get_name(self):
        return self.name

    def set_name(self, name):
        self.name = name

    def get_postalCode(self):
        return self.postalCode

    def set_postalCode(self, postalCode):
        self.postalCode = postalCode

    def get_city(self):
        return self.city

    def set_city(self, city):
        self.city = city

    def get_street(self):
        return self.street

    def set_street(self, street):
        self.street = street

    def get_houseNumber(self):
        return self.houseNumber

    def set_houseNumber(self, houseNumber):
        self.houseNumber = houseNumber

    def get_apartmentNumber(self):
        return self.apartmentNumber

    def set_apartmentNumber(self, apartmentNumber):
        self.apartmentNumber = apartmentNumber

    def get_contactPerson(self):
        return self.contactPerson

    def set_contactPerson(self, contactPerson):
        self.contactPerson = contactPerson

    def get_contactPhone(self):
        return self.contactPhone

    def set_contactPhone(self, contactPhone):
        self.contactPhone = contactPhone

    def get_contactEmail(self):
        return self.contactEmail

    def set_contactEmail(self, contactEmail):
        self.contactEmail = contactEmail

    def _hasContent(self):
        if (
            self.country is not None
            or self.isPackstation is not None
            or self.isPostfiliale is not None
            or self.postnummer is not None
            or self.addressType is not None
            or self.name is not None
            or self.postalCode is not None
            or self.city is not None
            or self.street is not None
            or self.houseNumber is not None
            or self.apartmentNumber is not None
            or self.contactPerson is not None
            or self.contactPhone is not None
            or self.contactEmail is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ReceiverAddressData",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ReceiverAddressData")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "ReceiverAddressData":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="ReceiverAddressData",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ReceiverAddressData",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="ReceiverAddressData",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ReceiverAddressData",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.country is not None:
            namespaceprefix_ = (
                self.country_nsprefix_ + ":"
                if (UseCapturedNS_ and self.country_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%scountry>%s</%scountry>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.country), input_name="country"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.isPackstation is not None:
            namespaceprefix_ = (
                self.isPackstation_nsprefix_ + ":"
                if (UseCapturedNS_ and self.isPackstation_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sisPackstation>%s</%sisPackstation>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_boolean(
                        self.isPackstation, input_name="isPackstation"
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.isPostfiliale is not None:
            namespaceprefix_ = (
                self.isPostfiliale_nsprefix_ + ":"
                if (UseCapturedNS_ and self.isPostfiliale_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sisPostfiliale>%s</%sisPostfiliale>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_boolean(
                        self.isPostfiliale, input_name="isPostfiliale"
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.postnummer is not None:
            namespaceprefix_ = (
                self.postnummer_nsprefix_ + ":"
                if (UseCapturedNS_ and self.postnummer_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%spostnummer>%s</%spostnummer>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.postnummer), input_name="postnummer"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.addressType is not None:
            namespaceprefix_ = (
                self.addressType_nsprefix_ + ":"
                if (UseCapturedNS_ and self.addressType_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%saddressType>%s</%saddressType>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.addressType), input_name="addressType"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.name is not None:
            namespaceprefix_ = (
                self.name_nsprefix_ + ":"
                if (UseCapturedNS_ and self.name_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sname>%s</%sname>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(quote_xml(self.name), input_name="name")
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.postalCode is not None:
            namespaceprefix_ = (
                self.postalCode_nsprefix_ + ":"
                if (UseCapturedNS_ and self.postalCode_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%spostalCode>%s</%spostalCode>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.postalCode), input_name="postalCode"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.city is not None:
            namespaceprefix_ = (
                self.city_nsprefix_ + ":"
                if (UseCapturedNS_ and self.city_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%scity>%s</%scity>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(quote_xml(self.city), input_name="city")
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.street is not None:
            namespaceprefix_ = (
                self.street_nsprefix_ + ":"
                if (UseCapturedNS_ and self.street_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sstreet>%s</%sstreet>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.street), input_name="street"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.houseNumber is not None:
            namespaceprefix_ = (
                self.houseNumber_nsprefix_ + ":"
                if (UseCapturedNS_ and self.houseNumber_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%shouseNumber>%s</%shouseNumber>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.houseNumber), input_name="houseNumber"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.apartmentNumber is not None:
            namespaceprefix_ = (
                self.apartmentNumber_nsprefix_ + ":"
                if (UseCapturedNS_ and self.apartmentNumber_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sapartmentNumber>%s</%sapartmentNumber>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.apartmentNumber),
                            input_name="apartmentNumber",
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.contactPerson is not None:
            namespaceprefix_ = (
                self.contactPerson_nsprefix_ + ":"
                if (UseCapturedNS_ and self.contactPerson_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%scontactPerson>%s</%scontactPerson>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.contactPerson), input_name="contactPerson"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.contactPhone is not None:
            namespaceprefix_ = (
                self.contactPhone_nsprefix_ + ":"
                if (UseCapturedNS_ and self.contactPhone_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%scontactPhone>%s</%scontactPhone>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.contactPhone), input_name="contactPhone"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.contactEmail is not None:
            namespaceprefix_ = (
                self.contactEmail_nsprefix_ + ":"
                if (UseCapturedNS_ and self.contactEmail_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%scontactEmail>%s</%scontactEmail>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.contactEmail), input_name="contactEmail"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "country":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "country")
            value_ = self.gds_validate_string(value_, node, "country")
            self.country = value_
            self.country_nsprefix_ = child_.prefix
        elif nodeName_ == "isPackstation":
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, "isPackstation")
            ival_ = self.gds_validate_boolean(ival_, node, "isPackstation")
            self.isPackstation = ival_
            self.isPackstation_nsprefix_ = child_.prefix
        elif nodeName_ == "isPostfiliale":
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, "isPostfiliale")
            ival_ = self.gds_validate_boolean(ival_, node, "isPostfiliale")
            self.isPostfiliale = ival_
            self.isPostfiliale_nsprefix_ = child_.prefix
        elif nodeName_ == "postnummer":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "postnummer")
            value_ = self.gds_validate_string(value_, node, "postnummer")
            self.postnummer = value_
            self.postnummer_nsprefix_ = child_.prefix
        elif nodeName_ == "addressType":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "addressType")
            value_ = self.gds_validate_string(value_, node, "addressType")
            self.addressType = value_
            self.addressType_nsprefix_ = child_.prefix
        elif nodeName_ == "name":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "name")
            value_ = self.gds_validate_string(value_, node, "name")
            self.name = value_
            self.name_nsprefix_ = child_.prefix
        elif nodeName_ == "postalCode":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "postalCode")
            value_ = self.gds_validate_string(value_, node, "postalCode")
            self.postalCode = value_
            self.postalCode_nsprefix_ = child_.prefix
        elif nodeName_ == "city":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "city")
            value_ = self.gds_validate_string(value_, node, "city")
            self.city = value_
            self.city_nsprefix_ = child_.prefix
        elif nodeName_ == "street":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "street")
            value_ = self.gds_validate_string(value_, node, "street")
            self.street = value_
            self.street_nsprefix_ = child_.prefix
        elif nodeName_ == "houseNumber":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "houseNumber")
            value_ = self.gds_validate_string(value_, node, "houseNumber")
            self.houseNumber = value_
            self.houseNumber_nsprefix_ = child_.prefix
        elif nodeName_ == "apartmentNumber":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "apartmentNumber")
            value_ = self.gds_validate_string(value_, node, "apartmentNumber")
            self.apartmentNumber = value_
            self.apartmentNumber_nsprefix_ = child_.prefix
        elif nodeName_ == "contactPerson":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "contactPerson")
            value_ = self.gds_validate_string(value_, node, "contactPerson")
            self.contactPerson = value_
            self.contactPerson_nsprefix_ = child_.prefix
        elif nodeName_ == "contactPhone":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "contactPhone")
            value_ = self.gds_validate_string(value_, node, "contactPhone")
            self.contactPhone = value_
            self.contactPhone_nsprefix_ = child_.prefix
        elif nodeName_ == "contactEmail":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "contactEmail")
            value_ = self.gds_validate_string(value_, node, "contactEmail")
            self.contactEmail = value_
            self.contactEmail_nsprefix_ = child_.prefix


# end class ReceiverAddressData


class NeighbourAddress(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(
        self,
        name=None,
        postalCode=None,
        city=None,
        street=None,
        houseNumber=None,
        apartmentNumber=None,
        contactPhone=None,
        contactEmail=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.name = name
        self.name_nsprefix_ = None
        self.postalCode = postalCode
        self.postalCode_nsprefix_ = None
        self.city = city
        self.city_nsprefix_ = None
        self.street = street
        self.street_nsprefix_ = None
        self.houseNumber = houseNumber
        self.houseNumber_nsprefix_ = None
        self.apartmentNumber = apartmentNumber
        self.apartmentNumber_nsprefix_ = None
        self.contactPhone = contactPhone
        self.contactPhone_nsprefix_ = None
        self.contactEmail = contactEmail
        self.contactEmail_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, NeighbourAddress)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if NeighbourAddress.subclass:
            return NeighbourAddress.subclass(*args_, **kwargs_)
        else:
            return NeighbourAddress(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_name(self):
        return self.name

    def set_name(self, name):
        self.name = name

    def get_postalCode(self):
        return self.postalCode

    def set_postalCode(self, postalCode):
        self.postalCode = postalCode

    def get_city(self):
        return self.city

    def set_city(self, city):
        self.city = city

    def get_street(self):
        return self.street

    def set_street(self, street):
        self.street = street

    def get_houseNumber(self):
        return self.houseNumber

    def set_houseNumber(self, houseNumber):
        self.houseNumber = houseNumber

    def get_apartmentNumber(self):
        return self.apartmentNumber

    def set_apartmentNumber(self, apartmentNumber):
        self.apartmentNumber = apartmentNumber

    def get_contactPhone(self):
        return self.contactPhone

    def set_contactPhone(self, contactPhone):
        self.contactPhone = contactPhone

    def get_contactEmail(self):
        return self.contactEmail

    def set_contactEmail(self, contactEmail):
        self.contactEmail = contactEmail

    def _hasContent(self):
        if (
            self.name is not None
            or self.postalCode is not None
            or self.city is not None
            or self.street is not None
            or self.houseNumber is not None
            or self.apartmentNumber is not None
            or self.contactPhone is not None
            or self.contactEmail is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="NeighbourAddress",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("NeighbourAddress")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "NeighbourAddress":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="NeighbourAddress",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="NeighbourAddress",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="NeighbourAddress",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="NeighbourAddress",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.name is not None:
            namespaceprefix_ = (
                self.name_nsprefix_ + ":"
                if (UseCapturedNS_ and self.name_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sname>%s</%sname>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(quote_xml(self.name), input_name="name")
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.postalCode is not None:
            namespaceprefix_ = (
                self.postalCode_nsprefix_ + ":"
                if (UseCapturedNS_ and self.postalCode_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%spostalCode>%s</%spostalCode>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.postalCode), input_name="postalCode"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.city is not None:
            namespaceprefix_ = (
                self.city_nsprefix_ + ":"
                if (UseCapturedNS_ and self.city_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%scity>%s</%scity>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(quote_xml(self.city), input_name="city")
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.street is not None:
            namespaceprefix_ = (
                self.street_nsprefix_ + ":"
                if (UseCapturedNS_ and self.street_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sstreet>%s</%sstreet>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.street), input_name="street"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.houseNumber is not None:
            namespaceprefix_ = (
                self.houseNumber_nsprefix_ + ":"
                if (UseCapturedNS_ and self.houseNumber_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%shouseNumber>%s</%shouseNumber>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.houseNumber), input_name="houseNumber"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.apartmentNumber is not None:
            namespaceprefix_ = (
                self.apartmentNumber_nsprefix_ + ":"
                if (UseCapturedNS_ and self.apartmentNumber_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sapartmentNumber>%s</%sapartmentNumber>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.apartmentNumber),
                            input_name="apartmentNumber",
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.contactPhone is not None:
            namespaceprefix_ = (
                self.contactPhone_nsprefix_ + ":"
                if (UseCapturedNS_ and self.contactPhone_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%scontactPhone>%s</%scontactPhone>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.contactPhone), input_name="contactPhone"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.contactEmail is not None:
            namespaceprefix_ = (
                self.contactEmail_nsprefix_ + ":"
                if (UseCapturedNS_ and self.contactEmail_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%scontactEmail>%s</%scontactEmail>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.contactEmail), input_name="contactEmail"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "name":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "name")
            value_ = self.gds_validate_string(value_, node, "name")
            self.name = value_
            self.name_nsprefix_ = child_.prefix
        elif nodeName_ == "postalCode":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "postalCode")
            value_ = self.gds_validate_string(value_, node, "postalCode")
            self.postalCode = value_
            self.postalCode_nsprefix_ = child_.prefix
        elif nodeName_ == "city":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "city")
            value_ = self.gds_validate_string(value_, node, "city")
            self.city = value_
            self.city_nsprefix_ = child_.prefix
        elif nodeName_ == "street":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "street")
            value_ = self.gds_validate_string(value_, node, "street")
            self.street = value_
            self.street_nsprefix_ = child_.prefix
        elif nodeName_ == "houseNumber":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "houseNumber")
            value_ = self.gds_validate_string(value_, node, "houseNumber")
            self.houseNumber = value_
            self.houseNumber_nsprefix_ = child_.prefix
        elif nodeName_ == "apartmentNumber":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "apartmentNumber")
            value_ = self.gds_validate_string(value_, node, "apartmentNumber")
            self.apartmentNumber = value_
            self.apartmentNumber_nsprefix_ = child_.prefix
        elif nodeName_ == "contactPhone":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "contactPhone")
            value_ = self.gds_validate_string(value_, node, "contactPhone")
            self.contactPhone = value_
            self.contactPhone_nsprefix_ = child_.prefix
        elif nodeName_ == "contactEmail":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "contactEmail")
            value_ = self.gds_validate_string(value_, node, "contactEmail")
            self.contactEmail = value_
            self.contactEmail_nsprefix_ = child_.prefix


# end class NeighbourAddress


class PieceDefinition(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(
        self,
        type_=None,
        width=None,
        height=None,
        length=None,
        weight=None,
        quantity=None,
        nonStandard=None,
        blpPieceId=None,
        euroReturn=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.type_ = type_
        self.type__nsprefix_ = None
        self.width = width
        self.width_nsprefix_ = None
        self.height = height
        self.height_nsprefix_ = None
        self.length = length
        self.length_nsprefix_ = None
        self.weight = weight
        self.weight_nsprefix_ = None
        self.quantity = quantity
        self.quantity_nsprefix_ = None
        self.nonStandard = nonStandard
        self.nonStandard_nsprefix_ = None
        self.blpPieceId = blpPieceId
        self.blpPieceId_nsprefix_ = None
        self.euroReturn = euroReturn
        self.euroReturn_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, PieceDefinition)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PieceDefinition.subclass:
            return PieceDefinition.subclass(*args_, **kwargs_)
        else:
            return PieceDefinition(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_type(self):
        return self.type_

    def set_type(self, type_):
        self.type_ = type_

    def get_width(self):
        return self.width

    def set_width(self, width):
        self.width = width

    def get_height(self):
        return self.height

    def set_height(self, height):
        self.height = height

    def get_length(self):
        return self.length

    def set_length(self, length):
        self.length = length

    def get_weight(self):
        return self.weight

    def set_weight(self, weight):
        self.weight = weight

    def get_quantity(self):
        return self.quantity

    def set_quantity(self, quantity):
        self.quantity = quantity

    def get_nonStandard(self):
        return self.nonStandard

    def set_nonStandard(self, nonStandard):
        self.nonStandard = nonStandard

    def get_blpPieceId(self):
        return self.blpPieceId

    def set_blpPieceId(self, blpPieceId):
        self.blpPieceId = blpPieceId

    def get_euroReturn(self):
        return self.euroReturn

    def set_euroReturn(self, euroReturn):
        self.euroReturn = euroReturn

    def _hasContent(self):
        if (
            self.type_ is not None
            or self.width is not None
            or self.height is not None
            or self.length is not None
            or self.weight is not None
            or self.quantity is not None
            or self.nonStandard is not None
            or self.blpPieceId is not None
            or self.euroReturn is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="PieceDefinition",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("PieceDefinition")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "PieceDefinition":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="PieceDefinition"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="PieceDefinition",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="PieceDefinition",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="PieceDefinition",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.type_ is not None:
            namespaceprefix_ = (
                self.type__nsprefix_ + ":"
                if (UseCapturedNS_ and self.type__nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%stype>%s</%stype>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(quote_xml(self.type_), input_name="type")
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.width is not None:
            namespaceprefix_ = (
                self.width_nsprefix_ + ":"
                if (UseCapturedNS_ and self.width_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%swidth>%s</%swidth>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_integer(self.width, input_name="width"),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.height is not None:
            namespaceprefix_ = (
                self.height_nsprefix_ + ":"
                if (UseCapturedNS_ and self.height_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sheight>%s</%sheight>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_integer(self.height, input_name="height"),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.length is not None:
            namespaceprefix_ = (
                self.length_nsprefix_ + ":"
                if (UseCapturedNS_ and self.length_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%slength>%s</%slength>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_integer(self.length, input_name="length"),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.weight is not None:
            namespaceprefix_ = (
                self.weight_nsprefix_ + ":"
                if (UseCapturedNS_ and self.weight_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sweight>%s</%sweight>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_float(self.weight, input_name="weight"),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.quantity is not None:
            namespaceprefix_ = (
                self.quantity_nsprefix_ + ":"
                if (UseCapturedNS_ and self.quantity_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%squantity>%s</%squantity>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_integer(self.quantity, input_name="quantity"),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.nonStandard is not None:
            namespaceprefix_ = (
                self.nonStandard_nsprefix_ + ":"
                if (UseCapturedNS_ and self.nonStandard_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%snonStandard>%s</%snonStandard>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_boolean(self.nonStandard, input_name="nonStandard"),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.blpPieceId is not None:
            namespaceprefix_ = (
                self.blpPieceId_nsprefix_ + ":"
                if (UseCapturedNS_ and self.blpPieceId_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sblpPieceId>%s</%sblpPieceId>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.blpPieceId), input_name="blpPieceId"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.euroReturn is not None:
            namespaceprefix_ = (
                self.euroReturn_nsprefix_ + ":"
                if (UseCapturedNS_ and self.euroReturn_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%seuroReturn>%s</%seuroReturn>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_boolean(self.euroReturn, input_name="euroReturn"),
                    namespaceprefix_,
                    eol_,
                )
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "type":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "type")
            value_ = self.gds_validate_string(value_, node, "type")
            self.type_ = value_
            self.type_nsprefix_ = child_.prefix
        elif nodeName_ == "width" and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, "width")
            ival_ = self.gds_validate_integer(ival_, node, "width")
            self.width = ival_
            self.width_nsprefix_ = child_.prefix
        elif nodeName_ == "height" and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, "height")
            ival_ = self.gds_validate_integer(ival_, node, "height")
            self.height = ival_
            self.height_nsprefix_ = child_.prefix
        elif nodeName_ == "length" and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, "length")
            ival_ = self.gds_validate_integer(ival_, node, "length")
            self.length = ival_
            self.length_nsprefix_ = child_.prefix
        elif nodeName_ == "weight" and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, "weight")
            fval_ = self.gds_validate_float(fval_, node, "weight")
            self.weight = fval_
            self.weight_nsprefix_ = child_.prefix
        elif nodeName_ == "quantity" and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, "quantity")
            ival_ = self.gds_validate_integer(ival_, node, "quantity")
            self.quantity = ival_
            self.quantity_nsprefix_ = child_.prefix
        elif nodeName_ == "nonStandard":
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, "nonStandard")
            ival_ = self.gds_validate_boolean(ival_, node, "nonStandard")
            self.nonStandard = ival_
            self.nonStandard_nsprefix_ = child_.prefix
        elif nodeName_ == "blpPieceId":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "blpPieceId")
            value_ = self.gds_validate_string(value_, node, "blpPieceId")
            self.blpPieceId = value_
            self.blpPieceId_nsprefix_ = child_.prefix
        elif nodeName_ == "euroReturn":
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, "euroReturn")
            ival_ = self.gds_validate_boolean(ival_, node, "euroReturn")
            self.euroReturn = ival_
            self.euroReturn_nsprefix_ = child_.prefix


# end class PieceDefinition


class ArrayOfPiecedefinition(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, item=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        if item is None:
            self.item = []
        else:
            self.item = item
        self.item_nsprefix_ = "tns"

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ArrayOfPiecedefinition
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ArrayOfPiecedefinition.subclass:
            return ArrayOfPiecedefinition.subclass(*args_, **kwargs_)
        else:
            return ArrayOfPiecedefinition(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_item(self):
        return self.item

    def set_item(self, item):
        self.item = item

    def add_item(self, value):
        self.item.append(value)

    def insert_item_at(self, index, value):
        self.item.insert(index, value)

    def replace_item_at(self, index, value):
        self.item[index] = value

    def _hasContent(self):
        if self.item:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ArrayOfPiecedefinition",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ArrayOfPiecedefinition")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "ArrayOfPiecedefinition":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="ArrayOfPiecedefinition",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ArrayOfPiecedefinition",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="ArrayOfPiecedefinition",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ArrayOfPiecedefinition",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for item_ in self.item:
            namespaceprefix_ = (
                self.item_nsprefix_ + ":"
                if (UseCapturedNS_ and self.item_nsprefix_)
                else ""
            )
            item_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="item",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "item":
            obj_ = PieceDefinition.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.item.append(obj_)
            obj_.original_tagname_ = "item"


# end class ArrayOfPiecedefinition


class PaymentData(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(
        self,
        paymentMethod=None,
        payerType=None,
        accountNumber=None,
        costsCenter=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.paymentMethod = paymentMethod
        self.paymentMethod_nsprefix_ = None
        self.payerType = payerType
        self.payerType_nsprefix_ = None
        self.accountNumber = accountNumber
        self.accountNumber_nsprefix_ = None
        self.costsCenter = costsCenter
        self.costsCenter_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, PaymentData)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PaymentData.subclass:
            return PaymentData.subclass(*args_, **kwargs_)
        else:
            return PaymentData(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_paymentMethod(self):
        return self.paymentMethod

    def set_paymentMethod(self, paymentMethod):
        self.paymentMethod = paymentMethod

    def get_payerType(self):
        return self.payerType

    def set_payerType(self, payerType):
        self.payerType = payerType

    def get_accountNumber(self):
        return self.accountNumber

    def set_accountNumber(self, accountNumber):
        self.accountNumber = accountNumber

    def get_costsCenter(self):
        return self.costsCenter

    def set_costsCenter(self, costsCenter):
        self.costsCenter = costsCenter

    def _hasContent(self):
        if (
            self.paymentMethod is not None
            or self.payerType is not None
            or self.accountNumber is not None
            or self.costsCenter is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="PaymentData",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("PaymentData")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "PaymentData":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="PaymentData"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="PaymentData",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="PaymentData",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="PaymentData",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.paymentMethod is not None:
            namespaceprefix_ = (
                self.paymentMethod_nsprefix_ + ":"
                if (UseCapturedNS_ and self.paymentMethod_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%spaymentMethod>%s</%spaymentMethod>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.paymentMethod), input_name="paymentMethod"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.payerType is not None:
            namespaceprefix_ = (
                self.payerType_nsprefix_ + ":"
                if (UseCapturedNS_ and self.payerType_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%spayerType>%s</%spayerType>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.payerType), input_name="payerType"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.accountNumber is not None:
            namespaceprefix_ = (
                self.accountNumber_nsprefix_ + ":"
                if (UseCapturedNS_ and self.accountNumber_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%saccountNumber>%s</%saccountNumber>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.accountNumber), input_name="accountNumber"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.costsCenter is not None:
            namespaceprefix_ = (
                self.costsCenter_nsprefix_ + ":"
                if (UseCapturedNS_ and self.costsCenter_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%scostsCenter>%s</%scostsCenter>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.costsCenter), input_name="costsCenter"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "paymentMethod":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "paymentMethod")
            value_ = self.gds_validate_string(value_, node, "paymentMethod")
            self.paymentMethod = value_
            self.paymentMethod_nsprefix_ = child_.prefix
        elif nodeName_ == "payerType":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "payerType")
            value_ = self.gds_validate_string(value_, node, "payerType")
            self.payerType = value_
            self.payerType_nsprefix_ = child_.prefix
        elif nodeName_ == "accountNumber":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "accountNumber")
            value_ = self.gds_validate_string(value_, node, "accountNumber")
            self.accountNumber = value_
            self.accountNumber_nsprefix_ = child_.prefix
        elif nodeName_ == "costsCenter":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "costsCenter")
            value_ = self.gds_validate_string(value_, node, "costsCenter")
            self.costsCenter = value_
            self.costsCenter_nsprefix_ = child_.prefix


# end class PaymentData


class ServiceDefinition(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(
        self,
        product=None,
        deliveryEvening=None,
        deliveryOnSaturday=None,
        pickupOnSaturday=None,
        collectOnDelivery=None,
        collectOnDeliveryValue=None,
        collectOnDeliveryForm=None,
        collectOnDeliveryReference=None,
        insurance=None,
        insuranceValue=None,
        returnOnDelivery=None,
        returnOnDeliveryReference=None,
        proofOfDelivery=None,
        selfCollect=None,
        predeliveryInformation=None,
        deliveryToNeighbour=None,
        preaviso=None,
        additionalService=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.product = product
        self.product_nsprefix_ = None
        self.deliveryEvening = deliveryEvening
        self.deliveryEvening_nsprefix_ = None
        self.deliveryOnSaturday = deliveryOnSaturday
        self.deliveryOnSaturday_nsprefix_ = None
        self.pickupOnSaturday = pickupOnSaturday
        self.pickupOnSaturday_nsprefix_ = None
        self.collectOnDelivery = collectOnDelivery
        self.collectOnDelivery_nsprefix_ = None
        self.collectOnDeliveryValue = collectOnDeliveryValue
        self.collectOnDeliveryValue_nsprefix_ = None
        self.collectOnDeliveryForm = collectOnDeliveryForm
        self.collectOnDeliveryForm_nsprefix_ = None
        self.collectOnDeliveryReference = collectOnDeliveryReference
        self.collectOnDeliveryReference_nsprefix_ = None
        self.insurance = insurance
        self.insurance_nsprefix_ = None
        self.insuranceValue = insuranceValue
        self.insuranceValue_nsprefix_ = None
        self.returnOnDelivery = returnOnDelivery
        self.returnOnDelivery_nsprefix_ = None
        self.returnOnDeliveryReference = returnOnDeliveryReference
        self.returnOnDeliveryReference_nsprefix_ = None
        self.proofOfDelivery = proofOfDelivery
        self.proofOfDelivery_nsprefix_ = None
        self.selfCollect = selfCollect
        self.selfCollect_nsprefix_ = None
        self.predeliveryInformation = predeliveryInformation
        self.predeliveryInformation_nsprefix_ = None
        self.deliveryToNeighbour = deliveryToNeighbour
        self.deliveryToNeighbour_nsprefix_ = None
        self.preaviso = preaviso
        self.preaviso_nsprefix_ = None
        self.additionalService = additionalService
        self.additionalService_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, ServiceDefinition)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ServiceDefinition.subclass:
            return ServiceDefinition.subclass(*args_, **kwargs_)
        else:
            return ServiceDefinition(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_product(self):
        return self.product

    def set_product(self, product):
        self.product = product

    def get_deliveryEvening(self):
        return self.deliveryEvening

    def set_deliveryEvening(self, deliveryEvening):
        self.deliveryEvening = deliveryEvening

    def get_deliveryOnSaturday(self):
        return self.deliveryOnSaturday

    def set_deliveryOnSaturday(self, deliveryOnSaturday):
        self.deliveryOnSaturday = deliveryOnSaturday

    def get_pickupOnSaturday(self):
        return self.pickupOnSaturday

    def set_pickupOnSaturday(self, pickupOnSaturday):
        self.pickupOnSaturday = pickupOnSaturday

    def get_collectOnDelivery(self):
        return self.collectOnDelivery

    def set_collectOnDelivery(self, collectOnDelivery):
        self.collectOnDelivery = collectOnDelivery

    def get_collectOnDeliveryValue(self):
        return self.collectOnDeliveryValue

    def set_collectOnDeliveryValue(self, collectOnDeliveryValue):
        self.collectOnDeliveryValue = collectOnDeliveryValue

    def get_collectOnDeliveryForm(self):
        return self.collectOnDeliveryForm

    def set_collectOnDeliveryForm(self, collectOnDeliveryForm):
        self.collectOnDeliveryForm = collectOnDeliveryForm

    def get_collectOnDeliveryReference(self):
        return self.collectOnDeliveryReference

    def set_collectOnDeliveryReference(self, collectOnDeliveryReference):
        self.collectOnDeliveryReference = collectOnDeliveryReference

    def get_insurance(self):
        return self.insurance

    def set_insurance(self, insurance):
        self.insurance = insurance

    def get_insuranceValue(self):
        return self.insuranceValue

    def set_insuranceValue(self, insuranceValue):
        self.insuranceValue = insuranceValue

    def get_returnOnDelivery(self):
        return self.returnOnDelivery

    def set_returnOnDelivery(self, returnOnDelivery):
        self.returnOnDelivery = returnOnDelivery

    def get_returnOnDeliveryReference(self):
        return self.returnOnDeliveryReference

    def set_returnOnDeliveryReference(self, returnOnDeliveryReference):
        self.returnOnDeliveryReference = returnOnDeliveryReference

    def get_proofOfDelivery(self):
        return self.proofOfDelivery

    def set_proofOfDelivery(self, proofOfDelivery):
        self.proofOfDelivery = proofOfDelivery

    def get_selfCollect(self):
        return self.selfCollect

    def set_selfCollect(self, selfCollect):
        self.selfCollect = selfCollect

    def get_predeliveryInformation(self):
        return self.predeliveryInformation

    def set_predeliveryInformation(self, predeliveryInformation):
        self.predeliveryInformation = predeliveryInformation

    def get_deliveryToNeighbour(self):
        return self.deliveryToNeighbour

    def set_deliveryToNeighbour(self, deliveryToNeighbour):
        self.deliveryToNeighbour = deliveryToNeighbour

    def get_preaviso(self):
        return self.preaviso

    def set_preaviso(self, preaviso):
        self.preaviso = preaviso

    def get_additionalService(self):
        return self.additionalService

    def set_additionalService(self, additionalService):
        self.additionalService = additionalService

    def _hasContent(self):
        if (
            self.product is not None
            or self.deliveryEvening is not None
            or self.deliveryOnSaturday is not None
            or self.pickupOnSaturday is not None
            or self.collectOnDelivery is not None
            or self.collectOnDeliveryValue is not None
            or self.collectOnDeliveryForm is not None
            or self.collectOnDeliveryReference is not None
            or self.insurance is not None
            or self.insuranceValue is not None
            or self.returnOnDelivery is not None
            or self.returnOnDeliveryReference is not None
            or self.proofOfDelivery is not None
            or self.selfCollect is not None
            or self.predeliveryInformation is not None
            or self.deliveryToNeighbour is not None
            or self.preaviso is not None
            or self.additionalService is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ServiceDefinition",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ServiceDefinition")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "ServiceDefinition":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="ServiceDefinition",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ServiceDefinition",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="ServiceDefinition",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ServiceDefinition",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.product is not None:
            namespaceprefix_ = (
                self.product_nsprefix_ + ":"
                if (UseCapturedNS_ and self.product_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sproduct>%s</%sproduct>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.product), input_name="product"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.deliveryEvening is not None:
            namespaceprefix_ = (
                self.deliveryEvening_nsprefix_ + ":"
                if (UseCapturedNS_ and self.deliveryEvening_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sdeliveryEvening>%s</%sdeliveryEvening>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_boolean(
                        self.deliveryEvening, input_name="deliveryEvening"
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.deliveryOnSaturday is not None:
            namespaceprefix_ = (
                self.deliveryOnSaturday_nsprefix_ + ":"
                if (UseCapturedNS_ and self.deliveryOnSaturday_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sdeliveryOnSaturday>%s</%sdeliveryOnSaturday>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_boolean(
                        self.deliveryOnSaturday, input_name="deliveryOnSaturday"
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.pickupOnSaturday is not None:
            namespaceprefix_ = (
                self.pickupOnSaturday_nsprefix_ + ":"
                if (UseCapturedNS_ and self.pickupOnSaturday_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%spickupOnSaturday>%s</%spickupOnSaturday>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_boolean(
                        self.pickupOnSaturday, input_name="pickupOnSaturday"
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.collectOnDelivery is not None:
            namespaceprefix_ = (
                self.collectOnDelivery_nsprefix_ + ":"
                if (UseCapturedNS_ and self.collectOnDelivery_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%scollectOnDelivery>%s</%scollectOnDelivery>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_boolean(
                        self.collectOnDelivery, input_name="collectOnDelivery"
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.collectOnDeliveryValue is not None:
            namespaceprefix_ = (
                self.collectOnDeliveryValue_nsprefix_ + ":"
                if (UseCapturedNS_ and self.collectOnDeliveryValue_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%scollectOnDeliveryValue>%s</%scollectOnDeliveryValue>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_float(
                        self.collectOnDeliveryValue, input_name="collectOnDeliveryValue"
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.collectOnDeliveryForm is not None:
            namespaceprefix_ = (
                self.collectOnDeliveryForm_nsprefix_ + ":"
                if (UseCapturedNS_ and self.collectOnDeliveryForm_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%scollectOnDeliveryForm>%s</%scollectOnDeliveryForm>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.collectOnDeliveryForm),
                            input_name="collectOnDeliveryForm",
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.collectOnDeliveryReference is not None:
            namespaceprefix_ = (
                self.collectOnDeliveryReference_nsprefix_ + ":"
                if (UseCapturedNS_ and self.collectOnDeliveryReference_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%scollectOnDeliveryReference>%s</%scollectOnDeliveryReference>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.collectOnDeliveryReference),
                            input_name="collectOnDeliveryReference",
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.insurance is not None:
            namespaceprefix_ = (
                self.insurance_nsprefix_ + ":"
                if (UseCapturedNS_ and self.insurance_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sinsurance>%s</%sinsurance>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_boolean(self.insurance, input_name="insurance"),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.insuranceValue is not None:
            namespaceprefix_ = (
                self.insuranceValue_nsprefix_ + ":"
                if (UseCapturedNS_ and self.insuranceValue_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sinsuranceValue>%s</%sinsuranceValue>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_float(
                        self.insuranceValue, input_name="insuranceValue"
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.returnOnDelivery is not None:
            namespaceprefix_ = (
                self.returnOnDelivery_nsprefix_ + ":"
                if (UseCapturedNS_ and self.returnOnDelivery_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sreturnOnDelivery>%s</%sreturnOnDelivery>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_boolean(
                        self.returnOnDelivery, input_name="returnOnDelivery"
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.returnOnDeliveryReference is not None:
            namespaceprefix_ = (
                self.returnOnDeliveryReference_nsprefix_ + ":"
                if (UseCapturedNS_ and self.returnOnDeliveryReference_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sreturnOnDeliveryReference>%s</%sreturnOnDeliveryReference>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.returnOnDeliveryReference),
                            input_name="returnOnDeliveryReference",
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.proofOfDelivery is not None:
            namespaceprefix_ = (
                self.proofOfDelivery_nsprefix_ + ":"
                if (UseCapturedNS_ and self.proofOfDelivery_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sproofOfDelivery>%s</%sproofOfDelivery>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_boolean(
                        self.proofOfDelivery, input_name="proofOfDelivery"
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.selfCollect is not None:
            namespaceprefix_ = (
                self.selfCollect_nsprefix_ + ":"
                if (UseCapturedNS_ and self.selfCollect_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sselfCollect>%s</%sselfCollect>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_boolean(self.selfCollect, input_name="selfCollect"),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.predeliveryInformation is not None:
            namespaceprefix_ = (
                self.predeliveryInformation_nsprefix_ + ":"
                if (UseCapturedNS_ and self.predeliveryInformation_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%spredeliveryInformation>%s</%spredeliveryInformation>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_boolean(
                        self.predeliveryInformation, input_name="predeliveryInformation"
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.deliveryToNeighbour is not None:
            namespaceprefix_ = (
                self.deliveryToNeighbour_nsprefix_ + ":"
                if (UseCapturedNS_ and self.deliveryToNeighbour_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sdeliveryToNeighbour>%s</%sdeliveryToNeighbour>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_boolean(
                        self.deliveryToNeighbour, input_name="deliveryToNeighbour"
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.preaviso is not None:
            namespaceprefix_ = (
                self.preaviso_nsprefix_ + ":"
                if (UseCapturedNS_ and self.preaviso_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%spreaviso>%s</%spreaviso>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_boolean(self.preaviso, input_name="preaviso"),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.additionalService is not None:
            namespaceprefix_ = (
                self.additionalService_nsprefix_ + ":"
                if (UseCapturedNS_ and self.additionalService_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sadditionalService>%s</%sadditionalService>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_boolean(
                        self.additionalService, input_name="additionalService"
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "product":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "product")
            value_ = self.gds_validate_string(value_, node, "product")
            self.product = value_
            self.product_nsprefix_ = child_.prefix
        elif nodeName_ == "deliveryEvening":
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, "deliveryEvening")
            ival_ = self.gds_validate_boolean(ival_, node, "deliveryEvening")
            self.deliveryEvening = ival_
            self.deliveryEvening_nsprefix_ = child_.prefix
        elif nodeName_ == "deliveryOnSaturday":
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, "deliveryOnSaturday")
            ival_ = self.gds_validate_boolean(ival_, node, "deliveryOnSaturday")
            self.deliveryOnSaturday = ival_
            self.deliveryOnSaturday_nsprefix_ = child_.prefix
        elif nodeName_ == "pickupOnSaturday":
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, "pickupOnSaturday")
            ival_ = self.gds_validate_boolean(ival_, node, "pickupOnSaturday")
            self.pickupOnSaturday = ival_
            self.pickupOnSaturday_nsprefix_ = child_.prefix
        elif nodeName_ == "collectOnDelivery":
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, "collectOnDelivery")
            ival_ = self.gds_validate_boolean(ival_, node, "collectOnDelivery")
            self.collectOnDelivery = ival_
            self.collectOnDelivery_nsprefix_ = child_.prefix
        elif nodeName_ == "collectOnDeliveryValue" and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, "collectOnDeliveryValue")
            fval_ = self.gds_validate_float(fval_, node, "collectOnDeliveryValue")
            self.collectOnDeliveryValue = fval_
            self.collectOnDeliveryValue_nsprefix_ = child_.prefix
        elif nodeName_ == "collectOnDeliveryForm":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "collectOnDeliveryForm")
            value_ = self.gds_validate_string(value_, node, "collectOnDeliveryForm")
            self.collectOnDeliveryForm = value_
            self.collectOnDeliveryForm_nsprefix_ = child_.prefix
        elif nodeName_ == "collectOnDeliveryReference":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "collectOnDeliveryReference")
            value_ = self.gds_validate_string(
                value_, node, "collectOnDeliveryReference"
            )
            self.collectOnDeliveryReference = value_
            self.collectOnDeliveryReference_nsprefix_ = child_.prefix
        elif nodeName_ == "insurance":
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, "insurance")
            ival_ = self.gds_validate_boolean(ival_, node, "insurance")
            self.insurance = ival_
            self.insurance_nsprefix_ = child_.prefix
        elif nodeName_ == "insuranceValue" and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, "insuranceValue")
            fval_ = self.gds_validate_float(fval_, node, "insuranceValue")
            self.insuranceValue = fval_
            self.insuranceValue_nsprefix_ = child_.prefix
        elif nodeName_ == "returnOnDelivery":
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, "returnOnDelivery")
            ival_ = self.gds_validate_boolean(ival_, node, "returnOnDelivery")
            self.returnOnDelivery = ival_
            self.returnOnDelivery_nsprefix_ = child_.prefix
        elif nodeName_ == "returnOnDeliveryReference":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "returnOnDeliveryReference")
            value_ = self.gds_validate_string(value_, node, "returnOnDeliveryReference")
            self.returnOnDeliveryReference = value_
            self.returnOnDeliveryReference_nsprefix_ = child_.prefix
        elif nodeName_ == "proofOfDelivery":
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, "proofOfDelivery")
            ival_ = self.gds_validate_boolean(ival_, node, "proofOfDelivery")
            self.proofOfDelivery = ival_
            self.proofOfDelivery_nsprefix_ = child_.prefix
        elif nodeName_ == "selfCollect":
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, "selfCollect")
            ival_ = self.gds_validate_boolean(ival_, node, "selfCollect")
            self.selfCollect = ival_
            self.selfCollect_nsprefix_ = child_.prefix
        elif nodeName_ == "predeliveryInformation":
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, "predeliveryInformation")
            ival_ = self.gds_validate_boolean(ival_, node, "predeliveryInformation")
            self.predeliveryInformation = ival_
            self.predeliveryInformation_nsprefix_ = child_.prefix
        elif nodeName_ == "deliveryToNeighbour":
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, "deliveryToNeighbour")
            ival_ = self.gds_validate_boolean(ival_, node, "deliveryToNeighbour")
            self.deliveryToNeighbour = ival_
            self.deliveryToNeighbour_nsprefix_ = child_.prefix
        elif nodeName_ == "preaviso":
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, "preaviso")
            ival_ = self.gds_validate_boolean(ival_, node, "preaviso")
            self.preaviso = ival_
            self.preaviso_nsprefix_ = child_.prefix
        elif nodeName_ == "additionalService":
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, "additionalService")
            ival_ = self.gds_validate_boolean(ival_, node, "additionalService")
            self.additionalService = ival_
            self.additionalService_nsprefix_ = child_.prefix


# end class ServiceDefinition


class CustomsItemData(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(
        self,
        nameEn=None,
        namePl=None,
        quantity=None,
        weight=None,
        value=None,
        tariffCode=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.nameEn = nameEn
        self.nameEn_nsprefix_ = None
        self.namePl = namePl
        self.namePl_nsprefix_ = None
        self.quantity = quantity
        self.quantity_nsprefix_ = None
        self.weight = weight
        self.weight_nsprefix_ = None
        self.value = value
        self.value_nsprefix_ = None
        self.tariffCode = tariffCode
        self.tariffCode_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, CustomsItemData)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CustomsItemData.subclass:
            return CustomsItemData.subclass(*args_, **kwargs_)
        else:
            return CustomsItemData(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_nameEn(self):
        return self.nameEn

    def set_nameEn(self, nameEn):
        self.nameEn = nameEn

    def get_namePl(self):
        return self.namePl

    def set_namePl(self, namePl):
        self.namePl = namePl

    def get_quantity(self):
        return self.quantity

    def set_quantity(self, quantity):
        self.quantity = quantity

    def get_weight(self):
        return self.weight

    def set_weight(self, weight):
        self.weight = weight

    def get_value(self):
        return self.value

    def set_value(self, value):
        self.value = value

    def get_tariffCode(self):
        return self.tariffCode

    def set_tariffCode(self, tariffCode):
        self.tariffCode = tariffCode

    def _hasContent(self):
        if (
            self.nameEn is not None
            or self.namePl is not None
            or self.quantity is not None
            or self.weight is not None
            or self.value is not None
            or self.tariffCode is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="CustomsItemData",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("CustomsItemData")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "CustomsItemData":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="CustomsItemData"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="CustomsItemData",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="CustomsItemData",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="CustomsItemData",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.nameEn is not None:
            namespaceprefix_ = (
                self.nameEn_nsprefix_ + ":"
                if (UseCapturedNS_ and self.nameEn_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%snameEn>%s</%snameEn>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.nameEn), input_name="nameEn"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.namePl is not None:
            namespaceprefix_ = (
                self.namePl_nsprefix_ + ":"
                if (UseCapturedNS_ and self.namePl_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%snamePl>%s</%snamePl>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.namePl), input_name="namePl"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.quantity is not None:
            namespaceprefix_ = (
                self.quantity_nsprefix_ + ":"
                if (UseCapturedNS_ and self.quantity_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%squantity>%s</%squantity>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.quantity), input_name="quantity"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.weight is not None:
            namespaceprefix_ = (
                self.weight_nsprefix_ + ":"
                if (UseCapturedNS_ and self.weight_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sweight>%s</%sweight>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.weight), input_name="weight"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.value is not None:
            namespaceprefix_ = (
                self.value_nsprefix_ + ":"
                if (UseCapturedNS_ and self.value_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%svalue>%s</%svalue>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.value), input_name="value"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.tariffCode is not None:
            namespaceprefix_ = (
                self.tariffCode_nsprefix_ + ":"
                if (UseCapturedNS_ and self.tariffCode_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%stariffCode>%s</%stariffCode>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.tariffCode), input_name="tariffCode"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "nameEn":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "nameEn")
            value_ = self.gds_validate_string(value_, node, "nameEn")
            self.nameEn = value_
            self.nameEn_nsprefix_ = child_.prefix
        elif nodeName_ == "namePl":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "namePl")
            value_ = self.gds_validate_string(value_, node, "namePl")
            self.namePl = value_
            self.namePl_nsprefix_ = child_.prefix
        elif nodeName_ == "quantity":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "quantity")
            value_ = self.gds_validate_string(value_, node, "quantity")
            self.quantity = value_
            self.quantity_nsprefix_ = child_.prefix
        elif nodeName_ == "weight":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "weight")
            value_ = self.gds_validate_string(value_, node, "weight")
            self.weight = value_
            self.weight_nsprefix_ = child_.prefix
        elif nodeName_ == "value":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "value")
            value_ = self.gds_validate_string(value_, node, "value")
            self.value = value_
            self.value_nsprefix_ = child_.prefix
        elif nodeName_ == "tariffCode":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "tariffCode")
            value_ = self.gds_validate_string(value_, node, "tariffCode")
            self.tariffCode = value_
            self.tariffCode_nsprefix_ = child_.prefix


# end class CustomsItemData


class ArrayOfCustomsitemdata(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, item=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        if item is None:
            self.item = []
        else:
            self.item = item
        self.item_nsprefix_ = "tns"

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ArrayOfCustomsitemdata
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ArrayOfCustomsitemdata.subclass:
            return ArrayOfCustomsitemdata.subclass(*args_, **kwargs_)
        else:
            return ArrayOfCustomsitemdata(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_item(self):
        return self.item

    def set_item(self, item):
        self.item = item

    def add_item(self, value):
        self.item.append(value)

    def insert_item_at(self, index, value):
        self.item.insert(index, value)

    def replace_item_at(self, index, value):
        self.item[index] = value

    def _hasContent(self):
        if self.item:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ArrayOfCustomsitemdata",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ArrayOfCustomsitemdata")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "ArrayOfCustomsitemdata":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="ArrayOfCustomsitemdata",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ArrayOfCustomsitemdata",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="ArrayOfCustomsitemdata",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ArrayOfCustomsitemdata",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for item_ in self.item:
            namespaceprefix_ = (
                self.item_nsprefix_ + ":"
                if (UseCapturedNS_ and self.item_nsprefix_)
                else ""
            )
            item_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="item",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "item":
            obj_ = CustomsItemData.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.item.append(obj_)
            obj_.original_tagname_ = "item"


# end class ArrayOfCustomsitemdata


class CustomsAgreementData(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(
        self,
        notExceedValue=None,
        notProhibitedGoods=None,
        notRestrictedGoods=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.notExceedValue = notExceedValue
        self.notExceedValue_nsprefix_ = None
        self.notProhibitedGoods = notProhibitedGoods
        self.notProhibitedGoods_nsprefix_ = None
        self.notRestrictedGoods = notRestrictedGoods
        self.notRestrictedGoods_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CustomsAgreementData
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CustomsAgreementData.subclass:
            return CustomsAgreementData.subclass(*args_, **kwargs_)
        else:
            return CustomsAgreementData(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_notExceedValue(self):
        return self.notExceedValue

    def set_notExceedValue(self, notExceedValue):
        self.notExceedValue = notExceedValue

    def get_notProhibitedGoods(self):
        return self.notProhibitedGoods

    def set_notProhibitedGoods(self, notProhibitedGoods):
        self.notProhibitedGoods = notProhibitedGoods

    def get_notRestrictedGoods(self):
        return self.notRestrictedGoods

    def set_notRestrictedGoods(self, notRestrictedGoods):
        self.notRestrictedGoods = notRestrictedGoods

    def _hasContent(self):
        if (
            self.notExceedValue is not None
            or self.notProhibitedGoods is not None
            or self.notRestrictedGoods is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="CustomsAgreementData",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("CustomsAgreementData")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "CustomsAgreementData":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="CustomsAgreementData",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="CustomsAgreementData",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="CustomsAgreementData",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="CustomsAgreementData",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.notExceedValue is not None:
            namespaceprefix_ = (
                self.notExceedValue_nsprefix_ + ":"
                if (UseCapturedNS_ and self.notExceedValue_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%snotExceedValue>%s</%snotExceedValue>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_boolean(
                        self.notExceedValue, input_name="notExceedValue"
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.notProhibitedGoods is not None:
            namespaceprefix_ = (
                self.notProhibitedGoods_nsprefix_ + ":"
                if (UseCapturedNS_ and self.notProhibitedGoods_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%snotProhibitedGoods>%s</%snotProhibitedGoods>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_boolean(
                        self.notProhibitedGoods, input_name="notProhibitedGoods"
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.notRestrictedGoods is not None:
            namespaceprefix_ = (
                self.notRestrictedGoods_nsprefix_ + ":"
                if (UseCapturedNS_ and self.notRestrictedGoods_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%snotRestrictedGoods>%s</%snotRestrictedGoods>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_boolean(
                        self.notRestrictedGoods, input_name="notRestrictedGoods"
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "notExceedValue":
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, "notExceedValue")
            ival_ = self.gds_validate_boolean(ival_, node, "notExceedValue")
            self.notExceedValue = ival_
            self.notExceedValue_nsprefix_ = child_.prefix
        elif nodeName_ == "notProhibitedGoods":
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, "notProhibitedGoods")
            ival_ = self.gds_validate_boolean(ival_, node, "notProhibitedGoods")
            self.notProhibitedGoods = ival_
            self.notProhibitedGoods_nsprefix_ = child_.prefix
        elif nodeName_ == "notRestrictedGoods":
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, "notRestrictedGoods")
            ival_ = self.gds_validate_boolean(ival_, node, "notRestrictedGoods")
            self.notRestrictedGoods = ival_
            self.notRestrictedGoods_nsprefix_ = child_.prefix


# end class CustomsAgreementData


class CustomsData(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(
        self,
        customsType=None,
        firstName=None,
        secondaryName=None,
        costsOfShipment=None,
        currency=None,
        nipNr=None,
        eoriNr=None,
        vatRegistrationNumber=None,
        categoryOfItem=None,
        invoiceNr=None,
        invoice=None,
        invoiceDate=None,
        countryOfOrigin=None,
        additionalInfo=None,
        grossWeight=None,
        customsItem=None,
        customAgreements=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.customsType = customsType
        self.customsType_nsprefix_ = None
        self.firstName = firstName
        self.firstName_nsprefix_ = None
        self.secondaryName = secondaryName
        self.secondaryName_nsprefix_ = None
        self.costsOfShipment = costsOfShipment
        self.costsOfShipment_nsprefix_ = None
        self.currency = currency
        self.currency_nsprefix_ = None
        self.nipNr = nipNr
        self.nipNr_nsprefix_ = None
        self.eoriNr = eoriNr
        self.eoriNr_nsprefix_ = None
        self.vatRegistrationNumber = vatRegistrationNumber
        self.vatRegistrationNumber_nsprefix_ = None
        self.categoryOfItem = categoryOfItem
        self.categoryOfItem_nsprefix_ = None
        self.invoiceNr = invoiceNr
        self.invoiceNr_nsprefix_ = None
        self.invoice = invoice
        self.invoice_nsprefix_ = None
        self.invoiceDate = invoiceDate
        self.invoiceDate_nsprefix_ = None
        self.countryOfOrigin = countryOfOrigin
        self.countryOfOrigin_nsprefix_ = None
        self.additionalInfo = additionalInfo
        self.additionalInfo_nsprefix_ = None
        self.grossWeight = grossWeight
        self.grossWeight_nsprefix_ = None
        self.customsItem = customsItem
        self.customsItem_nsprefix_ = "tns"
        self.customAgreements = customAgreements
        self.customAgreements_nsprefix_ = "tns"

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, CustomsData)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CustomsData.subclass:
            return CustomsData.subclass(*args_, **kwargs_)
        else:
            return CustomsData(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_customsType(self):
        return self.customsType

    def set_customsType(self, customsType):
        self.customsType = customsType

    def get_firstName(self):
        return self.firstName

    def set_firstName(self, firstName):
        self.firstName = firstName

    def get_secondaryName(self):
        return self.secondaryName

    def set_secondaryName(self, secondaryName):
        self.secondaryName = secondaryName

    def get_costsOfShipment(self):
        return self.costsOfShipment

    def set_costsOfShipment(self, costsOfShipment):
        self.costsOfShipment = costsOfShipment

    def get_currency(self):
        return self.currency

    def set_currency(self, currency):
        self.currency = currency

    def get_nipNr(self):
        return self.nipNr

    def set_nipNr(self, nipNr):
        self.nipNr = nipNr

    def get_eoriNr(self):
        return self.eoriNr

    def set_eoriNr(self, eoriNr):
        self.eoriNr = eoriNr

    def get_vatRegistrationNumber(self):
        return self.vatRegistrationNumber

    def set_vatRegistrationNumber(self, vatRegistrationNumber):
        self.vatRegistrationNumber = vatRegistrationNumber

    def get_categoryOfItem(self):
        return self.categoryOfItem

    def set_categoryOfItem(self, categoryOfItem):
        self.categoryOfItem = categoryOfItem

    def get_invoiceNr(self):
        return self.invoiceNr

    def set_invoiceNr(self, invoiceNr):
        self.invoiceNr = invoiceNr

    def get_invoice(self):
        return self.invoice

    def set_invoice(self, invoice):
        self.invoice = invoice

    def get_invoiceDate(self):
        return self.invoiceDate

    def set_invoiceDate(self, invoiceDate):
        self.invoiceDate = invoiceDate

    def get_countryOfOrigin(self):
        return self.countryOfOrigin

    def set_countryOfOrigin(self, countryOfOrigin):
        self.countryOfOrigin = countryOfOrigin

    def get_additionalInfo(self):
        return self.additionalInfo

    def set_additionalInfo(self, additionalInfo):
        self.additionalInfo = additionalInfo

    def get_grossWeight(self):
        return self.grossWeight

    def set_grossWeight(self, grossWeight):
        self.grossWeight = grossWeight

    def get_customsItem(self):
        return self.customsItem

    def set_customsItem(self, customsItem):
        self.customsItem = customsItem

    def get_customAgreements(self):
        return self.customAgreements

    def set_customAgreements(self, customAgreements):
        self.customAgreements = customAgreements

    def _hasContent(self):
        if (
            self.customsType is not None
            or self.firstName is not None
            or self.secondaryName is not None
            or self.costsOfShipment is not None
            or self.currency is not None
            or self.nipNr is not None
            or self.eoriNr is not None
            or self.vatRegistrationNumber is not None
            or self.categoryOfItem is not None
            or self.invoiceNr is not None
            or self.invoice is not None
            or self.invoiceDate is not None
            or self.countryOfOrigin is not None
            or self.additionalInfo is not None
            or self.grossWeight is not None
            or self.customsItem is not None
            or self.customAgreements is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="CustomsData",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("CustomsData")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "CustomsData":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="CustomsData"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="CustomsData",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="CustomsData",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="CustomsData",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.customsType is not None:
            namespaceprefix_ = (
                self.customsType_nsprefix_ + ":"
                if (UseCapturedNS_ and self.customsType_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%scustomsType>%s</%scustomsType>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.customsType), input_name="customsType"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.firstName is not None:
            namespaceprefix_ = (
                self.firstName_nsprefix_ + ":"
                if (UseCapturedNS_ and self.firstName_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sfirstName>%s</%sfirstName>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.firstName), input_name="firstName"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.secondaryName is not None:
            namespaceprefix_ = (
                self.secondaryName_nsprefix_ + ":"
                if (UseCapturedNS_ and self.secondaryName_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%ssecondaryName>%s</%ssecondaryName>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.secondaryName), input_name="secondaryName"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.costsOfShipment is not None:
            namespaceprefix_ = (
                self.costsOfShipment_nsprefix_ + ":"
                if (UseCapturedNS_ and self.costsOfShipment_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%scostsOfShipment>%s</%scostsOfShipment>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.costsOfShipment),
                            input_name="costsOfShipment",
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.currency is not None:
            namespaceprefix_ = (
                self.currency_nsprefix_ + ":"
                if (UseCapturedNS_ and self.currency_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%scurrency>%s</%scurrency>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.currency), input_name="currency"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.nipNr is not None:
            namespaceprefix_ = (
                self.nipNr_nsprefix_ + ":"
                if (UseCapturedNS_ and self.nipNr_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%snipNr>%s</%snipNr>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.nipNr), input_name="nipNr"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.eoriNr is not None:
            namespaceprefix_ = (
                self.eoriNr_nsprefix_ + ":"
                if (UseCapturedNS_ and self.eoriNr_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%seoriNr>%s</%seoriNr>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.eoriNr), input_name="eoriNr"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.vatRegistrationNumber is not None:
            namespaceprefix_ = (
                self.vatRegistrationNumber_nsprefix_ + ":"
                if (UseCapturedNS_ and self.vatRegistrationNumber_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%svatRegistrationNumber>%s</%svatRegistrationNumber>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.vatRegistrationNumber),
                            input_name="vatRegistrationNumber",
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.categoryOfItem is not None:
            namespaceprefix_ = (
                self.categoryOfItem_nsprefix_ + ":"
                if (UseCapturedNS_ and self.categoryOfItem_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%scategoryOfItem>%s</%scategoryOfItem>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.categoryOfItem), input_name="categoryOfItem"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.invoiceNr is not None:
            namespaceprefix_ = (
                self.invoiceNr_nsprefix_ + ":"
                if (UseCapturedNS_ and self.invoiceNr_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sinvoiceNr>%s</%sinvoiceNr>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.invoiceNr), input_name="invoiceNr"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.invoice is not None:
            namespaceprefix_ = (
                self.invoice_nsprefix_ + ":"
                if (UseCapturedNS_ and self.invoice_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sinvoice>%s</%sinvoice>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.invoice), input_name="invoice"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.invoiceDate is not None:
            namespaceprefix_ = (
                self.invoiceDate_nsprefix_ + ":"
                if (UseCapturedNS_ and self.invoiceDate_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sinvoiceDate>%s</%sinvoiceDate>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.invoiceDate), input_name="invoiceDate"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.countryOfOrigin is not None:
            namespaceprefix_ = (
                self.countryOfOrigin_nsprefix_ + ":"
                if (UseCapturedNS_ and self.countryOfOrigin_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%scountryOfOrigin>%s</%scountryOfOrigin>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.countryOfOrigin),
                            input_name="countryOfOrigin",
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.additionalInfo is not None:
            namespaceprefix_ = (
                self.additionalInfo_nsprefix_ + ":"
                if (UseCapturedNS_ and self.additionalInfo_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sadditionalInfo>%s</%sadditionalInfo>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.additionalInfo), input_name="additionalInfo"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.grossWeight is not None:
            namespaceprefix_ = (
                self.grossWeight_nsprefix_ + ":"
                if (UseCapturedNS_ and self.grossWeight_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sgrossWeight>%s</%sgrossWeight>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.grossWeight), input_name="grossWeight"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.customsItem is not None:
            namespaceprefix_ = (
                self.customsItem_nsprefix_ + ":"
                if (UseCapturedNS_ and self.customsItem_nsprefix_)
                else ""
            )
            self.customsItem.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="customsItem",
                pretty_print=pretty_print,
            )
        if self.customAgreements is not None:
            namespaceprefix_ = (
                self.customAgreements_nsprefix_ + ":"
                if (UseCapturedNS_ and self.customAgreements_nsprefix_)
                else ""
            )
            self.customAgreements.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="customAgreements",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "customsType":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "customsType")
            value_ = self.gds_validate_string(value_, node, "customsType")
            self.customsType = value_
            self.customsType_nsprefix_ = child_.prefix
        elif nodeName_ == "firstName":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "firstName")
            value_ = self.gds_validate_string(value_, node, "firstName")
            self.firstName = value_
            self.firstName_nsprefix_ = child_.prefix
        elif nodeName_ == "secondaryName":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "secondaryName")
            value_ = self.gds_validate_string(value_, node, "secondaryName")
            self.secondaryName = value_
            self.secondaryName_nsprefix_ = child_.prefix
        elif nodeName_ == "costsOfShipment":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "costsOfShipment")
            value_ = self.gds_validate_string(value_, node, "costsOfShipment")
            self.costsOfShipment = value_
            self.costsOfShipment_nsprefix_ = child_.prefix
        elif nodeName_ == "currency":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "currency")
            value_ = self.gds_validate_string(value_, node, "currency")
            self.currency = value_
            self.currency_nsprefix_ = child_.prefix
        elif nodeName_ == "nipNr":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "nipNr")
            value_ = self.gds_validate_string(value_, node, "nipNr")
            self.nipNr = value_
            self.nipNr_nsprefix_ = child_.prefix
        elif nodeName_ == "eoriNr":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "eoriNr")
            value_ = self.gds_validate_string(value_, node, "eoriNr")
            self.eoriNr = value_
            self.eoriNr_nsprefix_ = child_.prefix
        elif nodeName_ == "vatRegistrationNumber":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "vatRegistrationNumber")
            value_ = self.gds_validate_string(value_, node, "vatRegistrationNumber")
            self.vatRegistrationNumber = value_
            self.vatRegistrationNumber_nsprefix_ = child_.prefix
        elif nodeName_ == "categoryOfItem":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "categoryOfItem")
            value_ = self.gds_validate_string(value_, node, "categoryOfItem")
            self.categoryOfItem = value_
            self.categoryOfItem_nsprefix_ = child_.prefix
        elif nodeName_ == "invoiceNr":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "invoiceNr")
            value_ = self.gds_validate_string(value_, node, "invoiceNr")
            self.invoiceNr = value_
            self.invoiceNr_nsprefix_ = child_.prefix
        elif nodeName_ == "invoice":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "invoice")
            value_ = self.gds_validate_string(value_, node, "invoice")
            self.invoice = value_
            self.invoice_nsprefix_ = child_.prefix
        elif nodeName_ == "invoiceDate":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "invoiceDate")
            value_ = self.gds_validate_string(value_, node, "invoiceDate")
            self.invoiceDate = value_
            self.invoiceDate_nsprefix_ = child_.prefix
        elif nodeName_ == "countryOfOrigin":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "countryOfOrigin")
            value_ = self.gds_validate_string(value_, node, "countryOfOrigin")
            self.countryOfOrigin = value_
            self.countryOfOrigin_nsprefix_ = child_.prefix
        elif nodeName_ == "additionalInfo":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "additionalInfo")
            value_ = self.gds_validate_string(value_, node, "additionalInfo")
            self.additionalInfo = value_
            self.additionalInfo_nsprefix_ = child_.prefix
        elif nodeName_ == "grossWeight":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "grossWeight")
            value_ = self.gds_validate_string(value_, node, "grossWeight")
            self.grossWeight = value_
            self.grossWeight_nsprefix_ = child_.prefix
        elif nodeName_ == "customsItem":
            obj_ = ArrayOfCustomsitemdata.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.customsItem = obj_
            obj_.original_tagname_ = "customsItem"
        elif nodeName_ == "customAgreements":
            obj_ = CustomsAgreementData.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.customAgreements = obj_
            obj_.original_tagname_ = "customAgreements"


# end class CustomsData


class ShipmentFullData(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(
        self,
        shipper=None,
        receiver=None,
        neighbour=None,
        pieceList=None,
        payment=None,
        service=None,
        shipmentDate=None,
        skipRestrictionCheck=None,
        comment=None,
        content=None,
        reference=None,
        shipmentId=None,
        created=None,
        orderStatus=None,
        customs=None,
        wayBill=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.shipper = shipper
        self.shipper_nsprefix_ = "tns"
        self.receiver = receiver
        self.receiver_nsprefix_ = "tns"
        self.neighbour = neighbour
        self.neighbour_nsprefix_ = "tns"
        self.pieceList = pieceList
        self.pieceList_nsprefix_ = "tns"
        self.payment = payment
        self.payment_nsprefix_ = "tns"
        self.service = service
        self.service_nsprefix_ = "tns"
        self.shipmentDate = shipmentDate
        self.shipmentDate_nsprefix_ = None
        self.skipRestrictionCheck = skipRestrictionCheck
        self.skipRestrictionCheck_nsprefix_ = None
        self.comment = comment
        self.comment_nsprefix_ = None
        self.content = content
        self.content_nsprefix_ = None
        self.reference = reference
        self.reference_nsprefix_ = None
        self.shipmentId = shipmentId
        self.shipmentId_nsprefix_ = None
        self.created = created
        self.created_nsprefix_ = None
        self.orderStatus = orderStatus
        self.orderStatus_nsprefix_ = None
        self.customs = customs
        self.customs_nsprefix_ = "tns"
        self.wayBill = wayBill
        self.wayBill_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, ShipmentFullData)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ShipmentFullData.subclass:
            return ShipmentFullData.subclass(*args_, **kwargs_)
        else:
            return ShipmentFullData(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_shipper(self):
        return self.shipper

    def set_shipper(self, shipper):
        self.shipper = shipper

    def get_receiver(self):
        return self.receiver

    def set_receiver(self, receiver):
        self.receiver = receiver

    def get_neighbour(self):
        return self.neighbour

    def set_neighbour(self, neighbour):
        self.neighbour = neighbour

    def get_pieceList(self):
        return self.pieceList

    def set_pieceList(self, pieceList):
        self.pieceList = pieceList

    def get_payment(self):
        return self.payment

    def set_payment(self, payment):
        self.payment = payment

    def get_service(self):
        return self.service

    def set_service(self, service):
        self.service = service

    def get_shipmentDate(self):
        return self.shipmentDate

    def set_shipmentDate(self, shipmentDate):
        self.shipmentDate = shipmentDate

    def get_skipRestrictionCheck(self):
        return self.skipRestrictionCheck

    def set_skipRestrictionCheck(self, skipRestrictionCheck):
        self.skipRestrictionCheck = skipRestrictionCheck

    def get_comment(self):
        return self.comment

    def set_comment(self, comment):
        self.comment = comment

    def get_content(self):
        return self.content

    def set_content(self, content):
        self.content = content

    def get_reference(self):
        return self.reference

    def set_reference(self, reference):
        self.reference = reference

    def get_shipmentId(self):
        return self.shipmentId

    def set_shipmentId(self, shipmentId):
        self.shipmentId = shipmentId

    def get_created(self):
        return self.created

    def set_created(self, created):
        self.created = created

    def get_orderStatus(self):
        return self.orderStatus

    def set_orderStatus(self, orderStatus):
        self.orderStatus = orderStatus

    def get_customs(self):
        return self.customs

    def set_customs(self, customs):
        self.customs = customs

    def get_wayBill(self):
        return self.wayBill

    def set_wayBill(self, wayBill):
        self.wayBill = wayBill

    def _hasContent(self):
        if (
            self.shipper is not None
            or self.receiver is not None
            or self.neighbour is not None
            or self.pieceList is not None
            or self.payment is not None
            or self.service is not None
            or self.shipmentDate is not None
            or self.skipRestrictionCheck is not None
            or self.comment is not None
            or self.content is not None
            or self.reference is not None
            or self.shipmentId is not None
            or self.created is not None
            or self.orderStatus is not None
            or self.customs is not None
            or self.wayBill is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ShipmentFullData",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ShipmentFullData")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "ShipmentFullData":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="ShipmentFullData",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ShipmentFullData",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="ShipmentFullData",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ShipmentFullData",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.shipper is not None:
            namespaceprefix_ = (
                self.shipper_nsprefix_ + ":"
                if (UseCapturedNS_ and self.shipper_nsprefix_)
                else ""
            )
            self.shipper.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="shipper",
                pretty_print=pretty_print,
            )
        if self.receiver is not None:
            namespaceprefix_ = (
                self.receiver_nsprefix_ + ":"
                if (UseCapturedNS_ and self.receiver_nsprefix_)
                else ""
            )
            self.receiver.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="receiver",
                pretty_print=pretty_print,
            )
        if self.neighbour is not None:
            namespaceprefix_ = (
                self.neighbour_nsprefix_ + ":"
                if (UseCapturedNS_ and self.neighbour_nsprefix_)
                else ""
            )
            self.neighbour.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="neighbour",
                pretty_print=pretty_print,
            )
        if self.pieceList is not None:
            namespaceprefix_ = (
                self.pieceList_nsprefix_ + ":"
                if (UseCapturedNS_ and self.pieceList_nsprefix_)
                else ""
            )
            self.pieceList.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="pieceList",
                pretty_print=pretty_print,
            )
        if self.payment is not None:
            namespaceprefix_ = (
                self.payment_nsprefix_ + ":"
                if (UseCapturedNS_ and self.payment_nsprefix_)
                else ""
            )
            self.payment.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="payment",
                pretty_print=pretty_print,
            )
        if self.service is not None:
            namespaceprefix_ = (
                self.service_nsprefix_ + ":"
                if (UseCapturedNS_ and self.service_nsprefix_)
                else ""
            )
            self.service.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="service",
                pretty_print=pretty_print,
            )
        if self.shipmentDate is not None:
            namespaceprefix_ = (
                self.shipmentDate_nsprefix_ + ":"
                if (UseCapturedNS_ and self.shipmentDate_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sshipmentDate>%s</%sshipmentDate>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.shipmentDate), input_name="shipmentDate"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.skipRestrictionCheck is not None:
            namespaceprefix_ = (
                self.skipRestrictionCheck_nsprefix_ + ":"
                if (UseCapturedNS_ and self.skipRestrictionCheck_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sskipRestrictionCheck>%s</%sskipRestrictionCheck>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_boolean(
                        self.skipRestrictionCheck, input_name="skipRestrictionCheck"
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.comment is not None:
            namespaceprefix_ = (
                self.comment_nsprefix_ + ":"
                if (UseCapturedNS_ and self.comment_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%scomment>%s</%scomment>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.comment), input_name="comment"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.content is not None:
            namespaceprefix_ = (
                self.content_nsprefix_ + ":"
                if (UseCapturedNS_ and self.content_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%scontent>%s</%scontent>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.content), input_name="content"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.reference is not None:
            namespaceprefix_ = (
                self.reference_nsprefix_ + ":"
                if (UseCapturedNS_ and self.reference_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sreference>%s</%sreference>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.reference), input_name="reference"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.shipmentId is not None:
            namespaceprefix_ = (
                self.shipmentId_nsprefix_ + ":"
                if (UseCapturedNS_ and self.shipmentId_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sshipmentId>%s</%sshipmentId>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_integer(self.shipmentId, input_name="shipmentId"),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.created is not None:
            namespaceprefix_ = (
                self.created_nsprefix_ + ":"
                if (UseCapturedNS_ and self.created_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%screated>%s</%screated>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.created), input_name="created"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.orderStatus is not None:
            namespaceprefix_ = (
                self.orderStatus_nsprefix_ + ":"
                if (UseCapturedNS_ and self.orderStatus_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sorderStatus>%s</%sorderStatus>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.orderStatus), input_name="orderStatus"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.customs is not None:
            namespaceprefix_ = (
                self.customs_nsprefix_ + ":"
                if (UseCapturedNS_ and self.customs_nsprefix_)
                else ""
            )
            self.customs.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="customs",
                pretty_print=pretty_print,
            )
        if self.wayBill is not None:
            namespaceprefix_ = (
                self.wayBill_nsprefix_ + ":"
                if (UseCapturedNS_ and self.wayBill_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%swayBill>%s</%swayBill>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.wayBill), input_name="wayBill"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "shipper":
            obj_ = AddressData.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.shipper = obj_
            obj_.original_tagname_ = "shipper"
        elif nodeName_ == "receiver":
            obj_ = ReceiverAddressData.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.receiver = obj_
            obj_.original_tagname_ = "receiver"
        elif nodeName_ == "neighbour":
            obj_ = NeighbourAddress.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.neighbour = obj_
            obj_.original_tagname_ = "neighbour"
        elif nodeName_ == "pieceList":
            obj_ = ArrayOfPiecedefinition.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.pieceList = obj_
            obj_.original_tagname_ = "pieceList"
        elif nodeName_ == "payment":
            obj_ = PaymentData.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.payment = obj_
            obj_.original_tagname_ = "payment"
        elif nodeName_ == "service":
            obj_ = ServiceDefinition.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.service = obj_
            obj_.original_tagname_ = "service"
        elif nodeName_ == "shipmentDate":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "shipmentDate")
            value_ = self.gds_validate_string(value_, node, "shipmentDate")
            self.shipmentDate = value_
            self.shipmentDate_nsprefix_ = child_.prefix
        elif nodeName_ == "skipRestrictionCheck":
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, "skipRestrictionCheck")
            ival_ = self.gds_validate_boolean(ival_, node, "skipRestrictionCheck")
            self.skipRestrictionCheck = ival_
            self.skipRestrictionCheck_nsprefix_ = child_.prefix
        elif nodeName_ == "comment":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "comment")
            value_ = self.gds_validate_string(value_, node, "comment")
            self.comment = value_
            self.comment_nsprefix_ = child_.prefix
        elif nodeName_ == "content":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "content")
            value_ = self.gds_validate_string(value_, node, "content")
            self.content = value_
            self.content_nsprefix_ = child_.prefix
        elif nodeName_ == "reference":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "reference")
            value_ = self.gds_validate_string(value_, node, "reference")
            self.reference = value_
            self.reference_nsprefix_ = child_.prefix
        elif nodeName_ == "shipmentId" and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, "shipmentId")
            ival_ = self.gds_validate_integer(ival_, node, "shipmentId")
            self.shipmentId = ival_
            self.shipmentId_nsprefix_ = child_.prefix
        elif nodeName_ == "created":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "created")
            value_ = self.gds_validate_string(value_, node, "created")
            self.created = value_
            self.created_nsprefix_ = child_.prefix
        elif nodeName_ == "orderStatus":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "orderStatus")
            value_ = self.gds_validate_string(value_, node, "orderStatus")
            self.orderStatus = value_
            self.orderStatus_nsprefix_ = child_.prefix
        elif nodeName_ == "customs":
            obj_ = CustomsData.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.customs = obj_
            obj_.original_tagname_ = "customs"
        elif nodeName_ == "wayBill":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "wayBill")
            value_ = self.gds_validate_string(value_, node, "wayBill")
            self.wayBill = value_
            self.wayBill_nsprefix_ = child_.prefix


# end class ShipmentFullData


class ArrayOfShipmentfulldata(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, item=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        if item is None:
            self.item = []
        else:
            self.item = item
        self.item_nsprefix_ = "tns"

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ArrayOfShipmentfulldata
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ArrayOfShipmentfulldata.subclass:
            return ArrayOfShipmentfulldata.subclass(*args_, **kwargs_)
        else:
            return ArrayOfShipmentfulldata(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_item(self):
        return self.item

    def set_item(self, item):
        self.item = item

    def add_item(self, value):
        self.item.append(value)

    def insert_item_at(self, index, value):
        self.item.insert(index, value)

    def replace_item_at(self, index, value):
        self.item[index] = value

    def _hasContent(self):
        if self.item:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ArrayOfShipmentfulldata",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ArrayOfShipmentfulldata")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "ArrayOfShipmentfulldata":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="ArrayOfShipmentfulldata",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ArrayOfShipmentfulldata",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="ArrayOfShipmentfulldata",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ArrayOfShipmentfulldata",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for item_ in self.item:
            namespaceprefix_ = (
                self.item_nsprefix_ + ":"
                if (UseCapturedNS_ and self.item_nsprefix_)
                else ""
            )
            item_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="item",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "item":
            obj_ = ShipmentFullData.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.item.append(obj_)
            obj_.original_tagname_ = "item"


# end class ArrayOfShipmentfulldata


class createShipments(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, authData=None, shipments=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.authData = authData
        self.authData_nsprefix_ = "tns"
        self.shipments = shipments
        self.shipments_nsprefix_ = "tns"

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, createShipments)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if createShipments.subclass:
            return createShipments.subclass(*args_, **kwargs_)
        else:
            return createShipments(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_authData(self):
        return self.authData

    def set_authData(self, authData):
        self.authData = authData

    def get_shipments(self):
        return self.shipments

    def set_shipments(self, shipments):
        self.shipments = shipments

    def _hasContent(self):
        if self.authData is not None or self.shipments is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="createShipments",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("createShipments")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "createShipments":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="createShipments"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="createShipments",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="createShipments",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="createShipments",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.authData is not None:
            namespaceprefix_ = (
                self.authData_nsprefix_ + ":"
                if (UseCapturedNS_ and self.authData_nsprefix_)
                else ""
            )
            self.authData.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="authData",
                pretty_print=pretty_print,
            )
        if self.shipments is not None:
            namespaceprefix_ = (
                self.shipments_nsprefix_ + ":"
                if (UseCapturedNS_ and self.shipments_nsprefix_)
                else ""
            )
            self.shipments.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="shipments",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "authData":
            obj_ = AuthData.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.authData = obj_
            obj_.original_tagname_ = "authData"
        elif nodeName_ == "shipments":
            obj_ = ArrayOfShipmentfulldata.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.shipments = obj_
            obj_.original_tagname_ = "shipments"


# end class createShipments


class ShipmentBasicData(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(
        self,
        shipmentId=None,
        created=None,
        shipper=None,
        receiver=None,
        orderStatus=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.shipmentId = shipmentId
        self.shipmentId_nsprefix_ = None
        self.created = created
        self.created_nsprefix_ = None
        self.shipper = shipper
        self.shipper_nsprefix_ = "tns"
        self.receiver = receiver
        self.receiver_nsprefix_ = "tns"
        self.orderStatus = orderStatus
        self.orderStatus_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, ShipmentBasicData)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ShipmentBasicData.subclass:
            return ShipmentBasicData.subclass(*args_, **kwargs_)
        else:
            return ShipmentBasicData(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_shipmentId(self):
        return self.shipmentId

    def set_shipmentId(self, shipmentId):
        self.shipmentId = shipmentId

    def get_created(self):
        return self.created

    def set_created(self, created):
        self.created = created

    def get_shipper(self):
        return self.shipper

    def set_shipper(self, shipper):
        self.shipper = shipper

    def get_receiver(self):
        return self.receiver

    def set_receiver(self, receiver):
        self.receiver = receiver

    def get_orderStatus(self):
        return self.orderStatus

    def set_orderStatus(self, orderStatus):
        self.orderStatus = orderStatus

    def _hasContent(self):
        if (
            self.shipmentId is not None
            or self.created is not None
            or self.shipper is not None
            or self.receiver is not None
            or self.orderStatus is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ShipmentBasicData",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ShipmentBasicData")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "ShipmentBasicData":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="ShipmentBasicData",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ShipmentBasicData",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="ShipmentBasicData",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ShipmentBasicData",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.shipmentId is not None:
            namespaceprefix_ = (
                self.shipmentId_nsprefix_ + ":"
                if (UseCapturedNS_ and self.shipmentId_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sshipmentId>%s</%sshipmentId>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.shipmentId), input_name="shipmentId"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.created is not None:
            namespaceprefix_ = (
                self.created_nsprefix_ + ":"
                if (UseCapturedNS_ and self.created_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%screated>%s</%screated>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.created), input_name="created"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.shipper is not None:
            namespaceprefix_ = (
                self.shipper_nsprefix_ + ":"
                if (UseCapturedNS_ and self.shipper_nsprefix_)
                else ""
            )
            self.shipper.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="shipper",
                pretty_print=pretty_print,
            )
        if self.receiver is not None:
            namespaceprefix_ = (
                self.receiver_nsprefix_ + ":"
                if (UseCapturedNS_ and self.receiver_nsprefix_)
                else ""
            )
            self.receiver.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="receiver",
                pretty_print=pretty_print,
            )
        if self.orderStatus is not None:
            namespaceprefix_ = (
                self.orderStatus_nsprefix_ + ":"
                if (UseCapturedNS_ and self.orderStatus_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sorderStatus>%s</%sorderStatus>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.orderStatus), input_name="orderStatus"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "shipmentId":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "shipmentId")
            value_ = self.gds_validate_string(value_, node, "shipmentId")
            self.shipmentId = value_
            self.shipmentId_nsprefix_ = child_.prefix
        elif nodeName_ == "created":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "created")
            value_ = self.gds_validate_string(value_, node, "created")
            self.created = value_
            self.created_nsprefix_ = child_.prefix
        elif nodeName_ == "shipper":
            obj_ = AddressData.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.shipper = obj_
            obj_.original_tagname_ = "shipper"
        elif nodeName_ == "receiver":
            obj_ = AddressData.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.receiver = obj_
            obj_.original_tagname_ = "receiver"
        elif nodeName_ == "orderStatus":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "orderStatus")
            value_ = self.gds_validate_string(value_, node, "orderStatus")
            self.orderStatus = value_
            self.orderStatus_nsprefix_ = child_.prefix


# end class ShipmentBasicData


class ArrayOfShipmentbasicdata(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, item=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        if item is None:
            self.item = []
        else:
            self.item = item
        self.item_nsprefix_ = "tns"

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ArrayOfShipmentbasicdata
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ArrayOfShipmentbasicdata.subclass:
            return ArrayOfShipmentbasicdata.subclass(*args_, **kwargs_)
        else:
            return ArrayOfShipmentbasicdata(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_item(self):
        return self.item

    def set_item(self, item):
        self.item = item

    def add_item(self, value):
        self.item.append(value)

    def insert_item_at(self, index, value):
        self.item.insert(index, value)

    def replace_item_at(self, index, value):
        self.item[index] = value

    def _hasContent(self):
        if self.item:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ArrayOfShipmentbasicdata",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ArrayOfShipmentbasicdata")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "ArrayOfShipmentbasicdata":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="ArrayOfShipmentbasicdata",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ArrayOfShipmentbasicdata",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="ArrayOfShipmentbasicdata",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ArrayOfShipmentbasicdata",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for item_ in self.item:
            namespaceprefix_ = (
                self.item_nsprefix_ + ":"
                if (UseCapturedNS_ and self.item_nsprefix_)
                else ""
            )
            item_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="item",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "item":
            obj_ = ShipmentBasicData.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.item.append(obj_)
            obj_.original_tagname_ = "item"


# end class ArrayOfShipmentbasicdata


class createShipmentsResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, createShipmentsResult=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.createShipmentsResult = createShipmentsResult
        self.createShipmentsResult_nsprefix_ = "tns"

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, createShipmentsResponse
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if createShipmentsResponse.subclass:
            return createShipmentsResponse.subclass(*args_, **kwargs_)
        else:
            return createShipmentsResponse(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_createShipmentsResult(self):
        return self.createShipmentsResult

    def set_createShipmentsResult(self, createShipmentsResult):
        self.createShipmentsResult = createShipmentsResult

    def _hasContent(self):
        if self.createShipmentsResult is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="createShipmentsResponse",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("createShipmentsResponse")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "createShipmentsResponse":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="createShipmentsResponse",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="createShipmentsResponse",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="createShipmentsResponse",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="createShipmentsResponse",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.createShipmentsResult is not None:
            namespaceprefix_ = (
                self.createShipmentsResult_nsprefix_ + ":"
                if (UseCapturedNS_ and self.createShipmentsResult_nsprefix_)
                else ""
            )
            self.createShipmentsResult.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="createShipmentsResult",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "createShipmentsResult":
            obj_ = ArrayOfShipmentbasicdata.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.createShipmentsResult = obj_
            obj_.original_tagname_ = "createShipmentsResult"


# end class createShipmentsResponse


class ReturnItemToPrint(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(
        self,
        labelType=None,
        shipmentId=None,
        wayBill=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.labelType = labelType
        self.labelType_nsprefix_ = None
        self.shipmentId = shipmentId
        self.shipmentId_nsprefix_ = None
        self.wayBill = wayBill
        self.wayBill_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, ReturnItemToPrint)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ReturnItemToPrint.subclass:
            return ReturnItemToPrint.subclass(*args_, **kwargs_)
        else:
            return ReturnItemToPrint(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_labelType(self):
        return self.labelType

    def set_labelType(self, labelType):
        self.labelType = labelType

    def get_shipmentId(self):
        return self.shipmentId

    def set_shipmentId(self, shipmentId):
        self.shipmentId = shipmentId

    def get_wayBill(self):
        return self.wayBill

    def set_wayBill(self, wayBill):
        self.wayBill = wayBill

    def _hasContent(self):
        if (
            self.labelType is not None
            or self.shipmentId is not None
            or self.wayBill is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ReturnItemToPrint",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ReturnItemToPrint")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "ReturnItemToPrint":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="ReturnItemToPrint",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ReturnItemToPrint",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="ReturnItemToPrint",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ReturnItemToPrint",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.labelType is not None:
            namespaceprefix_ = (
                self.labelType_nsprefix_ + ":"
                if (UseCapturedNS_ and self.labelType_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%slabelType>%s</%slabelType>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.labelType), input_name="labelType"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.shipmentId is not None:
            namespaceprefix_ = (
                self.shipmentId_nsprefix_ + ":"
                if (UseCapturedNS_ and self.shipmentId_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sshipmentId>%s</%sshipmentId>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.shipmentId), input_name="shipmentId"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.wayBill is not None:
            namespaceprefix_ = (
                self.wayBill_nsprefix_ + ":"
                if (UseCapturedNS_ and self.wayBill_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%swayBill>%s</%swayBill>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.wayBill), input_name="wayBill"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "labelType":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "labelType")
            value_ = self.gds_validate_string(value_, node, "labelType")
            self.labelType = value_
            self.labelType_nsprefix_ = child_.prefix
        elif nodeName_ == "shipmentId":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "shipmentId")
            value_ = self.gds_validate_string(value_, node, "shipmentId")
            self.shipmentId = value_
            self.shipmentId_nsprefix_ = child_.prefix
        elif nodeName_ == "wayBill":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "wayBill")
            value_ = self.gds_validate_string(value_, node, "wayBill")
            self.wayBill = value_
            self.wayBill_nsprefix_ = child_.prefix


# end class ReturnItemToPrint


class ArrayOfReturnitemtoprint(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, item=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        if item is None:
            self.item = []
        else:
            self.item = item
        self.item_nsprefix_ = "tns"

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ArrayOfReturnitemtoprint
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ArrayOfReturnitemtoprint.subclass:
            return ArrayOfReturnitemtoprint.subclass(*args_, **kwargs_)
        else:
            return ArrayOfReturnitemtoprint(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_item(self):
        return self.item

    def set_item(self, item):
        self.item = item

    def add_item(self, value):
        self.item.append(value)

    def insert_item_at(self, index, value):
        self.item.insert(index, value)

    def replace_item_at(self, index, value):
        self.item[index] = value

    def _hasContent(self):
        if self.item:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ArrayOfReturnitemtoprint",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ArrayOfReturnitemtoprint")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "ArrayOfReturnitemtoprint":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="ArrayOfReturnitemtoprint",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ArrayOfReturnitemtoprint",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="ArrayOfReturnitemtoprint",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ArrayOfReturnitemtoprint",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for item_ in self.item:
            namespaceprefix_ = (
                self.item_nsprefix_ + ":"
                if (UseCapturedNS_ and self.item_nsprefix_)
                else ""
            )
            item_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="item",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "item":
            obj_ = ReturnItemToPrint.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.item.append(obj_)
            obj_.original_tagname_ = "item"


# end class ArrayOfReturnitemtoprint


class getReturnByWaybill(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(
        self, authData=None, itemsToPrint=None, gds_collector_=None, **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.authData = authData
        self.authData_nsprefix_ = "tns"
        self.itemsToPrint = itemsToPrint
        self.itemsToPrint_nsprefix_ = "tns"

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, getReturnByWaybill
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getReturnByWaybill.subclass:
            return getReturnByWaybill.subclass(*args_, **kwargs_)
        else:
            return getReturnByWaybill(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_authData(self):
        return self.authData

    def set_authData(self, authData):
        self.authData = authData

    def get_itemsToPrint(self):
        return self.itemsToPrint

    def set_itemsToPrint(self, itemsToPrint):
        self.itemsToPrint = itemsToPrint

    def _hasContent(self):
        if self.authData is not None or self.itemsToPrint is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="getReturnByWaybill",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("getReturnByWaybill")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "getReturnByWaybill":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="getReturnByWaybill",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="getReturnByWaybill",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="getReturnByWaybill",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="getReturnByWaybill",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.authData is not None:
            namespaceprefix_ = (
                self.authData_nsprefix_ + ":"
                if (UseCapturedNS_ and self.authData_nsprefix_)
                else ""
            )
            self.authData.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="authData",
                pretty_print=pretty_print,
            )
        if self.itemsToPrint is not None:
            namespaceprefix_ = (
                self.itemsToPrint_nsprefix_ + ":"
                if (UseCapturedNS_ and self.itemsToPrint_nsprefix_)
                else ""
            )
            self.itemsToPrint.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="itemsToPrint",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "authData":
            obj_ = AuthData.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.authData = obj_
            obj_.original_tagname_ = "authData"
        elif nodeName_ == "itemsToPrint":
            obj_ = ArrayOfReturnitemtoprint.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.itemsToPrint = obj_
            obj_.original_tagname_ = "itemsToPrint"


# end class getReturnByWaybill


class Label(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(
        self,
        labelType=None,
        labelFormat=None,
        labelContent=None,
        cn23Content=None,
        cn23MimeType=None,
        fvProformaContent=None,
        fvProformaMimeType=None,
        fvProformaNumer=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.labelType = labelType
        self.labelType_nsprefix_ = None
        self.labelFormat = labelFormat
        self.labelFormat_nsprefix_ = None
        self.labelContent = labelContent
        self.labelContent_nsprefix_ = None
        self.cn23Content = cn23Content
        self.cn23Content_nsprefix_ = None
        self.cn23MimeType = cn23MimeType
        self.cn23MimeType_nsprefix_ = None
        self.fvProformaContent = fvProformaContent
        self.fvProformaContent_nsprefix_ = None
        self.fvProformaMimeType = fvProformaMimeType
        self.fvProformaMimeType_nsprefix_ = None
        self.fvProformaNumer = fvProformaNumer
        self.fvProformaNumer_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, Label)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Label.subclass:
            return Label.subclass(*args_, **kwargs_)
        else:
            return Label(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_labelType(self):
        return self.labelType

    def set_labelType(self, labelType):
        self.labelType = labelType

    def get_labelFormat(self):
        return self.labelFormat

    def set_labelFormat(self, labelFormat):
        self.labelFormat = labelFormat

    def get_labelContent(self):
        return self.labelContent

    def set_labelContent(self, labelContent):
        self.labelContent = labelContent

    def get_cn23Content(self):
        return self.cn23Content

    def set_cn23Content(self, cn23Content):
        self.cn23Content = cn23Content

    def get_cn23MimeType(self):
        return self.cn23MimeType

    def set_cn23MimeType(self, cn23MimeType):
        self.cn23MimeType = cn23MimeType

    def get_fvProformaContent(self):
        return self.fvProformaContent

    def set_fvProformaContent(self, fvProformaContent):
        self.fvProformaContent = fvProformaContent

    def get_fvProformaMimeType(self):
        return self.fvProformaMimeType

    def set_fvProformaMimeType(self, fvProformaMimeType):
        self.fvProformaMimeType = fvProformaMimeType

    def get_fvProformaNumer(self):
        return self.fvProformaNumer

    def set_fvProformaNumer(self, fvProformaNumer):
        self.fvProformaNumer = fvProformaNumer

    def _hasContent(self):
        if (
            self.labelType is not None
            or self.labelFormat is not None
            or self.labelContent is not None
            or self.cn23Content is not None
            or self.cn23MimeType is not None
            or self.fvProformaContent is not None
            or self.fvProformaMimeType is not None
            or self.fvProformaNumer is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Label",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("Label")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "Label":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Label"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="Label",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="Label"
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Label",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.labelType is not None:
            namespaceprefix_ = (
                self.labelType_nsprefix_ + ":"
                if (UseCapturedNS_ and self.labelType_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%slabelType>%s</%slabelType>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.labelType), input_name="labelType"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.labelFormat is not None:
            namespaceprefix_ = (
                self.labelFormat_nsprefix_ + ":"
                if (UseCapturedNS_ and self.labelFormat_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%slabelFormat>%s</%slabelFormat>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.labelFormat), input_name="labelFormat"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.labelContent is not None:
            namespaceprefix_ = (
                self.labelContent_nsprefix_ + ":"
                if (UseCapturedNS_ and self.labelContent_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%slabelContent>%s</%slabelContent>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.labelContent), input_name="labelContent"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.cn23Content is not None:
            namespaceprefix_ = (
                self.cn23Content_nsprefix_ + ":"
                if (UseCapturedNS_ and self.cn23Content_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%scn23Content>%s</%scn23Content>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.cn23Content), input_name="cn23Content"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.cn23MimeType is not None:
            namespaceprefix_ = (
                self.cn23MimeType_nsprefix_ + ":"
                if (UseCapturedNS_ and self.cn23MimeType_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%scn23MimeType>%s</%scn23MimeType>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.cn23MimeType), input_name="cn23MimeType"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.fvProformaContent is not None:
            namespaceprefix_ = (
                self.fvProformaContent_nsprefix_ + ":"
                if (UseCapturedNS_ and self.fvProformaContent_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sfvProformaContent>%s</%sfvProformaContent>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.fvProformaContent),
                            input_name="fvProformaContent",
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.fvProformaMimeType is not None:
            namespaceprefix_ = (
                self.fvProformaMimeType_nsprefix_ + ":"
                if (UseCapturedNS_ and self.fvProformaMimeType_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sfvProformaMimeType>%s</%sfvProformaMimeType>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.fvProformaMimeType),
                            input_name="fvProformaMimeType",
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.fvProformaNumer is not None:
            namespaceprefix_ = (
                self.fvProformaNumer_nsprefix_ + ":"
                if (UseCapturedNS_ and self.fvProformaNumer_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sfvProformaNumer>%s</%sfvProformaNumer>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.fvProformaNumer),
                            input_name="fvProformaNumer",
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "labelType":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "labelType")
            value_ = self.gds_validate_string(value_, node, "labelType")
            self.labelType = value_
            self.labelType_nsprefix_ = child_.prefix
        elif nodeName_ == "labelFormat":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "labelFormat")
            value_ = self.gds_validate_string(value_, node, "labelFormat")
            self.labelFormat = value_
            self.labelFormat_nsprefix_ = child_.prefix
        elif nodeName_ == "labelContent":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "labelContent")
            value_ = self.gds_validate_string(value_, node, "labelContent")
            self.labelContent = value_
            self.labelContent_nsprefix_ = child_.prefix
        elif nodeName_ == "cn23Content":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "cn23Content")
            value_ = self.gds_validate_string(value_, node, "cn23Content")
            self.cn23Content = value_
            self.cn23Content_nsprefix_ = child_.prefix
        elif nodeName_ == "cn23MimeType":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "cn23MimeType")
            value_ = self.gds_validate_string(value_, node, "cn23MimeType")
            self.cn23MimeType = value_
            self.cn23MimeType_nsprefix_ = child_.prefix
        elif nodeName_ == "fvProformaContent":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "fvProformaContent")
            value_ = self.gds_validate_string(value_, node, "fvProformaContent")
            self.fvProformaContent = value_
            self.fvProformaContent_nsprefix_ = child_.prefix
        elif nodeName_ == "fvProformaMimeType":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "fvProformaMimeType")
            value_ = self.gds_validate_string(value_, node, "fvProformaMimeType")
            self.fvProformaMimeType = value_
            self.fvProformaMimeType_nsprefix_ = child_.prefix
        elif nodeName_ == "fvProformaNumer":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "fvProformaNumer")
            value_ = self.gds_validate_string(value_, node, "fvProformaNumer")
            self.fvProformaNumer = value_
            self.fvProformaNumer_nsprefix_ = child_.prefix


# end class Label


class CreateShipmentResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(
        self,
        shipmentNotificationNumber=None,
        shipmentTrackingNumber=None,
        packagesTrackingNumbers=None,
        dispatchNotificationNumber=None,
        label=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.shipmentNotificationNumber = shipmentNotificationNumber
        self.shipmentNotificationNumber_nsprefix_ = None
        self.shipmentTrackingNumber = shipmentTrackingNumber
        self.shipmentTrackingNumber_nsprefix_ = None
        self.packagesTrackingNumbers = packagesTrackingNumbers
        self.packagesTrackingNumbers_nsprefix_ = None
        self.dispatchNotificationNumber = dispatchNotificationNumber
        self.dispatchNotificationNumber_nsprefix_ = None
        self.label = label
        self.label_nsprefix_ = "tns"

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CreateShipmentResponse
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CreateShipmentResponse.subclass:
            return CreateShipmentResponse.subclass(*args_, **kwargs_)
        else:
            return CreateShipmentResponse(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_shipmentNotificationNumber(self):
        return self.shipmentNotificationNumber

    def set_shipmentNotificationNumber(self, shipmentNotificationNumber):
        self.shipmentNotificationNumber = shipmentNotificationNumber

    def get_shipmentTrackingNumber(self):
        return self.shipmentTrackingNumber

    def set_shipmentTrackingNumber(self, shipmentTrackingNumber):
        self.shipmentTrackingNumber = shipmentTrackingNumber

    def get_packagesTrackingNumbers(self):
        return self.packagesTrackingNumbers

    def set_packagesTrackingNumbers(self, packagesTrackingNumbers):
        self.packagesTrackingNumbers = packagesTrackingNumbers

    def get_dispatchNotificationNumber(self):
        return self.dispatchNotificationNumber

    def set_dispatchNotificationNumber(self, dispatchNotificationNumber):
        self.dispatchNotificationNumber = dispatchNotificationNumber

    def get_label(self):
        return self.label

    def set_label(self, label):
        self.label = label

    def _hasContent(self):
        if (
            self.shipmentNotificationNumber is not None
            or self.shipmentTrackingNumber is not None
            or self.packagesTrackingNumbers is not None
            or self.dispatchNotificationNumber is not None
            or self.label is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="CreateShipmentResponse",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("CreateShipmentResponse")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "CreateShipmentResponse":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="CreateShipmentResponse",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="CreateShipmentResponse",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="CreateShipmentResponse",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="CreateShipmentResponse",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.shipmentNotificationNumber is not None:
            namespaceprefix_ = (
                self.shipmentNotificationNumber_nsprefix_ + ":"
                if (UseCapturedNS_ and self.shipmentNotificationNumber_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sshipmentNotificationNumber>%s</%sshipmentNotificationNumber>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.shipmentNotificationNumber),
                            input_name="shipmentNotificationNumber",
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.shipmentTrackingNumber is not None:
            namespaceprefix_ = (
                self.shipmentTrackingNumber_nsprefix_ + ":"
                if (UseCapturedNS_ and self.shipmentTrackingNumber_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sshipmentTrackingNumber>%s</%sshipmentTrackingNumber>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.shipmentTrackingNumber),
                            input_name="shipmentTrackingNumber",
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.packagesTrackingNumbers is not None:
            namespaceprefix_ = (
                self.packagesTrackingNumbers_nsprefix_ + ":"
                if (UseCapturedNS_ and self.packagesTrackingNumbers_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%spackagesTrackingNumbers>%s</%spackagesTrackingNumbers>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.packagesTrackingNumbers),
                            input_name="packagesTrackingNumbers",
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.dispatchNotificationNumber is not None:
            namespaceprefix_ = (
                self.dispatchNotificationNumber_nsprefix_ + ":"
                if (UseCapturedNS_ and self.dispatchNotificationNumber_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sdispatchNotificationNumber>%s</%sdispatchNotificationNumber>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.dispatchNotificationNumber),
                            input_name="dispatchNotificationNumber",
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.label is not None:
            namespaceprefix_ = (
                self.label_nsprefix_ + ":"
                if (UseCapturedNS_ and self.label_nsprefix_)
                else ""
            )
            self.label.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="label",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "shipmentNotificationNumber":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "shipmentNotificationNumber")
            value_ = self.gds_validate_string(
                value_, node, "shipmentNotificationNumber"
            )
            self.shipmentNotificationNumber = value_
            self.shipmentNotificationNumber_nsprefix_ = child_.prefix
        elif nodeName_ == "shipmentTrackingNumber":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "shipmentTrackingNumber")
            value_ = self.gds_validate_string(value_, node, "shipmentTrackingNumber")
            self.shipmentTrackingNumber = value_
            self.shipmentTrackingNumber_nsprefix_ = child_.prefix
        elif nodeName_ == "packagesTrackingNumbers":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "packagesTrackingNumbers")
            value_ = self.gds_validate_string(value_, node, "packagesTrackingNumbers")
            self.packagesTrackingNumbers = value_
            self.packagesTrackingNumbers_nsprefix_ = child_.prefix
        elif nodeName_ == "dispatchNotificationNumber":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "dispatchNotificationNumber")
            value_ = self.gds_validate_string(
                value_, node, "dispatchNotificationNumber"
            )
            self.dispatchNotificationNumber = value_
            self.dispatchNotificationNumber_nsprefix_ = child_.prefix
        elif nodeName_ == "label":
            obj_ = Label.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.label = obj_
            obj_.original_tagname_ = "label"


# end class CreateShipmentResponse


class ArrayOfCreateshipmentresponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, item=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        if item is None:
            self.item = []
        else:
            self.item = item
        self.item_nsprefix_ = "tns"

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ArrayOfCreateshipmentresponse
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ArrayOfCreateshipmentresponse.subclass:
            return ArrayOfCreateshipmentresponse.subclass(*args_, **kwargs_)
        else:
            return ArrayOfCreateshipmentresponse(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_item(self):
        return self.item

    def set_item(self, item):
        self.item = item

    def add_item(self, value):
        self.item.append(value)

    def insert_item_at(self, index, value):
        self.item.insert(index, value)

    def replace_item_at(self, index, value):
        self.item[index] = value

    def _hasContent(self):
        if self.item:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ArrayOfCreateshipmentresponse",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ArrayOfCreateshipmentresponse")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if (
            self.original_tagname_ is not None
            and name_ == "ArrayOfCreateshipmentresponse"
        ):
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="ArrayOfCreateshipmentresponse",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ArrayOfCreateshipmentresponse",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="ArrayOfCreateshipmentresponse",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ArrayOfCreateshipmentresponse",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for item_ in self.item:
            namespaceprefix_ = (
                self.item_nsprefix_ + ":"
                if (UseCapturedNS_ and self.item_nsprefix_)
                else ""
            )
            item_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="item",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "item":
            obj_ = CreateShipmentResponse.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.item.append(obj_)
            obj_.original_tagname_ = "item"


# end class ArrayOfCreateshipmentresponse


class getReturnByWaybillResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, getReturnByWaybillResult=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.getReturnByWaybillResult = getReturnByWaybillResult
        self.getReturnByWaybillResult_nsprefix_ = "tns"

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, getReturnByWaybillResponse
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getReturnByWaybillResponse.subclass:
            return getReturnByWaybillResponse.subclass(*args_, **kwargs_)
        else:
            return getReturnByWaybillResponse(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_getReturnByWaybillResult(self):
        return self.getReturnByWaybillResult

    def set_getReturnByWaybillResult(self, getReturnByWaybillResult):
        self.getReturnByWaybillResult = getReturnByWaybillResult

    def _hasContent(self):
        if self.getReturnByWaybillResult is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="getReturnByWaybillResponse",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("getReturnByWaybillResponse")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "getReturnByWaybillResponse":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="getReturnByWaybillResponse",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="getReturnByWaybillResponse",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="getReturnByWaybillResponse",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="getReturnByWaybillResponse",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.getReturnByWaybillResult is not None:
            namespaceprefix_ = (
                self.getReturnByWaybillResult_nsprefix_ + ":"
                if (UseCapturedNS_ and self.getReturnByWaybillResult_nsprefix_)
                else ""
            )
            self.getReturnByWaybillResult.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="getReturnByWaybillResult",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "getReturnByWaybillResult":
            obj_ = ArrayOfCreateshipmentresponse.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.getReturnByWaybillResult = obj_
            obj_.original_tagname_ = "getReturnByWaybillResult"


# end class getReturnByWaybillResponse


class Billing(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(
        self,
        shippingPaymentType=None,
        billingAccountNumber=None,
        paymentType=None,
        costsCenter=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.shippingPaymentType = shippingPaymentType
        self.shippingPaymentType_nsprefix_ = None
        self.billingAccountNumber = billingAccountNumber
        self.billingAccountNumber_nsprefix_ = None
        self.paymentType = paymentType
        self.paymentType_nsprefix_ = None
        self.costsCenter = costsCenter
        self.costsCenter_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, Billing)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Billing.subclass:
            return Billing.subclass(*args_, **kwargs_)
        else:
            return Billing(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_shippingPaymentType(self):
        return self.shippingPaymentType

    def set_shippingPaymentType(self, shippingPaymentType):
        self.shippingPaymentType = shippingPaymentType

    def get_billingAccountNumber(self):
        return self.billingAccountNumber

    def set_billingAccountNumber(self, billingAccountNumber):
        self.billingAccountNumber = billingAccountNumber

    def get_paymentType(self):
        return self.paymentType

    def set_paymentType(self, paymentType):
        self.paymentType = paymentType

    def get_costsCenter(self):
        return self.costsCenter

    def set_costsCenter(self, costsCenter):
        self.costsCenter = costsCenter

    def _hasContent(self):
        if (
            self.shippingPaymentType is not None
            or self.billingAccountNumber is not None
            or self.paymentType is not None
            or self.costsCenter is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Billing",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("Billing")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "Billing":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Billing"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="Billing",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="Billing"
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Billing",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.shippingPaymentType is not None:
            namespaceprefix_ = (
                self.shippingPaymentType_nsprefix_ + ":"
                if (UseCapturedNS_ and self.shippingPaymentType_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sshippingPaymentType>%s</%sshippingPaymentType>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.shippingPaymentType),
                            input_name="shippingPaymentType",
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.billingAccountNumber is not None:
            namespaceprefix_ = (
                self.billingAccountNumber_nsprefix_ + ":"
                if (UseCapturedNS_ and self.billingAccountNumber_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sbillingAccountNumber>%s</%sbillingAccountNumber>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_integer(
                        self.billingAccountNumber, input_name="billingAccountNumber"
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.paymentType is not None:
            namespaceprefix_ = (
                self.paymentType_nsprefix_ + ":"
                if (UseCapturedNS_ and self.paymentType_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%spaymentType>%s</%spaymentType>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.paymentType), input_name="paymentType"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.costsCenter is not None:
            namespaceprefix_ = (
                self.costsCenter_nsprefix_ + ":"
                if (UseCapturedNS_ and self.costsCenter_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%scostsCenter>%s</%scostsCenter>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.costsCenter), input_name="costsCenter"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "shippingPaymentType":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "shippingPaymentType")
            value_ = self.gds_validate_string(value_, node, "shippingPaymentType")
            self.shippingPaymentType = value_
            self.shippingPaymentType_nsprefix_ = child_.prefix
        elif nodeName_ == "billingAccountNumber" and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, "billingAccountNumber")
            ival_ = self.gds_validate_integer(ival_, node, "billingAccountNumber")
            self.billingAccountNumber = ival_
            self.billingAccountNumber_nsprefix_ = child_.prefix
        elif nodeName_ == "paymentType":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "paymentType")
            value_ = self.gds_validate_string(value_, node, "paymentType")
            self.paymentType = value_
            self.paymentType_nsprefix_ = child_.prefix
        elif nodeName_ == "costsCenter":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "costsCenter")
            value_ = self.gds_validate_string(value_, node, "costsCenter")
            self.costsCenter = value_
            self.costsCenter_nsprefix_ = child_.prefix


# end class Billing


class ReturnService(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(
        self, serviceType=None, serviceValue=None, gds_collector_=None, **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.serviceType = serviceType
        self.serviceType_nsprefix_ = None
        self.serviceValue = serviceValue
        self.serviceValue_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, ReturnService)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ReturnService.subclass:
            return ReturnService.subclass(*args_, **kwargs_)
        else:
            return ReturnService(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_serviceType(self):
        return self.serviceType

    def set_serviceType(self, serviceType):
        self.serviceType = serviceType

    def get_serviceValue(self):
        return self.serviceValue

    def set_serviceValue(self, serviceValue):
        self.serviceValue = serviceValue

    def _hasContent(self):
        if self.serviceType is not None or self.serviceValue is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ReturnService",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ReturnService")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "ReturnService":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="ReturnService"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ReturnService",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="ReturnService",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ReturnService",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.serviceType is not None:
            namespaceprefix_ = (
                self.serviceType_nsprefix_ + ":"
                if (UseCapturedNS_ and self.serviceType_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sserviceType>%s</%sserviceType>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.serviceType), input_name="serviceType"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.serviceValue is not None:
            namespaceprefix_ = (
                self.serviceValue_nsprefix_ + ":"
                if (UseCapturedNS_ and self.serviceValue_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sserviceValue>%s</%sserviceValue>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_float(self.serviceValue, input_name="serviceValue"),
                    namespaceprefix_,
                    eol_,
                )
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "serviceType":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "serviceType")
            value_ = self.gds_validate_string(value_, node, "serviceType")
            self.serviceType = value_
            self.serviceType_nsprefix_ = child_.prefix
        elif nodeName_ == "serviceValue" and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, "serviceValue")
            fval_ = self.gds_validate_float(fval_, node, "serviceValue")
            self.serviceValue = fval_
            self.serviceValue_nsprefix_ = child_.prefix


# end class ReturnService


class ArrayOfReturnservice(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, item=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        if item is None:
            self.item = []
        else:
            self.item = item
        self.item_nsprefix_ = "tns"

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ArrayOfReturnservice
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ArrayOfReturnservice.subclass:
            return ArrayOfReturnservice.subclass(*args_, **kwargs_)
        else:
            return ArrayOfReturnservice(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_item(self):
        return self.item

    def set_item(self, item):
        self.item = item

    def add_item(self, value):
        self.item.append(value)

    def insert_item_at(self, index, value):
        self.item.insert(index, value)

    def replace_item_at(self, index, value):
        self.item[index] = value

    def _hasContent(self):
        if self.item:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ArrayOfReturnservice",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ArrayOfReturnservice")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "ArrayOfReturnservice":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="ArrayOfReturnservice",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ArrayOfReturnservice",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="ArrayOfReturnservice",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ArrayOfReturnservice",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for item_ in self.item:
            namespaceprefix_ = (
                self.item_nsprefix_ + ":"
                if (UseCapturedNS_ and self.item_nsprefix_)
                else ""
            )
            item_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="item",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "item":
            obj_ = ReturnService.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.item.append(obj_)
            obj_.original_tagname_ = "item"


# end class ArrayOfReturnservice


class ReturnShipmentTime(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, labelExpDate=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.labelExpDate = labelExpDate
        self.labelExpDate_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ReturnShipmentTime
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ReturnShipmentTime.subclass:
            return ReturnShipmentTime.subclass(*args_, **kwargs_)
        else:
            return ReturnShipmentTime(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_labelExpDate(self):
        return self.labelExpDate

    def set_labelExpDate(self, labelExpDate):
        self.labelExpDate = labelExpDate

    def _hasContent(self):
        if self.labelExpDate is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ReturnShipmentTime",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ReturnShipmentTime")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "ReturnShipmentTime":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="ReturnShipmentTime",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ReturnShipmentTime",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="ReturnShipmentTime",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ReturnShipmentTime",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.labelExpDate is not None:
            namespaceprefix_ = (
                self.labelExpDate_nsprefix_ + ":"
                if (UseCapturedNS_ and self.labelExpDate_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%slabelExpDate>%s</%slabelExpDate>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.labelExpDate), input_name="labelExpDate"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "labelExpDate":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "labelExpDate")
            value_ = self.gds_validate_string(value_, node, "labelExpDate")
            self.labelExpDate = value_
            self.labelExpDate_nsprefix_ = child_.prefix


# end class ReturnShipmentTime


class ReturnShipmentInfo(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(
        self,
        wayBill=None,
        serviceType=None,
        bookCourier=None,
        billing=None,
        specialServices=None,
        shipmentTime=None,
        labelType=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.wayBill = wayBill
        self.wayBill_nsprefix_ = None
        self.serviceType = serviceType
        self.serviceType_nsprefix_ = None
        self.bookCourier = bookCourier
        self.bookCourier_nsprefix_ = None
        self.billing = billing
        self.billing_nsprefix_ = "tns"
        self.specialServices = specialServices
        self.specialServices_nsprefix_ = "tns"
        self.shipmentTime = shipmentTime
        self.shipmentTime_nsprefix_ = "tns"
        self.labelType = labelType
        self.labelType_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ReturnShipmentInfo
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ReturnShipmentInfo.subclass:
            return ReturnShipmentInfo.subclass(*args_, **kwargs_)
        else:
            return ReturnShipmentInfo(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_wayBill(self):
        return self.wayBill

    def set_wayBill(self, wayBill):
        self.wayBill = wayBill

    def get_serviceType(self):
        return self.serviceType

    def set_serviceType(self, serviceType):
        self.serviceType = serviceType

    def get_bookCourier(self):
        return self.bookCourier

    def set_bookCourier(self, bookCourier):
        self.bookCourier = bookCourier

    def get_billing(self):
        return self.billing

    def set_billing(self, billing):
        self.billing = billing

    def get_specialServices(self):
        return self.specialServices

    def set_specialServices(self, specialServices):
        self.specialServices = specialServices

    def get_shipmentTime(self):
        return self.shipmentTime

    def set_shipmentTime(self, shipmentTime):
        self.shipmentTime = shipmentTime

    def get_labelType(self):
        return self.labelType

    def set_labelType(self, labelType):
        self.labelType = labelType

    def _hasContent(self):
        if (
            self.wayBill is not None
            or self.serviceType is not None
            or self.bookCourier is not None
            or self.billing is not None
            or self.specialServices is not None
            or self.shipmentTime is not None
            or self.labelType is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ReturnShipmentInfo",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ReturnShipmentInfo")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "ReturnShipmentInfo":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="ReturnShipmentInfo",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ReturnShipmentInfo",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="ReturnShipmentInfo",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ReturnShipmentInfo",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.wayBill is not None:
            namespaceprefix_ = (
                self.wayBill_nsprefix_ + ":"
                if (UseCapturedNS_ and self.wayBill_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%swayBill>%s</%swayBill>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.wayBill), input_name="wayBill"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.serviceType is not None:
            namespaceprefix_ = (
                self.serviceType_nsprefix_ + ":"
                if (UseCapturedNS_ and self.serviceType_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sserviceType>%s</%sserviceType>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.serviceType), input_name="serviceType"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.bookCourier is not None:
            namespaceprefix_ = (
                self.bookCourier_nsprefix_ + ":"
                if (UseCapturedNS_ and self.bookCourier_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sbookCourier>%s</%sbookCourier>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_boolean(self.bookCourier, input_name="bookCourier"),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.billing is not None:
            namespaceprefix_ = (
                self.billing_nsprefix_ + ":"
                if (UseCapturedNS_ and self.billing_nsprefix_)
                else ""
            )
            self.billing.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="billing",
                pretty_print=pretty_print,
            )
        if self.specialServices is not None:
            namespaceprefix_ = (
                self.specialServices_nsprefix_ + ":"
                if (UseCapturedNS_ and self.specialServices_nsprefix_)
                else ""
            )
            self.specialServices.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="specialServices",
                pretty_print=pretty_print,
            )
        if self.shipmentTime is not None:
            namespaceprefix_ = (
                self.shipmentTime_nsprefix_ + ":"
                if (UseCapturedNS_ and self.shipmentTime_nsprefix_)
                else ""
            )
            self.shipmentTime.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="shipmentTime",
                pretty_print=pretty_print,
            )
        if self.labelType is not None:
            namespaceprefix_ = (
                self.labelType_nsprefix_ + ":"
                if (UseCapturedNS_ and self.labelType_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%slabelType>%s</%slabelType>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.labelType), input_name="labelType"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "wayBill":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "wayBill")
            value_ = self.gds_validate_string(value_, node, "wayBill")
            self.wayBill = value_
            self.wayBill_nsprefix_ = child_.prefix
        elif nodeName_ == "serviceType":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "serviceType")
            value_ = self.gds_validate_string(value_, node, "serviceType")
            self.serviceType = value_
            self.serviceType_nsprefix_ = child_.prefix
        elif nodeName_ == "bookCourier":
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, "bookCourier")
            ival_ = self.gds_validate_boolean(ival_, node, "bookCourier")
            self.bookCourier = ival_
            self.bookCourier_nsprefix_ = child_.prefix
        elif nodeName_ == "billing":
            obj_ = Billing.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.billing = obj_
            obj_.original_tagname_ = "billing"
        elif nodeName_ == "specialServices":
            obj_ = ArrayOfReturnservice.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.specialServices = obj_
            obj_.original_tagname_ = "specialServices"
        elif nodeName_ == "shipmentTime":
            obj_ = ReturnShipmentTime.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.shipmentTime = obj_
            obj_.original_tagname_ = "shipmentTime"
        elif nodeName_ == "labelType":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "labelType")
            value_ = self.gds_validate_string(value_, node, "labelType")
            self.labelType = value_
            self.labelType_nsprefix_ = child_.prefix


# end class ReturnShipmentInfo


class PreavisoContact(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(
        self,
        personName=None,
        phoneNumber=None,
        emailAddress=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.personName = personName
        self.personName_nsprefix_ = None
        self.phoneNumber = phoneNumber
        self.phoneNumber_nsprefix_ = None
        self.emailAddress = emailAddress
        self.emailAddress_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, PreavisoContact)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PreavisoContact.subclass:
            return PreavisoContact.subclass(*args_, **kwargs_)
        else:
            return PreavisoContact(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_personName(self):
        return self.personName

    def set_personName(self, personName):
        self.personName = personName

    def get_phoneNumber(self):
        return self.phoneNumber

    def set_phoneNumber(self, phoneNumber):
        self.phoneNumber = phoneNumber

    def get_emailAddress(self):
        return self.emailAddress

    def set_emailAddress(self, emailAddress):
        self.emailAddress = emailAddress

    def _hasContent(self):
        if (
            self.personName is not None
            or self.phoneNumber is not None
            or self.emailAddress is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="PreavisoContact",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("PreavisoContact")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "PreavisoContact":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="PreavisoContact"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="PreavisoContact",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="PreavisoContact",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="PreavisoContact",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.personName is not None:
            namespaceprefix_ = (
                self.personName_nsprefix_ + ":"
                if (UseCapturedNS_ and self.personName_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%spersonName>%s</%spersonName>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.personName), input_name="personName"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.phoneNumber is not None:
            namespaceprefix_ = (
                self.phoneNumber_nsprefix_ + ":"
                if (UseCapturedNS_ and self.phoneNumber_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sphoneNumber>%s</%sphoneNumber>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.phoneNumber), input_name="phoneNumber"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.emailAddress is not None:
            namespaceprefix_ = (
                self.emailAddress_nsprefix_ + ":"
                if (UseCapturedNS_ and self.emailAddress_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%semailAddress>%s</%semailAddress>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.emailAddress), input_name="emailAddress"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "personName":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "personName")
            value_ = self.gds_validate_string(value_, node, "personName")
            self.personName = value_
            self.personName_nsprefix_ = child_.prefix
        elif nodeName_ == "phoneNumber":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "phoneNumber")
            value_ = self.gds_validate_string(value_, node, "phoneNumber")
            self.phoneNumber = value_
            self.phoneNumber_nsprefix_ = child_.prefix
        elif nodeName_ == "emailAddress":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "emailAddress")
            value_ = self.gds_validate_string(value_, node, "emailAddress")
            self.emailAddress = value_
            self.emailAddress_nsprefix_ = child_.prefix


# end class PreavisoContact


class ShipperAddress(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(
        self,
        country=None,
        name=None,
        postalCode=None,
        city=None,
        street=None,
        houseNumber=None,
        apartmentNumber=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.country = country
        self.country_nsprefix_ = None
        self.name = name
        self.name_nsprefix_ = None
        self.postalCode = postalCode
        self.postalCode_nsprefix_ = None
        self.city = city
        self.city_nsprefix_ = None
        self.street = street
        self.street_nsprefix_ = None
        self.houseNumber = houseNumber
        self.houseNumber_nsprefix_ = None
        self.apartmentNumber = apartmentNumber
        self.apartmentNumber_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, ShipperAddress)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ShipperAddress.subclass:
            return ShipperAddress.subclass(*args_, **kwargs_)
        else:
            return ShipperAddress(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_country(self):
        return self.country

    def set_country(self, country):
        self.country = country

    def get_name(self):
        return self.name

    def set_name(self, name):
        self.name = name

    def get_postalCode(self):
        return self.postalCode

    def set_postalCode(self, postalCode):
        self.postalCode = postalCode

    def get_city(self):
        return self.city

    def set_city(self, city):
        self.city = city

    def get_street(self):
        return self.street

    def set_street(self, street):
        self.street = street

    def get_houseNumber(self):
        return self.houseNumber

    def set_houseNumber(self, houseNumber):
        self.houseNumber = houseNumber

    def get_apartmentNumber(self):
        return self.apartmentNumber

    def set_apartmentNumber(self, apartmentNumber):
        self.apartmentNumber = apartmentNumber

    def _hasContent(self):
        if (
            self.country is not None
            or self.name is not None
            or self.postalCode is not None
            or self.city is not None
            or self.street is not None
            or self.houseNumber is not None
            or self.apartmentNumber is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ShipperAddress",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ShipperAddress")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "ShipperAddress":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="ShipperAddress"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ShipperAddress",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="ShipperAddress",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ShipperAddress",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.country is not None:
            namespaceprefix_ = (
                self.country_nsprefix_ + ":"
                if (UseCapturedNS_ and self.country_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%scountry>%s</%scountry>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.country), input_name="country"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.name is not None:
            namespaceprefix_ = (
                self.name_nsprefix_ + ":"
                if (UseCapturedNS_ and self.name_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sname>%s</%sname>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(quote_xml(self.name), input_name="name")
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.postalCode is not None:
            namespaceprefix_ = (
                self.postalCode_nsprefix_ + ":"
                if (UseCapturedNS_ and self.postalCode_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%spostalCode>%s</%spostalCode>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.postalCode), input_name="postalCode"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.city is not None:
            namespaceprefix_ = (
                self.city_nsprefix_ + ":"
                if (UseCapturedNS_ and self.city_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%scity>%s</%scity>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(quote_xml(self.city), input_name="city")
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.street is not None:
            namespaceprefix_ = (
                self.street_nsprefix_ + ":"
                if (UseCapturedNS_ and self.street_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sstreet>%s</%sstreet>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.street), input_name="street"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.houseNumber is not None:
            namespaceprefix_ = (
                self.houseNumber_nsprefix_ + ":"
                if (UseCapturedNS_ and self.houseNumber_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%shouseNumber>%s</%shouseNumber>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.houseNumber), input_name="houseNumber"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.apartmentNumber is not None:
            namespaceprefix_ = (
                self.apartmentNumber_nsprefix_ + ":"
                if (UseCapturedNS_ and self.apartmentNumber_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sapartmentNumber>%s</%sapartmentNumber>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.apartmentNumber),
                            input_name="apartmentNumber",
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "country":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "country")
            value_ = self.gds_validate_string(value_, node, "country")
            self.country = value_
            self.country_nsprefix_ = child_.prefix
        elif nodeName_ == "name":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "name")
            value_ = self.gds_validate_string(value_, node, "name")
            self.name = value_
            self.name_nsprefix_ = child_.prefix
        elif nodeName_ == "postalCode":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "postalCode")
            value_ = self.gds_validate_string(value_, node, "postalCode")
            self.postalCode = value_
            self.postalCode_nsprefix_ = child_.prefix
        elif nodeName_ == "city":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "city")
            value_ = self.gds_validate_string(value_, node, "city")
            self.city = value_
            self.city_nsprefix_ = child_.prefix
        elif nodeName_ == "street":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "street")
            value_ = self.gds_validate_string(value_, node, "street")
            self.street = value_
            self.street_nsprefix_ = child_.prefix
        elif nodeName_ == "houseNumber":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "houseNumber")
            value_ = self.gds_validate_string(value_, node, "houseNumber")
            self.houseNumber = value_
            self.houseNumber_nsprefix_ = child_.prefix
        elif nodeName_ == "apartmentNumber":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "apartmentNumber")
            value_ = self.gds_validate_string(value_, node, "apartmentNumber")
            self.apartmentNumber = value_
            self.apartmentNumber_nsprefix_ = child_.prefix


# end class ShipperAddress


class ReturnAddressat(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(
        self, preaviso=None, contact=None, address=None, gds_collector_=None, **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.preaviso = preaviso
        self.preaviso_nsprefix_ = "tns"
        self.contact = contact
        self.contact_nsprefix_ = "tns"
        self.address = address
        self.address_nsprefix_ = "tns"

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, ReturnAddressat)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ReturnAddressat.subclass:
            return ReturnAddressat.subclass(*args_, **kwargs_)
        else:
            return ReturnAddressat(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_preaviso(self):
        return self.preaviso

    def set_preaviso(self, preaviso):
        self.preaviso = preaviso

    def get_contact(self):
        return self.contact

    def set_contact(self, contact):
        self.contact = contact

    def get_address(self):
        return self.address

    def set_address(self, address):
        self.address = address

    def _hasContent(self):
        if (
            self.preaviso is not None
            or self.contact is not None
            or self.address is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ReturnAddressat",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ReturnAddressat")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "ReturnAddressat":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="ReturnAddressat"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ReturnAddressat",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="ReturnAddressat",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ReturnAddressat",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.preaviso is not None:
            namespaceprefix_ = (
                self.preaviso_nsprefix_ + ":"
                if (UseCapturedNS_ and self.preaviso_nsprefix_)
                else ""
            )
            self.preaviso.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="preaviso",
                pretty_print=pretty_print,
            )
        if self.contact is not None:
            namespaceprefix_ = (
                self.contact_nsprefix_ + ":"
                if (UseCapturedNS_ and self.contact_nsprefix_)
                else ""
            )
            self.contact.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="contact",
                pretty_print=pretty_print,
            )
        if self.address is not None:
            namespaceprefix_ = (
                self.address_nsprefix_ + ":"
                if (UseCapturedNS_ and self.address_nsprefix_)
                else ""
            )
            self.address.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="address",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "preaviso":
            obj_ = PreavisoContact.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.preaviso = obj_
            obj_.original_tagname_ = "preaviso"
        elif nodeName_ == "contact":
            obj_ = PreavisoContact.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.contact = obj_
            obj_.original_tagname_ = "contact"
        elif nodeName_ == "address":
            obj_ = ShipperAddress.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.address = obj_
            obj_.original_tagname_ = "address"


# end class ReturnAddressat


class ReturnShip(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, shipper=None, receiver=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.shipper = shipper
        self.shipper_nsprefix_ = "tns"
        self.receiver = receiver
        self.receiver_nsprefix_ = "tns"

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, ReturnShip)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ReturnShip.subclass:
            return ReturnShip.subclass(*args_, **kwargs_)
        else:
            return ReturnShip(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_shipper(self):
        return self.shipper

    def set_shipper(self, shipper):
        self.shipper = shipper

    def get_receiver(self):
        return self.receiver

    def set_receiver(self, receiver):
        self.receiver = receiver

    def _hasContent(self):
        if self.shipper is not None or self.receiver is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ReturnShip",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ReturnShip")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "ReturnShip":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="ReturnShip"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ReturnShip",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="ReturnShip"
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ReturnShip",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.shipper is not None:
            namespaceprefix_ = (
                self.shipper_nsprefix_ + ":"
                if (UseCapturedNS_ and self.shipper_nsprefix_)
                else ""
            )
            self.shipper.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="shipper",
                pretty_print=pretty_print,
            )
        if self.receiver is not None:
            namespaceprefix_ = (
                self.receiver_nsprefix_ + ":"
                if (UseCapturedNS_ and self.receiver_nsprefix_)
                else ""
            )
            self.receiver.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="receiver",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "shipper":
            obj_ = ReturnAddressat.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.shipper = obj_
            obj_.original_tagname_ = "shipper"
        elif nodeName_ == "receiver":
            obj_ = ReturnAddressat.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.receiver = obj_
            obj_.original_tagname_ = "receiver"


# end class ReturnShip


class ReturnPackage(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(
        self,
        type_=None,
        weight=None,
        width=None,
        height=None,
        length=None,
        quantity=None,
        nonStandard=None,
        blpPieceId=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.type_ = type_
        self.type__nsprefix_ = None
        self.weight = weight
        self.weight_nsprefix_ = None
        self.width = width
        self.width_nsprefix_ = None
        self.height = height
        self.height_nsprefix_ = None
        self.length = length
        self.length_nsprefix_ = None
        self.quantity = quantity
        self.quantity_nsprefix_ = None
        self.nonStandard = nonStandard
        self.nonStandard_nsprefix_ = None
        self.blpPieceId = blpPieceId
        self.blpPieceId_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, ReturnPackage)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ReturnPackage.subclass:
            return ReturnPackage.subclass(*args_, **kwargs_)
        else:
            return ReturnPackage(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_type(self):
        return self.type_

    def set_type(self, type_):
        self.type_ = type_

    def get_weight(self):
        return self.weight

    def set_weight(self, weight):
        self.weight = weight

    def get_width(self):
        return self.width

    def set_width(self, width):
        self.width = width

    def get_height(self):
        return self.height

    def set_height(self, height):
        self.height = height

    def get_length(self):
        return self.length

    def set_length(self, length):
        self.length = length

    def get_quantity(self):
        return self.quantity

    def set_quantity(self, quantity):
        self.quantity = quantity

    def get_nonStandard(self):
        return self.nonStandard

    def set_nonStandard(self, nonStandard):
        self.nonStandard = nonStandard

    def get_blpPieceId(self):
        return self.blpPieceId

    def set_blpPieceId(self, blpPieceId):
        self.blpPieceId = blpPieceId

    def _hasContent(self):
        if (
            self.type_ is not None
            or self.weight is not None
            or self.width is not None
            or self.height is not None
            or self.length is not None
            or self.quantity is not None
            or self.nonStandard is not None
            or self.blpPieceId is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ReturnPackage",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ReturnPackage")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "ReturnPackage":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="ReturnPackage"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ReturnPackage",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="ReturnPackage",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ReturnPackage",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.type_ is not None:
            namespaceprefix_ = (
                self.type__nsprefix_ + ":"
                if (UseCapturedNS_ and self.type__nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%stype>%s</%stype>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(quote_xml(self.type_), input_name="type")
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.weight is not None:
            namespaceprefix_ = (
                self.weight_nsprefix_ + ":"
                if (UseCapturedNS_ and self.weight_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sweight>%s</%sweight>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_integer(self.weight, input_name="weight"),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.width is not None:
            namespaceprefix_ = (
                self.width_nsprefix_ + ":"
                if (UseCapturedNS_ and self.width_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%swidth>%s</%swidth>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_integer(self.width, input_name="width"),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.height is not None:
            namespaceprefix_ = (
                self.height_nsprefix_ + ":"
                if (UseCapturedNS_ and self.height_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sheight>%s</%sheight>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_integer(self.height, input_name="height"),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.length is not None:
            namespaceprefix_ = (
                self.length_nsprefix_ + ":"
                if (UseCapturedNS_ and self.length_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%slength>%s</%slength>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_integer(self.length, input_name="length"),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.quantity is not None:
            namespaceprefix_ = (
                self.quantity_nsprefix_ + ":"
                if (UseCapturedNS_ and self.quantity_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%squantity>%s</%squantity>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_integer(self.quantity, input_name="quantity"),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.nonStandard is not None:
            namespaceprefix_ = (
                self.nonStandard_nsprefix_ + ":"
                if (UseCapturedNS_ and self.nonStandard_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%snonStandard>%s</%snonStandard>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_boolean(self.nonStandard, input_name="nonStandard"),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.blpPieceId is not None:
            namespaceprefix_ = (
                self.blpPieceId_nsprefix_ + ":"
                if (UseCapturedNS_ and self.blpPieceId_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sblpPieceId>%s</%sblpPieceId>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.blpPieceId), input_name="blpPieceId"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "type":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "type")
            value_ = self.gds_validate_string(value_, node, "type")
            self.type_ = value_
            self.type_nsprefix_ = child_.prefix
        elif nodeName_ == "weight" and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, "weight")
            ival_ = self.gds_validate_integer(ival_, node, "weight")
            self.weight = ival_
            self.weight_nsprefix_ = child_.prefix
        elif nodeName_ == "width" and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, "width")
            ival_ = self.gds_validate_integer(ival_, node, "width")
            self.width = ival_
            self.width_nsprefix_ = child_.prefix
        elif nodeName_ == "height" and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, "height")
            ival_ = self.gds_validate_integer(ival_, node, "height")
            self.height = ival_
            self.height_nsprefix_ = child_.prefix
        elif nodeName_ == "length" and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, "length")
            ival_ = self.gds_validate_integer(ival_, node, "length")
            self.length = ival_
            self.length_nsprefix_ = child_.prefix
        elif nodeName_ == "quantity" and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, "quantity")
            ival_ = self.gds_validate_integer(ival_, node, "quantity")
            self.quantity = ival_
            self.quantity_nsprefix_ = child_.prefix
        elif nodeName_ == "nonStandard":
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, "nonStandard")
            ival_ = self.gds_validate_boolean(ival_, node, "nonStandard")
            self.nonStandard = ival_
            self.nonStandard_nsprefix_ = child_.prefix
        elif nodeName_ == "blpPieceId":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "blpPieceId")
            value_ = self.gds_validate_string(value_, node, "blpPieceId")
            self.blpPieceId = value_
            self.blpPieceId_nsprefix_ = child_.prefix


# end class ReturnPackage


class ArrayOfReturnpackage(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, item=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        if item is None:
            self.item = []
        else:
            self.item = item
        self.item_nsprefix_ = "tns"

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ArrayOfReturnpackage
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ArrayOfReturnpackage.subclass:
            return ArrayOfReturnpackage.subclass(*args_, **kwargs_)
        else:
            return ArrayOfReturnpackage(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_item(self):
        return self.item

    def set_item(self, item):
        self.item = item

    def add_item(self, value):
        self.item.append(value)

    def insert_item_at(self, index, value):
        self.item.insert(index, value)

    def replace_item_at(self, index, value):
        self.item[index] = value

    def _hasContent(self):
        if self.item:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ArrayOfReturnpackage",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ArrayOfReturnpackage")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "ArrayOfReturnpackage":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="ArrayOfReturnpackage",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ArrayOfReturnpackage",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="ArrayOfReturnpackage",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ArrayOfReturnpackage",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for item_ in self.item:
            namespaceprefix_ = (
                self.item_nsprefix_ + ":"
                if (UseCapturedNS_ and self.item_nsprefix_)
                else ""
            )
            item_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="item",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "item":
            obj_ = ReturnPackage.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.item.append(obj_)
            obj_.original_tagname_ = "item"


# end class ArrayOfReturnpackage


class CreateReturnShipmentRequest(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(
        self,
        shipmentInfo=None,
        content=None,
        comment=None,
        reference=None,
        primaryWaybillNumber=None,
        ship=None,
        pieceList=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.shipmentInfo = shipmentInfo
        self.shipmentInfo_nsprefix_ = "tns"
        self.content = content
        self.content_nsprefix_ = None
        self.comment = comment
        self.comment_nsprefix_ = None
        self.reference = reference
        self.reference_nsprefix_ = None
        self.primaryWaybillNumber = primaryWaybillNumber
        self.primaryWaybillNumber_nsprefix_ = None
        self.ship = ship
        self.ship_nsprefix_ = "tns"
        self.pieceList = pieceList
        self.pieceList_nsprefix_ = "tns"

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CreateReturnShipmentRequest
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CreateReturnShipmentRequest.subclass:
            return CreateReturnShipmentRequest.subclass(*args_, **kwargs_)
        else:
            return CreateReturnShipmentRequest(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_shipmentInfo(self):
        return self.shipmentInfo

    def set_shipmentInfo(self, shipmentInfo):
        self.shipmentInfo = shipmentInfo

    def get_content(self):
        return self.content

    def set_content(self, content):
        self.content = content

    def get_comment(self):
        return self.comment

    def set_comment(self, comment):
        self.comment = comment

    def get_reference(self):
        return self.reference

    def set_reference(self, reference):
        self.reference = reference

    def get_primaryWaybillNumber(self):
        return self.primaryWaybillNumber

    def set_primaryWaybillNumber(self, primaryWaybillNumber):
        self.primaryWaybillNumber = primaryWaybillNumber

    def get_ship(self):
        return self.ship

    def set_ship(self, ship):
        self.ship = ship

    def get_pieceList(self):
        return self.pieceList

    def set_pieceList(self, pieceList):
        self.pieceList = pieceList

    def _hasContent(self):
        if (
            self.shipmentInfo is not None
            or self.content is not None
            or self.comment is not None
            or self.reference is not None
            or self.primaryWaybillNumber is not None
            or self.ship is not None
            or self.pieceList is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="CreateReturnShipmentRequest",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("CreateReturnShipmentRequest")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if (
            self.original_tagname_ is not None
            and name_ == "CreateReturnShipmentRequest"
        ):
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="CreateReturnShipmentRequest",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="CreateReturnShipmentRequest",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="CreateReturnShipmentRequest",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="CreateReturnShipmentRequest",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.shipmentInfo is not None:
            namespaceprefix_ = (
                self.shipmentInfo_nsprefix_ + ":"
                if (UseCapturedNS_ and self.shipmentInfo_nsprefix_)
                else ""
            )
            self.shipmentInfo.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="shipmentInfo",
                pretty_print=pretty_print,
            )
        if self.content is not None:
            namespaceprefix_ = (
                self.content_nsprefix_ + ":"
                if (UseCapturedNS_ and self.content_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%scontent>%s</%scontent>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.content), input_name="content"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.comment is not None:
            namespaceprefix_ = (
                self.comment_nsprefix_ + ":"
                if (UseCapturedNS_ and self.comment_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%scomment>%s</%scomment>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.comment), input_name="comment"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.reference is not None:
            namespaceprefix_ = (
                self.reference_nsprefix_ + ":"
                if (UseCapturedNS_ and self.reference_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sreference>%s</%sreference>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.reference), input_name="reference"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.primaryWaybillNumber is not None:
            namespaceprefix_ = (
                self.primaryWaybillNumber_nsprefix_ + ":"
                if (UseCapturedNS_ and self.primaryWaybillNumber_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sprimaryWaybillNumber>%s</%sprimaryWaybillNumber>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.primaryWaybillNumber),
                            input_name="primaryWaybillNumber",
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.ship is not None:
            namespaceprefix_ = (
                self.ship_nsprefix_ + ":"
                if (UseCapturedNS_ and self.ship_nsprefix_)
                else ""
            )
            self.ship.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="ship",
                pretty_print=pretty_print,
            )
        if self.pieceList is not None:
            namespaceprefix_ = (
                self.pieceList_nsprefix_ + ":"
                if (UseCapturedNS_ and self.pieceList_nsprefix_)
                else ""
            )
            self.pieceList.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="pieceList",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "shipmentInfo":
            obj_ = ReturnShipmentInfo.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.shipmentInfo = obj_
            obj_.original_tagname_ = "shipmentInfo"
        elif nodeName_ == "content":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "content")
            value_ = self.gds_validate_string(value_, node, "content")
            self.content = value_
            self.content_nsprefix_ = child_.prefix
        elif nodeName_ == "comment":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "comment")
            value_ = self.gds_validate_string(value_, node, "comment")
            self.comment = value_
            self.comment_nsprefix_ = child_.prefix
        elif nodeName_ == "reference":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "reference")
            value_ = self.gds_validate_string(value_, node, "reference")
            self.reference = value_
            self.reference_nsprefix_ = child_.prefix
        elif nodeName_ == "primaryWaybillNumber":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "primaryWaybillNumber")
            value_ = self.gds_validate_string(value_, node, "primaryWaybillNumber")
            self.primaryWaybillNumber = value_
            self.primaryWaybillNumber_nsprefix_ = child_.prefix
        elif nodeName_ == "ship":
            obj_ = ReturnShip.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ship = obj_
            obj_.original_tagname_ = "ship"
        elif nodeName_ == "pieceList":
            obj_ = ArrayOfReturnpackage.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.pieceList = obj_
            obj_.original_tagname_ = "pieceList"


# end class CreateReturnShipmentRequest


class createShipmentReturn(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, authData=None, shipment=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.authData = authData
        self.authData_nsprefix_ = "tns"
        self.shipment = shipment
        self.shipment_nsprefix_ = "tns"

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, createShipmentReturn
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if createShipmentReturn.subclass:
            return createShipmentReturn.subclass(*args_, **kwargs_)
        else:
            return createShipmentReturn(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_authData(self):
        return self.authData

    def set_authData(self, authData):
        self.authData = authData

    def get_shipment(self):
        return self.shipment

    def set_shipment(self, shipment):
        self.shipment = shipment

    def _hasContent(self):
        if self.authData is not None or self.shipment is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="createShipmentReturn",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("createShipmentReturn")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "createShipmentReturn":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="createShipmentReturn",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="createShipmentReturn",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="createShipmentReturn",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="createShipmentReturn",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.authData is not None:
            namespaceprefix_ = (
                self.authData_nsprefix_ + ":"
                if (UseCapturedNS_ and self.authData_nsprefix_)
                else ""
            )
            self.authData.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="authData",
                pretty_print=pretty_print,
            )
        if self.shipment is not None:
            namespaceprefix_ = (
                self.shipment_nsprefix_ + ":"
                if (UseCapturedNS_ and self.shipment_nsprefix_)
                else ""
            )
            self.shipment.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="shipment",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "authData":
            obj_ = AuthData.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.authData = obj_
            obj_.original_tagname_ = "authData"
        elif nodeName_ == "shipment":
            obj_ = CreateReturnShipmentRequest.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.shipment = obj_
            obj_.original_tagname_ = "shipment"


# end class createShipmentReturn


class CreateReturnShipmentResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(
        self,
        shipmentNotificationNumber=None,
        shipmentTrackingNumber=None,
        packagesTrackingNumbers=None,
        dispatchNotificationNumber=None,
        label=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.shipmentNotificationNumber = shipmentNotificationNumber
        self.shipmentNotificationNumber_nsprefix_ = None
        self.shipmentTrackingNumber = shipmentTrackingNumber
        self.shipmentTrackingNumber_nsprefix_ = None
        self.packagesTrackingNumbers = packagesTrackingNumbers
        self.packagesTrackingNumbers_nsprefix_ = None
        self.dispatchNotificationNumber = dispatchNotificationNumber
        self.dispatchNotificationNumber_nsprefix_ = None
        self.label = label
        self.label_nsprefix_ = "tns"

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CreateReturnShipmentResponse
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CreateReturnShipmentResponse.subclass:
            return CreateReturnShipmentResponse.subclass(*args_, **kwargs_)
        else:
            return CreateReturnShipmentResponse(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_shipmentNotificationNumber(self):
        return self.shipmentNotificationNumber

    def set_shipmentNotificationNumber(self, shipmentNotificationNumber):
        self.shipmentNotificationNumber = shipmentNotificationNumber

    def get_shipmentTrackingNumber(self):
        return self.shipmentTrackingNumber

    def set_shipmentTrackingNumber(self, shipmentTrackingNumber):
        self.shipmentTrackingNumber = shipmentTrackingNumber

    def get_packagesTrackingNumbers(self):
        return self.packagesTrackingNumbers

    def set_packagesTrackingNumbers(self, packagesTrackingNumbers):
        self.packagesTrackingNumbers = packagesTrackingNumbers

    def get_dispatchNotificationNumber(self):
        return self.dispatchNotificationNumber

    def set_dispatchNotificationNumber(self, dispatchNotificationNumber):
        self.dispatchNotificationNumber = dispatchNotificationNumber

    def get_label(self):
        return self.label

    def set_label(self, label):
        self.label = label

    def _hasContent(self):
        if (
            self.shipmentNotificationNumber is not None
            or self.shipmentTrackingNumber is not None
            or self.packagesTrackingNumbers is not None
            or self.dispatchNotificationNumber is not None
            or self.label is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="CreateReturnShipmentResponse",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("CreateReturnShipmentResponse")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if (
            self.original_tagname_ is not None
            and name_ == "CreateReturnShipmentResponse"
        ):
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="CreateReturnShipmentResponse",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="CreateReturnShipmentResponse",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="CreateReturnShipmentResponse",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="CreateReturnShipmentResponse",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.shipmentNotificationNumber is not None:
            namespaceprefix_ = (
                self.shipmentNotificationNumber_nsprefix_ + ":"
                if (UseCapturedNS_ and self.shipmentNotificationNumber_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sshipmentNotificationNumber>%s</%sshipmentNotificationNumber>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.shipmentNotificationNumber),
                            input_name="shipmentNotificationNumber",
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.shipmentTrackingNumber is not None:
            namespaceprefix_ = (
                self.shipmentTrackingNumber_nsprefix_ + ":"
                if (UseCapturedNS_ and self.shipmentTrackingNumber_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sshipmentTrackingNumber>%s</%sshipmentTrackingNumber>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.shipmentTrackingNumber),
                            input_name="shipmentTrackingNumber",
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.packagesTrackingNumbers is not None:
            namespaceprefix_ = (
                self.packagesTrackingNumbers_nsprefix_ + ":"
                if (UseCapturedNS_ and self.packagesTrackingNumbers_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%spackagesTrackingNumbers>%s</%spackagesTrackingNumbers>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.packagesTrackingNumbers),
                            input_name="packagesTrackingNumbers",
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.dispatchNotificationNumber is not None:
            namespaceprefix_ = (
                self.dispatchNotificationNumber_nsprefix_ + ":"
                if (UseCapturedNS_ and self.dispatchNotificationNumber_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sdispatchNotificationNumber>%s</%sdispatchNotificationNumber>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.dispatchNotificationNumber),
                            input_name="dispatchNotificationNumber",
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.label is not None:
            namespaceprefix_ = (
                self.label_nsprefix_ + ":"
                if (UseCapturedNS_ and self.label_nsprefix_)
                else ""
            )
            self.label.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="label",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "shipmentNotificationNumber":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "shipmentNotificationNumber")
            value_ = self.gds_validate_string(
                value_, node, "shipmentNotificationNumber"
            )
            self.shipmentNotificationNumber = value_
            self.shipmentNotificationNumber_nsprefix_ = child_.prefix
        elif nodeName_ == "shipmentTrackingNumber":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "shipmentTrackingNumber")
            value_ = self.gds_validate_string(value_, node, "shipmentTrackingNumber")
            self.shipmentTrackingNumber = value_
            self.shipmentTrackingNumber_nsprefix_ = child_.prefix
        elif nodeName_ == "packagesTrackingNumbers":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "packagesTrackingNumbers")
            value_ = self.gds_validate_string(value_, node, "packagesTrackingNumbers")
            self.packagesTrackingNumbers = value_
            self.packagesTrackingNumbers_nsprefix_ = child_.prefix
        elif nodeName_ == "dispatchNotificationNumber":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "dispatchNotificationNumber")
            value_ = self.gds_validate_string(
                value_, node, "dispatchNotificationNumber"
            )
            self.dispatchNotificationNumber = value_
            self.dispatchNotificationNumber_nsprefix_ = child_.prefix
        elif nodeName_ == "label":
            obj_ = Label.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.label = obj_
            obj_.original_tagname_ = "label"


# end class CreateReturnShipmentResponse


class ArrayOfCreatereturnshipmentresponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, item=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        if item is None:
            self.item = []
        else:
            self.item = item
        self.item_nsprefix_ = "tns"

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ArrayOfCreatereturnshipmentresponse
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ArrayOfCreatereturnshipmentresponse.subclass:
            return ArrayOfCreatereturnshipmentresponse.subclass(*args_, **kwargs_)
        else:
            return ArrayOfCreatereturnshipmentresponse(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_item(self):
        return self.item

    def set_item(self, item):
        self.item = item

    def add_item(self, value):
        self.item.append(value)

    def insert_item_at(self, index, value):
        self.item.insert(index, value)

    def replace_item_at(self, index, value):
        self.item[index] = value

    def _hasContent(self):
        if self.item:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ArrayOfCreatereturnshipmentresponse",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get(
            "ArrayOfCreatereturnshipmentresponse"
        )
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if (
            self.original_tagname_ is not None
            and name_ == "ArrayOfCreatereturnshipmentresponse"
        ):
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="ArrayOfCreatereturnshipmentresponse",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ArrayOfCreatereturnshipmentresponse",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="ArrayOfCreatereturnshipmentresponse",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ArrayOfCreatereturnshipmentresponse",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for item_ in self.item:
            namespaceprefix_ = (
                self.item_nsprefix_ + ":"
                if (UseCapturedNS_ and self.item_nsprefix_)
                else ""
            )
            item_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="item",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "item":
            obj_ = CreateReturnShipmentResponse.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.item.append(obj_)
            obj_.original_tagname_ = "item"


# end class ArrayOfCreatereturnshipmentresponse


class createShipmentReturnResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, createShipmentReturnResult=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.createShipmentReturnResult = createShipmentReturnResult
        self.createShipmentReturnResult_nsprefix_ = "tns"

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, createShipmentReturnResponse
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if createShipmentReturnResponse.subclass:
            return createShipmentReturnResponse.subclass(*args_, **kwargs_)
        else:
            return createShipmentReturnResponse(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_createShipmentReturnResult(self):
        return self.createShipmentReturnResult

    def set_createShipmentReturnResult(self, createShipmentReturnResult):
        self.createShipmentReturnResult = createShipmentReturnResult

    def _hasContent(self):
        if self.createShipmentReturnResult is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="createShipmentReturnResponse",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("createShipmentReturnResponse")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if (
            self.original_tagname_ is not None
            and name_ == "createShipmentReturnResponse"
        ):
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="createShipmentReturnResponse",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="createShipmentReturnResponse",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="createShipmentReturnResponse",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="createShipmentReturnResponse",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.createShipmentReturnResult is not None:
            namespaceprefix_ = (
                self.createShipmentReturnResult_nsprefix_ + ":"
                if (UseCapturedNS_ and self.createShipmentReturnResult_nsprefix_)
                else ""
            )
            self.createShipmentReturnResult.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="createShipmentReturnResult",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "createShipmentReturnResult":
            obj_ = ArrayOfCreatereturnshipmentresponse.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.createShipmentReturnResult = obj_
            obj_.original_tagname_ = "createShipmentReturnResult"


# end class createShipmentReturnResponse


class ArrayOfString(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, item=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        if item is None:
            self.item = []
        else:
            self.item = item
        self.item_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, ArrayOfString)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ArrayOfString.subclass:
            return ArrayOfString.subclass(*args_, **kwargs_)
        else:
            return ArrayOfString(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_item(self):
        return self.item

    def set_item(self, item):
        self.item = item

    def add_item(self, value):
        self.item.append(value)

    def insert_item_at(self, index, value):
        self.item.insert(index, value)

    def replace_item_at(self, index, value):
        self.item[index] = value

    def _hasContent(self):
        if self.item:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ArrayOfString",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ArrayOfString")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "ArrayOfString":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="ArrayOfString"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ArrayOfString",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="ArrayOfString",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ArrayOfString",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for item_ in self.item:
            namespaceprefix_ = (
                self.item_nsprefix_ + ":"
                if (UseCapturedNS_ and self.item_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sitem>%s</%sitem>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(quote_xml(item_), input_name="item")
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "item":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "item")
            value_ = self.gds_validate_string(value_, node, "item")
            self.item.append(value_)
            self.item_nsprefix_ = child_.prefix


# end class ArrayOfString


class deleteShipments(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, authData=None, shipments=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.authData = authData
        self.authData_nsprefix_ = "tns"
        self.shipments = shipments
        self.shipments_nsprefix_ = "tns"

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, deleteShipments)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if deleteShipments.subclass:
            return deleteShipments.subclass(*args_, **kwargs_)
        else:
            return deleteShipments(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_authData(self):
        return self.authData

    def set_authData(self, authData):
        self.authData = authData

    def get_shipments(self):
        return self.shipments

    def set_shipments(self, shipments):
        self.shipments = shipments

    def _hasContent(self):
        if self.authData is not None or self.shipments is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="deleteShipments",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("deleteShipments")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "deleteShipments":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="deleteShipments"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="deleteShipments",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="deleteShipments",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="deleteShipments",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.authData is not None:
            namespaceprefix_ = (
                self.authData_nsprefix_ + ":"
                if (UseCapturedNS_ and self.authData_nsprefix_)
                else ""
            )
            self.authData.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="authData",
                pretty_print=pretty_print,
            )
        if self.shipments is not None:
            namespaceprefix_ = (
                self.shipments_nsprefix_ + ":"
                if (UseCapturedNS_ and self.shipments_nsprefix_)
                else ""
            )
            self.shipments.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="shipments",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "authData":
            obj_ = AuthData.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.authData = obj_
            obj_.original_tagname_ = "authData"
        elif nodeName_ == "shipments":
            obj_ = ArrayOfString.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.shipments = obj_
            obj_.original_tagname_ = "shipments"


# end class deleteShipments


class DeleteNotification(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(
        self, id=None, result=None, error=None, gds_collector_=None, **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.id = id
        self.id_nsprefix_ = None
        self.result = result
        self.result_nsprefix_ = None
        self.error = error
        self.error_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, DeleteNotification
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if DeleteNotification.subclass:
            return DeleteNotification.subclass(*args_, **kwargs_)
        else:
            return DeleteNotification(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_id(self):
        return self.id

    def set_id(self, id):
        self.id = id

    def get_result(self):
        return self.result

    def set_result(self, result):
        self.result = result

    def get_error(self):
        return self.error

    def set_error(self, error):
        self.error = error

    def _hasContent(self):
        if self.id is not None or self.result is not None or self.error is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="DeleteNotification",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("DeleteNotification")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "DeleteNotification":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="DeleteNotification",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="DeleteNotification",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="DeleteNotification",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="DeleteNotification",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.id is not None:
            namespaceprefix_ = (
                self.id_nsprefix_ + ":"
                if (UseCapturedNS_ and self.id_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sid>%s</%sid>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(quote_xml(self.id), input_name="id")
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.result is not None:
            namespaceprefix_ = (
                self.result_nsprefix_ + ":"
                if (UseCapturedNS_ and self.result_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sresult>%s</%sresult>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_boolean(self.result, input_name="result"),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.error is not None:
            namespaceprefix_ = (
                self.error_nsprefix_ + ":"
                if (UseCapturedNS_ and self.error_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%serror>%s</%serror>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.error), input_name="error"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "id":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "id")
            value_ = self.gds_validate_string(value_, node, "id")
            self.id = value_
            self.id_nsprefix_ = child_.prefix
        elif nodeName_ == "result":
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, "result")
            ival_ = self.gds_validate_boolean(ival_, node, "result")
            self.result = ival_
            self.result_nsprefix_ = child_.prefix
        elif nodeName_ == "error":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "error")
            value_ = self.gds_validate_string(value_, node, "error")
            self.error = value_
            self.error_nsprefix_ = child_.prefix


# end class DeleteNotification


class ArrayOfDeletenotification(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, item=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        if item is None:
            self.item = []
        else:
            self.item = item
        self.item_nsprefix_ = "tns"

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ArrayOfDeletenotification
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ArrayOfDeletenotification.subclass:
            return ArrayOfDeletenotification.subclass(*args_, **kwargs_)
        else:
            return ArrayOfDeletenotification(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_item(self):
        return self.item

    def set_item(self, item):
        self.item = item

    def add_item(self, value):
        self.item.append(value)

    def insert_item_at(self, index, value):
        self.item.insert(index, value)

    def replace_item_at(self, index, value):
        self.item[index] = value

    def _hasContent(self):
        if self.item:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ArrayOfDeletenotification",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ArrayOfDeletenotification")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "ArrayOfDeletenotification":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="ArrayOfDeletenotification",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ArrayOfDeletenotification",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="ArrayOfDeletenotification",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ArrayOfDeletenotification",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for item_ in self.item:
            namespaceprefix_ = (
                self.item_nsprefix_ + ":"
                if (UseCapturedNS_ and self.item_nsprefix_)
                else ""
            )
            item_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="item",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "item":
            obj_ = DeleteNotification.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.item.append(obj_)
            obj_.original_tagname_ = "item"


# end class ArrayOfDeletenotification


class deleteShipmentsResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, deleteShipmentsResult=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.deleteShipmentsResult = deleteShipmentsResult
        self.deleteShipmentsResult_nsprefix_ = "tns"

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, deleteShipmentsResponse
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if deleteShipmentsResponse.subclass:
            return deleteShipmentsResponse.subclass(*args_, **kwargs_)
        else:
            return deleteShipmentsResponse(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_deleteShipmentsResult(self):
        return self.deleteShipmentsResult

    def set_deleteShipmentsResult(self, deleteShipmentsResult):
        self.deleteShipmentsResult = deleteShipmentsResult

    def _hasContent(self):
        if self.deleteShipmentsResult is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="deleteShipmentsResponse",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("deleteShipmentsResponse")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "deleteShipmentsResponse":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="deleteShipmentsResponse",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="deleteShipmentsResponse",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="deleteShipmentsResponse",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="deleteShipmentsResponse",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.deleteShipmentsResult is not None:
            namespaceprefix_ = (
                self.deleteShipmentsResult_nsprefix_ + ":"
                if (UseCapturedNS_ and self.deleteShipmentsResult_nsprefix_)
                else ""
            )
            self.deleteShipmentsResult.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="deleteShipmentsResult",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "deleteShipmentsResult":
            obj_ = ArrayOfDeletenotification.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.deleteShipmentsResult = obj_
            obj_.original_tagname_ = "deleteShipmentsResult"


# end class deleteShipmentsResponse


class getMyShipments(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(
        self,
        authData=None,
        createdFrom=None,
        createdTo=None,
        offset=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.authData = authData
        self.authData_nsprefix_ = "tns"
        self.createdFrom = createdFrom
        self.createdFrom_nsprefix_ = None
        self.createdTo = createdTo
        self.createdTo_nsprefix_ = None
        self.offset = offset
        self.offset_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, getMyShipments)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getMyShipments.subclass:
            return getMyShipments.subclass(*args_, **kwargs_)
        else:
            return getMyShipments(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_authData(self):
        return self.authData

    def set_authData(self, authData):
        self.authData = authData

    def get_createdFrom(self):
        return self.createdFrom

    def set_createdFrom(self, createdFrom):
        self.createdFrom = createdFrom

    def get_createdTo(self):
        return self.createdTo

    def set_createdTo(self, createdTo):
        self.createdTo = createdTo

    def get_offset(self):
        return self.offset

    def set_offset(self, offset):
        self.offset = offset

    def _hasContent(self):
        if (
            self.authData is not None
            or self.createdFrom is not None
            or self.createdTo is not None
            or self.offset is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="getMyShipments",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("getMyShipments")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "getMyShipments":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="getMyShipments"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="getMyShipments",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="getMyShipments",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="getMyShipments",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.authData is not None:
            namespaceprefix_ = (
                self.authData_nsprefix_ + ":"
                if (UseCapturedNS_ and self.authData_nsprefix_)
                else ""
            )
            self.authData.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="authData",
                pretty_print=pretty_print,
            )
        if self.createdFrom is not None:
            namespaceprefix_ = (
                self.createdFrom_nsprefix_ + ":"
                if (UseCapturedNS_ and self.createdFrom_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%screatedFrom>%s</%screatedFrom>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.createdFrom), input_name="createdFrom"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.createdTo is not None:
            namespaceprefix_ = (
                self.createdTo_nsprefix_ + ":"
                if (UseCapturedNS_ and self.createdTo_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%screatedTo>%s</%screatedTo>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.createdTo), input_name="createdTo"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.offset is not None:
            namespaceprefix_ = (
                self.offset_nsprefix_ + ":"
                if (UseCapturedNS_ and self.offset_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%soffset>%s</%soffset>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_integer(self.offset, input_name="offset"),
                    namespaceprefix_,
                    eol_,
                )
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "authData":
            obj_ = AuthData.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.authData = obj_
            obj_.original_tagname_ = "authData"
        elif nodeName_ == "createdFrom":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "createdFrom")
            value_ = self.gds_validate_string(value_, node, "createdFrom")
            self.createdFrom = value_
            self.createdFrom_nsprefix_ = child_.prefix
        elif nodeName_ == "createdTo":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "createdTo")
            value_ = self.gds_validate_string(value_, node, "createdTo")
            self.createdTo = value_
            self.createdTo_nsprefix_ = child_.prefix
        elif nodeName_ == "offset" and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, "offset")
            ival_ = self.gds_validate_integer(ival_, node, "offset")
            self.offset = ival_
            self.offset_nsprefix_ = child_.prefix


# end class getMyShipments


class getMyShipmentsResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, getMyShipmentsResult=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.getMyShipmentsResult = getMyShipmentsResult
        self.getMyShipmentsResult_nsprefix_ = "tns"

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, getMyShipmentsResponse
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getMyShipmentsResponse.subclass:
            return getMyShipmentsResponse.subclass(*args_, **kwargs_)
        else:
            return getMyShipmentsResponse(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_getMyShipmentsResult(self):
        return self.getMyShipmentsResult

    def set_getMyShipmentsResult(self, getMyShipmentsResult):
        self.getMyShipmentsResult = getMyShipmentsResult

    def _hasContent(self):
        if self.getMyShipmentsResult is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="getMyShipmentsResponse",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("getMyShipmentsResponse")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "getMyShipmentsResponse":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="getMyShipmentsResponse",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="getMyShipmentsResponse",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="getMyShipmentsResponse",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="getMyShipmentsResponse",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.getMyShipmentsResult is not None:
            namespaceprefix_ = (
                self.getMyShipmentsResult_nsprefix_ + ":"
                if (UseCapturedNS_ and self.getMyShipmentsResult_nsprefix_)
                else ""
            )
            self.getMyShipmentsResult.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="getMyShipmentsResult",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "getMyShipmentsResult":
            obj_ = ArrayOfShipmentbasicdata.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.getMyShipmentsResult = obj_
            obj_.original_tagname_ = "getMyShipmentsResult"


# end class getMyShipmentsResponse


class getMyShipmentsCount(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(
        self,
        authData=None,
        createdFrom=None,
        createdTo=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.authData = authData
        self.authData_nsprefix_ = "tns"
        self.createdFrom = createdFrom
        self.createdFrom_nsprefix_ = None
        self.createdTo = createdTo
        self.createdTo_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, getMyShipmentsCount
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getMyShipmentsCount.subclass:
            return getMyShipmentsCount.subclass(*args_, **kwargs_)
        else:
            return getMyShipmentsCount(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_authData(self):
        return self.authData

    def set_authData(self, authData):
        self.authData = authData

    def get_createdFrom(self):
        return self.createdFrom

    def set_createdFrom(self, createdFrom):
        self.createdFrom = createdFrom

    def get_createdTo(self):
        return self.createdTo

    def set_createdTo(self, createdTo):
        self.createdTo = createdTo

    def _hasContent(self):
        if (
            self.authData is not None
            or self.createdFrom is not None
            or self.createdTo is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="getMyShipmentsCount",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("getMyShipmentsCount")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "getMyShipmentsCount":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="getMyShipmentsCount",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="getMyShipmentsCount",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="getMyShipmentsCount",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="getMyShipmentsCount",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.authData is not None:
            namespaceprefix_ = (
                self.authData_nsprefix_ + ":"
                if (UseCapturedNS_ and self.authData_nsprefix_)
                else ""
            )
            self.authData.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="authData",
                pretty_print=pretty_print,
            )
        if self.createdFrom is not None:
            namespaceprefix_ = (
                self.createdFrom_nsprefix_ + ":"
                if (UseCapturedNS_ and self.createdFrom_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%screatedFrom>%s</%screatedFrom>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.createdFrom), input_name="createdFrom"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.createdTo is not None:
            namespaceprefix_ = (
                self.createdTo_nsprefix_ + ":"
                if (UseCapturedNS_ and self.createdTo_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%screatedTo>%s</%screatedTo>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.createdTo), input_name="createdTo"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "authData":
            obj_ = AuthData.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.authData = obj_
            obj_.original_tagname_ = "authData"
        elif nodeName_ == "createdFrom":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "createdFrom")
            value_ = self.gds_validate_string(value_, node, "createdFrom")
            self.createdFrom = value_
            self.createdFrom_nsprefix_ = child_.prefix
        elif nodeName_ == "createdTo":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "createdTo")
            value_ = self.gds_validate_string(value_, node, "createdTo")
            self.createdTo = value_
            self.createdTo_nsprefix_ = child_.prefix


# end class getMyShipmentsCount


class getMyShipmentsCountResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, getMyShipmentsCountResult=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.getMyShipmentsCountResult = getMyShipmentsCountResult
        self.getMyShipmentsCountResult_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, getMyShipmentsCountResponse
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getMyShipmentsCountResponse.subclass:
            return getMyShipmentsCountResponse.subclass(*args_, **kwargs_)
        else:
            return getMyShipmentsCountResponse(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_getMyShipmentsCountResult(self):
        return self.getMyShipmentsCountResult

    def set_getMyShipmentsCountResult(self, getMyShipmentsCountResult):
        self.getMyShipmentsCountResult = getMyShipmentsCountResult

    def _hasContent(self):
        if self.getMyShipmentsCountResult is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="getMyShipmentsCountResponse",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("getMyShipmentsCountResponse")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if (
            self.original_tagname_ is not None
            and name_ == "getMyShipmentsCountResponse"
        ):
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="getMyShipmentsCountResponse",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="getMyShipmentsCountResponse",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="getMyShipmentsCountResponse",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="getMyShipmentsCountResponse",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.getMyShipmentsCountResult is not None:
            namespaceprefix_ = (
                self.getMyShipmentsCountResult_nsprefix_ + ":"
                if (UseCapturedNS_ and self.getMyShipmentsCountResult_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sgetMyShipmentsCountResult>%s</%sgetMyShipmentsCountResult>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_integer(
                        self.getMyShipmentsCountResult,
                        input_name="getMyShipmentsCountResult",
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "getMyShipmentsCountResult" and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, "getMyShipmentsCountResult")
            ival_ = self.gds_validate_integer(ival_, node, "getMyShipmentsCountResult")
            self.getMyShipmentsCountResult = ival_
            self.getMyShipmentsCountResult_nsprefix_ = child_.prefix


# end class getMyShipmentsCountResponse


class getPostalCodeServices(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(
        self,
        authData=None,
        postCode=None,
        pickupDate=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.authData = authData
        self.authData_nsprefix_ = "tns"
        self.postCode = postCode
        self.postCode_nsprefix_ = None
        self.pickupDate = pickupDate
        self.pickupDate_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, getPostalCodeServices
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getPostalCodeServices.subclass:
            return getPostalCodeServices.subclass(*args_, **kwargs_)
        else:
            return getPostalCodeServices(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_authData(self):
        return self.authData

    def set_authData(self, authData):
        self.authData = authData

    def get_postCode(self):
        return self.postCode

    def set_postCode(self, postCode):
        self.postCode = postCode

    def get_pickupDate(self):
        return self.pickupDate

    def set_pickupDate(self, pickupDate):
        self.pickupDate = pickupDate

    def _hasContent(self):
        if (
            self.authData is not None
            or self.postCode is not None
            or self.pickupDate is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="getPostalCodeServices",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("getPostalCodeServices")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "getPostalCodeServices":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="getPostalCodeServices",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="getPostalCodeServices",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="getPostalCodeServices",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="getPostalCodeServices",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.authData is not None:
            namespaceprefix_ = (
                self.authData_nsprefix_ + ":"
                if (UseCapturedNS_ and self.authData_nsprefix_)
                else ""
            )
            self.authData.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="authData",
                pretty_print=pretty_print,
            )
        if self.postCode is not None:
            namespaceprefix_ = (
                self.postCode_nsprefix_ + ":"
                if (UseCapturedNS_ and self.postCode_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%spostCode>%s</%spostCode>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.postCode), input_name="postCode"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.pickupDate is not None:
            namespaceprefix_ = (
                self.pickupDate_nsprefix_ + ":"
                if (UseCapturedNS_ and self.pickupDate_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%spickupDate>%s</%spickupDate>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.pickupDate), input_name="pickupDate"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "authData":
            obj_ = AuthData.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.authData = obj_
            obj_.original_tagname_ = "authData"
        elif nodeName_ == "postCode":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "postCode")
            value_ = self.gds_validate_string(value_, node, "postCode")
            self.postCode = value_
            self.postCode_nsprefix_ = child_.prefix
        elif nodeName_ == "pickupDate":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "pickupDate")
            value_ = self.gds_validate_string(value_, node, "pickupDate")
            self.pickupDate = value_
            self.pickupDate_nsprefix_ = child_.prefix


# end class getPostalCodeServices


class PostalCodeServicesResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(
        self,
        domesticExpress9=None,
        domesticExpress12=None,
        deliveryEvening=None,
        pickupOnSaturday=None,
        deliverySaturday=None,
        exPickupFrom=None,
        exPickupTo=None,
        drPickupFrom=None,
        drPickupTo=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.domesticExpress9 = domesticExpress9
        self.domesticExpress9_nsprefix_ = None
        self.domesticExpress12 = domesticExpress12
        self.domesticExpress12_nsprefix_ = None
        self.deliveryEvening = deliveryEvening
        self.deliveryEvening_nsprefix_ = None
        self.pickupOnSaturday = pickupOnSaturday
        self.pickupOnSaturday_nsprefix_ = None
        self.deliverySaturday = deliverySaturday
        self.deliverySaturday_nsprefix_ = None
        self.exPickupFrom = exPickupFrom
        self.exPickupFrom_nsprefix_ = None
        self.exPickupTo = exPickupTo
        self.exPickupTo_nsprefix_ = None
        self.drPickupFrom = drPickupFrom
        self.drPickupFrom_nsprefix_ = None
        self.drPickupTo = drPickupTo
        self.drPickupTo_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PostalCodeServicesResponse
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PostalCodeServicesResponse.subclass:
            return PostalCodeServicesResponse.subclass(*args_, **kwargs_)
        else:
            return PostalCodeServicesResponse(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_domesticExpress9(self):
        return self.domesticExpress9

    def set_domesticExpress9(self, domesticExpress9):
        self.domesticExpress9 = domesticExpress9

    def get_domesticExpress12(self):
        return self.domesticExpress12

    def set_domesticExpress12(self, domesticExpress12):
        self.domesticExpress12 = domesticExpress12

    def get_deliveryEvening(self):
        return self.deliveryEvening

    def set_deliveryEvening(self, deliveryEvening):
        self.deliveryEvening = deliveryEvening

    def get_pickupOnSaturday(self):
        return self.pickupOnSaturday

    def set_pickupOnSaturday(self, pickupOnSaturday):
        self.pickupOnSaturday = pickupOnSaturday

    def get_deliverySaturday(self):
        return self.deliverySaturday

    def set_deliverySaturday(self, deliverySaturday):
        self.deliverySaturday = deliverySaturday

    def get_exPickupFrom(self):
        return self.exPickupFrom

    def set_exPickupFrom(self, exPickupFrom):
        self.exPickupFrom = exPickupFrom

    def get_exPickupTo(self):
        return self.exPickupTo

    def set_exPickupTo(self, exPickupTo):
        self.exPickupTo = exPickupTo

    def get_drPickupFrom(self):
        return self.drPickupFrom

    def set_drPickupFrom(self, drPickupFrom):
        self.drPickupFrom = drPickupFrom

    def get_drPickupTo(self):
        return self.drPickupTo

    def set_drPickupTo(self, drPickupTo):
        self.drPickupTo = drPickupTo

    def _hasContent(self):
        if (
            self.domesticExpress9 is not None
            or self.domesticExpress12 is not None
            or self.deliveryEvening is not None
            or self.pickupOnSaturday is not None
            or self.deliverySaturday is not None
            or self.exPickupFrom is not None
            or self.exPickupTo is not None
            or self.drPickupFrom is not None
            or self.drPickupTo is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="PostalCodeServicesResponse",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("PostalCodeServicesResponse")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "PostalCodeServicesResponse":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="PostalCodeServicesResponse",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="PostalCodeServicesResponse",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="PostalCodeServicesResponse",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="PostalCodeServicesResponse",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.domesticExpress9 is not None:
            namespaceprefix_ = (
                self.domesticExpress9_nsprefix_ + ":"
                if (UseCapturedNS_ and self.domesticExpress9_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sdomesticExpress9>%s</%sdomesticExpress9>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_boolean(
                        self.domesticExpress9, input_name="domesticExpress9"
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.domesticExpress12 is not None:
            namespaceprefix_ = (
                self.domesticExpress12_nsprefix_ + ":"
                if (UseCapturedNS_ and self.domesticExpress12_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sdomesticExpress12>%s</%sdomesticExpress12>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_boolean(
                        self.domesticExpress12, input_name="domesticExpress12"
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.deliveryEvening is not None:
            namespaceprefix_ = (
                self.deliveryEvening_nsprefix_ + ":"
                if (UseCapturedNS_ and self.deliveryEvening_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sdeliveryEvening>%s</%sdeliveryEvening>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_boolean(
                        self.deliveryEvening, input_name="deliveryEvening"
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.pickupOnSaturday is not None:
            namespaceprefix_ = (
                self.pickupOnSaturday_nsprefix_ + ":"
                if (UseCapturedNS_ and self.pickupOnSaturday_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%spickupOnSaturday>%s</%spickupOnSaturday>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_boolean(
                        self.pickupOnSaturday, input_name="pickupOnSaturday"
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.deliverySaturday is not None:
            namespaceprefix_ = (
                self.deliverySaturday_nsprefix_ + ":"
                if (UseCapturedNS_ and self.deliverySaturday_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sdeliverySaturday>%s</%sdeliverySaturday>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_boolean(
                        self.deliverySaturday, input_name="deliverySaturday"
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.exPickupFrom is not None:
            namespaceprefix_ = (
                self.exPickupFrom_nsprefix_ + ":"
                if (UseCapturedNS_ and self.exPickupFrom_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sexPickupFrom>%s</%sexPickupFrom>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.exPickupFrom), input_name="exPickupFrom"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.exPickupTo is not None:
            namespaceprefix_ = (
                self.exPickupTo_nsprefix_ + ":"
                if (UseCapturedNS_ and self.exPickupTo_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sexPickupTo>%s</%sexPickupTo>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.exPickupTo), input_name="exPickupTo"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.drPickupFrom is not None:
            namespaceprefix_ = (
                self.drPickupFrom_nsprefix_ + ":"
                if (UseCapturedNS_ and self.drPickupFrom_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sdrPickupFrom>%s</%sdrPickupFrom>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.drPickupFrom), input_name="drPickupFrom"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.drPickupTo is not None:
            namespaceprefix_ = (
                self.drPickupTo_nsprefix_ + ":"
                if (UseCapturedNS_ and self.drPickupTo_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sdrPickupTo>%s</%sdrPickupTo>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.drPickupTo), input_name="drPickupTo"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "domesticExpress9":
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, "domesticExpress9")
            ival_ = self.gds_validate_boolean(ival_, node, "domesticExpress9")
            self.domesticExpress9 = ival_
            self.domesticExpress9_nsprefix_ = child_.prefix
        elif nodeName_ == "domesticExpress12":
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, "domesticExpress12")
            ival_ = self.gds_validate_boolean(ival_, node, "domesticExpress12")
            self.domesticExpress12 = ival_
            self.domesticExpress12_nsprefix_ = child_.prefix
        elif nodeName_ == "deliveryEvening":
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, "deliveryEvening")
            ival_ = self.gds_validate_boolean(ival_, node, "deliveryEvening")
            self.deliveryEvening = ival_
            self.deliveryEvening_nsprefix_ = child_.prefix
        elif nodeName_ == "pickupOnSaturday":
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, "pickupOnSaturday")
            ival_ = self.gds_validate_boolean(ival_, node, "pickupOnSaturday")
            self.pickupOnSaturday = ival_
            self.pickupOnSaturday_nsprefix_ = child_.prefix
        elif nodeName_ == "deliverySaturday":
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, "deliverySaturday")
            ival_ = self.gds_validate_boolean(ival_, node, "deliverySaturday")
            self.deliverySaturday = ival_
            self.deliverySaturday_nsprefix_ = child_.prefix
        elif nodeName_ == "exPickupFrom":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "exPickupFrom")
            value_ = self.gds_validate_string(value_, node, "exPickupFrom")
            self.exPickupFrom = value_
            self.exPickupFrom_nsprefix_ = child_.prefix
        elif nodeName_ == "exPickupTo":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "exPickupTo")
            value_ = self.gds_validate_string(value_, node, "exPickupTo")
            self.exPickupTo = value_
            self.exPickupTo_nsprefix_ = child_.prefix
        elif nodeName_ == "drPickupFrom":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "drPickupFrom")
            value_ = self.gds_validate_string(value_, node, "drPickupFrom")
            self.drPickupFrom = value_
            self.drPickupFrom_nsprefix_ = child_.prefix
        elif nodeName_ == "drPickupTo":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "drPickupTo")
            value_ = self.gds_validate_string(value_, node, "drPickupTo")
            self.drPickupTo = value_
            self.drPickupTo_nsprefix_ = child_.prefix


# end class PostalCodeServicesResponse


class getPostalCodeServicesResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(
        self, getPostalCodeServicesResult=None, gds_collector_=None, **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.getPostalCodeServicesResult = getPostalCodeServicesResult
        self.getPostalCodeServicesResult_nsprefix_ = "tns"

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, getPostalCodeServicesResponse
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getPostalCodeServicesResponse.subclass:
            return getPostalCodeServicesResponse.subclass(*args_, **kwargs_)
        else:
            return getPostalCodeServicesResponse(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_getPostalCodeServicesResult(self):
        return self.getPostalCodeServicesResult

    def set_getPostalCodeServicesResult(self, getPostalCodeServicesResult):
        self.getPostalCodeServicesResult = getPostalCodeServicesResult

    def _hasContent(self):
        if self.getPostalCodeServicesResult is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="getPostalCodeServicesResponse",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("getPostalCodeServicesResponse")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if (
            self.original_tagname_ is not None
            and name_ == "getPostalCodeServicesResponse"
        ):
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="getPostalCodeServicesResponse",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="getPostalCodeServicesResponse",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="getPostalCodeServicesResponse",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="getPostalCodeServicesResponse",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.getPostalCodeServicesResult is not None:
            namespaceprefix_ = (
                self.getPostalCodeServicesResult_nsprefix_ + ":"
                if (UseCapturedNS_ and self.getPostalCodeServicesResult_nsprefix_)
                else ""
            )
            self.getPostalCodeServicesResult.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="getPostalCodeServicesResult",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "getPostalCodeServicesResult":
            obj_ = PostalCodeServicesResponse.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.getPostalCodeServicesResult = obj_
            obj_.original_tagname_ = "getPostalCodeServicesResult"


# end class getPostalCodeServicesResponse


class getTrackAndTraceInfo(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, authData=None, shipmentId=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.authData = authData
        self.authData_nsprefix_ = "tns"
        self.shipmentId = shipmentId
        self.shipmentId_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, getTrackAndTraceInfo
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getTrackAndTraceInfo.subclass:
            return getTrackAndTraceInfo.subclass(*args_, **kwargs_)
        else:
            return getTrackAndTraceInfo(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_authData(self):
        return self.authData

    def set_authData(self, authData):
        self.authData = authData

    def get_shipmentId(self):
        return self.shipmentId

    def set_shipmentId(self, shipmentId):
        self.shipmentId = shipmentId

    def _hasContent(self):
        if self.authData is not None or self.shipmentId is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="getTrackAndTraceInfo",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("getTrackAndTraceInfo")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "getTrackAndTraceInfo":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="getTrackAndTraceInfo",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="getTrackAndTraceInfo",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="getTrackAndTraceInfo",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="getTrackAndTraceInfo",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.authData is not None:
            namespaceprefix_ = (
                self.authData_nsprefix_ + ":"
                if (UseCapturedNS_ and self.authData_nsprefix_)
                else ""
            )
            self.authData.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="authData",
                pretty_print=pretty_print,
            )
        if self.shipmentId is not None:
            namespaceprefix_ = (
                self.shipmentId_nsprefix_ + ":"
                if (UseCapturedNS_ and self.shipmentId_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sshipmentId>%s</%sshipmentId>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.shipmentId), input_name="shipmentId"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "authData":
            obj_ = AuthData.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.authData = obj_
            obj_.original_tagname_ = "authData"
        elif nodeName_ == "shipmentId":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "shipmentId")
            value_ = self.gds_validate_string(value_, node, "shipmentId")
            self.shipmentId = value_
            self.shipmentId_nsprefix_ = child_.prefix


# end class getTrackAndTraceInfo


class TrackAndTraceEvent(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(
        self,
        status=None,
        description=None,
        terminal=None,
        timestamp=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.status = status
        self.status_nsprefix_ = None
        self.description = description
        self.description_nsprefix_ = None
        self.terminal = terminal
        self.terminal_nsprefix_ = None
        self.timestamp = timestamp
        self.timestamp_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TrackAndTraceEvent
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TrackAndTraceEvent.subclass:
            return TrackAndTraceEvent.subclass(*args_, **kwargs_)
        else:
            return TrackAndTraceEvent(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_status(self):
        return self.status

    def set_status(self, status):
        self.status = status

    def get_description(self):
        return self.description

    def set_description(self, description):
        self.description = description

    def get_terminal(self):
        return self.terminal

    def set_terminal(self, terminal):
        self.terminal = terminal

    def get_timestamp(self):
        return self.timestamp

    def set_timestamp(self, timestamp):
        self.timestamp = timestamp

    def _hasContent(self):
        if (
            self.status is not None
            or self.description is not None
            or self.terminal is not None
            or self.timestamp is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="TrackAndTraceEvent",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("TrackAndTraceEvent")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "TrackAndTraceEvent":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="TrackAndTraceEvent",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="TrackAndTraceEvent",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="TrackAndTraceEvent",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="TrackAndTraceEvent",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.status is not None:
            namespaceprefix_ = (
                self.status_nsprefix_ + ":"
                if (UseCapturedNS_ and self.status_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sstatus>%s</%sstatus>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.status), input_name="status"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.description is not None:
            namespaceprefix_ = (
                self.description_nsprefix_ + ":"
                if (UseCapturedNS_ and self.description_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sdescription>%s</%sdescription>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.description), input_name="description"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.terminal is not None:
            namespaceprefix_ = (
                self.terminal_nsprefix_ + ":"
                if (UseCapturedNS_ and self.terminal_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sterminal>%s</%sterminal>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.terminal), input_name="terminal"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.timestamp is not None:
            namespaceprefix_ = (
                self.timestamp_nsprefix_ + ":"
                if (UseCapturedNS_ and self.timestamp_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%stimestamp>%s</%stimestamp>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.timestamp), input_name="timestamp"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "status":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "status")
            value_ = self.gds_validate_string(value_, node, "status")
            self.status = value_
            self.status_nsprefix_ = child_.prefix
        elif nodeName_ == "description":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "description")
            value_ = self.gds_validate_string(value_, node, "description")
            self.description = value_
            self.description_nsprefix_ = child_.prefix
        elif nodeName_ == "terminal":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "terminal")
            value_ = self.gds_validate_string(value_, node, "terminal")
            self.terminal = value_
            self.terminal_nsprefix_ = child_.prefix
        elif nodeName_ == "timestamp":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "timestamp")
            value_ = self.gds_validate_string(value_, node, "timestamp")
            self.timestamp = value_
            self.timestamp_nsprefix_ = child_.prefix


# end class TrackAndTraceEvent


class ArrayOfTrackandtraceevent(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, item=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        if item is None:
            self.item = []
        else:
            self.item = item
        self.item_nsprefix_ = "tns"

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ArrayOfTrackandtraceevent
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ArrayOfTrackandtraceevent.subclass:
            return ArrayOfTrackandtraceevent.subclass(*args_, **kwargs_)
        else:
            return ArrayOfTrackandtraceevent(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_item(self):
        return self.item

    def set_item(self, item):
        self.item = item

    def add_item(self, value):
        self.item.append(value)

    def insert_item_at(self, index, value):
        self.item.insert(index, value)

    def replace_item_at(self, index, value):
        self.item[index] = value

    def _hasContent(self):
        if self.item:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ArrayOfTrackandtraceevent",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ArrayOfTrackandtraceevent")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "ArrayOfTrackandtraceevent":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="ArrayOfTrackandtraceevent",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ArrayOfTrackandtraceevent",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="ArrayOfTrackandtraceevent",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ArrayOfTrackandtraceevent",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for item_ in self.item:
            namespaceprefix_ = (
                self.item_nsprefix_ + ":"
                if (UseCapturedNS_ and self.item_nsprefix_)
                else ""
            )
            item_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="item",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "item":
            obj_ = TrackAndTraceEvent.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.item.append(obj_)
            obj_.original_tagname_ = "item"


# end class ArrayOfTrackandtraceevent


class TrackAndTraceResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(
        self,
        shipmentId=None,
        receivedBy=None,
        events=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.shipmentId = shipmentId
        self.shipmentId_nsprefix_ = None
        self.receivedBy = receivedBy
        self.receivedBy_nsprefix_ = None
        self.events = events
        self.events_nsprefix_ = "tns"

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TrackAndTraceResponse
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TrackAndTraceResponse.subclass:
            return TrackAndTraceResponse.subclass(*args_, **kwargs_)
        else:
            return TrackAndTraceResponse(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_shipmentId(self):
        return self.shipmentId

    def set_shipmentId(self, shipmentId):
        self.shipmentId = shipmentId

    def get_receivedBy(self):
        return self.receivedBy

    def set_receivedBy(self, receivedBy):
        self.receivedBy = receivedBy

    def get_events(self):
        return self.events

    def set_events(self, events):
        self.events = events

    def _hasContent(self):
        if (
            self.shipmentId is not None
            or self.receivedBy is not None
            or self.events is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="TrackAndTraceResponse",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("TrackAndTraceResponse")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "TrackAndTraceResponse":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="TrackAndTraceResponse",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="TrackAndTraceResponse",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="TrackAndTraceResponse",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="TrackAndTraceResponse",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.shipmentId is not None:
            namespaceprefix_ = (
                self.shipmentId_nsprefix_ + ":"
                if (UseCapturedNS_ and self.shipmentId_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sshipmentId>%s</%sshipmentId>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.shipmentId), input_name="shipmentId"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.receivedBy is not None:
            namespaceprefix_ = (
                self.receivedBy_nsprefix_ + ":"
                if (UseCapturedNS_ and self.receivedBy_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sreceivedBy>%s</%sreceivedBy>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.receivedBy), input_name="receivedBy"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.events is not None:
            namespaceprefix_ = (
                self.events_nsprefix_ + ":"
                if (UseCapturedNS_ and self.events_nsprefix_)
                else ""
            )
            self.events.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="events",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "shipmentId":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "shipmentId")
            value_ = self.gds_validate_string(value_, node, "shipmentId")
            self.shipmentId = value_
            self.shipmentId_nsprefix_ = child_.prefix
        elif nodeName_ == "receivedBy":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "receivedBy")
            value_ = self.gds_validate_string(value_, node, "receivedBy")
            self.receivedBy = value_
            self.receivedBy_nsprefix_ = child_.prefix
        elif nodeName_ == "events":
            obj_ = ArrayOfTrackandtraceevent.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.events = obj_
            obj_.original_tagname_ = "events"


# end class TrackAndTraceResponse


class getTrackAndTraceInfoResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, getTrackAndTraceInfoResult=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.getTrackAndTraceInfoResult = getTrackAndTraceInfoResult
        self.getTrackAndTraceInfoResult_nsprefix_ = "tns"

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, getTrackAndTraceInfoResponse
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getTrackAndTraceInfoResponse.subclass:
            return getTrackAndTraceInfoResponse.subclass(*args_, **kwargs_)
        else:
            return getTrackAndTraceInfoResponse(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_getTrackAndTraceInfoResult(self):
        return self.getTrackAndTraceInfoResult

    def set_getTrackAndTraceInfoResult(self, getTrackAndTraceInfoResult):
        self.getTrackAndTraceInfoResult = getTrackAndTraceInfoResult

    def _hasContent(self):
        if self.getTrackAndTraceInfoResult is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="getTrackAndTraceInfoResponse",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("getTrackAndTraceInfoResponse")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if (
            self.original_tagname_ is not None
            and name_ == "getTrackAndTraceInfoResponse"
        ):
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="getTrackAndTraceInfoResponse",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="getTrackAndTraceInfoResponse",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="getTrackAndTraceInfoResponse",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="getTrackAndTraceInfoResponse",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.getTrackAndTraceInfoResult is not None:
            namespaceprefix_ = (
                self.getTrackAndTraceInfoResult_nsprefix_ + ":"
                if (UseCapturedNS_ and self.getTrackAndTraceInfoResult_nsprefix_)
                else ""
            )
            self.getTrackAndTraceInfoResult.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="getTrackAndTraceInfoResult",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "getTrackAndTraceInfoResult":
            obj_ = TrackAndTraceResponse.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.getTrackAndTraceInfoResult = obj_
            obj_.original_tagname_ = "getTrackAndTraceInfoResult"


# end class getTrackAndTraceInfoResponse


class ShipmentOrderInfo(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(
        self,
        shipper=None,
        numberOfExPieces=None,
        numberOfDrPieces=None,
        totalWeight=None,
        heaviestPieceWeight=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.shipper = shipper
        self.shipper_nsprefix_ = "tns"
        self.numberOfExPieces = numberOfExPieces
        self.numberOfExPieces_nsprefix_ = None
        self.numberOfDrPieces = numberOfDrPieces
        self.numberOfDrPieces_nsprefix_ = None
        self.totalWeight = totalWeight
        self.totalWeight_nsprefix_ = None
        self.heaviestPieceWeight = heaviestPieceWeight
        self.heaviestPieceWeight_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, ShipmentOrderInfo)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ShipmentOrderInfo.subclass:
            return ShipmentOrderInfo.subclass(*args_, **kwargs_)
        else:
            return ShipmentOrderInfo(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_shipper(self):
        return self.shipper

    def set_shipper(self, shipper):
        self.shipper = shipper

    def get_numberOfExPieces(self):
        return self.numberOfExPieces

    def set_numberOfExPieces(self, numberOfExPieces):
        self.numberOfExPieces = numberOfExPieces

    def get_numberOfDrPieces(self):
        return self.numberOfDrPieces

    def set_numberOfDrPieces(self, numberOfDrPieces):
        self.numberOfDrPieces = numberOfDrPieces

    def get_totalWeight(self):
        return self.totalWeight

    def set_totalWeight(self, totalWeight):
        self.totalWeight = totalWeight

    def get_heaviestPieceWeight(self):
        return self.heaviestPieceWeight

    def set_heaviestPieceWeight(self, heaviestPieceWeight):
        self.heaviestPieceWeight = heaviestPieceWeight

    def _hasContent(self):
        if (
            self.shipper is not None
            or self.numberOfExPieces is not None
            or self.numberOfDrPieces is not None
            or self.totalWeight is not None
            or self.heaviestPieceWeight is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ShipmentOrderInfo",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ShipmentOrderInfo")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "ShipmentOrderInfo":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="ShipmentOrderInfo",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ShipmentOrderInfo",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="ShipmentOrderInfo",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ShipmentOrderInfo",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.shipper is not None:
            namespaceprefix_ = (
                self.shipper_nsprefix_ + ":"
                if (UseCapturedNS_ and self.shipper_nsprefix_)
                else ""
            )
            self.shipper.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="shipper",
                pretty_print=pretty_print,
            )
        if self.numberOfExPieces is not None:
            namespaceprefix_ = (
                self.numberOfExPieces_nsprefix_ + ":"
                if (UseCapturedNS_ and self.numberOfExPieces_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%snumberOfExPieces>%s</%snumberOfExPieces>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_integer(
                        self.numberOfExPieces, input_name="numberOfExPieces"
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.numberOfDrPieces is not None:
            namespaceprefix_ = (
                self.numberOfDrPieces_nsprefix_ + ":"
                if (UseCapturedNS_ and self.numberOfDrPieces_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%snumberOfDrPieces>%s</%snumberOfDrPieces>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_integer(
                        self.numberOfDrPieces, input_name="numberOfDrPieces"
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.totalWeight is not None:
            namespaceprefix_ = (
                self.totalWeight_nsprefix_ + ":"
                if (UseCapturedNS_ and self.totalWeight_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%stotalWeight>%s</%stotalWeight>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_integer(self.totalWeight, input_name="totalWeight"),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.heaviestPieceWeight is not None:
            namespaceprefix_ = (
                self.heaviestPieceWeight_nsprefix_ + ":"
                if (UseCapturedNS_ and self.heaviestPieceWeight_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sheaviestPieceWeight>%s</%sheaviestPieceWeight>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_integer(
                        self.heaviestPieceWeight, input_name="heaviestPieceWeight"
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "shipper":
            obj_ = AddressData.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.shipper = obj_
            obj_.original_tagname_ = "shipper"
        elif nodeName_ == "numberOfExPieces" and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, "numberOfExPieces")
            ival_ = self.gds_validate_integer(ival_, node, "numberOfExPieces")
            self.numberOfExPieces = ival_
            self.numberOfExPieces_nsprefix_ = child_.prefix
        elif nodeName_ == "numberOfDrPieces" and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, "numberOfDrPieces")
            ival_ = self.gds_validate_integer(ival_, node, "numberOfDrPieces")
            self.numberOfDrPieces = ival_
            self.numberOfDrPieces_nsprefix_ = child_.prefix
        elif nodeName_ == "totalWeight" and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, "totalWeight")
            ival_ = self.gds_validate_integer(ival_, node, "totalWeight")
            self.totalWeight = ival_
            self.totalWeight_nsprefix_ = child_.prefix
        elif nodeName_ == "heaviestPieceWeight" and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, "heaviestPieceWeight")
            ival_ = self.gds_validate_integer(ival_, node, "heaviestPieceWeight")
            self.heaviestPieceWeight = ival_
            self.heaviestPieceWeight_nsprefix_ = child_.prefix


# end class ShipmentOrderInfo


class bookCourier(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(
        self,
        authData=None,
        pickupDate=None,
        pickupTimeFrom=None,
        pickupTimeTo=None,
        additionalInfo=None,
        shipmentIdList=None,
        shipmentOrderInfo=None,
        courierWithLabel=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.authData = authData
        self.authData_nsprefix_ = "tns"
        self.pickupDate = pickupDate
        self.pickupDate_nsprefix_ = None
        self.pickupTimeFrom = pickupTimeFrom
        self.pickupTimeFrom_nsprefix_ = None
        self.pickupTimeTo = pickupTimeTo
        self.pickupTimeTo_nsprefix_ = None
        self.additionalInfo = additionalInfo
        self.additionalInfo_nsprefix_ = None
        self.shipmentIdList = shipmentIdList
        self.shipmentIdList_nsprefix_ = "tns"
        self.shipmentOrderInfo = shipmentOrderInfo
        self.shipmentOrderInfo_nsprefix_ = "tns"
        self.courierWithLabel = courierWithLabel
        self.courierWithLabel_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, bookCourier)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if bookCourier.subclass:
            return bookCourier.subclass(*args_, **kwargs_)
        else:
            return bookCourier(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_authData(self):
        return self.authData

    def set_authData(self, authData):
        self.authData = authData

    def get_pickupDate(self):
        return self.pickupDate

    def set_pickupDate(self, pickupDate):
        self.pickupDate = pickupDate

    def get_pickupTimeFrom(self):
        return self.pickupTimeFrom

    def set_pickupTimeFrom(self, pickupTimeFrom):
        self.pickupTimeFrom = pickupTimeFrom

    def get_pickupTimeTo(self):
        return self.pickupTimeTo

    def set_pickupTimeTo(self, pickupTimeTo):
        self.pickupTimeTo = pickupTimeTo

    def get_additionalInfo(self):
        return self.additionalInfo

    def set_additionalInfo(self, additionalInfo):
        self.additionalInfo = additionalInfo

    def get_shipmentIdList(self):
        return self.shipmentIdList

    def set_shipmentIdList(self, shipmentIdList):
        self.shipmentIdList = shipmentIdList

    def get_shipmentOrderInfo(self):
        return self.shipmentOrderInfo

    def set_shipmentOrderInfo(self, shipmentOrderInfo):
        self.shipmentOrderInfo = shipmentOrderInfo

    def get_courierWithLabel(self):
        return self.courierWithLabel

    def set_courierWithLabel(self, courierWithLabel):
        self.courierWithLabel = courierWithLabel

    def _hasContent(self):
        if (
            self.authData is not None
            or self.pickupDate is not None
            or self.pickupTimeFrom is not None
            or self.pickupTimeTo is not None
            or self.additionalInfo is not None
            or self.shipmentIdList is not None
            or self.shipmentOrderInfo is not None
            or self.courierWithLabel is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="bookCourier",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("bookCourier")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "bookCourier":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="bookCourier"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="bookCourier",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="bookCourier",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="bookCourier",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.authData is not None:
            namespaceprefix_ = (
                self.authData_nsprefix_ + ":"
                if (UseCapturedNS_ and self.authData_nsprefix_)
                else ""
            )
            self.authData.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="authData",
                pretty_print=pretty_print,
            )
        if self.pickupDate is not None:
            namespaceprefix_ = (
                self.pickupDate_nsprefix_ + ":"
                if (UseCapturedNS_ and self.pickupDate_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%spickupDate>%s</%spickupDate>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.pickupDate), input_name="pickupDate"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.pickupTimeFrom is not None:
            namespaceprefix_ = (
                self.pickupTimeFrom_nsprefix_ + ":"
                if (UseCapturedNS_ and self.pickupTimeFrom_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%spickupTimeFrom>%s</%spickupTimeFrom>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.pickupTimeFrom), input_name="pickupTimeFrom"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.pickupTimeTo is not None:
            namespaceprefix_ = (
                self.pickupTimeTo_nsprefix_ + ":"
                if (UseCapturedNS_ and self.pickupTimeTo_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%spickupTimeTo>%s</%spickupTimeTo>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.pickupTimeTo), input_name="pickupTimeTo"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.additionalInfo is not None:
            namespaceprefix_ = (
                self.additionalInfo_nsprefix_ + ":"
                if (UseCapturedNS_ and self.additionalInfo_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sadditionalInfo>%s</%sadditionalInfo>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.additionalInfo), input_name="additionalInfo"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.shipmentIdList is not None:
            namespaceprefix_ = (
                self.shipmentIdList_nsprefix_ + ":"
                if (UseCapturedNS_ and self.shipmentIdList_nsprefix_)
                else ""
            )
            self.shipmentIdList.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="shipmentIdList",
                pretty_print=pretty_print,
            )
        if self.shipmentOrderInfo is not None:
            namespaceprefix_ = (
                self.shipmentOrderInfo_nsprefix_ + ":"
                if (UseCapturedNS_ and self.shipmentOrderInfo_nsprefix_)
                else ""
            )
            self.shipmentOrderInfo.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="shipmentOrderInfo",
                pretty_print=pretty_print,
            )
        if self.courierWithLabel is not None:
            namespaceprefix_ = (
                self.courierWithLabel_nsprefix_ + ":"
                if (UseCapturedNS_ and self.courierWithLabel_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%scourierWithLabel>%s</%scourierWithLabel>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_boolean(
                        self.courierWithLabel, input_name="courierWithLabel"
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "authData":
            obj_ = AuthData.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.authData = obj_
            obj_.original_tagname_ = "authData"
        elif nodeName_ == "pickupDate":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "pickupDate")
            value_ = self.gds_validate_string(value_, node, "pickupDate")
            self.pickupDate = value_
            self.pickupDate_nsprefix_ = child_.prefix
        elif nodeName_ == "pickupTimeFrom":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "pickupTimeFrom")
            value_ = self.gds_validate_string(value_, node, "pickupTimeFrom")
            self.pickupTimeFrom = value_
            self.pickupTimeFrom_nsprefix_ = child_.prefix
        elif nodeName_ == "pickupTimeTo":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "pickupTimeTo")
            value_ = self.gds_validate_string(value_, node, "pickupTimeTo")
            self.pickupTimeTo = value_
            self.pickupTimeTo_nsprefix_ = child_.prefix
        elif nodeName_ == "additionalInfo":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "additionalInfo")
            value_ = self.gds_validate_string(value_, node, "additionalInfo")
            self.additionalInfo = value_
            self.additionalInfo_nsprefix_ = child_.prefix
        elif nodeName_ == "shipmentIdList":
            obj_ = ArrayOfString.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.shipmentIdList = obj_
            obj_.original_tagname_ = "shipmentIdList"
        elif nodeName_ == "shipmentOrderInfo":
            obj_ = ShipmentOrderInfo.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.shipmentOrderInfo = obj_
            obj_.original_tagname_ = "shipmentOrderInfo"
        elif nodeName_ == "courierWithLabel":
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, "courierWithLabel")
            ival_ = self.gds_validate_boolean(ival_, node, "courierWithLabel")
            self.courierWithLabel = ival_
            self.courierWithLabel_nsprefix_ = child_.prefix


# end class bookCourier


class bookCourierResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, bookCourierResult=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.bookCourierResult = bookCourierResult
        self.bookCourierResult_nsprefix_ = "tns"

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, bookCourierResponse
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if bookCourierResponse.subclass:
            return bookCourierResponse.subclass(*args_, **kwargs_)
        else:
            return bookCourierResponse(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_bookCourierResult(self):
        return self.bookCourierResult

    def set_bookCourierResult(self, bookCourierResult):
        self.bookCourierResult = bookCourierResult

    def _hasContent(self):
        if self.bookCourierResult is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="bookCourierResponse",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("bookCourierResponse")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "bookCourierResponse":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="bookCourierResponse",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="bookCourierResponse",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="bookCourierResponse",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="bookCourierResponse",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.bookCourierResult is not None:
            namespaceprefix_ = (
                self.bookCourierResult_nsprefix_ + ":"
                if (UseCapturedNS_ and self.bookCourierResult_nsprefix_)
                else ""
            )
            self.bookCourierResult.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="bookCourierResult",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "bookCourierResult":
            obj_ = ArrayOfString.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.bookCourierResult = obj_
            obj_.original_tagname_ = "bookCourierResult"


# end class bookCourierResponse


class cancelCourierBooking(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, authData=None, orders=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.authData = authData
        self.authData_nsprefix_ = "tns"
        self.orders = orders
        self.orders_nsprefix_ = "tns"

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, cancelCourierBooking
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if cancelCourierBooking.subclass:
            return cancelCourierBooking.subclass(*args_, **kwargs_)
        else:
            return cancelCourierBooking(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_authData(self):
        return self.authData

    def set_authData(self, authData):
        self.authData = authData

    def get_orders(self):
        return self.orders

    def set_orders(self, orders):
        self.orders = orders

    def _hasContent(self):
        if self.authData is not None or self.orders is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="cancelCourierBooking",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("cancelCourierBooking")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "cancelCourierBooking":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="cancelCourierBooking",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="cancelCourierBooking",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="cancelCourierBooking",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="cancelCourierBooking",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.authData is not None:
            namespaceprefix_ = (
                self.authData_nsprefix_ + ":"
                if (UseCapturedNS_ and self.authData_nsprefix_)
                else ""
            )
            self.authData.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="authData",
                pretty_print=pretty_print,
            )
        if self.orders is not None:
            namespaceprefix_ = (
                self.orders_nsprefix_ + ":"
                if (UseCapturedNS_ and self.orders_nsprefix_)
                else ""
            )
            self.orders.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="orders",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "authData":
            obj_ = AuthData.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.authData = obj_
            obj_.original_tagname_ = "authData"
        elif nodeName_ == "orders":
            obj_ = ArrayOfString.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.orders = obj_
            obj_.original_tagname_ = "orders"


# end class cancelCourierBooking


class cancelCourierBookingResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, cancelCourierBookingResult=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.cancelCourierBookingResult = cancelCourierBookingResult
        self.cancelCourierBookingResult_nsprefix_ = "tns"

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, cancelCourierBookingResponse
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if cancelCourierBookingResponse.subclass:
            return cancelCourierBookingResponse.subclass(*args_, **kwargs_)
        else:
            return cancelCourierBookingResponse(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_cancelCourierBookingResult(self):
        return self.cancelCourierBookingResult

    def set_cancelCourierBookingResult(self, cancelCourierBookingResult):
        self.cancelCourierBookingResult = cancelCourierBookingResult

    def _hasContent(self):
        if self.cancelCourierBookingResult is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="cancelCourierBookingResponse",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("cancelCourierBookingResponse")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if (
            self.original_tagname_ is not None
            and name_ == "cancelCourierBookingResponse"
        ):
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="cancelCourierBookingResponse",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="cancelCourierBookingResponse",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="cancelCourierBookingResponse",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="cancelCourierBookingResponse",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.cancelCourierBookingResult is not None:
            namespaceprefix_ = (
                self.cancelCourierBookingResult_nsprefix_ + ":"
                if (UseCapturedNS_ and self.cancelCourierBookingResult_nsprefix_)
                else ""
            )
            self.cancelCourierBookingResult.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="cancelCourierBookingResult",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "cancelCourierBookingResult":
            obj_ = ArrayOfDeletenotification.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.cancelCourierBookingResult = obj_
            obj_.original_tagname_ = "cancelCourierBookingResult"


# end class cancelCourierBookingResponse


class ItemToPrint(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, labelType=None, shipmentId=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.labelType = labelType
        self.labelType_nsprefix_ = None
        self.shipmentId = shipmentId
        self.shipmentId_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, ItemToPrint)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ItemToPrint.subclass:
            return ItemToPrint.subclass(*args_, **kwargs_)
        else:
            return ItemToPrint(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_labelType(self):
        return self.labelType

    def set_labelType(self, labelType):
        self.labelType = labelType

    def get_shipmentId(self):
        return self.shipmentId

    def set_shipmentId(self, shipmentId):
        self.shipmentId = shipmentId

    def _hasContent(self):
        if self.labelType is not None or self.shipmentId is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ItemToPrint",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ItemToPrint")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "ItemToPrint":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="ItemToPrint"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ItemToPrint",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="ItemToPrint",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ItemToPrint",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.labelType is not None:
            namespaceprefix_ = (
                self.labelType_nsprefix_ + ":"
                if (UseCapturedNS_ and self.labelType_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%slabelType>%s</%slabelType>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.labelType), input_name="labelType"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.shipmentId is not None:
            namespaceprefix_ = (
                self.shipmentId_nsprefix_ + ":"
                if (UseCapturedNS_ and self.shipmentId_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sshipmentId>%s</%sshipmentId>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.shipmentId), input_name="shipmentId"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "labelType":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "labelType")
            value_ = self.gds_validate_string(value_, node, "labelType")
            self.labelType = value_
            self.labelType_nsprefix_ = child_.prefix
        elif nodeName_ == "shipmentId":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "shipmentId")
            value_ = self.gds_validate_string(value_, node, "shipmentId")
            self.shipmentId = value_
            self.shipmentId_nsprefix_ = child_.prefix


# end class ItemToPrint


class ArrayOfItemtoprint(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, item=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        if item is None:
            self.item = []
        else:
            self.item = item
        self.item_nsprefix_ = "tns"

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ArrayOfItemtoprint
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ArrayOfItemtoprint.subclass:
            return ArrayOfItemtoprint.subclass(*args_, **kwargs_)
        else:
            return ArrayOfItemtoprint(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_item(self):
        return self.item

    def set_item(self, item):
        self.item = item

    def add_item(self, value):
        self.item.append(value)

    def insert_item_at(self, index, value):
        self.item.insert(index, value)

    def replace_item_at(self, index, value):
        self.item[index] = value

    def _hasContent(self):
        if self.item:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ArrayOfItemtoprint",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ArrayOfItemtoprint")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "ArrayOfItemtoprint":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="ArrayOfItemtoprint",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ArrayOfItemtoprint",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="ArrayOfItemtoprint",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ArrayOfItemtoprint",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for item_ in self.item:
            namespaceprefix_ = (
                self.item_nsprefix_ + ":"
                if (UseCapturedNS_ and self.item_nsprefix_)
                else ""
            )
            item_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="item",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "item":
            obj_ = ItemToPrint.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.item.append(obj_)
            obj_.original_tagname_ = "item"


# end class ArrayOfItemtoprint


class getLabels(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(
        self, authData=None, itemsToPrint=None, gds_collector_=None, **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.authData = authData
        self.authData_nsprefix_ = "tns"
        self.itemsToPrint = itemsToPrint
        self.itemsToPrint_nsprefix_ = "tns"

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, getLabels)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getLabels.subclass:
            return getLabels.subclass(*args_, **kwargs_)
        else:
            return getLabels(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_authData(self):
        return self.authData

    def set_authData(self, authData):
        self.authData = authData

    def get_itemsToPrint(self):
        return self.itemsToPrint

    def set_itemsToPrint(self, itemsToPrint):
        self.itemsToPrint = itemsToPrint

    def _hasContent(self):
        if self.authData is not None or self.itemsToPrint is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="getLabels",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("getLabels")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "getLabels":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="getLabels"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="getLabels",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="getLabels"
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="getLabels",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.authData is not None:
            namespaceprefix_ = (
                self.authData_nsprefix_ + ":"
                if (UseCapturedNS_ and self.authData_nsprefix_)
                else ""
            )
            self.authData.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="authData",
                pretty_print=pretty_print,
            )
        if self.itemsToPrint is not None:
            namespaceprefix_ = (
                self.itemsToPrint_nsprefix_ + ":"
                if (UseCapturedNS_ and self.itemsToPrint_nsprefix_)
                else ""
            )
            self.itemsToPrint.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="itemsToPrint",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "authData":
            obj_ = AuthData.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.authData = obj_
            obj_.original_tagname_ = "authData"
        elif nodeName_ == "itemsToPrint":
            obj_ = ArrayOfItemtoprint.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.itemsToPrint = obj_
            obj_.original_tagname_ = "itemsToPrint"


# end class getLabels


class ItemToPrintResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(
        self,
        shipmentId=None,
        labelType=None,
        labelName=None,
        labelData=None,
        labelMimeType=None,
        cn23Data=None,
        cn23MimeType=None,
        fvProformaData=None,
        fvProformaMimeType=None,
        fvProformaNumer=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.shipmentId = shipmentId
        self.shipmentId_nsprefix_ = None
        self.labelType = labelType
        self.labelType_nsprefix_ = None
        self.labelName = labelName
        self.labelName_nsprefix_ = None
        self.labelData = labelData
        self.labelData_nsprefix_ = None
        self.labelMimeType = labelMimeType
        self.labelMimeType_nsprefix_ = None
        self.cn23Data = cn23Data
        self.cn23Data_nsprefix_ = None
        self.cn23MimeType = cn23MimeType
        self.cn23MimeType_nsprefix_ = None
        self.fvProformaData = fvProformaData
        self.fvProformaData_nsprefix_ = None
        self.fvProformaMimeType = fvProformaMimeType
        self.fvProformaMimeType_nsprefix_ = None
        self.fvProformaNumer = fvProformaNumer
        self.fvProformaNumer_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ItemToPrintResponse
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ItemToPrintResponse.subclass:
            return ItemToPrintResponse.subclass(*args_, **kwargs_)
        else:
            return ItemToPrintResponse(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_shipmentId(self):
        return self.shipmentId

    def set_shipmentId(self, shipmentId):
        self.shipmentId = shipmentId

    def get_labelType(self):
        return self.labelType

    def set_labelType(self, labelType):
        self.labelType = labelType

    def get_labelName(self):
        return self.labelName

    def set_labelName(self, labelName):
        self.labelName = labelName

    def get_labelData(self):
        return self.labelData

    def set_labelData(self, labelData):
        self.labelData = labelData

    def get_labelMimeType(self):
        return self.labelMimeType

    def set_labelMimeType(self, labelMimeType):
        self.labelMimeType = labelMimeType

    def get_cn23Data(self):
        return self.cn23Data

    def set_cn23Data(self, cn23Data):
        self.cn23Data = cn23Data

    def get_cn23MimeType(self):
        return self.cn23MimeType

    def set_cn23MimeType(self, cn23MimeType):
        self.cn23MimeType = cn23MimeType

    def get_fvProformaData(self):
        return self.fvProformaData

    def set_fvProformaData(self, fvProformaData):
        self.fvProformaData = fvProformaData

    def get_fvProformaMimeType(self):
        return self.fvProformaMimeType

    def set_fvProformaMimeType(self, fvProformaMimeType):
        self.fvProformaMimeType = fvProformaMimeType

    def get_fvProformaNumer(self):
        return self.fvProformaNumer

    def set_fvProformaNumer(self, fvProformaNumer):
        self.fvProformaNumer = fvProformaNumer

    def _hasContent(self):
        if (
            self.shipmentId is not None
            or self.labelType is not None
            or self.labelName is not None
            or self.labelData is not None
            or self.labelMimeType is not None
            or self.cn23Data is not None
            or self.cn23MimeType is not None
            or self.fvProformaData is not None
            or self.fvProformaMimeType is not None
            or self.fvProformaNumer is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ItemToPrintResponse",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ItemToPrintResponse")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "ItemToPrintResponse":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="ItemToPrintResponse",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ItemToPrintResponse",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="ItemToPrintResponse",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ItemToPrintResponse",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.shipmentId is not None:
            namespaceprefix_ = (
                self.shipmentId_nsprefix_ + ":"
                if (UseCapturedNS_ and self.shipmentId_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sshipmentId>%s</%sshipmentId>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.shipmentId), input_name="shipmentId"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.labelType is not None:
            namespaceprefix_ = (
                self.labelType_nsprefix_ + ":"
                if (UseCapturedNS_ and self.labelType_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%slabelType>%s</%slabelType>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.labelType), input_name="labelType"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.labelName is not None:
            namespaceprefix_ = (
                self.labelName_nsprefix_ + ":"
                if (UseCapturedNS_ and self.labelName_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%slabelName>%s</%slabelName>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.labelName), input_name="labelName"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.labelData is not None:
            namespaceprefix_ = (
                self.labelData_nsprefix_ + ":"
                if (UseCapturedNS_ and self.labelData_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%slabelData>%s</%slabelData>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.labelData), input_name="labelData"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.labelMimeType is not None:
            namespaceprefix_ = (
                self.labelMimeType_nsprefix_ + ":"
                if (UseCapturedNS_ and self.labelMimeType_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%slabelMimeType>%s</%slabelMimeType>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.labelMimeType), input_name="labelMimeType"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.cn23Data is not None:
            namespaceprefix_ = (
                self.cn23Data_nsprefix_ + ":"
                if (UseCapturedNS_ and self.cn23Data_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%scn23Data>%s</%scn23Data>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.cn23Data), input_name="cn23Data"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.cn23MimeType is not None:
            namespaceprefix_ = (
                self.cn23MimeType_nsprefix_ + ":"
                if (UseCapturedNS_ and self.cn23MimeType_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%scn23MimeType>%s</%scn23MimeType>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.cn23MimeType), input_name="cn23MimeType"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.fvProformaData is not None:
            namespaceprefix_ = (
                self.fvProformaData_nsprefix_ + ":"
                if (UseCapturedNS_ and self.fvProformaData_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sfvProformaData>%s</%sfvProformaData>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.fvProformaData), input_name="fvProformaData"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.fvProformaMimeType is not None:
            namespaceprefix_ = (
                self.fvProformaMimeType_nsprefix_ + ":"
                if (UseCapturedNS_ and self.fvProformaMimeType_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sfvProformaMimeType>%s</%sfvProformaMimeType>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.fvProformaMimeType),
                            input_name="fvProformaMimeType",
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.fvProformaNumer is not None:
            namespaceprefix_ = (
                self.fvProformaNumer_nsprefix_ + ":"
                if (UseCapturedNS_ and self.fvProformaNumer_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sfvProformaNumer>%s</%sfvProformaNumer>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.fvProformaNumer),
                            input_name="fvProformaNumer",
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "shipmentId":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "shipmentId")
            value_ = self.gds_validate_string(value_, node, "shipmentId")
            self.shipmentId = value_
            self.shipmentId_nsprefix_ = child_.prefix
        elif nodeName_ == "labelType":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "labelType")
            value_ = self.gds_validate_string(value_, node, "labelType")
            self.labelType = value_
            self.labelType_nsprefix_ = child_.prefix
        elif nodeName_ == "labelName":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "labelName")
            value_ = self.gds_validate_string(value_, node, "labelName")
            self.labelName = value_
            self.labelName_nsprefix_ = child_.prefix
        elif nodeName_ == "labelData":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "labelData")
            value_ = self.gds_validate_string(value_, node, "labelData")
            self.labelData = value_
            self.labelData_nsprefix_ = child_.prefix
        elif nodeName_ == "labelMimeType":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "labelMimeType")
            value_ = self.gds_validate_string(value_, node, "labelMimeType")
            self.labelMimeType = value_
            self.labelMimeType_nsprefix_ = child_.prefix
        elif nodeName_ == "cn23Data":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "cn23Data")
            value_ = self.gds_validate_string(value_, node, "cn23Data")
            self.cn23Data = value_
            self.cn23Data_nsprefix_ = child_.prefix
        elif nodeName_ == "cn23MimeType":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "cn23MimeType")
            value_ = self.gds_validate_string(value_, node, "cn23MimeType")
            self.cn23MimeType = value_
            self.cn23MimeType_nsprefix_ = child_.prefix
        elif nodeName_ == "fvProformaData":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "fvProformaData")
            value_ = self.gds_validate_string(value_, node, "fvProformaData")
            self.fvProformaData = value_
            self.fvProformaData_nsprefix_ = child_.prefix
        elif nodeName_ == "fvProformaMimeType":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "fvProformaMimeType")
            value_ = self.gds_validate_string(value_, node, "fvProformaMimeType")
            self.fvProformaMimeType = value_
            self.fvProformaMimeType_nsprefix_ = child_.prefix
        elif nodeName_ == "fvProformaNumer":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "fvProformaNumer")
            value_ = self.gds_validate_string(value_, node, "fvProformaNumer")
            self.fvProformaNumer = value_
            self.fvProformaNumer_nsprefix_ = child_.prefix


# end class ItemToPrintResponse


class ArrayOfItemtoprintresponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, item=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        if item is None:
            self.item = []
        else:
            self.item = item
        self.item_nsprefix_ = "tns"

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ArrayOfItemtoprintresponse
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ArrayOfItemtoprintresponse.subclass:
            return ArrayOfItemtoprintresponse.subclass(*args_, **kwargs_)
        else:
            return ArrayOfItemtoprintresponse(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_item(self):
        return self.item

    def set_item(self, item):
        self.item = item

    def add_item(self, value):
        self.item.append(value)

    def insert_item_at(self, index, value):
        self.item.insert(index, value)

    def replace_item_at(self, index, value):
        self.item[index] = value

    def _hasContent(self):
        if self.item:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ArrayOfItemtoprintresponse",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ArrayOfItemtoprintresponse")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "ArrayOfItemtoprintresponse":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="ArrayOfItemtoprintresponse",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ArrayOfItemtoprintresponse",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="ArrayOfItemtoprintresponse",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ArrayOfItemtoprintresponse",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for item_ in self.item:
            namespaceprefix_ = (
                self.item_nsprefix_ + ":"
                if (UseCapturedNS_ and self.item_nsprefix_)
                else ""
            )
            item_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="item",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "item":
            obj_ = ItemToPrintResponse.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.item.append(obj_)
            obj_.original_tagname_ = "item"


# end class ArrayOfItemtoprintresponse


class getLabelsResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, getLabelsResult=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.getLabelsResult = getLabelsResult
        self.getLabelsResult_nsprefix_ = "tns"

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, getLabelsResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getLabelsResponse.subclass:
            return getLabelsResponse.subclass(*args_, **kwargs_)
        else:
            return getLabelsResponse(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_getLabelsResult(self):
        return self.getLabelsResult

    def set_getLabelsResult(self, getLabelsResult):
        self.getLabelsResult = getLabelsResult

    def _hasContent(self):
        if self.getLabelsResult is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="getLabelsResponse",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("getLabelsResponse")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "getLabelsResponse":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="getLabelsResponse",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="getLabelsResponse",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="getLabelsResponse",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="getLabelsResponse",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.getLabelsResult is not None:
            namespaceprefix_ = (
                self.getLabelsResult_nsprefix_ + ":"
                if (UseCapturedNS_ and self.getLabelsResult_nsprefix_)
                else ""
            )
            self.getLabelsResult.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="getLabelsResult",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "getLabelsResult":
            obj_ = ArrayOfItemtoprintresponse.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.getLabelsResult = obj_
            obj_.original_tagname_ = "getLabelsResult"


# end class getLabelsResponse


class PnpRequest(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(
        self, authData=None, date=None, type_=None, gds_collector_=None, **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.authData = authData
        self.authData_nsprefix_ = "tns"
        self.date = date
        self.date_nsprefix_ = None
        self.type_ = type_
        self.type__nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, PnpRequest)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PnpRequest.subclass:
            return PnpRequest.subclass(*args_, **kwargs_)
        else:
            return PnpRequest(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_authData(self):
        return self.authData

    def set_authData(self, authData):
        self.authData = authData

    def get_date(self):
        return self.date

    def set_date(self, date):
        self.date = date

    def get_type(self):
        return self.type_

    def set_type(self, type_):
        self.type_ = type_

    def _hasContent(self):
        if self.authData is not None or self.date is not None or self.type_ is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="PnpRequest",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("PnpRequest")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "PnpRequest":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="PnpRequest"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="PnpRequest",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="PnpRequest"
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="PnpRequest",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.authData is not None:
            namespaceprefix_ = (
                self.authData_nsprefix_ + ":"
                if (UseCapturedNS_ and self.authData_nsprefix_)
                else ""
            )
            self.authData.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="authData",
                pretty_print=pretty_print,
            )
        if self.date is not None:
            namespaceprefix_ = (
                self.date_nsprefix_ + ":"
                if (UseCapturedNS_ and self.date_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sdate>%s</%sdate>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(quote_xml(self.date), input_name="date")
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.type_ is not None:
            namespaceprefix_ = (
                self.type__nsprefix_ + ":"
                if (UseCapturedNS_ and self.type__nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%stype>%s</%stype>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(quote_xml(self.type_), input_name="type")
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "authData":
            obj_ = AuthData.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.authData = obj_
            obj_.original_tagname_ = "authData"
        elif nodeName_ == "date":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "date")
            value_ = self.gds_validate_string(value_, node, "date")
            self.date = value_
            self.date_nsprefix_ = child_.prefix
        elif nodeName_ == "type":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "type")
            value_ = self.gds_validate_string(value_, node, "type")
            self.type_ = value_
            self.type_nsprefix_ = child_.prefix


# end class PnpRequest


class getPnp(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, pnpRequest=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.pnpRequest = pnpRequest
        self.pnpRequest_nsprefix_ = "tns"

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, getPnp)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getPnp.subclass:
            return getPnp.subclass(*args_, **kwargs_)
        else:
            return getPnp(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_pnpRequest(self):
        return self.pnpRequest

    def set_pnpRequest(self, pnpRequest):
        self.pnpRequest = pnpRequest

    def _hasContent(self):
        if self.pnpRequest is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="getPnp",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("getPnp")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "getPnp":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="getPnp"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="getPnp",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="getPnp"
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="getPnp",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.pnpRequest is not None:
            namespaceprefix_ = (
                self.pnpRequest_nsprefix_ + ":"
                if (UseCapturedNS_ and self.pnpRequest_nsprefix_)
                else ""
            )
            self.pnpRequest.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="pnpRequest",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "pnpRequest":
            obj_ = PnpRequest.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.pnpRequest = obj_
            obj_.original_tagname_ = "pnpRequest"


# end class getPnp


class PnpResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(
        self,
        fileName=None,
        fileData=None,
        fileMimeType=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.fileName = fileName
        self.fileName_nsprefix_ = None
        self.fileData = fileData
        self.fileData_nsprefix_ = None
        self.fileMimeType = fileMimeType
        self.fileMimeType_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, PnpResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PnpResponse.subclass:
            return PnpResponse.subclass(*args_, **kwargs_)
        else:
            return PnpResponse(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_fileName(self):
        return self.fileName

    def set_fileName(self, fileName):
        self.fileName = fileName

    def get_fileData(self):
        return self.fileData

    def set_fileData(self, fileData):
        self.fileData = fileData

    def get_fileMimeType(self):
        return self.fileMimeType

    def set_fileMimeType(self, fileMimeType):
        self.fileMimeType = fileMimeType

    def _hasContent(self):
        if (
            self.fileName is not None
            or self.fileData is not None
            or self.fileMimeType is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="PnpResponse",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("PnpResponse")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "PnpResponse":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="PnpResponse"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="PnpResponse",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="PnpResponse",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="PnpResponse",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.fileName is not None:
            namespaceprefix_ = (
                self.fileName_nsprefix_ + ":"
                if (UseCapturedNS_ and self.fileName_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sfileName>%s</%sfileName>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.fileName), input_name="fileName"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.fileData is not None:
            namespaceprefix_ = (
                self.fileData_nsprefix_ + ":"
                if (UseCapturedNS_ and self.fileData_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sfileData>%s</%sfileData>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.fileData), input_name="fileData"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.fileMimeType is not None:
            namespaceprefix_ = (
                self.fileMimeType_nsprefix_ + ":"
                if (UseCapturedNS_ and self.fileMimeType_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sfileMimeType>%s</%sfileMimeType>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.fileMimeType), input_name="fileMimeType"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "fileName":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "fileName")
            value_ = self.gds_validate_string(value_, node, "fileName")
            self.fileName = value_
            self.fileName_nsprefix_ = child_.prefix
        elif nodeName_ == "fileData":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "fileData")
            value_ = self.gds_validate_string(value_, node, "fileData")
            self.fileData = value_
            self.fileData_nsprefix_ = child_.prefix
        elif nodeName_ == "fileMimeType":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "fileMimeType")
            value_ = self.gds_validate_string(value_, node, "fileMimeType")
            self.fileMimeType = value_
            self.fileMimeType_nsprefix_ = child_.prefix


# end class PnpResponse


class getPnpResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, getPnpResult=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.getPnpResult = getPnpResult
        self.getPnpResult_nsprefix_ = "tns"

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, getPnpResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getPnpResponse.subclass:
            return getPnpResponse.subclass(*args_, **kwargs_)
        else:
            return getPnpResponse(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_getPnpResult(self):
        return self.getPnpResult

    def set_getPnpResult(self, getPnpResult):
        self.getPnpResult = getPnpResult

    def _hasContent(self):
        if self.getPnpResult is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="getPnpResponse",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("getPnpResponse")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "getPnpResponse":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="getPnpResponse"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="getPnpResponse",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="getPnpResponse",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="getPnpResponse",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.getPnpResult is not None:
            namespaceprefix_ = (
                self.getPnpResult_nsprefix_ + ":"
                if (UseCapturedNS_ and self.getPnpResult_nsprefix_)
                else ""
            )
            self.getPnpResult.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="getPnpResult",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "getPnpResult":
            obj_ = PnpResponse.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.getPnpResult = obj_
            obj_.original_tagname_ = "getPnpResult"


# end class getPnpResponse


class getShipmentScan(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, authData=None, shipmentId=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.authData = authData
        self.authData_nsprefix_ = "tns"
        self.shipmentId = shipmentId
        self.shipmentId_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, getShipmentScan)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getShipmentScan.subclass:
            return getShipmentScan.subclass(*args_, **kwargs_)
        else:
            return getShipmentScan(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_authData(self):
        return self.authData

    def set_authData(self, authData):
        self.authData = authData

    def get_shipmentId(self):
        return self.shipmentId

    def set_shipmentId(self, shipmentId):
        self.shipmentId = shipmentId

    def _hasContent(self):
        if self.authData is not None or self.shipmentId is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="getShipmentScan",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("getShipmentScan")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "getShipmentScan":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="getShipmentScan"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="getShipmentScan",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="getShipmentScan",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="getShipmentScan",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.authData is not None:
            namespaceprefix_ = (
                self.authData_nsprefix_ + ":"
                if (UseCapturedNS_ and self.authData_nsprefix_)
                else ""
            )
            self.authData.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="authData",
                pretty_print=pretty_print,
            )
        if self.shipmentId is not None:
            namespaceprefix_ = (
                self.shipmentId_nsprefix_ + ":"
                if (UseCapturedNS_ and self.shipmentId_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sshipmentId>%s</%sshipmentId>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.shipmentId), input_name="shipmentId"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "authData":
            obj_ = AuthData.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.authData = obj_
            obj_.original_tagname_ = "authData"
        elif nodeName_ == "shipmentId":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "shipmentId")
            value_ = self.gds_validate_string(value_, node, "shipmentId")
            self.shipmentId = value_
            self.shipmentId_nsprefix_ = child_.prefix


# end class getShipmentScan


class ScanToPrintResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(
        self, scanData=None, scanMimeType=None, gds_collector_=None, **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.scanData = scanData
        self.scanData_nsprefix_ = None
        self.scanMimeType = scanMimeType
        self.scanMimeType_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ScanToPrintResponse
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ScanToPrintResponse.subclass:
            return ScanToPrintResponse.subclass(*args_, **kwargs_)
        else:
            return ScanToPrintResponse(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_scanData(self):
        return self.scanData

    def set_scanData(self, scanData):
        self.scanData = scanData

    def get_scanMimeType(self):
        return self.scanMimeType

    def set_scanMimeType(self, scanMimeType):
        self.scanMimeType = scanMimeType

    def _hasContent(self):
        if self.scanData is not None or self.scanMimeType is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ScanToPrintResponse",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ScanToPrintResponse")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "ScanToPrintResponse":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="ScanToPrintResponse",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ScanToPrintResponse",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="ScanToPrintResponse",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ScanToPrintResponse",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.scanData is not None:
            namespaceprefix_ = (
                self.scanData_nsprefix_ + ":"
                if (UseCapturedNS_ and self.scanData_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sscanData>%s</%sscanData>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.scanData), input_name="scanData"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.scanMimeType is not None:
            namespaceprefix_ = (
                self.scanMimeType_nsprefix_ + ":"
                if (UseCapturedNS_ and self.scanMimeType_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sscanMimeType>%s</%sscanMimeType>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.scanMimeType), input_name="scanMimeType"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "scanData":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "scanData")
            value_ = self.gds_validate_string(value_, node, "scanData")
            self.scanData = value_
            self.scanData_nsprefix_ = child_.prefix
        elif nodeName_ == "scanMimeType":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "scanMimeType")
            value_ = self.gds_validate_string(value_, node, "scanMimeType")
            self.scanMimeType = value_
            self.scanMimeType_nsprefix_ = child_.prefix


# end class ScanToPrintResponse


class getShipmentScanResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, getShipmentScanResult=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.getShipmentScanResult = getShipmentScanResult
        self.getShipmentScanResult_nsprefix_ = "tns"

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, getShipmentScanResponse
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getShipmentScanResponse.subclass:
            return getShipmentScanResponse.subclass(*args_, **kwargs_)
        else:
            return getShipmentScanResponse(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_getShipmentScanResult(self):
        return self.getShipmentScanResult

    def set_getShipmentScanResult(self, getShipmentScanResult):
        self.getShipmentScanResult = getShipmentScanResult

    def _hasContent(self):
        if self.getShipmentScanResult is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="getShipmentScanResponse",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("getShipmentScanResponse")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "getShipmentScanResponse":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="getShipmentScanResponse",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="getShipmentScanResponse",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="getShipmentScanResponse",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="getShipmentScanResponse",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.getShipmentScanResult is not None:
            namespaceprefix_ = (
                self.getShipmentScanResult_nsprefix_ + ":"
                if (UseCapturedNS_ and self.getShipmentScanResult_nsprefix_)
                else ""
            )
            self.getShipmentScanResult.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="getShipmentScanResult",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "getShipmentScanResult":
            obj_ = ScanToPrintResponse.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.getShipmentScanResult = obj_
            obj_.original_tagname_ = "getShipmentScanResult"


# end class getShipmentScanResponse


class Service(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(
        self,
        serviceType=None,
        serviceValue=None,
        textInstruction=None,
        collectOnDeliveryForm=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.serviceType = serviceType
        self.serviceType_nsprefix_ = None
        self.serviceValue = serviceValue
        self.serviceValue_nsprefix_ = None
        self.textInstruction = textInstruction
        self.textInstruction_nsprefix_ = None
        self.collectOnDeliveryForm = collectOnDeliveryForm
        self.collectOnDeliveryForm_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, Service)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Service.subclass:
            return Service.subclass(*args_, **kwargs_)
        else:
            return Service(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_serviceType(self):
        return self.serviceType

    def set_serviceType(self, serviceType):
        self.serviceType = serviceType

    def get_serviceValue(self):
        return self.serviceValue

    def set_serviceValue(self, serviceValue):
        self.serviceValue = serviceValue

    def get_textInstruction(self):
        return self.textInstruction

    def set_textInstruction(self, textInstruction):
        self.textInstruction = textInstruction

    def get_collectOnDeliveryForm(self):
        return self.collectOnDeliveryForm

    def set_collectOnDeliveryForm(self, collectOnDeliveryForm):
        self.collectOnDeliveryForm = collectOnDeliveryForm

    def _hasContent(self):
        if (
            self.serviceType is not None
            or self.serviceValue is not None
            or self.textInstruction is not None
            or self.collectOnDeliveryForm is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Service",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("Service")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "Service":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Service"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="Service",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="Service"
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Service",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.serviceType is not None:
            namespaceprefix_ = (
                self.serviceType_nsprefix_ + ":"
                if (UseCapturedNS_ and self.serviceType_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sserviceType>%s</%sserviceType>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.serviceType), input_name="serviceType"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.serviceValue is not None:
            namespaceprefix_ = (
                self.serviceValue_nsprefix_ + ":"
                if (UseCapturedNS_ and self.serviceValue_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sserviceValue>%s</%sserviceValue>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_float(self.serviceValue, input_name="serviceValue"),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.textInstruction is not None:
            namespaceprefix_ = (
                self.textInstruction_nsprefix_ + ":"
                if (UseCapturedNS_ and self.textInstruction_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%stextInstruction>%s</%stextInstruction>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.textInstruction),
                            input_name="textInstruction",
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.collectOnDeliveryForm is not None:
            namespaceprefix_ = (
                self.collectOnDeliveryForm_nsprefix_ + ":"
                if (UseCapturedNS_ and self.collectOnDeliveryForm_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%scollectOnDeliveryForm>%s</%scollectOnDeliveryForm>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.collectOnDeliveryForm),
                            input_name="collectOnDeliveryForm",
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "serviceType":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "serviceType")
            value_ = self.gds_validate_string(value_, node, "serviceType")
            self.serviceType = value_
            self.serviceType_nsprefix_ = child_.prefix
        elif nodeName_ == "serviceValue" and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, "serviceValue")
            fval_ = self.gds_validate_float(fval_, node, "serviceValue")
            self.serviceValue = fval_
            self.serviceValue_nsprefix_ = child_.prefix
        elif nodeName_ == "textInstruction":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "textInstruction")
            value_ = self.gds_validate_string(value_, node, "textInstruction")
            self.textInstruction = value_
            self.textInstruction_nsprefix_ = child_.prefix
        elif nodeName_ == "collectOnDeliveryForm":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "collectOnDeliveryForm")
            value_ = self.gds_validate_string(value_, node, "collectOnDeliveryForm")
            self.collectOnDeliveryForm = value_
            self.collectOnDeliveryForm_nsprefix_ = child_.prefix


# end class Service


class ArrayOfService(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, item=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        if item is None:
            self.item = []
        else:
            self.item = item
        self.item_nsprefix_ = "tns"

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, ArrayOfService)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ArrayOfService.subclass:
            return ArrayOfService.subclass(*args_, **kwargs_)
        else:
            return ArrayOfService(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_item(self):
        return self.item

    def set_item(self, item):
        self.item = item

    def add_item(self, value):
        self.item.append(value)

    def insert_item_at(self, index, value):
        self.item.insert(index, value)

    def replace_item_at(self, index, value):
        self.item[index] = value

    def _hasContent(self):
        if self.item:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ArrayOfService",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ArrayOfService")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "ArrayOfService":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="ArrayOfService"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ArrayOfService",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="ArrayOfService",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ArrayOfService",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for item_ in self.item:
            namespaceprefix_ = (
                self.item_nsprefix_ + ":"
                if (UseCapturedNS_ and self.item_nsprefix_)
                else ""
            )
            item_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="item",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "item":
            obj_ = Service.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.item.append(obj_)
            obj_.original_tagname_ = "item"


# end class ArrayOfService


class ShipmentTime(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(
        self,
        shipmentDate=None,
        shipmentStartHour=None,
        shipmentEndHour=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.shipmentDate = shipmentDate
        self.shipmentDate_nsprefix_ = None
        self.shipmentStartHour = shipmentStartHour
        self.shipmentStartHour_nsprefix_ = None
        self.shipmentEndHour = shipmentEndHour
        self.shipmentEndHour_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, ShipmentTime)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ShipmentTime.subclass:
            return ShipmentTime.subclass(*args_, **kwargs_)
        else:
            return ShipmentTime(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_shipmentDate(self):
        return self.shipmentDate

    def set_shipmentDate(self, shipmentDate):
        self.shipmentDate = shipmentDate

    def get_shipmentStartHour(self):
        return self.shipmentStartHour

    def set_shipmentStartHour(self, shipmentStartHour):
        self.shipmentStartHour = shipmentStartHour

    def get_shipmentEndHour(self):
        return self.shipmentEndHour

    def set_shipmentEndHour(self, shipmentEndHour):
        self.shipmentEndHour = shipmentEndHour

    def _hasContent(self):
        if (
            self.shipmentDate is not None
            or self.shipmentStartHour is not None
            or self.shipmentEndHour is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ShipmentTime",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ShipmentTime")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "ShipmentTime":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="ShipmentTime"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ShipmentTime",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="ShipmentTime",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ShipmentTime",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.shipmentDate is not None:
            namespaceprefix_ = (
                self.shipmentDate_nsprefix_ + ":"
                if (UseCapturedNS_ and self.shipmentDate_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sshipmentDate>%s</%sshipmentDate>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.shipmentDate), input_name="shipmentDate"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.shipmentStartHour is not None:
            namespaceprefix_ = (
                self.shipmentStartHour_nsprefix_ + ":"
                if (UseCapturedNS_ and self.shipmentStartHour_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sshipmentStartHour>%s</%sshipmentStartHour>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.shipmentStartHour),
                            input_name="shipmentStartHour",
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.shipmentEndHour is not None:
            namespaceprefix_ = (
                self.shipmentEndHour_nsprefix_ + ":"
                if (UseCapturedNS_ and self.shipmentEndHour_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sshipmentEndHour>%s</%sshipmentEndHour>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.shipmentEndHour),
                            input_name="shipmentEndHour",
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "shipmentDate":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "shipmentDate")
            value_ = self.gds_validate_string(value_, node, "shipmentDate")
            self.shipmentDate = value_
            self.shipmentDate_nsprefix_ = child_.prefix
        elif nodeName_ == "shipmentStartHour":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "shipmentStartHour")
            value_ = self.gds_validate_string(value_, node, "shipmentStartHour")
            self.shipmentStartHour = value_
            self.shipmentStartHour_nsprefix_ = child_.prefix
        elif nodeName_ == "shipmentEndHour":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "shipmentEndHour")
            value_ = self.gds_validate_string(value_, node, "shipmentEndHour")
            self.shipmentEndHour = value_
            self.shipmentEndHour_nsprefix_ = child_.prefix


# end class ShipmentTime


class ShipmentInfo(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(
        self,
        wayBill=None,
        dropOffType=None,
        serviceType=None,
        billing=None,
        specialServices=None,
        shipmentTime=None,
        labelType=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.wayBill = wayBill
        self.wayBill_nsprefix_ = None
        self.dropOffType = dropOffType
        self.dropOffType_nsprefix_ = None
        self.serviceType = serviceType
        self.serviceType_nsprefix_ = None
        self.billing = billing
        self.billing_nsprefix_ = "tns"
        self.specialServices = specialServices
        self.specialServices_nsprefix_ = "tns"
        self.shipmentTime = shipmentTime
        self.shipmentTime_nsprefix_ = "tns"
        self.labelType = labelType
        self.labelType_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, ShipmentInfo)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ShipmentInfo.subclass:
            return ShipmentInfo.subclass(*args_, **kwargs_)
        else:
            return ShipmentInfo(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_wayBill(self):
        return self.wayBill

    def set_wayBill(self, wayBill):
        self.wayBill = wayBill

    def get_dropOffType(self):
        return self.dropOffType

    def set_dropOffType(self, dropOffType):
        self.dropOffType = dropOffType

    def get_serviceType(self):
        return self.serviceType

    def set_serviceType(self, serviceType):
        self.serviceType = serviceType

    def get_billing(self):
        return self.billing

    def set_billing(self, billing):
        self.billing = billing

    def get_specialServices(self):
        return self.specialServices

    def set_specialServices(self, specialServices):
        self.specialServices = specialServices

    def get_shipmentTime(self):
        return self.shipmentTime

    def set_shipmentTime(self, shipmentTime):
        self.shipmentTime = shipmentTime

    def get_labelType(self):
        return self.labelType

    def set_labelType(self, labelType):
        self.labelType = labelType

    def _hasContent(self):
        if (
            self.wayBill is not None
            or self.dropOffType is not None
            or self.serviceType is not None
            or self.billing is not None
            or self.specialServices is not None
            or self.shipmentTime is not None
            or self.labelType is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ShipmentInfo",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ShipmentInfo")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "ShipmentInfo":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="ShipmentInfo"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ShipmentInfo",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="ShipmentInfo",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ShipmentInfo",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.wayBill is not None:
            namespaceprefix_ = (
                self.wayBill_nsprefix_ + ":"
                if (UseCapturedNS_ and self.wayBill_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%swayBill>%s</%swayBill>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.wayBill), input_name="wayBill"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.dropOffType is not None:
            namespaceprefix_ = (
                self.dropOffType_nsprefix_ + ":"
                if (UseCapturedNS_ and self.dropOffType_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sdropOffType>%s</%sdropOffType>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.dropOffType), input_name="dropOffType"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.serviceType is not None:
            namespaceprefix_ = (
                self.serviceType_nsprefix_ + ":"
                if (UseCapturedNS_ and self.serviceType_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sserviceType>%s</%sserviceType>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.serviceType), input_name="serviceType"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.billing is not None:
            namespaceprefix_ = (
                self.billing_nsprefix_ + ":"
                if (UseCapturedNS_ and self.billing_nsprefix_)
                else ""
            )
            self.billing.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="billing",
                pretty_print=pretty_print,
            )
        if self.specialServices is not None:
            namespaceprefix_ = (
                self.specialServices_nsprefix_ + ":"
                if (UseCapturedNS_ and self.specialServices_nsprefix_)
                else ""
            )
            self.specialServices.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="specialServices",
                pretty_print=pretty_print,
            )
        if self.shipmentTime is not None:
            namespaceprefix_ = (
                self.shipmentTime_nsprefix_ + ":"
                if (UseCapturedNS_ and self.shipmentTime_nsprefix_)
                else ""
            )
            self.shipmentTime.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="shipmentTime",
                pretty_print=pretty_print,
            )
        if self.labelType is not None:
            namespaceprefix_ = (
                self.labelType_nsprefix_ + ":"
                if (UseCapturedNS_ and self.labelType_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%slabelType>%s</%slabelType>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.labelType), input_name="labelType"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "wayBill":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "wayBill")
            value_ = self.gds_validate_string(value_, node, "wayBill")
            self.wayBill = value_
            self.wayBill_nsprefix_ = child_.prefix
        elif nodeName_ == "dropOffType":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "dropOffType")
            value_ = self.gds_validate_string(value_, node, "dropOffType")
            self.dropOffType = value_
            self.dropOffType_nsprefix_ = child_.prefix
        elif nodeName_ == "serviceType":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "serviceType")
            value_ = self.gds_validate_string(value_, node, "serviceType")
            self.serviceType = value_
            self.serviceType_nsprefix_ = child_.prefix
        elif nodeName_ == "billing":
            obj_ = Billing.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.billing = obj_
            obj_.original_tagname_ = "billing"
        elif nodeName_ == "specialServices":
            obj_ = ArrayOfService.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.specialServices = obj_
            obj_.original_tagname_ = "specialServices"
        elif nodeName_ == "shipmentTime":
            obj_ = ShipmentTime.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.shipmentTime = obj_
            obj_.original_tagname_ = "shipmentTime"
        elif nodeName_ == "labelType":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "labelType")
            value_ = self.gds_validate_string(value_, node, "labelType")
            self.labelType = value_
            self.labelType_nsprefix_ = child_.prefix


# end class ShipmentInfo


class Address(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(
        self,
        name=None,
        postalCode=None,
        city=None,
        street=None,
        houseNumber=None,
        apartmentNumber=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.name = name
        self.name_nsprefix_ = None
        self.postalCode = postalCode
        self.postalCode_nsprefix_ = None
        self.city = city
        self.city_nsprefix_ = None
        self.street = street
        self.street_nsprefix_ = None
        self.houseNumber = houseNumber
        self.houseNumber_nsprefix_ = None
        self.apartmentNumber = apartmentNumber
        self.apartmentNumber_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, Address)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Address.subclass:
            return Address.subclass(*args_, **kwargs_)
        else:
            return Address(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_name(self):
        return self.name

    def set_name(self, name):
        self.name = name

    def get_postalCode(self):
        return self.postalCode

    def set_postalCode(self, postalCode):
        self.postalCode = postalCode

    def get_city(self):
        return self.city

    def set_city(self, city):
        self.city = city

    def get_street(self):
        return self.street

    def set_street(self, street):
        self.street = street

    def get_houseNumber(self):
        return self.houseNumber

    def set_houseNumber(self, houseNumber):
        self.houseNumber = houseNumber

    def get_apartmentNumber(self):
        return self.apartmentNumber

    def set_apartmentNumber(self, apartmentNumber):
        self.apartmentNumber = apartmentNumber

    def _hasContent(self):
        if (
            self.name is not None
            or self.postalCode is not None
            or self.city is not None
            or self.street is not None
            or self.houseNumber is not None
            or self.apartmentNumber is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Address",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("Address")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "Address":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Address"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="Address",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="Address"
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Address",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.name is not None:
            namespaceprefix_ = (
                self.name_nsprefix_ + ":"
                if (UseCapturedNS_ and self.name_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sname>%s</%sname>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(quote_xml(self.name), input_name="name")
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.postalCode is not None:
            namespaceprefix_ = (
                self.postalCode_nsprefix_ + ":"
                if (UseCapturedNS_ and self.postalCode_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%spostalCode>%s</%spostalCode>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.postalCode), input_name="postalCode"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.city is not None:
            namespaceprefix_ = (
                self.city_nsprefix_ + ":"
                if (UseCapturedNS_ and self.city_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%scity>%s</%scity>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(quote_xml(self.city), input_name="city")
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.street is not None:
            namespaceprefix_ = (
                self.street_nsprefix_ + ":"
                if (UseCapturedNS_ and self.street_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sstreet>%s</%sstreet>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.street), input_name="street"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.houseNumber is not None:
            namespaceprefix_ = (
                self.houseNumber_nsprefix_ + ":"
                if (UseCapturedNS_ and self.houseNumber_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%shouseNumber>%s</%shouseNumber>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.houseNumber), input_name="houseNumber"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.apartmentNumber is not None:
            namespaceprefix_ = (
                self.apartmentNumber_nsprefix_ + ":"
                if (UseCapturedNS_ and self.apartmentNumber_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sapartmentNumber>%s</%sapartmentNumber>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.apartmentNumber),
                            input_name="apartmentNumber",
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "name":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "name")
            value_ = self.gds_validate_string(value_, node, "name")
            self.name = value_
            self.name_nsprefix_ = child_.prefix
        elif nodeName_ == "postalCode":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "postalCode")
            value_ = self.gds_validate_string(value_, node, "postalCode")
            self.postalCode = value_
            self.postalCode_nsprefix_ = child_.prefix
        elif nodeName_ == "city":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "city")
            value_ = self.gds_validate_string(value_, node, "city")
            self.city = value_
            self.city_nsprefix_ = child_.prefix
        elif nodeName_ == "street":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "street")
            value_ = self.gds_validate_string(value_, node, "street")
            self.street = value_
            self.street_nsprefix_ = child_.prefix
        elif nodeName_ == "houseNumber":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "houseNumber")
            value_ = self.gds_validate_string(value_, node, "houseNumber")
            self.houseNumber = value_
            self.houseNumber_nsprefix_ = child_.prefix
        elif nodeName_ == "apartmentNumber":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "apartmentNumber")
            value_ = self.gds_validate_string(value_, node, "apartmentNumber")
            self.apartmentNumber = value_
            self.apartmentNumber_nsprefix_ = child_.prefix


# end class Address


class Addressat(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(
        self, preaviso=None, contact=None, address=None, gds_collector_=None, **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.preaviso = preaviso
        self.preaviso_nsprefix_ = "tns"
        self.contact = contact
        self.contact_nsprefix_ = "tns"
        self.address = address
        self.address_nsprefix_ = "tns"

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, Addressat)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Addressat.subclass:
            return Addressat.subclass(*args_, **kwargs_)
        else:
            return Addressat(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_preaviso(self):
        return self.preaviso

    def set_preaviso(self, preaviso):
        self.preaviso = preaviso

    def get_contact(self):
        return self.contact

    def set_contact(self, contact):
        self.contact = contact

    def get_address(self):
        return self.address

    def set_address(self, address):
        self.address = address

    def _hasContent(self):
        if (
            self.preaviso is not None
            or self.contact is not None
            or self.address is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Addressat",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("Addressat")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "Addressat":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Addressat"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="Addressat",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="Addressat"
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Addressat",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.preaviso is not None:
            namespaceprefix_ = (
                self.preaviso_nsprefix_ + ":"
                if (UseCapturedNS_ and self.preaviso_nsprefix_)
                else ""
            )
            self.preaviso.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="preaviso",
                pretty_print=pretty_print,
            )
        if self.contact is not None:
            namespaceprefix_ = (
                self.contact_nsprefix_ + ":"
                if (UseCapturedNS_ and self.contact_nsprefix_)
                else ""
            )
            self.contact.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="contact",
                pretty_print=pretty_print,
            )
        if self.address is not None:
            namespaceprefix_ = (
                self.address_nsprefix_ + ":"
                if (UseCapturedNS_ and self.address_nsprefix_)
                else ""
            )
            self.address.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="address",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "preaviso":
            obj_ = PreavisoContact.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.preaviso = obj_
            obj_.original_tagname_ = "preaviso"
        elif nodeName_ == "contact":
            obj_ = PreavisoContact.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.contact = obj_
            obj_.original_tagname_ = "contact"
        elif nodeName_ == "address":
            obj_ = Address.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.address = obj_
            obj_.original_tagname_ = "address"


# end class Addressat


class ReceiverAddress(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(
        self,
        country=None,
        isPackstation=None,
        isPostfiliale=None,
        postnummer=None,
        addressType=None,
        name=None,
        postalCode=None,
        city=None,
        street=None,
        houseNumber=None,
        apartmentNumber=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.country = country
        self.country_nsprefix_ = None
        self.isPackstation = isPackstation
        self.isPackstation_nsprefix_ = None
        self.isPostfiliale = isPostfiliale
        self.isPostfiliale_nsprefix_ = None
        self.postnummer = postnummer
        self.postnummer_nsprefix_ = None
        self.addressType = addressType
        self.addressType_nsprefix_ = None
        self.name = name
        self.name_nsprefix_ = None
        self.postalCode = postalCode
        self.postalCode_nsprefix_ = None
        self.city = city
        self.city_nsprefix_ = None
        self.street = street
        self.street_nsprefix_ = None
        self.houseNumber = houseNumber
        self.houseNumber_nsprefix_ = None
        self.apartmentNumber = apartmentNumber
        self.apartmentNumber_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, ReceiverAddress)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ReceiverAddress.subclass:
            return ReceiverAddress.subclass(*args_, **kwargs_)
        else:
            return ReceiverAddress(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_country(self):
        return self.country

    def set_country(self, country):
        self.country = country

    def get_isPackstation(self):
        return self.isPackstation

    def set_isPackstation(self, isPackstation):
        self.isPackstation = isPackstation

    def get_isPostfiliale(self):
        return self.isPostfiliale

    def set_isPostfiliale(self, isPostfiliale):
        self.isPostfiliale = isPostfiliale

    def get_postnummer(self):
        return self.postnummer

    def set_postnummer(self, postnummer):
        self.postnummer = postnummer

    def get_addressType(self):
        return self.addressType

    def set_addressType(self, addressType):
        self.addressType = addressType

    def get_name(self):
        return self.name

    def set_name(self, name):
        self.name = name

    def get_postalCode(self):
        return self.postalCode

    def set_postalCode(self, postalCode):
        self.postalCode = postalCode

    def get_city(self):
        return self.city

    def set_city(self, city):
        self.city = city

    def get_street(self):
        return self.street

    def set_street(self, street):
        self.street = street

    def get_houseNumber(self):
        return self.houseNumber

    def set_houseNumber(self, houseNumber):
        self.houseNumber = houseNumber

    def get_apartmentNumber(self):
        return self.apartmentNumber

    def set_apartmentNumber(self, apartmentNumber):
        self.apartmentNumber = apartmentNumber

    def _hasContent(self):
        if (
            self.country is not None
            or self.isPackstation is not None
            or self.isPostfiliale is not None
            or self.postnummer is not None
            or self.addressType is not None
            or self.name is not None
            or self.postalCode is not None
            or self.city is not None
            or self.street is not None
            or self.houseNumber is not None
            or self.apartmentNumber is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ReceiverAddress",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ReceiverAddress")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "ReceiverAddress":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="ReceiverAddress"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ReceiverAddress",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="ReceiverAddress",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ReceiverAddress",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.country is not None:
            namespaceprefix_ = (
                self.country_nsprefix_ + ":"
                if (UseCapturedNS_ and self.country_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%scountry>%s</%scountry>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.country), input_name="country"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.isPackstation is not None:
            namespaceprefix_ = (
                self.isPackstation_nsprefix_ + ":"
                if (UseCapturedNS_ and self.isPackstation_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sisPackstation>%s</%sisPackstation>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_boolean(
                        self.isPackstation, input_name="isPackstation"
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.isPostfiliale is not None:
            namespaceprefix_ = (
                self.isPostfiliale_nsprefix_ + ":"
                if (UseCapturedNS_ and self.isPostfiliale_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sisPostfiliale>%s</%sisPostfiliale>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_boolean(
                        self.isPostfiliale, input_name="isPostfiliale"
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.postnummer is not None:
            namespaceprefix_ = (
                self.postnummer_nsprefix_ + ":"
                if (UseCapturedNS_ and self.postnummer_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%spostnummer>%s</%spostnummer>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.postnummer), input_name="postnummer"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.addressType is not None:
            namespaceprefix_ = (
                self.addressType_nsprefix_ + ":"
                if (UseCapturedNS_ and self.addressType_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%saddressType>%s</%saddressType>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.addressType), input_name="addressType"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.name is not None:
            namespaceprefix_ = (
                self.name_nsprefix_ + ":"
                if (UseCapturedNS_ and self.name_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sname>%s</%sname>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(quote_xml(self.name), input_name="name")
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.postalCode is not None:
            namespaceprefix_ = (
                self.postalCode_nsprefix_ + ":"
                if (UseCapturedNS_ and self.postalCode_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%spostalCode>%s</%spostalCode>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.postalCode), input_name="postalCode"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.city is not None:
            namespaceprefix_ = (
                self.city_nsprefix_ + ":"
                if (UseCapturedNS_ and self.city_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%scity>%s</%scity>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(quote_xml(self.city), input_name="city")
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.street is not None:
            namespaceprefix_ = (
                self.street_nsprefix_ + ":"
                if (UseCapturedNS_ and self.street_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sstreet>%s</%sstreet>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.street), input_name="street"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.houseNumber is not None:
            namespaceprefix_ = (
                self.houseNumber_nsprefix_ + ":"
                if (UseCapturedNS_ and self.houseNumber_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%shouseNumber>%s</%shouseNumber>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.houseNumber), input_name="houseNumber"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.apartmentNumber is not None:
            namespaceprefix_ = (
                self.apartmentNumber_nsprefix_ + ":"
                if (UseCapturedNS_ and self.apartmentNumber_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sapartmentNumber>%s</%sapartmentNumber>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.apartmentNumber),
                            input_name="apartmentNumber",
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "country":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "country")
            value_ = self.gds_validate_string(value_, node, "country")
            self.country = value_
            self.country_nsprefix_ = child_.prefix
        elif nodeName_ == "isPackstation":
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, "isPackstation")
            ival_ = self.gds_validate_boolean(ival_, node, "isPackstation")
            self.isPackstation = ival_
            self.isPackstation_nsprefix_ = child_.prefix
        elif nodeName_ == "isPostfiliale":
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, "isPostfiliale")
            ival_ = self.gds_validate_boolean(ival_, node, "isPostfiliale")
            self.isPostfiliale = ival_
            self.isPostfiliale_nsprefix_ = child_.prefix
        elif nodeName_ == "postnummer":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "postnummer")
            value_ = self.gds_validate_string(value_, node, "postnummer")
            self.postnummer = value_
            self.postnummer_nsprefix_ = child_.prefix
        elif nodeName_ == "addressType":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "addressType")
            value_ = self.gds_validate_string(value_, node, "addressType")
            self.addressType = value_
            self.addressType_nsprefix_ = child_.prefix
        elif nodeName_ == "name":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "name")
            value_ = self.gds_validate_string(value_, node, "name")
            self.name = value_
            self.name_nsprefix_ = child_.prefix
        elif nodeName_ == "postalCode":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "postalCode")
            value_ = self.gds_validate_string(value_, node, "postalCode")
            self.postalCode = value_
            self.postalCode_nsprefix_ = child_.prefix
        elif nodeName_ == "city":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "city")
            value_ = self.gds_validate_string(value_, node, "city")
            self.city = value_
            self.city_nsprefix_ = child_.prefix
        elif nodeName_ == "street":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "street")
            value_ = self.gds_validate_string(value_, node, "street")
            self.street = value_
            self.street_nsprefix_ = child_.prefix
        elif nodeName_ == "houseNumber":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "houseNumber")
            value_ = self.gds_validate_string(value_, node, "houseNumber")
            self.houseNumber = value_
            self.houseNumber_nsprefix_ = child_.prefix
        elif nodeName_ == "apartmentNumber":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "apartmentNumber")
            value_ = self.gds_validate_string(value_, node, "apartmentNumber")
            self.apartmentNumber = value_
            self.apartmentNumber_nsprefix_ = child_.prefix


# end class ReceiverAddress


class ReceiverAddressat(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(
        self, preaviso=None, contact=None, address=None, gds_collector_=None, **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.preaviso = preaviso
        self.preaviso_nsprefix_ = "tns"
        self.contact = contact
        self.contact_nsprefix_ = "tns"
        self.address = address
        self.address_nsprefix_ = "tns"

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, ReceiverAddressat)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ReceiverAddressat.subclass:
            return ReceiverAddressat.subclass(*args_, **kwargs_)
        else:
            return ReceiverAddressat(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_preaviso(self):
        return self.preaviso

    def set_preaviso(self, preaviso):
        self.preaviso = preaviso

    def get_contact(self):
        return self.contact

    def set_contact(self, contact):
        self.contact = contact

    def get_address(self):
        return self.address

    def set_address(self, address):
        self.address = address

    def _hasContent(self):
        if (
            self.preaviso is not None
            or self.contact is not None
            or self.address is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ReceiverAddressat",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ReceiverAddressat")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "ReceiverAddressat":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="ReceiverAddressat",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ReceiverAddressat",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="ReceiverAddressat",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ReceiverAddressat",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.preaviso is not None:
            namespaceprefix_ = (
                self.preaviso_nsprefix_ + ":"
                if (UseCapturedNS_ and self.preaviso_nsprefix_)
                else ""
            )
            self.preaviso.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="preaviso",
                pretty_print=pretty_print,
            )
        if self.contact is not None:
            namespaceprefix_ = (
                self.contact_nsprefix_ + ":"
                if (UseCapturedNS_ and self.contact_nsprefix_)
                else ""
            )
            self.contact.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="contact",
                pretty_print=pretty_print,
            )
        if self.address is not None:
            namespaceprefix_ = (
                self.address_nsprefix_ + ":"
                if (UseCapturedNS_ and self.address_nsprefix_)
                else ""
            )
            self.address.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="address",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "preaviso":
            obj_ = PreavisoContact.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.preaviso = obj_
            obj_.original_tagname_ = "preaviso"
        elif nodeName_ == "contact":
            obj_ = PreavisoContact.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.contact = obj_
            obj_.original_tagname_ = "contact"
        elif nodeName_ == "address":
            obj_ = ReceiverAddress.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.address = obj_
            obj_.original_tagname_ = "address"


# end class ReceiverAddressat


class Ship(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(
        self,
        shipper=None,
        receiver=None,
        neighbour=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.shipper = shipper
        self.shipper_nsprefix_ = "tns"
        self.receiver = receiver
        self.receiver_nsprefix_ = "tns"
        self.neighbour = neighbour
        self.neighbour_nsprefix_ = "tns"

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, Ship)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Ship.subclass:
            return Ship.subclass(*args_, **kwargs_)
        else:
            return Ship(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_shipper(self):
        return self.shipper

    def set_shipper(self, shipper):
        self.shipper = shipper

    def get_receiver(self):
        return self.receiver

    def set_receiver(self, receiver):
        self.receiver = receiver

    def get_neighbour(self):
        return self.neighbour

    def set_neighbour(self, neighbour):
        self.neighbour = neighbour

    def _hasContent(self):
        if (
            self.shipper is not None
            or self.receiver is not None
            or self.neighbour is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Ship",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("Ship")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "Ship":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Ship"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="Ship",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="Ship"
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Ship",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.shipper is not None:
            namespaceprefix_ = (
                self.shipper_nsprefix_ + ":"
                if (UseCapturedNS_ and self.shipper_nsprefix_)
                else ""
            )
            self.shipper.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="shipper",
                pretty_print=pretty_print,
            )
        if self.receiver is not None:
            namespaceprefix_ = (
                self.receiver_nsprefix_ + ":"
                if (UseCapturedNS_ and self.receiver_nsprefix_)
                else ""
            )
            self.receiver.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="receiver",
                pretty_print=pretty_print,
            )
        if self.neighbour is not None:
            namespaceprefix_ = (
                self.neighbour_nsprefix_ + ":"
                if (UseCapturedNS_ and self.neighbour_nsprefix_)
                else ""
            )
            self.neighbour.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="neighbour",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "shipper":
            obj_ = Addressat.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.shipper = obj_
            obj_.original_tagname_ = "shipper"
        elif nodeName_ == "receiver":
            obj_ = ReceiverAddressat.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.receiver = obj_
            obj_.original_tagname_ = "receiver"
        elif nodeName_ == "neighbour":
            obj_ = NeighbourAddress.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.neighbour = obj_
            obj_.original_tagname_ = "neighbour"


# end class Ship


class Package(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(
        self,
        type_=None,
        euroReturn=None,
        weight=None,
        width=None,
        height=None,
        length=None,
        quantity=None,
        nonStandard=None,
        blpPieceId=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.type_ = type_
        self.type__nsprefix_ = None
        self.euroReturn = euroReturn
        self.euroReturn_nsprefix_ = None
        self.weight = weight
        self.weight_nsprefix_ = None
        self.width = width
        self.width_nsprefix_ = None
        self.height = height
        self.height_nsprefix_ = None
        self.length = length
        self.length_nsprefix_ = None
        self.quantity = quantity
        self.quantity_nsprefix_ = None
        self.nonStandard = nonStandard
        self.nonStandard_nsprefix_ = None
        self.blpPieceId = blpPieceId
        self.blpPieceId_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, Package)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Package.subclass:
            return Package.subclass(*args_, **kwargs_)
        else:
            return Package(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_type(self):
        return self.type_

    def set_type(self, type_):
        self.type_ = type_

    def get_euroReturn(self):
        return self.euroReturn

    def set_euroReturn(self, euroReturn):
        self.euroReturn = euroReturn

    def get_weight(self):
        return self.weight

    def set_weight(self, weight):
        self.weight = weight

    def get_width(self):
        return self.width

    def set_width(self, width):
        self.width = width

    def get_height(self):
        return self.height

    def set_height(self, height):
        self.height = height

    def get_length(self):
        return self.length

    def set_length(self, length):
        self.length = length

    def get_quantity(self):
        return self.quantity

    def set_quantity(self, quantity):
        self.quantity = quantity

    def get_nonStandard(self):
        return self.nonStandard

    def set_nonStandard(self, nonStandard):
        self.nonStandard = nonStandard

    def get_blpPieceId(self):
        return self.blpPieceId

    def set_blpPieceId(self, blpPieceId):
        self.blpPieceId = blpPieceId

    def _hasContent(self):
        if (
            self.type_ is not None
            or self.euroReturn is not None
            or self.weight is not None
            or self.width is not None
            or self.height is not None
            or self.length is not None
            or self.quantity is not None
            or self.nonStandard is not None
            or self.blpPieceId is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Package",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("Package")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "Package":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Package"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="Package",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="Package"
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Package",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.type_ is not None:
            namespaceprefix_ = (
                self.type__nsprefix_ + ":"
                if (UseCapturedNS_ and self.type__nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%stype>%s</%stype>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(quote_xml(self.type_), input_name="type")
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.euroReturn is not None:
            namespaceprefix_ = (
                self.euroReturn_nsprefix_ + ":"
                if (UseCapturedNS_ and self.euroReturn_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%seuroReturn>%s</%seuroReturn>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_boolean(self.euroReturn, input_name="euroReturn"),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.weight is not None:
            namespaceprefix_ = (
                self.weight_nsprefix_ + ":"
                if (UseCapturedNS_ and self.weight_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sweight>%s</%sweight>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_integer(self.weight, input_name="weight"),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.width is not None:
            namespaceprefix_ = (
                self.width_nsprefix_ + ":"
                if (UseCapturedNS_ and self.width_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%swidth>%s</%swidth>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_integer(self.width, input_name="width"),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.height is not None:
            namespaceprefix_ = (
                self.height_nsprefix_ + ":"
                if (UseCapturedNS_ and self.height_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sheight>%s</%sheight>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_integer(self.height, input_name="height"),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.length is not None:
            namespaceprefix_ = (
                self.length_nsprefix_ + ":"
                if (UseCapturedNS_ and self.length_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%slength>%s</%slength>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_integer(self.length, input_name="length"),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.quantity is not None:
            namespaceprefix_ = (
                self.quantity_nsprefix_ + ":"
                if (UseCapturedNS_ and self.quantity_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%squantity>%s</%squantity>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_integer(self.quantity, input_name="quantity"),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.nonStandard is not None:
            namespaceprefix_ = (
                self.nonStandard_nsprefix_ + ":"
                if (UseCapturedNS_ and self.nonStandard_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%snonStandard>%s</%snonStandard>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_boolean(self.nonStandard, input_name="nonStandard"),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.blpPieceId is not None:
            namespaceprefix_ = (
                self.blpPieceId_nsprefix_ + ":"
                if (UseCapturedNS_ and self.blpPieceId_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sblpPieceId>%s</%sblpPieceId>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.blpPieceId), input_name="blpPieceId"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "type":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "type")
            value_ = self.gds_validate_string(value_, node, "type")
            self.type_ = value_
            self.type_nsprefix_ = child_.prefix
        elif nodeName_ == "euroReturn":
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, "euroReturn")
            ival_ = self.gds_validate_boolean(ival_, node, "euroReturn")
            self.euroReturn = ival_
            self.euroReturn_nsprefix_ = child_.prefix
        elif nodeName_ == "weight" and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, "weight")
            ival_ = self.gds_validate_integer(ival_, node, "weight")
            self.weight = ival_
            self.weight_nsprefix_ = child_.prefix
        elif nodeName_ == "width" and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, "width")
            ival_ = self.gds_validate_integer(ival_, node, "width")
            self.width = ival_
            self.width_nsprefix_ = child_.prefix
        elif nodeName_ == "height" and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, "height")
            ival_ = self.gds_validate_integer(ival_, node, "height")
            self.height = ival_
            self.height_nsprefix_ = child_.prefix
        elif nodeName_ == "length" and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, "length")
            ival_ = self.gds_validate_integer(ival_, node, "length")
            self.length = ival_
            self.length_nsprefix_ = child_.prefix
        elif nodeName_ == "quantity" and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, "quantity")
            ival_ = self.gds_validate_integer(ival_, node, "quantity")
            self.quantity = ival_
            self.quantity_nsprefix_ = child_.prefix
        elif nodeName_ == "nonStandard":
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, "nonStandard")
            ival_ = self.gds_validate_boolean(ival_, node, "nonStandard")
            self.nonStandard = ival_
            self.nonStandard_nsprefix_ = child_.prefix
        elif nodeName_ == "blpPieceId":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "blpPieceId")
            value_ = self.gds_validate_string(value_, node, "blpPieceId")
            self.blpPieceId = value_
            self.blpPieceId_nsprefix_ = child_.prefix


# end class Package


class ArrayOfPackage(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, item=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        if item is None:
            self.item = []
        else:
            self.item = item
        self.item_nsprefix_ = "tns"

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, ArrayOfPackage)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ArrayOfPackage.subclass:
            return ArrayOfPackage.subclass(*args_, **kwargs_)
        else:
            return ArrayOfPackage(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_item(self):
        return self.item

    def set_item(self, item):
        self.item = item

    def add_item(self, value):
        self.item.append(value)

    def insert_item_at(self, index, value):
        self.item.insert(index, value)

    def replace_item_at(self, index, value):
        self.item[index] = value

    def _hasContent(self):
        if self.item:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ArrayOfPackage",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ArrayOfPackage")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "ArrayOfPackage":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="ArrayOfPackage"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ArrayOfPackage",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="ArrayOfPackage",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ArrayOfPackage",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for item_ in self.item:
            namespaceprefix_ = (
                self.item_nsprefix_ + ":"
                if (UseCapturedNS_ and self.item_nsprefix_)
                else ""
            )
            item_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="item",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "item":
            obj_ = Package.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.item.append(obj_)
            obj_.original_tagname_ = "item"


# end class ArrayOfPackage


class CreateShipmentRequest(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(
        self,
        shipmentInfo=None,
        content=None,
        comment=None,
        reference=None,
        ship=None,
        pieceList=None,
        customs=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.shipmentInfo = shipmentInfo
        self.shipmentInfo_nsprefix_ = "tns"
        self.content = content
        self.content_nsprefix_ = None
        self.comment = comment
        self.comment_nsprefix_ = None
        self.reference = reference
        self.reference_nsprefix_ = None
        self.ship = ship
        self.ship_nsprefix_ = "tns"
        self.pieceList = pieceList
        self.pieceList_nsprefix_ = "tns"
        self.customs = customs
        self.customs_nsprefix_ = "tns"

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CreateShipmentRequest
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CreateShipmentRequest.subclass:
            return CreateShipmentRequest.subclass(*args_, **kwargs_)
        else:
            return CreateShipmentRequest(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_shipmentInfo(self):
        return self.shipmentInfo

    def set_shipmentInfo(self, shipmentInfo):
        self.shipmentInfo = shipmentInfo

    def get_content(self):
        return self.content

    def set_content(self, content):
        self.content = content

    def get_comment(self):
        return self.comment

    def set_comment(self, comment):
        self.comment = comment

    def get_reference(self):
        return self.reference

    def set_reference(self, reference):
        self.reference = reference

    def get_ship(self):
        return self.ship

    def set_ship(self, ship):
        self.ship = ship

    def get_pieceList(self):
        return self.pieceList

    def set_pieceList(self, pieceList):
        self.pieceList = pieceList

    def get_customs(self):
        return self.customs

    def set_customs(self, customs):
        self.customs = customs

    def _hasContent(self):
        if (
            self.shipmentInfo is not None
            or self.content is not None
            or self.comment is not None
            or self.reference is not None
            or self.ship is not None
            or self.pieceList is not None
            or self.customs is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="CreateShipmentRequest",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("CreateShipmentRequest")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "CreateShipmentRequest":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="CreateShipmentRequest",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="CreateShipmentRequest",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="CreateShipmentRequest",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="CreateShipmentRequest",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.shipmentInfo is not None:
            namespaceprefix_ = (
                self.shipmentInfo_nsprefix_ + ":"
                if (UseCapturedNS_ and self.shipmentInfo_nsprefix_)
                else ""
            )
            self.shipmentInfo.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="shipmentInfo",
                pretty_print=pretty_print,
            )
        if self.content is not None:
            namespaceprefix_ = (
                self.content_nsprefix_ + ":"
                if (UseCapturedNS_ and self.content_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%scontent>%s</%scontent>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.content), input_name="content"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.comment is not None:
            namespaceprefix_ = (
                self.comment_nsprefix_ + ":"
                if (UseCapturedNS_ and self.comment_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%scomment>%s</%scomment>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.comment), input_name="comment"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.reference is not None:
            namespaceprefix_ = (
                self.reference_nsprefix_ + ":"
                if (UseCapturedNS_ and self.reference_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sreference>%s</%sreference>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.reference), input_name="reference"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.ship is not None:
            namespaceprefix_ = (
                self.ship_nsprefix_ + ":"
                if (UseCapturedNS_ and self.ship_nsprefix_)
                else ""
            )
            self.ship.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="ship",
                pretty_print=pretty_print,
            )
        if self.pieceList is not None:
            namespaceprefix_ = (
                self.pieceList_nsprefix_ + ":"
                if (UseCapturedNS_ and self.pieceList_nsprefix_)
                else ""
            )
            self.pieceList.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="pieceList",
                pretty_print=pretty_print,
            )
        if self.customs is not None:
            namespaceprefix_ = (
                self.customs_nsprefix_ + ":"
                if (UseCapturedNS_ and self.customs_nsprefix_)
                else ""
            )
            self.customs.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="customs",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "shipmentInfo":
            obj_ = ShipmentInfo.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.shipmentInfo = obj_
            obj_.original_tagname_ = "shipmentInfo"
        elif nodeName_ == "content":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "content")
            value_ = self.gds_validate_string(value_, node, "content")
            self.content = value_
            self.content_nsprefix_ = child_.prefix
        elif nodeName_ == "comment":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "comment")
            value_ = self.gds_validate_string(value_, node, "comment")
            self.comment = value_
            self.comment_nsprefix_ = child_.prefix
        elif nodeName_ == "reference":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "reference")
            value_ = self.gds_validate_string(value_, node, "reference")
            self.reference = value_
            self.reference_nsprefix_ = child_.prefix
        elif nodeName_ == "ship":
            obj_ = Ship.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ship = obj_
            obj_.original_tagname_ = "ship"
        elif nodeName_ == "pieceList":
            obj_ = ArrayOfPackage.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.pieceList = obj_
            obj_.original_tagname_ = "pieceList"
        elif nodeName_ == "customs":
            obj_ = CustomsData.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.customs = obj_
            obj_.original_tagname_ = "customs"


# end class CreateShipmentRequest


class createShipment(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, authData=None, shipment=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.authData = authData
        self.authData_nsprefix_ = "tns"
        self.shipment = shipment
        self.shipment_nsprefix_ = "tns"

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, createShipment)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if createShipment.subclass:
            return createShipment.subclass(*args_, **kwargs_)
        else:
            return createShipment(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_authData(self):
        return self.authData

    def set_authData(self, authData):
        self.authData = authData

    def get_shipment(self):
        return self.shipment

    def set_shipment(self, shipment):
        self.shipment = shipment

    def _hasContent(self):
        if self.authData is not None or self.shipment is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="createShipment",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("createShipment")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "createShipment":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="createShipment"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="createShipment",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="createShipment",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="createShipment",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.authData is not None:
            namespaceprefix_ = (
                self.authData_nsprefix_ + ":"
                if (UseCapturedNS_ and self.authData_nsprefix_)
                else ""
            )
            self.authData.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="authData",
                pretty_print=pretty_print,
            )
        if self.shipment is not None:
            namespaceprefix_ = (
                self.shipment_nsprefix_ + ":"
                if (UseCapturedNS_ and self.shipment_nsprefix_)
                else ""
            )
            self.shipment.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="shipment",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "authData":
            obj_ = AuthData.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.authData = obj_
            obj_.original_tagname_ = "authData"
        elif nodeName_ == "shipment":
            obj_ = CreateShipmentRequest.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.shipment = obj_
            obj_.original_tagname_ = "shipment"


# end class createShipment


class createShipmentResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, createShipmentResult=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.createShipmentResult = createShipmentResult
        self.createShipmentResult_nsprefix_ = "tns"

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, createShipmentResponse
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if createShipmentResponse.subclass:
            return createShipmentResponse.subclass(*args_, **kwargs_)
        else:
            return createShipmentResponse(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_createShipmentResult(self):
        return self.createShipmentResult

    def set_createShipmentResult(self, createShipmentResult):
        self.createShipmentResult = createShipmentResult

    def _hasContent(self):
        if self.createShipmentResult is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="createShipmentResponse",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("createShipmentResponse")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "createShipmentResponse":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="createShipmentResponse",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="createShipmentResponse",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="createShipmentResponse",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="createShipmentResponse",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.createShipmentResult is not None:
            namespaceprefix_ = (
                self.createShipmentResult_nsprefix_ + ":"
                if (UseCapturedNS_ and self.createShipmentResult_nsprefix_)
                else ""
            )
            self.createShipmentResult.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="createShipmentResult",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "createShipmentResult":
            obj_ = CreateShipmentResponse.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.createShipmentResult = obj_
            obj_.original_tagname_ = "createShipmentResult"


# end class createShipmentResponse


class DeleteShipmentRequest(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(
        self,
        shipmentIdentificationNumber=None,
        dispatchIdentificationNumber=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.shipmentIdentificationNumber = shipmentIdentificationNumber
        self.shipmentIdentificationNumber_nsprefix_ = None
        self.dispatchIdentificationNumber = dispatchIdentificationNumber
        self.dispatchIdentificationNumber_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, DeleteShipmentRequest
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if DeleteShipmentRequest.subclass:
            return DeleteShipmentRequest.subclass(*args_, **kwargs_)
        else:
            return DeleteShipmentRequest(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_shipmentIdentificationNumber(self):
        return self.shipmentIdentificationNumber

    def set_shipmentIdentificationNumber(self, shipmentIdentificationNumber):
        self.shipmentIdentificationNumber = shipmentIdentificationNumber

    def get_dispatchIdentificationNumber(self):
        return self.dispatchIdentificationNumber

    def set_dispatchIdentificationNumber(self, dispatchIdentificationNumber):
        self.dispatchIdentificationNumber = dispatchIdentificationNumber

    def _hasContent(self):
        if (
            self.shipmentIdentificationNumber is not None
            or self.dispatchIdentificationNumber is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="DeleteShipmentRequest",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("DeleteShipmentRequest")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "DeleteShipmentRequest":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="DeleteShipmentRequest",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="DeleteShipmentRequest",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="DeleteShipmentRequest",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="DeleteShipmentRequest",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.shipmentIdentificationNumber is not None:
            namespaceprefix_ = (
                self.shipmentIdentificationNumber_nsprefix_ + ":"
                if (UseCapturedNS_ and self.shipmentIdentificationNumber_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sshipmentIdentificationNumber>%s</%sshipmentIdentificationNumber>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.shipmentIdentificationNumber),
                            input_name="shipmentIdentificationNumber",
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.dispatchIdentificationNumber is not None:
            namespaceprefix_ = (
                self.dispatchIdentificationNumber_nsprefix_ + ":"
                if (UseCapturedNS_ and self.dispatchIdentificationNumber_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sdispatchIdentificationNumber>%s</%sdispatchIdentificationNumber>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.dispatchIdentificationNumber),
                            input_name="dispatchIdentificationNumber",
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "shipmentIdentificationNumber":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "shipmentIdentificationNumber")
            value_ = self.gds_validate_string(
                value_, node, "shipmentIdentificationNumber"
            )
            self.shipmentIdentificationNumber = value_
            self.shipmentIdentificationNumber_nsprefix_ = child_.prefix
        elif nodeName_ == "dispatchIdentificationNumber":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "dispatchIdentificationNumber")
            value_ = self.gds_validate_string(
                value_, node, "dispatchIdentificationNumber"
            )
            self.dispatchIdentificationNumber = value_
            self.dispatchIdentificationNumber_nsprefix_ = child_.prefix


# end class DeleteShipmentRequest


class deleteShipment(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, authData=None, shipment=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.authData = authData
        self.authData_nsprefix_ = "tns"
        self.shipment = shipment
        self.shipment_nsprefix_ = "tns"

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, deleteShipment)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if deleteShipment.subclass:
            return deleteShipment.subclass(*args_, **kwargs_)
        else:
            return deleteShipment(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_authData(self):
        return self.authData

    def set_authData(self, authData):
        self.authData = authData

    def get_shipment(self):
        return self.shipment

    def set_shipment(self, shipment):
        self.shipment = shipment

    def _hasContent(self):
        if self.authData is not None or self.shipment is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="deleteShipment",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("deleteShipment")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "deleteShipment":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="deleteShipment"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="deleteShipment",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="deleteShipment",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="deleteShipment",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.authData is not None:
            namespaceprefix_ = (
                self.authData_nsprefix_ + ":"
                if (UseCapturedNS_ and self.authData_nsprefix_)
                else ""
            )
            self.authData.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="authData",
                pretty_print=pretty_print,
            )
        if self.shipment is not None:
            namespaceprefix_ = (
                self.shipment_nsprefix_ + ":"
                if (UseCapturedNS_ and self.shipment_nsprefix_)
                else ""
            )
            self.shipment.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="shipment",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "authData":
            obj_ = AuthData.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.authData = obj_
            obj_.original_tagname_ = "authData"
        elif nodeName_ == "shipment":
            obj_ = DeleteShipmentRequest.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.shipment = obj_
            obj_.original_tagname_ = "shipment"


# end class deleteShipment


class DeleteShipmentResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(
        self, id=None, result=None, error=None, gds_collector_=None, **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.id = id
        self.id_nsprefix_ = None
        self.result = result
        self.result_nsprefix_ = None
        self.error = error
        self.error_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, DeleteShipmentResponse
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if DeleteShipmentResponse.subclass:
            return DeleteShipmentResponse.subclass(*args_, **kwargs_)
        else:
            return DeleteShipmentResponse(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_id(self):
        return self.id

    def set_id(self, id):
        self.id = id

    def get_result(self):
        return self.result

    def set_result(self, result):
        self.result = result

    def get_error(self):
        return self.error

    def set_error(self, error):
        self.error = error

    def _hasContent(self):
        if self.id is not None or self.result is not None or self.error is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="DeleteShipmentResponse",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("DeleteShipmentResponse")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "DeleteShipmentResponse":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="DeleteShipmentResponse",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="DeleteShipmentResponse",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="DeleteShipmentResponse",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="DeleteShipmentResponse",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.id is not None:
            namespaceprefix_ = (
                self.id_nsprefix_ + ":"
                if (UseCapturedNS_ and self.id_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sid>%s</%sid>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(quote_xml(self.id), input_name="id")
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.result is not None:
            namespaceprefix_ = (
                self.result_nsprefix_ + ":"
                if (UseCapturedNS_ and self.result_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sresult>%s</%sresult>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_boolean(self.result, input_name="result"),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.error is not None:
            namespaceprefix_ = (
                self.error_nsprefix_ + ":"
                if (UseCapturedNS_ and self.error_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%serror>%s</%serror>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.error), input_name="error"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "id":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "id")
            value_ = self.gds_validate_string(value_, node, "id")
            self.id = value_
            self.id_nsprefix_ = child_.prefix
        elif nodeName_ == "result":
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, "result")
            ival_ = self.gds_validate_boolean(ival_, node, "result")
            self.result = ival_
            self.result_nsprefix_ = child_.prefix
        elif nodeName_ == "error":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "error")
            value_ = self.gds_validate_string(value_, node, "error")
            self.error = value_
            self.error_nsprefix_ = child_.prefix


# end class DeleteShipmentResponse


class deleteShipmentResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, deleteShipmentResult=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.deleteShipmentResult = deleteShipmentResult
        self.deleteShipmentResult_nsprefix_ = "tns"

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, deleteShipmentResponse
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if deleteShipmentResponse.subclass:
            return deleteShipmentResponse.subclass(*args_, **kwargs_)
        else:
            return deleteShipmentResponse(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_deleteShipmentResult(self):
        return self.deleteShipmentResult

    def set_deleteShipmentResult(self, deleteShipmentResult):
        self.deleteShipmentResult = deleteShipmentResult

    def _hasContent(self):
        if self.deleteShipmentResult is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="deleteShipmentResponse",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("deleteShipmentResponse")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "deleteShipmentResponse":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="deleteShipmentResponse",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="deleteShipmentResponse",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="deleteShipmentResponse",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="deleteShipmentResponse",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.deleteShipmentResult is not None:
            namespaceprefix_ = (
                self.deleteShipmentResult_nsprefix_ + ":"
                if (UseCapturedNS_ and self.deleteShipmentResult_nsprefix_)
                else ""
            )
            self.deleteShipmentResult.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="deleteShipmentResult",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "deleteShipmentResult":
            obj_ = DeleteShipmentResponse.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.deleteShipmentResult = obj_
            obj_.original_tagname_ = "deleteShipmentResult"


# end class deleteShipmentResponse


class GetNearestServicepointsRequest(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(
        self,
        country=None,
        postcode=None,
        city=None,
        radius=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.country = country
        self.country_nsprefix_ = None
        self.postcode = postcode
        self.postcode_nsprefix_ = None
        self.city = city
        self.city_nsprefix_ = None
        self.radius = radius
        self.radius_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GetNearestServicepointsRequest
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GetNearestServicepointsRequest.subclass:
            return GetNearestServicepointsRequest.subclass(*args_, **kwargs_)
        else:
            return GetNearestServicepointsRequest(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_country(self):
        return self.country

    def set_country(self, country):
        self.country = country

    def get_postcode(self):
        return self.postcode

    def set_postcode(self, postcode):
        self.postcode = postcode

    def get_city(self):
        return self.city

    def set_city(self, city):
        self.city = city

    def get_radius(self):
        return self.radius

    def set_radius(self, radius):
        self.radius = radius

    def _hasContent(self):
        if (
            self.country is not None
            or self.postcode is not None
            or self.city is not None
            or self.radius is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="GetNearestServicepointsRequest",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get(
            "GetNearestServicepointsRequest"
        )
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if (
            self.original_tagname_ is not None
            and name_ == "GetNearestServicepointsRequest"
        ):
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="GetNearestServicepointsRequest",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="GetNearestServicepointsRequest",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="GetNearestServicepointsRequest",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="GetNearestServicepointsRequest",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.country is not None:
            namespaceprefix_ = (
                self.country_nsprefix_ + ":"
                if (UseCapturedNS_ and self.country_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%scountry>%s</%scountry>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.country), input_name="country"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.postcode is not None:
            namespaceprefix_ = (
                self.postcode_nsprefix_ + ":"
                if (UseCapturedNS_ and self.postcode_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%spostcode>%s</%spostcode>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.postcode), input_name="postcode"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.city is not None:
            namespaceprefix_ = (
                self.city_nsprefix_ + ":"
                if (UseCapturedNS_ and self.city_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%scity>%s</%scity>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(quote_xml(self.city), input_name="city")
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.radius is not None:
            namespaceprefix_ = (
                self.radius_nsprefix_ + ":"
                if (UseCapturedNS_ and self.radius_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sradius>%s</%sradius>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_integer(self.radius, input_name="radius"),
                    namespaceprefix_,
                    eol_,
                )
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "country":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "country")
            value_ = self.gds_validate_string(value_, node, "country")
            self.country = value_
            self.country_nsprefix_ = child_.prefix
        elif nodeName_ == "postcode":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "postcode")
            value_ = self.gds_validate_string(value_, node, "postcode")
            self.postcode = value_
            self.postcode_nsprefix_ = child_.prefix
        elif nodeName_ == "city":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "city")
            value_ = self.gds_validate_string(value_, node, "city")
            self.city = value_
            self.city_nsprefix_ = child_.prefix
        elif nodeName_ == "radius" and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, "radius")
            ival_ = self.gds_validate_integer(ival_, node, "radius")
            self.radius = ival_
            self.radius_nsprefix_ = child_.prefix


# end class GetNearestServicepointsRequest


class getNearestServicepoints(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, authData=None, structure=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.authData = authData
        self.authData_nsprefix_ = "tns"
        self.structure = structure
        self.structure_nsprefix_ = "tns"

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, getNearestServicepoints
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getNearestServicepoints.subclass:
            return getNearestServicepoints.subclass(*args_, **kwargs_)
        else:
            return getNearestServicepoints(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_authData(self):
        return self.authData

    def set_authData(self, authData):
        self.authData = authData

    def get_structure(self):
        return self.structure

    def set_structure(self, structure):
        self.structure = structure

    def _hasContent(self):
        if self.authData is not None or self.structure is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="getNearestServicepoints",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("getNearestServicepoints")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "getNearestServicepoints":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="getNearestServicepoints",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="getNearestServicepoints",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="getNearestServicepoints",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="getNearestServicepoints",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.authData is not None:
            namespaceprefix_ = (
                self.authData_nsprefix_ + ":"
                if (UseCapturedNS_ and self.authData_nsprefix_)
                else ""
            )
            self.authData.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="authData",
                pretty_print=pretty_print,
            )
        if self.structure is not None:
            namespaceprefix_ = (
                self.structure_nsprefix_ + ":"
                if (UseCapturedNS_ and self.structure_nsprefix_)
                else ""
            )
            self.structure.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="structure",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "authData":
            obj_ = AuthData.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.authData = obj_
            obj_.original_tagname_ = "authData"
        elif nodeName_ == "structure":
            obj_ = GetNearestServicepointsRequest.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.structure = obj_
            obj_.original_tagname_ = "structure"


# end class getNearestServicepoints


class SearchAddress(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(
        self,
        country=None,
        name=None,
        postcode=None,
        city=None,
        street=None,
        houseNumber=None,
        apartmentNumber=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.country = country
        self.country_nsprefix_ = None
        self.name = name
        self.name_nsprefix_ = None
        self.postcode = postcode
        self.postcode_nsprefix_ = None
        self.city = city
        self.city_nsprefix_ = None
        self.street = street
        self.street_nsprefix_ = None
        self.houseNumber = houseNumber
        self.houseNumber_nsprefix_ = None
        self.apartmentNumber = apartmentNumber
        self.apartmentNumber_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, SearchAddress)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SearchAddress.subclass:
            return SearchAddress.subclass(*args_, **kwargs_)
        else:
            return SearchAddress(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_country(self):
        return self.country

    def set_country(self, country):
        self.country = country

    def get_name(self):
        return self.name

    def set_name(self, name):
        self.name = name

    def get_postcode(self):
        return self.postcode

    def set_postcode(self, postcode):
        self.postcode = postcode

    def get_city(self):
        return self.city

    def set_city(self, city):
        self.city = city

    def get_street(self):
        return self.street

    def set_street(self, street):
        self.street = street

    def get_houseNumber(self):
        return self.houseNumber

    def set_houseNumber(self, houseNumber):
        self.houseNumber = houseNumber

    def get_apartmentNumber(self):
        return self.apartmentNumber

    def set_apartmentNumber(self, apartmentNumber):
        self.apartmentNumber = apartmentNumber

    def _hasContent(self):
        if (
            self.country is not None
            or self.name is not None
            or self.postcode is not None
            or self.city is not None
            or self.street is not None
            or self.houseNumber is not None
            or self.apartmentNumber is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="SearchAddress",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("SearchAddress")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "SearchAddress":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="SearchAddress"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="SearchAddress",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="SearchAddress",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="SearchAddress",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.country is not None:
            namespaceprefix_ = (
                self.country_nsprefix_ + ":"
                if (UseCapturedNS_ and self.country_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%scountry>%s</%scountry>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.country), input_name="country"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.name is not None:
            namespaceprefix_ = (
                self.name_nsprefix_ + ":"
                if (UseCapturedNS_ and self.name_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sname>%s</%sname>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(quote_xml(self.name), input_name="name")
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.postcode is not None:
            namespaceprefix_ = (
                self.postcode_nsprefix_ + ":"
                if (UseCapturedNS_ and self.postcode_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%spostcode>%s</%spostcode>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.postcode), input_name="postcode"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.city is not None:
            namespaceprefix_ = (
                self.city_nsprefix_ + ":"
                if (UseCapturedNS_ and self.city_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%scity>%s</%scity>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(quote_xml(self.city), input_name="city")
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.street is not None:
            namespaceprefix_ = (
                self.street_nsprefix_ + ":"
                if (UseCapturedNS_ and self.street_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sstreet>%s</%sstreet>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.street), input_name="street"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.houseNumber is not None:
            namespaceprefix_ = (
                self.houseNumber_nsprefix_ + ":"
                if (UseCapturedNS_ and self.houseNumber_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%shouseNumber>%s</%shouseNumber>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.houseNumber), input_name="houseNumber"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.apartmentNumber is not None:
            namespaceprefix_ = (
                self.apartmentNumber_nsprefix_ + ":"
                if (UseCapturedNS_ and self.apartmentNumber_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sapartmentNumber>%s</%sapartmentNumber>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.apartmentNumber),
                            input_name="apartmentNumber",
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "country":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "country")
            value_ = self.gds_validate_string(value_, node, "country")
            self.country = value_
            self.country_nsprefix_ = child_.prefix
        elif nodeName_ == "name":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "name")
            value_ = self.gds_validate_string(value_, node, "name")
            self.name = value_
            self.name_nsprefix_ = child_.prefix
        elif nodeName_ == "postcode":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "postcode")
            value_ = self.gds_validate_string(value_, node, "postcode")
            self.postcode = value_
            self.postcode_nsprefix_ = child_.prefix
        elif nodeName_ == "city":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "city")
            value_ = self.gds_validate_string(value_, node, "city")
            self.city = value_
            self.city_nsprefix_ = child_.prefix
        elif nodeName_ == "street":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "street")
            value_ = self.gds_validate_string(value_, node, "street")
            self.street = value_
            self.street_nsprefix_ = child_.prefix
        elif nodeName_ == "houseNumber":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "houseNumber")
            value_ = self.gds_validate_string(value_, node, "houseNumber")
            self.houseNumber = value_
            self.houseNumber_nsprefix_ = child_.prefix
        elif nodeName_ == "apartmentNumber":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "apartmentNumber")
            value_ = self.gds_validate_string(value_, node, "apartmentNumber")
            self.apartmentNumber = value_
            self.apartmentNumber_nsprefix_ = child_.prefix


# end class SearchAddress


class Point(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(
        self,
        type_=None,
        address=None,
        description=None,
        longitude=None,
        latitude=None,
        sap=None,
        monOpen=None,
        monClose=None,
        tueOpen=None,
        tueClose=None,
        wedOpen=None,
        wedClose=None,
        thuOpen=None,
        thuClose=None,
        friOpen=None,
        friClose=None,
        satOpen=None,
        satClose=None,
        sunOpen=None,
        sunClose=None,
        workInHoliday=None,
        name=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.type_ = type_
        self.type__nsprefix_ = None
        self.address = address
        self.address_nsprefix_ = "tns"
        self.description = description
        self.description_nsprefix_ = None
        self.longitude = longitude
        self.longitude_nsprefix_ = None
        self.latitude = latitude
        self.latitude_nsprefix_ = None
        self.sap = sap
        self.sap_nsprefix_ = None
        self.monOpen = monOpen
        self.monOpen_nsprefix_ = None
        self.monClose = monClose
        self.monClose_nsprefix_ = None
        self.tueOpen = tueOpen
        self.tueOpen_nsprefix_ = None
        self.tueClose = tueClose
        self.tueClose_nsprefix_ = None
        self.wedOpen = wedOpen
        self.wedOpen_nsprefix_ = None
        self.wedClose = wedClose
        self.wedClose_nsprefix_ = None
        self.thuOpen = thuOpen
        self.thuOpen_nsprefix_ = None
        self.thuClose = thuClose
        self.thuClose_nsprefix_ = None
        self.friOpen = friOpen
        self.friOpen_nsprefix_ = None
        self.friClose = friClose
        self.friClose_nsprefix_ = None
        self.satOpen = satOpen
        self.satOpen_nsprefix_ = None
        self.satClose = satClose
        self.satClose_nsprefix_ = None
        self.sunOpen = sunOpen
        self.sunOpen_nsprefix_ = None
        self.sunClose = sunClose
        self.sunClose_nsprefix_ = None
        self.workInHoliday = workInHoliday
        self.workInHoliday_nsprefix_ = None
        self.name = name
        self.name_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, Point)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Point.subclass:
            return Point.subclass(*args_, **kwargs_)
        else:
            return Point(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_type(self):
        return self.type_

    def set_type(self, type_):
        self.type_ = type_

    def get_address(self):
        return self.address

    def set_address(self, address):
        self.address = address

    def get_description(self):
        return self.description

    def set_description(self, description):
        self.description = description

    def get_longitude(self):
        return self.longitude

    def set_longitude(self, longitude):
        self.longitude = longitude

    def get_latitude(self):
        return self.latitude

    def set_latitude(self, latitude):
        self.latitude = latitude

    def get_sap(self):
        return self.sap

    def set_sap(self, sap):
        self.sap = sap

    def get_monOpen(self):
        return self.monOpen

    def set_monOpen(self, monOpen):
        self.monOpen = monOpen

    def get_monClose(self):
        return self.monClose

    def set_monClose(self, monClose):
        self.monClose = monClose

    def get_tueOpen(self):
        return self.tueOpen

    def set_tueOpen(self, tueOpen):
        self.tueOpen = tueOpen

    def get_tueClose(self):
        return self.tueClose

    def set_tueClose(self, tueClose):
        self.tueClose = tueClose

    def get_wedOpen(self):
        return self.wedOpen

    def set_wedOpen(self, wedOpen):
        self.wedOpen = wedOpen

    def get_wedClose(self):
        return self.wedClose

    def set_wedClose(self, wedClose):
        self.wedClose = wedClose

    def get_thuOpen(self):
        return self.thuOpen

    def set_thuOpen(self, thuOpen):
        self.thuOpen = thuOpen

    def get_thuClose(self):
        return self.thuClose

    def set_thuClose(self, thuClose):
        self.thuClose = thuClose

    def get_friOpen(self):
        return self.friOpen

    def set_friOpen(self, friOpen):
        self.friOpen = friOpen

    def get_friClose(self):
        return self.friClose

    def set_friClose(self, friClose):
        self.friClose = friClose

    def get_satOpen(self):
        return self.satOpen

    def set_satOpen(self, satOpen):
        self.satOpen = satOpen

    def get_satClose(self):
        return self.satClose

    def set_satClose(self, satClose):
        self.satClose = satClose

    def get_sunOpen(self):
        return self.sunOpen

    def set_sunOpen(self, sunOpen):
        self.sunOpen = sunOpen

    def get_sunClose(self):
        return self.sunClose

    def set_sunClose(self, sunClose):
        self.sunClose = sunClose

    def get_workInHoliday(self):
        return self.workInHoliday

    def set_workInHoliday(self, workInHoliday):
        self.workInHoliday = workInHoliday

    def get_name(self):
        return self.name

    def set_name(self, name):
        self.name = name

    def _hasContent(self):
        if (
            self.type_ is not None
            or self.address is not None
            or self.description is not None
            or self.longitude is not None
            or self.latitude is not None
            or self.sap is not None
            or self.monOpen is not None
            or self.monClose is not None
            or self.tueOpen is not None
            or self.tueClose is not None
            or self.wedOpen is not None
            or self.wedClose is not None
            or self.thuOpen is not None
            or self.thuClose is not None
            or self.friOpen is not None
            or self.friClose is not None
            or self.satOpen is not None
            or self.satClose is not None
            or self.sunOpen is not None
            or self.sunClose is not None
            or self.workInHoliday is not None
            or self.name is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Point",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("Point")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "Point":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Point"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="Point",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="Point"
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Point",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.type_ is not None:
            namespaceprefix_ = (
                self.type__nsprefix_ + ":"
                if (UseCapturedNS_ and self.type__nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%stype>%s</%stype>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(quote_xml(self.type_), input_name="type")
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.address is not None:
            namespaceprefix_ = (
                self.address_nsprefix_ + ":"
                if (UseCapturedNS_ and self.address_nsprefix_)
                else ""
            )
            self.address.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="address",
                pretty_print=pretty_print,
            )
        if self.description is not None:
            namespaceprefix_ = (
                self.description_nsprefix_ + ":"
                if (UseCapturedNS_ and self.description_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sdescription>%s</%sdescription>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.description), input_name="description"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.longitude is not None:
            namespaceprefix_ = (
                self.longitude_nsprefix_ + ":"
                if (UseCapturedNS_ and self.longitude_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%slongitude>%s</%slongitude>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.longitude), input_name="longitude"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.latitude is not None:
            namespaceprefix_ = (
                self.latitude_nsprefix_ + ":"
                if (UseCapturedNS_ and self.latitude_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%slatitude>%s</%slatitude>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.latitude), input_name="latitude"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.sap is not None:
            namespaceprefix_ = (
                self.sap_nsprefix_ + ":"
                if (UseCapturedNS_ and self.sap_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%ssap>%s</%ssap>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(quote_xml(self.sap), input_name="sap")
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.monOpen is not None:
            namespaceprefix_ = (
                self.monOpen_nsprefix_ + ":"
                if (UseCapturedNS_ and self.monOpen_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%smonOpen>%s</%smonOpen>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.monOpen), input_name="monOpen"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.monClose is not None:
            namespaceprefix_ = (
                self.monClose_nsprefix_ + ":"
                if (UseCapturedNS_ and self.monClose_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%smonClose>%s</%smonClose>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.monClose), input_name="monClose"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.tueOpen is not None:
            namespaceprefix_ = (
                self.tueOpen_nsprefix_ + ":"
                if (UseCapturedNS_ and self.tueOpen_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%stueOpen>%s</%stueOpen>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.tueOpen), input_name="tueOpen"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.tueClose is not None:
            namespaceprefix_ = (
                self.tueClose_nsprefix_ + ":"
                if (UseCapturedNS_ and self.tueClose_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%stueClose>%s</%stueClose>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.tueClose), input_name="tueClose"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.wedOpen is not None:
            namespaceprefix_ = (
                self.wedOpen_nsprefix_ + ":"
                if (UseCapturedNS_ and self.wedOpen_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%swedOpen>%s</%swedOpen>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.wedOpen), input_name="wedOpen"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.wedClose is not None:
            namespaceprefix_ = (
                self.wedClose_nsprefix_ + ":"
                if (UseCapturedNS_ and self.wedClose_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%swedClose>%s</%swedClose>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.wedClose), input_name="wedClose"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.thuOpen is not None:
            namespaceprefix_ = (
                self.thuOpen_nsprefix_ + ":"
                if (UseCapturedNS_ and self.thuOpen_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sthuOpen>%s</%sthuOpen>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.thuOpen), input_name="thuOpen"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.thuClose is not None:
            namespaceprefix_ = (
                self.thuClose_nsprefix_ + ":"
                if (UseCapturedNS_ and self.thuClose_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sthuClose>%s</%sthuClose>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.thuClose), input_name="thuClose"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.friOpen is not None:
            namespaceprefix_ = (
                self.friOpen_nsprefix_ + ":"
                if (UseCapturedNS_ and self.friOpen_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sfriOpen>%s</%sfriOpen>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.friOpen), input_name="friOpen"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.friClose is not None:
            namespaceprefix_ = (
                self.friClose_nsprefix_ + ":"
                if (UseCapturedNS_ and self.friClose_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sfriClose>%s</%sfriClose>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.friClose), input_name="friClose"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.satOpen is not None:
            namespaceprefix_ = (
                self.satOpen_nsprefix_ + ":"
                if (UseCapturedNS_ and self.satOpen_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%ssatOpen>%s</%ssatOpen>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.satOpen), input_name="satOpen"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.satClose is not None:
            namespaceprefix_ = (
                self.satClose_nsprefix_ + ":"
                if (UseCapturedNS_ and self.satClose_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%ssatClose>%s</%ssatClose>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.satClose), input_name="satClose"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.sunOpen is not None:
            namespaceprefix_ = (
                self.sunOpen_nsprefix_ + ":"
                if (UseCapturedNS_ and self.sunOpen_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%ssunOpen>%s</%ssunOpen>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.sunOpen), input_name="sunOpen"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.sunClose is not None:
            namespaceprefix_ = (
                self.sunClose_nsprefix_ + ":"
                if (UseCapturedNS_ and self.sunClose_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%ssunClose>%s</%ssunClose>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.sunClose), input_name="sunClose"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.workInHoliday is not None:
            namespaceprefix_ = (
                self.workInHoliday_nsprefix_ + ":"
                if (UseCapturedNS_ and self.workInHoliday_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sworkInHoliday>%s</%sworkInHoliday>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_boolean(
                        self.workInHoliday, input_name="workInHoliday"
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.name is not None:
            namespaceprefix_ = (
                self.name_nsprefix_ + ":"
                if (UseCapturedNS_ and self.name_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sname>%s</%sname>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(quote_xml(self.name), input_name="name")
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "type":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "type")
            value_ = self.gds_validate_string(value_, node, "type")
            self.type_ = value_
            self.type_nsprefix_ = child_.prefix
        elif nodeName_ == "address":
            obj_ = SearchAddress.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.address = obj_
            obj_.original_tagname_ = "address"
        elif nodeName_ == "description":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "description")
            value_ = self.gds_validate_string(value_, node, "description")
            self.description = value_
            self.description_nsprefix_ = child_.prefix
        elif nodeName_ == "longitude":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "longitude")
            value_ = self.gds_validate_string(value_, node, "longitude")
            self.longitude = value_
            self.longitude_nsprefix_ = child_.prefix
        elif nodeName_ == "latitude":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "latitude")
            value_ = self.gds_validate_string(value_, node, "latitude")
            self.latitude = value_
            self.latitude_nsprefix_ = child_.prefix
        elif nodeName_ == "sap":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "sap")
            value_ = self.gds_validate_string(value_, node, "sap")
            self.sap = value_
            self.sap_nsprefix_ = child_.prefix
        elif nodeName_ == "monOpen":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "monOpen")
            value_ = self.gds_validate_string(value_, node, "monOpen")
            self.monOpen = value_
            self.monOpen_nsprefix_ = child_.prefix
        elif nodeName_ == "monClose":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "monClose")
            value_ = self.gds_validate_string(value_, node, "monClose")
            self.monClose = value_
            self.monClose_nsprefix_ = child_.prefix
        elif nodeName_ == "tueOpen":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "tueOpen")
            value_ = self.gds_validate_string(value_, node, "tueOpen")
            self.tueOpen = value_
            self.tueOpen_nsprefix_ = child_.prefix
        elif nodeName_ == "tueClose":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "tueClose")
            value_ = self.gds_validate_string(value_, node, "tueClose")
            self.tueClose = value_
            self.tueClose_nsprefix_ = child_.prefix
        elif nodeName_ == "wedOpen":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "wedOpen")
            value_ = self.gds_validate_string(value_, node, "wedOpen")
            self.wedOpen = value_
            self.wedOpen_nsprefix_ = child_.prefix
        elif nodeName_ == "wedClose":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "wedClose")
            value_ = self.gds_validate_string(value_, node, "wedClose")
            self.wedClose = value_
            self.wedClose_nsprefix_ = child_.prefix
        elif nodeName_ == "thuOpen":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "thuOpen")
            value_ = self.gds_validate_string(value_, node, "thuOpen")
            self.thuOpen = value_
            self.thuOpen_nsprefix_ = child_.prefix
        elif nodeName_ == "thuClose":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "thuClose")
            value_ = self.gds_validate_string(value_, node, "thuClose")
            self.thuClose = value_
            self.thuClose_nsprefix_ = child_.prefix
        elif nodeName_ == "friOpen":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "friOpen")
            value_ = self.gds_validate_string(value_, node, "friOpen")
            self.friOpen = value_
            self.friOpen_nsprefix_ = child_.prefix
        elif nodeName_ == "friClose":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "friClose")
            value_ = self.gds_validate_string(value_, node, "friClose")
            self.friClose = value_
            self.friClose_nsprefix_ = child_.prefix
        elif nodeName_ == "satOpen":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "satOpen")
            value_ = self.gds_validate_string(value_, node, "satOpen")
            self.satOpen = value_
            self.satOpen_nsprefix_ = child_.prefix
        elif nodeName_ == "satClose":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "satClose")
            value_ = self.gds_validate_string(value_, node, "satClose")
            self.satClose = value_
            self.satClose_nsprefix_ = child_.prefix
        elif nodeName_ == "sunOpen":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "sunOpen")
            value_ = self.gds_validate_string(value_, node, "sunOpen")
            self.sunOpen = value_
            self.sunOpen_nsprefix_ = child_.prefix
        elif nodeName_ == "sunClose":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "sunClose")
            value_ = self.gds_validate_string(value_, node, "sunClose")
            self.sunClose = value_
            self.sunClose_nsprefix_ = child_.prefix
        elif nodeName_ == "workInHoliday":
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, "workInHoliday")
            ival_ = self.gds_validate_boolean(ival_, node, "workInHoliday")
            self.workInHoliday = ival_
            self.workInHoliday_nsprefix_ = child_.prefix
        elif nodeName_ == "name":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "name")
            value_ = self.gds_validate_string(value_, node, "name")
            self.name = value_
            self.name_nsprefix_ = child_.prefix


# end class Point


class ArrayOfPoint(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, item=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        if item is None:
            self.item = []
        else:
            self.item = item
        self.item_nsprefix_ = "tns"

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, ArrayOfPoint)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ArrayOfPoint.subclass:
            return ArrayOfPoint.subclass(*args_, **kwargs_)
        else:
            return ArrayOfPoint(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_item(self):
        return self.item

    def set_item(self, item):
        self.item = item

    def add_item(self, value):
        self.item.append(value)

    def insert_item_at(self, index, value):
        self.item.insert(index, value)

    def replace_item_at(self, index, value):
        self.item[index] = value

    def _hasContent(self):
        if self.item:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ArrayOfPoint",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ArrayOfPoint")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "ArrayOfPoint":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="ArrayOfPoint"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ArrayOfPoint",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="ArrayOfPoint",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ArrayOfPoint",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for item_ in self.item:
            namespaceprefix_ = (
                self.item_nsprefix_ + ":"
                if (UseCapturedNS_ and self.item_nsprefix_)
                else ""
            )
            item_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="item",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "item":
            obj_ = Point.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.item.append(obj_)
            obj_.original_tagname_ = "item"


# end class ArrayOfPoint


class GetNearestServicepointsResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, points=None, count=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.points = points
        self.points_nsprefix_ = "tns"
        self.count = count
        self.count_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GetNearestServicepointsResponse
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GetNearestServicepointsResponse.subclass:
            return GetNearestServicepointsResponse.subclass(*args_, **kwargs_)
        else:
            return GetNearestServicepointsResponse(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_points(self):
        return self.points

    def set_points(self, points):
        self.points = points

    def get_count(self):
        return self.count

    def set_count(self, count):
        self.count = count

    def _hasContent(self):
        if self.points is not None or self.count is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="GetNearestServicepointsResponse",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get(
            "GetNearestServicepointsResponse"
        )
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if (
            self.original_tagname_ is not None
            and name_ == "GetNearestServicepointsResponse"
        ):
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="GetNearestServicepointsResponse",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="GetNearestServicepointsResponse",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="GetNearestServicepointsResponse",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="GetNearestServicepointsResponse",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.points is not None:
            namespaceprefix_ = (
                self.points_nsprefix_ + ":"
                if (UseCapturedNS_ and self.points_nsprefix_)
                else ""
            )
            self.points.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="points",
                pretty_print=pretty_print,
            )
        if self.count is not None:
            namespaceprefix_ = (
                self.count_nsprefix_ + ":"
                if (UseCapturedNS_ and self.count_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%scount>%s</%scount>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_integer(self.count, input_name="count"),
                    namespaceprefix_,
                    eol_,
                )
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "points":
            obj_ = ArrayOfPoint.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.points = obj_
            obj_.original_tagname_ = "points"
        elif nodeName_ == "count" and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, "count")
            ival_ = self.gds_validate_integer(ival_, node, "count")
            self.count = ival_
            self.count_nsprefix_ = child_.prefix


# end class GetNearestServicepointsResponse


class getNearestServicepointsResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(
        self, getNearestServicepointsResult=None, gds_collector_=None, **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.getNearestServicepointsResult = getNearestServicepointsResult
        self.getNearestServicepointsResult_nsprefix_ = "tns"

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, getNearestServicepointsResponse
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getNearestServicepointsResponse.subclass:
            return getNearestServicepointsResponse.subclass(*args_, **kwargs_)
        else:
            return getNearestServicepointsResponse(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_getNearestServicepointsResult(self):
        return self.getNearestServicepointsResult

    def set_getNearestServicepointsResult(self, getNearestServicepointsResult):
        self.getNearestServicepointsResult = getNearestServicepointsResult

    def _hasContent(self):
        if self.getNearestServicepointsResult is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="getNearestServicepointsResponse",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get(
            "getNearestServicepointsResponse"
        )
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if (
            self.original_tagname_ is not None
            and name_ == "getNearestServicepointsResponse"
        ):
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="getNearestServicepointsResponse",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="getNearestServicepointsResponse",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="getNearestServicepointsResponse",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="getNearestServicepointsResponse",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.getNearestServicepointsResult is not None:
            namespaceprefix_ = (
                self.getNearestServicepointsResult_nsprefix_ + ":"
                if (UseCapturedNS_ and self.getNearestServicepointsResult_nsprefix_)
                else ""
            )
            self.getNearestServicepointsResult.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="getNearestServicepointsResult",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "getNearestServicepointsResult":
            obj_ = GetNearestServicepointsResponse.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.getNearestServicepointsResult = obj_
            obj_.original_tagname_ = "getNearestServicepointsResult"


# end class getNearestServicepointsResponse


class getInternationalParams(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, authData=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.authData = authData
        self.authData_nsprefix_ = "tns"

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, getInternationalParams
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if getInternationalParams.subclass:
            return getInternationalParams.subclass(*args_, **kwargs_)
        else:
            return getInternationalParams(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_authData(self):
        return self.authData

    def set_authData(self, authData):
        self.authData = authData

    def _hasContent(self):
        if self.authData is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="getInternationalParams",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("getInternationalParams")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "getInternationalParams":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="getInternationalParams",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="getInternationalParams",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="getInternationalParams",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="getInternationalParams",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.authData is not None:
            namespaceprefix_ = (
                self.authData_nsprefix_ + ":"
                if (UseCapturedNS_ and self.authData_nsprefix_)
                else ""
            )
            self.authData.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="authData",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "authData":
            obj_ = AuthData.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.authData = obj_
            obj_.original_tagname_ = "authData"


# end class getInternationalParams


class InternationalParam(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(
        self,
        countryName=None,
        countryNameEn=None,
        countryCode=None,
        product=None,
        pieceHeader=None,
        routing=None,
        code2l=None,
        pickupDays=None,
        courierMaxWeight=None,
        courierMaxWidth=None,
        courierMaxHeight=None,
        courierMaxLength=None,
        courierMaxCod=None,
        courierCodCurrency=None,
        courierExchrate=None,
        courierNstAvailable=None,
        courierMaxNst=None,
        courierMaxGirth=None,
        packstationAvailable=None,
        packstationMaxWeight=None,
        packstationMaxWidth=None,
        packstationMaxHeight=None,
        packstationMaxLength=None,
        postfilialeAvailable=None,
        postfilialeMaxWeight=None,
        postfilialeMaxWidth=None,
        postfilialeMaxHeight=None,
        postfilialeMaxLength=None,
        zipFormat=None,
        identifier=None,
        emailRequired=None,
        active=None,
        dutyProduct=None,
        dutyPickupDays=None,
        dutyPieceHeader=None,
        dutyMaxWeight=None,
        dutyMaxWidth=None,
        dutyMaxHeight=None,
        dutyMaxLength=None,
        dutyNstAvailable=None,
        dutyMaxNst=None,
        dutyMaxGirth=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.countryName = countryName
        self.countryName_nsprefix_ = None
        self.countryNameEn = countryNameEn
        self.countryNameEn_nsprefix_ = None
        self.countryCode = countryCode
        self.countryCode_nsprefix_ = None
        self.product = product
        self.product_nsprefix_ = None
        self.pieceHeader = pieceHeader
        self.pieceHeader_nsprefix_ = None
        self.routing = routing
        self.routing_nsprefix_ = None
        self.code2l = code2l
        self.code2l_nsprefix_ = None
        self.pickupDays = pickupDays
        self.pickupDays_nsprefix_ = None
        self.courierMaxWeight = courierMaxWeight
        self.courierMaxWeight_nsprefix_ = None
        self.courierMaxWidth = courierMaxWidth
        self.courierMaxWidth_nsprefix_ = None
        self.courierMaxHeight = courierMaxHeight
        self.courierMaxHeight_nsprefix_ = None
        self.courierMaxLength = courierMaxLength
        self.courierMaxLength_nsprefix_ = None
        self.courierMaxCod = courierMaxCod
        self.courierMaxCod_nsprefix_ = None
        self.courierCodCurrency = courierCodCurrency
        self.courierCodCurrency_nsprefix_ = None
        self.courierExchrate = courierExchrate
        self.courierExchrate_nsprefix_ = None
        self.courierNstAvailable = courierNstAvailable
        self.courierNstAvailable_nsprefix_ = None
        self.courierMaxNst = courierMaxNst
        self.courierMaxNst_nsprefix_ = None
        self.courierMaxGirth = courierMaxGirth
        self.courierMaxGirth_nsprefix_ = None
        self.packstationAvailable = packstationAvailable
        self.packstationAvailable_nsprefix_ = None
        self.packstationMaxWeight = packstationMaxWeight
        self.packstationMaxWeight_nsprefix_ = None
        self.packstationMaxWidth = packstationMaxWidth
        self.packstationMaxWidth_nsprefix_ = None
        self.packstationMaxHeight = packstationMaxHeight
        self.packstationMaxHeight_nsprefix_ = None
        self.packstationMaxLength = packstationMaxLength
        self.packstationMaxLength_nsprefix_ = None
        self.postfilialeAvailable = postfilialeAvailable
        self.postfilialeAvailable_nsprefix_ = None
        self.postfilialeMaxWeight = postfilialeMaxWeight
        self.postfilialeMaxWeight_nsprefix_ = None
        self.postfilialeMaxWidth = postfilialeMaxWidth
        self.postfilialeMaxWidth_nsprefix_ = None
        self.postfilialeMaxHeight = postfilialeMaxHeight
        self.postfilialeMaxHeight_nsprefix_ = None
        self.postfilialeMaxLength = postfilialeMaxLength
        self.postfilialeMaxLength_nsprefix_ = None
        self.zipFormat = zipFormat
        self.zipFormat_nsprefix_ = None
        self.identifier = identifier
        self.identifier_nsprefix_ = None
        self.emailRequired = emailRequired
        self.emailRequired_nsprefix_ = None
        self.active = active
        self.active_nsprefix_ = None
        self.dutyProduct = dutyProduct
        self.dutyProduct_nsprefix_ = None
        self.dutyPickupDays = dutyPickupDays
        self.dutyPickupDays_nsprefix_ = None
        self.dutyPieceHeader = dutyPieceHeader
        self.dutyPieceHeader_nsprefix_ = None
        self.dutyMaxWeight = dutyMaxWeight
        self.dutyMaxWeight_nsprefix_ = None
        self.dutyMaxWidth = dutyMaxWidth
        self.dutyMaxWidth_nsprefix_ = None
        self.dutyMaxHeight = dutyMaxHeight
        self.dutyMaxHeight_nsprefix_ = None
        self.dutyMaxLength = dutyMaxLength
        self.dutyMaxLength_nsprefix_ = None
        self.dutyNstAvailable = dutyNstAvailable
        self.dutyNstAvailable_nsprefix_ = None
        self.dutyMaxNst = dutyMaxNst
        self.dutyMaxNst_nsprefix_ = None
        self.dutyMaxGirth = dutyMaxGirth
        self.dutyMaxGirth_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, InternationalParam
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if InternationalParam.subclass:
            return InternationalParam.subclass(*args_, **kwargs_)
        else:
            return InternationalParam(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_countryName(self):
        return self.countryName

    def set_countryName(self, countryName):
        self.countryName = countryName

    def get_countryNameEn(self):
        return self.countryNameEn

    def set_countryNameEn(self, countryNameEn):
        self.countryNameEn = countryNameEn

    def get_countryCode(self):
        return self.countryCode

    def set_countryCode(self, countryCode):
        self.countryCode = countryCode

    def get_product(self):
        return self.product

    def set_product(self, product):
        self.product = product

    def get_pieceHeader(self):
        return self.pieceHeader

    def set_pieceHeader(self, pieceHeader):
        self.pieceHeader = pieceHeader

    def get_routing(self):
        return self.routing

    def set_routing(self, routing):
        self.routing = routing

    def get_code2l(self):
        return self.code2l

    def set_code2l(self, code2l):
        self.code2l = code2l

    def get_pickupDays(self):
        return self.pickupDays

    def set_pickupDays(self, pickupDays):
        self.pickupDays = pickupDays

    def get_courierMaxWeight(self):
        return self.courierMaxWeight

    def set_courierMaxWeight(self, courierMaxWeight):
        self.courierMaxWeight = courierMaxWeight

    def get_courierMaxWidth(self):
        return self.courierMaxWidth

    def set_courierMaxWidth(self, courierMaxWidth):
        self.courierMaxWidth = courierMaxWidth

    def get_courierMaxHeight(self):
        return self.courierMaxHeight

    def set_courierMaxHeight(self, courierMaxHeight):
        self.courierMaxHeight = courierMaxHeight

    def get_courierMaxLength(self):
        return self.courierMaxLength

    def set_courierMaxLength(self, courierMaxLength):
        self.courierMaxLength = courierMaxLength

    def get_courierMaxCod(self):
        return self.courierMaxCod

    def set_courierMaxCod(self, courierMaxCod):
        self.courierMaxCod = courierMaxCod

    def get_courierCodCurrency(self):
        return self.courierCodCurrency

    def set_courierCodCurrency(self, courierCodCurrency):
        self.courierCodCurrency = courierCodCurrency

    def get_courierExchrate(self):
        return self.courierExchrate

    def set_courierExchrate(self, courierExchrate):
        self.courierExchrate = courierExchrate

    def get_courierNstAvailable(self):
        return self.courierNstAvailable

    def set_courierNstAvailable(self, courierNstAvailable):
        self.courierNstAvailable = courierNstAvailable

    def get_courierMaxNst(self):
        return self.courierMaxNst

    def set_courierMaxNst(self, courierMaxNst):
        self.courierMaxNst = courierMaxNst

    def get_courierMaxGirth(self):
        return self.courierMaxGirth

    def set_courierMaxGirth(self, courierMaxGirth):
        self.courierMaxGirth = courierMaxGirth

    def get_packstationAvailable(self):
        return self.packstationAvailable

    def set_packstationAvailable(self, packstationAvailable):
        self.packstationAvailable = packstationAvailable

    def get_packstationMaxWeight(self):
        return self.packstationMaxWeight

    def set_packstationMaxWeight(self, packstationMaxWeight):
        self.packstationMaxWeight = packstationMaxWeight

    def get_packstationMaxWidth(self):
        return self.packstationMaxWidth

    def set_packstationMaxWidth(self, packstationMaxWidth):
        self.packstationMaxWidth = packstationMaxWidth

    def get_packstationMaxHeight(self):
        return self.packstationMaxHeight

    def set_packstationMaxHeight(self, packstationMaxHeight):
        self.packstationMaxHeight = packstationMaxHeight

    def get_packstationMaxLength(self):
        return self.packstationMaxLength

    def set_packstationMaxLength(self, packstationMaxLength):
        self.packstationMaxLength = packstationMaxLength

    def get_postfilialeAvailable(self):
        return self.postfilialeAvailable

    def set_postfilialeAvailable(self, postfilialeAvailable):
        self.postfilialeAvailable = postfilialeAvailable

    def get_postfilialeMaxWeight(self):
        return self.postfilialeMaxWeight

    def set_postfilialeMaxWeight(self, postfilialeMaxWeight):
        self.postfilialeMaxWeight = postfilialeMaxWeight

    def get_postfilialeMaxWidth(self):
        return self.postfilialeMaxWidth

    def set_postfilialeMaxWidth(self, postfilialeMaxWidth):
        self.postfilialeMaxWidth = postfilialeMaxWidth

    def get_postfilialeMaxHeight(self):
        return self.postfilialeMaxHeight

    def set_postfilialeMaxHeight(self, postfilialeMaxHeight):
        self.postfilialeMaxHeight = postfilialeMaxHeight

    def get_postfilialeMaxLength(self):
        return self.postfilialeMaxLength

    def set_postfilialeMaxLength(self, postfilialeMaxLength):
        self.postfilialeMaxLength = postfilialeMaxLength

    def get_zipFormat(self):
        return self.zipFormat

    def set_zipFormat(self, zipFormat):
        self.zipFormat = zipFormat

    def get_identifier(self):
        return self.identifier

    def set_identifier(self, identifier):
        self.identifier = identifier

    def get_emailRequired(self):
        return self.emailRequired

    def set_emailRequired(self, emailRequired):
        self.emailRequired = emailRequired

    def get_active(self):
        return self.active

    def set_active(self, active):
        self.active = active

    def get_dutyProduct(self):
        return self.dutyProduct

    def set_dutyProduct(self, dutyProduct):
        self.dutyProduct = dutyProduct

    def get_dutyPickupDays(self):
        return self.dutyPickupDays

    def set_dutyPickupDays(self, dutyPickupDays):
        self.dutyPickupDays = dutyPickupDays

    def get_dutyPieceHeader(self):
        return self.dutyPieceHeader

    def set_dutyPieceHeader(self, dutyPieceHeader):
        self.dutyPieceHeader = dutyPieceHeader

    def get_dutyMaxWeight(self):
        return self.dutyMaxWeight

    def set_dutyMaxWeight(self, dutyMaxWeight):
        self.dutyMaxWeight = dutyMaxWeight

    def get_dutyMaxWidth(self):
        return self.dutyMaxWidth

    def set_dutyMaxWidth(self, dutyMaxWidth):
        self.dutyMaxWidth = dutyMaxWidth

    def get_dutyMaxHeight(self):
        return self.dutyMaxHeight

    def set_dutyMaxHeight(self, dutyMaxHeight):
        self.dutyMaxHeight = dutyMaxHeight

    def get_dutyMaxLength(self):
        return self.dutyMaxLength

    def set_dutyMaxLength(self, dutyMaxLength):
        self.dutyMaxLength = dutyMaxLength

    def get_dutyNstAvailable(self):
        return self.dutyNstAvailable

    def set_dutyNstAvailable(self, dutyNstAvailable):
        self.dutyNstAvailable = dutyNstAvailable

    def get_dutyMaxNst(self):
        return self.dutyMaxNst

    def set_dutyMaxNst(self, dutyMaxNst):
        self.dutyMaxNst = dutyMaxNst

    def get_dutyMaxGirth(self):
        return self.dutyMaxGirth

    def set_dutyMaxGirth(self, dutyMaxGirth):
        self.dutyMaxGirth = dutyMaxGirth

    def _hasContent(self):
        if (
            self.countryName is not None
            or self.countryNameEn is not None
            or self.countryCode is not None
            or self.product is not None
            or self.pieceHeader is not None
            or self.routing is not None
            or self.code2l is not None
            or self.pickupDays is not None
            or self.courierMaxWeight is not None
            or self.courierMaxWidth is not None
            or self.courierMaxHeight is not None
            or self.courierMaxLength is not None
            or self.courierMaxCod is not None
            or self.courierCodCurrency is not None
            or self.courierExchrate is not None
            or self.courierNstAvailable is not None
            or self.courierMaxNst is not None
            or self.courierMaxGirth is not None
            or self.packstationAvailable is not None
            or self.packstationMaxWeight is not None
            or self.packstationMaxWidth is not None
            or self.packstationMaxHeight is not None
            or self.packstationMaxLength is not None
            or self.postfilialeAvailable is not None
            or self.postfilialeMaxWeight is not None
            or self.postfilialeMaxWidth is not None
            or self.postfilialeMaxHeight is not None
            or self.postfilialeMaxLength is not None
            or self.zipFormat is not None
            or self.identifier is not None
            or self.emailRequired is not None
            or self.active is not None
            or self.dutyProduct is not None
            or self.dutyPickupDays is not None
            or self.dutyPieceHeader is not None
            or self.dutyMaxWeight is not None
            or self.dutyMaxWidth is not None
            or self.dutyMaxHeight is not None
            or self.dutyMaxLength is not None
            or self.dutyNstAvailable is not None
            or self.dutyMaxNst is not None
            or self.dutyMaxGirth is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="InternationalParam",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("InternationalParam")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "InternationalParam":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="InternationalParam",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="InternationalParam",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="InternationalParam",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="InternationalParam",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.countryName is not None:
            namespaceprefix_ = (
                self.countryName_nsprefix_ + ":"
                if (UseCapturedNS_ and self.countryName_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%scountryName>%s</%scountryName>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.countryName), input_name="countryName"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.countryNameEn is not None:
            namespaceprefix_ = (
                self.countryNameEn_nsprefix_ + ":"
                if (UseCapturedNS_ and self.countryNameEn_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%scountryNameEn>%s</%scountryNameEn>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.countryNameEn), input_name="countryNameEn"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.countryCode is not None:
            namespaceprefix_ = (
                self.countryCode_nsprefix_ + ":"
                if (UseCapturedNS_ and self.countryCode_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%scountryCode>%s</%scountryCode>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.countryCode), input_name="countryCode"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.product is not None:
            namespaceprefix_ = (
                self.product_nsprefix_ + ":"
                if (UseCapturedNS_ and self.product_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sproduct>%s</%sproduct>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.product), input_name="product"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.pieceHeader is not None:
            namespaceprefix_ = (
                self.pieceHeader_nsprefix_ + ":"
                if (UseCapturedNS_ and self.pieceHeader_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%spieceHeader>%s</%spieceHeader>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.pieceHeader), input_name="pieceHeader"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.routing is not None:
            namespaceprefix_ = (
                self.routing_nsprefix_ + ":"
                if (UseCapturedNS_ and self.routing_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%srouting>%s</%srouting>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.routing), input_name="routing"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.code2l is not None:
            namespaceprefix_ = (
                self.code2l_nsprefix_ + ":"
                if (UseCapturedNS_ and self.code2l_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%scode2l>%s</%scode2l>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.code2l), input_name="code2l"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.pickupDays is not None:
            namespaceprefix_ = (
                self.pickupDays_nsprefix_ + ":"
                if (UseCapturedNS_ and self.pickupDays_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%spickupDays>%s</%spickupDays>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_integer(self.pickupDays, input_name="pickupDays"),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.courierMaxWeight is not None:
            namespaceprefix_ = (
                self.courierMaxWeight_nsprefix_ + ":"
                if (UseCapturedNS_ and self.courierMaxWeight_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%scourierMaxWeight>%s</%scourierMaxWeight>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_float(
                        self.courierMaxWeight, input_name="courierMaxWeight"
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.courierMaxWidth is not None:
            namespaceprefix_ = (
                self.courierMaxWidth_nsprefix_ + ":"
                if (UseCapturedNS_ and self.courierMaxWidth_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%scourierMaxWidth>%s</%scourierMaxWidth>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_integer(
                        self.courierMaxWidth, input_name="courierMaxWidth"
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.courierMaxHeight is not None:
            namespaceprefix_ = (
                self.courierMaxHeight_nsprefix_ + ":"
                if (UseCapturedNS_ and self.courierMaxHeight_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%scourierMaxHeight>%s</%scourierMaxHeight>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_integer(
                        self.courierMaxHeight, input_name="courierMaxHeight"
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.courierMaxLength is not None:
            namespaceprefix_ = (
                self.courierMaxLength_nsprefix_ + ":"
                if (UseCapturedNS_ and self.courierMaxLength_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%scourierMaxLength>%s</%scourierMaxLength>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_integer(
                        self.courierMaxLength, input_name="courierMaxLength"
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.courierMaxCod is not None:
            namespaceprefix_ = (
                self.courierMaxCod_nsprefix_ + ":"
                if (UseCapturedNS_ and self.courierMaxCod_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%scourierMaxCod>%s</%scourierMaxCod>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_integer(
                        self.courierMaxCod, input_name="courierMaxCod"
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.courierCodCurrency is not None:
            namespaceprefix_ = (
                self.courierCodCurrency_nsprefix_ + ":"
                if (UseCapturedNS_ and self.courierCodCurrency_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%scourierCodCurrency>%s</%scourierCodCurrency>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.courierCodCurrency),
                            input_name="courierCodCurrency",
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.courierExchrate is not None:
            namespaceprefix_ = (
                self.courierExchrate_nsprefix_ + ":"
                if (UseCapturedNS_ and self.courierExchrate_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%scourierExchrate>%s</%scourierExchrate>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_float(
                        self.courierExchrate, input_name="courierExchrate"
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.courierNstAvailable is not None:
            namespaceprefix_ = (
                self.courierNstAvailable_nsprefix_ + ":"
                if (UseCapturedNS_ and self.courierNstAvailable_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%scourierNstAvailable>%s</%scourierNstAvailable>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_boolean(
                        self.courierNstAvailable, input_name="courierNstAvailable"
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.courierMaxNst is not None:
            namespaceprefix_ = (
                self.courierMaxNst_nsprefix_ + ":"
                if (UseCapturedNS_ and self.courierMaxNst_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%scourierMaxNst>%s</%scourierMaxNst>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_integer(
                        self.courierMaxNst, input_name="courierMaxNst"
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.courierMaxGirth is not None:
            namespaceprefix_ = (
                self.courierMaxGirth_nsprefix_ + ":"
                if (UseCapturedNS_ and self.courierMaxGirth_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%scourierMaxGirth>%s</%scourierMaxGirth>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_integer(
                        self.courierMaxGirth, input_name="courierMaxGirth"
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.packstationAvailable is not None:
            namespaceprefix_ = (
                self.packstationAvailable_nsprefix_ + ":"
                if (UseCapturedNS_ and self.packstationAvailable_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%spackstationAvailable>%s</%spackstationAvailable>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_boolean(
                        self.packstationAvailable, input_name="packstationAvailable"
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.packstationMaxWeight is not None:
            namespaceprefix_ = (
                self.packstationMaxWeight_nsprefix_ + ":"
                if (UseCapturedNS_ and self.packstationMaxWeight_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%spackstationMaxWeight>%s</%spackstationMaxWeight>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_float(
                        self.packstationMaxWeight, input_name="packstationMaxWeight"
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.packstationMaxWidth is not None:
            namespaceprefix_ = (
                self.packstationMaxWidth_nsprefix_ + ":"
                if (UseCapturedNS_ and self.packstationMaxWidth_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%spackstationMaxWidth>%s</%spackstationMaxWidth>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_integer(
                        self.packstationMaxWidth, input_name="packstationMaxWidth"
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.packstationMaxHeight is not None:
            namespaceprefix_ = (
                self.packstationMaxHeight_nsprefix_ + ":"
                if (UseCapturedNS_ and self.packstationMaxHeight_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%spackstationMaxHeight>%s</%spackstationMaxHeight>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_integer(
                        self.packstationMaxHeight, input_name="packstationMaxHeight"
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.packstationMaxLength is not None:
            namespaceprefix_ = (
                self.packstationMaxLength_nsprefix_ + ":"
                if (UseCapturedNS_ and self.packstationMaxLength_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%spackstationMaxLength>%s</%spackstationMaxLength>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_integer(
                        self.packstationMaxLength, input_name="packstationMaxLength"
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.postfilialeAvailable is not None:
            namespaceprefix_ = (
                self.postfilialeAvailable_nsprefix_ + ":"
                if (UseCapturedNS_ and self.postfilialeAvailable_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%spostfilialeAvailable>%s</%spostfilialeAvailable>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_boolean(
                        self.postfilialeAvailable, input_name="postfilialeAvailable"
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.postfilialeMaxWeight is not None:
            namespaceprefix_ = (
                self.postfilialeMaxWeight_nsprefix_ + ":"
                if (UseCapturedNS_ and self.postfilialeMaxWeight_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%spostfilialeMaxWeight>%s</%spostfilialeMaxWeight>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_float(
                        self.postfilialeMaxWeight, input_name="postfilialeMaxWeight"
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.postfilialeMaxWidth is not None:
            namespaceprefix_ = (
                self.postfilialeMaxWidth_nsprefix_ + ":"
                if (UseCapturedNS_ and self.postfilialeMaxWidth_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%spostfilialeMaxWidth>%s</%spostfilialeMaxWidth>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_integer(
                        self.postfilialeMaxWidth, input_name="postfilialeMaxWidth"
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.postfilialeMaxHeight is not None:
            namespaceprefix_ = (
                self.postfilialeMaxHeight_nsprefix_ + ":"
                if (UseCapturedNS_ and self.postfilialeMaxHeight_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%spostfilialeMaxHeight>%s</%spostfilialeMaxHeight>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_integer(
                        self.postfilialeMaxHeight, input_name="postfilialeMaxHeight"
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.postfilialeMaxLength is not None:
            namespaceprefix_ = (
                self.postfilialeMaxLength_nsprefix_ + ":"
                if (UseCapturedNS_ and self.postfilialeMaxLength_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%spostfilialeMaxLength>%s</%spostfilialeMaxLength>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_integer(
                        self.postfilialeMaxLength, input_name="postfilialeMaxLength"
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.zipFormat is not None:
            namespaceprefix_ = (
                self.zipFormat_nsprefix_ + ":"
                if (UseCapturedNS_ and self.zipFormat_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%szipFormat>%s</%szipFormat>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.zipFormat), input_name="zipFormat"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.identifier is not None:
            namespaceprefix_ = (
                self.identifier_nsprefix_ + ":"
                if (UseCapturedNS_ and self.identifier_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sidentifier>%s</%sidentifier>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.identifier), input_name="identifier"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.emailRequired is not None:
            namespaceprefix_ = (
                self.emailRequired_nsprefix_ + ":"
                if (UseCapturedNS_ and self.emailRequired_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%semailRequired>%s</%semailRequired>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_integer(
                        self.emailRequired, input_name="emailRequired"
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.active is not None:
            namespaceprefix_ = (
                self.active_nsprefix_ + ":"
                if (UseCapturedNS_ and self.active_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sactive>%s</%sactive>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.active), input_name="active"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.dutyProduct is not None:
            namespaceprefix_ = (
                self.dutyProduct_nsprefix_ + ":"
                if (UseCapturedNS_ and self.dutyProduct_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sdutyProduct>%s</%sdutyProduct>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.dutyProduct), input_name="dutyProduct"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.dutyPickupDays is not None:
            namespaceprefix_ = (
                self.dutyPickupDays_nsprefix_ + ":"
                if (UseCapturedNS_ and self.dutyPickupDays_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sdutyPickupDays>%s</%sdutyPickupDays>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_integer(
                        self.dutyPickupDays, input_name="dutyPickupDays"
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.dutyPieceHeader is not None:
            namespaceprefix_ = (
                self.dutyPieceHeader_nsprefix_ + ":"
                if (UseCapturedNS_ and self.dutyPieceHeader_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sdutyPieceHeader>%s</%sdutyPieceHeader>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.dutyPieceHeader),
                            input_name="dutyPieceHeader",
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.dutyMaxWeight is not None:
            namespaceprefix_ = (
                self.dutyMaxWeight_nsprefix_ + ":"
                if (UseCapturedNS_ and self.dutyMaxWeight_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sdutyMaxWeight>%s</%sdutyMaxWeight>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_float(
                        self.dutyMaxWeight, input_name="dutyMaxWeight"
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.dutyMaxWidth is not None:
            namespaceprefix_ = (
                self.dutyMaxWidth_nsprefix_ + ":"
                if (UseCapturedNS_ and self.dutyMaxWidth_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sdutyMaxWidth>%s</%sdutyMaxWidth>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_integer(
                        self.dutyMaxWidth, input_name="dutyMaxWidth"
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.dutyMaxHeight is not None:
            namespaceprefix_ = (
                self.dutyMaxHeight_nsprefix_ + ":"
                if (UseCapturedNS_ and self.dutyMaxHeight_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sdutyMaxHeight>%s</%sdutyMaxHeight>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_integer(
                        self.dutyMaxHeight, input_name="dutyMaxHeight"
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.dutyMaxLength is not None:
            namespaceprefix_ = (
                self.dutyMaxLength_nsprefix_ + ":"
                if (UseCapturedNS_ and self.dutyMaxLength_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sdutyMaxLength>%s</%sdutyMaxLength>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_integer(
                        self.dutyMaxLength, input_name="dutyMaxLength"
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.dutyNstAvailable is not None:
            namespaceprefix_ = (
                self.dutyNstAvailable_nsprefix_ + ":"
                if (UseCapturedNS_ and self.dutyNstAvailable_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sdutyNstAvailable>%s</%sdutyNstAvailable>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_boolean(
                        self.dutyNstAvailable, input_name="dutyNstAvailable"
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.dutyMaxNst is not None:
            namespaceprefix_ = (
                self.dutyMaxNst_nsprefix_ + ":"
                if (UseCapturedNS_ and self.dutyMaxNst_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sdutyMaxNst>%s</%sdutyMaxNst>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_integer(self.dutyMaxNst, input_name="dutyMaxNst"),
                    namespaceprefix_,
                    eol_,
                )
            )
        if self.dutyMaxGirth is not None:
            namespaceprefix_ = (
                self.dutyMaxGirth_nsprefix_ + ":"
                if (UseCapturedNS_ and self.dutyMaxGirth_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%sdutyMaxGirth>%s</%sdutyMaxGirth>%s"
                % (
                    namespaceprefix_,
                    self.gds_format_integer(
                        self.dutyMaxGirth, input_name="dutyMaxGirth"
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "countryName":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "countryName")
            value_ = self.gds_validate_string(value_, node, "countryName")
            self.countryName = value_
            self.countryName_nsprefix_ = child_.prefix
        elif nodeName_ == "countryNameEn":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "countryNameEn")
            value_ = self.gds_validate_string(value_, node, "countryNameEn")
            self.countryNameEn = value_
            self.countryNameEn_nsprefix_ = child_.prefix
        elif nodeName_ == "countryCode":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "countryCode")
            value_ = self.gds_validate_string(value_, node, "countryCode")
            self.countryCode = value_
            self.countryCode_nsprefix_ = child_.prefix
        elif nodeName_ == "product":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "product")
            value_ = self.gds_validate_string(value_, node, "product")
            self.product = value_
            self.product_nsprefix_ = child_.prefix
        elif nodeName_ == "pieceHeader":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "pieceHeader")
            value_ = self.gds_validate_string(value_, node, "pieceHeader")
            self.pieceHeader = value_
            self.pieceHeader_nsprefix_ = child_.prefix
        elif nodeName_ == "routing":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "routing")
            value_ = self.gds_validate_string(value_, node, "routing")
            self.routing = value_
            self.routing_nsprefix_ = child_.prefix
        elif nodeName_ == "code2l":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "code2l")
            value_ = self.gds_validate_string(value_, node, "code2l")
            self.code2l = value_
            self.code2l_nsprefix_ = child_.prefix
        elif nodeName_ == "pickupDays" and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, "pickupDays")
            ival_ = self.gds_validate_integer(ival_, node, "pickupDays")
            self.pickupDays = ival_
            self.pickupDays_nsprefix_ = child_.prefix
        elif nodeName_ == "courierMaxWeight" and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, "courierMaxWeight")
            fval_ = self.gds_validate_float(fval_, node, "courierMaxWeight")
            self.courierMaxWeight = fval_
            self.courierMaxWeight_nsprefix_ = child_.prefix
        elif nodeName_ == "courierMaxWidth" and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, "courierMaxWidth")
            ival_ = self.gds_validate_integer(ival_, node, "courierMaxWidth")
            self.courierMaxWidth = ival_
            self.courierMaxWidth_nsprefix_ = child_.prefix
        elif nodeName_ == "courierMaxHeight" and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, "courierMaxHeight")
            ival_ = self.gds_validate_integer(ival_, node, "courierMaxHeight")
            self.courierMaxHeight = ival_
            self.courierMaxHeight_nsprefix_ = child_.prefix
        elif nodeName_ == "courierMaxLength" and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, "courierMaxLength")
            ival_ = self.gds_validate_integer(ival_, node, "courierMaxLength")
            self.courierMaxLength = ival_
            self.courierMaxLength_nsprefix_ = child_.prefix
        elif nodeName_ == "courierMaxCod" and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, "courierMaxCod")
            ival_ = self.gds_validate_integer(ival_, node, "courierMaxCod")
            self.courierMaxCod = ival_
            self.courierMaxCod_nsprefix_ = child_.prefix
        elif nodeName_ == "courierCodCurrency":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "courierCodCurrency")
            value_ = self.gds_validate_string(value_, node, "courierCodCurrency")
            self.courierCodCurrency = value_
            self.courierCodCurrency_nsprefix_ = child_.prefix
        elif nodeName_ == "courierExchrate" and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, "courierExchrate")
            fval_ = self.gds_validate_float(fval_, node, "courierExchrate")
            self.courierExchrate = fval_
            self.courierExchrate_nsprefix_ = child_.prefix
        elif nodeName_ == "courierNstAvailable":
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, "courierNstAvailable")
            ival_ = self.gds_validate_boolean(ival_, node, "courierNstAvailable")
            self.courierNstAvailable = ival_
            self.courierNstAvailable_nsprefix_ = child_.prefix
        elif nodeName_ == "courierMaxNst" and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, "courierMaxNst")
            ival_ = self.gds_validate_integer(ival_, node, "courierMaxNst")
            self.courierMaxNst = ival_
            self.courierMaxNst_nsprefix_ = child_.prefix
        elif nodeName_ == "courierMaxGirth" and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, "courierMaxGirth")
            ival_ = self.gds_validate_integer(ival_, node, "courierMaxGirth")
            self.courierMaxGirth = ival_
            self.courierMaxGirth_nsprefix_ = child_.prefix
        elif nodeName_ == "packstationAvailable":
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, "packstationAvailable")
            ival_ = self.gds_validate_boolean(ival_, node, "packstationAvailable")
            self.packstationAvailable = ival_
            self.packstationAvailable_nsprefix_ = child_.prefix
        elif nodeName_ == "packstationMaxWeight" and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, "packstationMaxWeight")
            fval_ = self.gds_validate_float(fval_, node, "packstationMaxWeight")
            self.packstationMaxWeight = fval_
            self.packstationMaxWeight_nsprefix_ = child_.prefix
        elif nodeName_ == "packstationMaxWidth" and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, "packstationMaxWidth")
            ival_ = self.gds_validate_integer(ival_, node, "packstationMaxWidth")
            self.packstationMaxWidth = ival_
            self.packstationMaxWidth_nsprefix_ = child_.prefix
        elif nodeName_ == "packstationMaxHeight" and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, "packstationMaxHeight")
            ival_ = self.gds_validate_integer(ival_, node, "packstationMaxHeight")
            self.packstationMaxHeight = ival_
            self.packstationMaxHeight_nsprefix_ = child_.prefix
        elif nodeName_ == "packstationMaxLength" and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, "packstationMaxLength")
            ival_ = self.gds_validate_integer(ival_, node, "packstationMaxLength")
            self.packstationMaxLength = ival_
            self.packstationMaxLength_nsprefix_ = child_.prefix
        elif nodeName_ == "postfilialeAvailable":
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, "postfilialeAvailable")
            ival_ = self.gds_validate_boolean(ival_, node, "postfilialeAvailable")
            self.postfilialeAvailable = ival_
            self.postfilialeAvailable_nsprefix_ = child_.prefix
        elif nodeName_ == "postfilialeMaxWeight" and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, "postfilialeMaxWeight")
            fval_ = self.gds_validate_float(fval_, node, "postfilialeMaxWeight")
            self.postfilialeMaxWeight = fval_
            self.postfilialeMaxWeight_nsprefix_ = child_.prefix
        elif nodeName_ == "postfilialeMaxWidth" and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, "postfilialeMaxWidth")
            ival_ = self.gds_validate_integer(ival_, node, "postfilialeMaxWidth")
            self.postfilialeMaxWidth = ival_
            self.postfilialeMaxWidth_nsprefix_ = child_.prefix
        elif nodeName_ == "postfilialeMaxHeight" and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, "postfilialeMaxHeight")
            ival_ = self.gds_validate_integer(ival_, node, "postfilialeMaxHeight")
            self.postfilialeMaxHeight = ival_
            self.postfilialeMaxHeight_nsprefix_ = child_.prefix
        elif nodeName_ == "postfilialeMaxLength" and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, "postfilialeMaxLength")
            ival_ = self.gds_validate_integer(ival_, node, "postfilialeMaxLength")
            self.postfilialeMaxLength = ival_
            self.postfilialeMaxLength_nsprefix_ = child_.prefix
        elif nodeName_ == "zipFormat":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "zipFormat")
            value_ = self.gds_validate_string(value_, node, "zipFormat")
            self.zipFormat = value_
            self.zipFormat_nsprefix_ = child_.prefix
        elif nodeName_ == "identifier":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "identifier")
            value_ = self.gds_validate_string(value_, node, "identifier")
            self.identifier = value_
            self.identifier_nsprefix_ = child_.prefix
        elif nodeName_ == "emailRequired" and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, "emailRequired")
            ival_ = self.gds_validate_integer(ival_, node, "emailRequired")
            self.emailRequired = ival_
            self.emailRequired_nsprefix_ = child_.prefix
        elif nodeName_ == "active":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "active")
            value_ = self.gds_validate_string(value_, node, "active")
            self.active = value_
            self.active_nsprefix_ = child_.prefix
        elif nodeName_ == "dutyProduct":
            value_ = child_.text
            value_ = self.gds_parse_stri