/*
 * Decompiled with CFR 0.152.
 */
package com.certora.evmverifier.cvl;

import com.certora.evmverifier.cvl.KotlinizeResult;
import com.certora.evmverifier.cvl.TypeOrLhs;
import java.util.List;
import java.util.stream.Collectors;
import spec.TypeResolver;
import spec.cvlast.CVLParam;
import spec.cvlast.CVLRange;
import spec.cvlast.CVLScope;
import spec.cvlast.VMParam;
import spec.cvlast.typechecker.CVLError;
import utils.CollectingResult;

public abstract class Param {
    public TypeOrLhs type;
    public String location;
    public final CVLRange cvlRange;

    public Param(TypeOrLhs _type, String location, CVLRange _cvlRange) {
        this.cvlRange = _cvlRange;
        this.type = _type;
        this.location = location;
    }

    public static CollectingResult<List<VMParam>, CVLError> toVMParams(List<Param> ps, TypeResolver resolver, CVLScope scope) {
        return CollectingResult.Companion.flatten(ps.stream().map(p -> p.toVMParam(resolver, scope)).collect(Collectors.toList()));
    }

    public static CollectingResult<List<VMParam>, CVLError> toVMDualParams(List<Param> ps, TypeResolver resolver, CVLScope scope) {
        return CollectingResult.Companion.flatten(ps.stream().map(p -> p.toVMParam(resolver, scope)).collect(Collectors.toList()));
    }

    protected CollectingResult<Void, CVLError> errorIfLocated() {
        if (this.location != null) {
            return KotlinizeResult.error(new CVLError.General(this.cvlRange, "Cannot include location " + this.location + " on what is supposed to be a cvl type"));
        }
        return KotlinizeResult.lift(null);
    }

    public abstract CollectingResult<? extends CVLParam, CVLError> toPureParam(TypeResolver var1, CVLScope var2);

    public abstract CollectingResult<? extends VMParam, CVLError> toVMParam(TypeResolver var1, CVLScope var2);
}

