/*
 * Decompiled with CFR 0.152.
 */
package spec;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import spec.CVLPrimitiveResolution;
import spec.TypeResolver;
import spec.cvlast.CVLType;
import spec.cvlast.ContractAliasDefinition;
import spec.cvlast.SortDeclaration;
import spec.cvlast.typechecker.CVLError;
import utils.CollectingResult;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\r\u001a\u0018\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000ej\b\u0012\u0004\u0012\u00020\u0010`\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0016\u0010\u0014\u001a\u00020\u000f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\u0016H\u0016J&\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00050\u000e2\b\u0010\u0019\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001a\u001a\u00020\u0005H\u0016J$\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00050\u000e2\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0005H$J\u0010\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0005H\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0005H&R \u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006 "}, d2={"Lspec/AbstractTypeResolver;", "Lspec/TypeResolver;", "()V", "contractAliases", "", "", "getContractAliases", "()Ljava/util/Map;", "sorts", "", "Lspec/cvlast/SortDeclaration;", "getSorts", "()Ljava/util/List;", "registerContractAlias", "Lutils/CollectingResult;", "", "Lspec/cvlast/typechecker/CVLError;", "Lutils/VoidResult;", "alias", "Lspec/cvlast/ContractAliasDefinition;", "registerSorts", "s", "", "resolveCVLType", "Lspec/cvlast/CVLType$PureCVLType;", "contract", "id", "resolveCVLTypeWithContract", "resolveContract", "validContract", "", "contractName", "Shared"})
public abstract class AbstractTypeResolver
implements TypeResolver {
    @NotNull
    private final Map<String, String> contractAliases = new LinkedHashMap();
    @NotNull
    private final List<SortDeclaration> sorts = new ArrayList();

    @NotNull
    protected final Map<String, String> getContractAliases() {
        return this.contractAliases;
    }

    public abstract boolean validContract(@NotNull String var1);

    @Override
    @NotNull
    public CollectingResult<Unit, CVLError> registerContractAlias(@NotNull ContractAliasDefinition alias) {
        CollectingResult collectingResult;
        Intrinsics.checkNotNullParameter(alias, "alias");
        if (!this.validContract(alias.getContractName())) {
            collectingResult = CollectingResult.Companion.asError(new CVLError.General(alias.getCvlRange(), "Tried to register " + alias.getAlias() + " as " + alias.getContractName() + " but " + alias.getContractName() + " does not exist."));
        } else if (this.contractAliases.containsKey(alias.getAlias())) {
            collectingResult = CollectingResult.Companion.asError(new CVLError.General(alias.getCvlRange(), "Registered contract alias " + alias.getAlias() + " more than once."));
        } else {
            this.contractAliases.put(alias.getAlias(), alias.getContractName());
            collectingResult = CollectingResult.Companion.lift(Unit.INSTANCE);
        }
        return collectingResult;
    }

    @Override
    @NotNull
    public String resolveContract(@NotNull String contract) {
        Intrinsics.checkNotNullParameter(contract, "contract");
        String string = this.contractAliases.get(contract);
        if (string == null) {
            string = contract;
        }
        return string;
    }

    @NotNull
    protected abstract CollectingResult<CVLType.PureCVLType, String> resolveCVLTypeWithContract(@NotNull String var1, @NotNull String var2);

    @Override
    @NotNull
    public CollectingResult<CVLType.PureCVLType, String> resolveCVLType(@Nullable String contract, @NotNull String id) {
        CollectingResult<CVLType.PureCVLType, String> collectingResult;
        Intrinsics.checkNotNullParameter(id, "id");
        if (contract == null) {
            CollectingResult.Result<CVLType.PureCVLType.Sort> result2;
            CollectingResult.Result<CVLType.PureCVLType.Sort> result3;
            Object v0;
            block5: {
                Iterable $this$firstOrNull$iv = this.sorts;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    SortDeclaration s = (SortDeclaration)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(id, s.getSort().getName())) continue;
                    v0 = element$iv;
                    break block5;
                }
                v0 = null;
            }
            SortDeclaration sortDeclaration = v0;
            if (sortDeclaration == null) {
                result3 = null;
            } else {
                CVLType.PureCVLType.Sort sort = sortDeclaration.getSort();
                result3 = result2 = sort == null ? null : CollectingResult.Companion.lift(sort);
            }
            collectingResult = result2 == null ? CVLPrimitiveResolution.INSTANCE.resolveCVLPrimitive(id) : (CollectingResult<CVLType.PureCVLType, String>)result2;
        } else {
            collectingResult = this.resolveCVLTypeWithContract(contract, id);
        }
        return collectingResult;
    }

    @NotNull
    protected final List<SortDeclaration> getSorts() {
        return this.sorts;
    }

    @Override
    public void registerSorts(@NotNull List<SortDeclaration> s) {
        Intrinsics.checkNotNullParameter(s, "s");
        this.sorts.addAll((Collection<SortDeclaration>)s);
    }
}

