/*
 * Decompiled with CFR 0.152.
 */
package config;

import config.ConfigType;
import config.TransformationAgnosticConfig;
import datastructures.stdcollections.ListsKt;
import java.io.Serializable;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u000e2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0003\r\u000e\u000fB\u001f\b\u0004\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002J\u000e\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0002R\u000e\u0010\u0006\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lconfig/AWSConfig;", "Lconfig/ConfigType;", "", "Lconfig/TransformationAgnosticConfig;", "default", "name", "envVarName", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "checkQueueName", "", "queue", "checkRegionName", "region", "AWSRegion", "Companion", "SQSQueueName", "Lconfig/AWSConfig$AWSRegion;", "Lconfig/AWSConfig$SQSQueueName;", "Shared"})
public abstract class AWSConfig
extends ConfigType<String>
implements TransformationAgnosticConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String envVarName;
    @NotNull
    private static final List<String> QUEUES = ListsKt.listOf("event.fifo", "testEvents.fifo");
    @NotNull
    private static final List<String> REGIONS;

    private AWSConfig(String string2, String name, String envVarName) {
        super((Serializable)((Object)string2), name, true, null);
        this.envVarName = envVarName;
        String string3 = System.getenv(this.envVarName);
        if (string3 != null) {
            String string4;
            String p0 = string4 = string3;
            boolean bl = false;
            this.set((Serializable)((Object)p0));
        }
        this.register();
    }

    public final boolean checkQueueName(@NotNull String queue) {
        Intrinsics.checkNotNullParameter(queue, "queue");
        return QUEUES.contains(queue);
    }

    public final boolean checkRegionName(@NotNull String region) {
        Intrinsics.checkNotNullParameter(region, "region");
        return REGIONS.contains(region);
    }

    public /* synthetic */ AWSConfig(String string2, String name, String envVarName, DefaultConstructorMarker $constructor_marker) {
        this(string2, name, envVarName);
    }

    static {
        String[] stringArray = new String[]{"us-east-1", "us-east-2", "us-west-1", "us-west-2", "ap-east-1", "ap-south-1", "ap-northeast-1", "ap-northeast-2", "ap-northeast-3", "ap-southeast-1", "ap-southeast-2", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-west-3", "eu-north-1", "me-south-1", "sa-east-1"};
        REGIONS = ListsKt.listOf(stringArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lconfig/AWSConfig$Companion;", "", "()V", "QUEUES", "", "", "getQUEUES", "()Ljava/util/List;", "REGIONS", "getREGIONS", "Shared"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getQUEUES() {
            return QUEUES;
        }

        @NotNull
        public final List<String> getREGIONS() {
            return REGIONS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lconfig/AWSConfig$AWSRegion;", "Lconfig/AWSConfig;", "()V", "check", "", "newValue", "", "illegalArgMessage", "Shared"})
    public static final class AWSRegion
    extends AWSConfig {
        @NotNull
        public static final AWSRegion INSTANCE = new AWSRegion();

        private AWSRegion() {
            super("us-west-2", "AWSRegion", "AWS_REGION", null);
        }

        @Override
        public boolean check(@NotNull String newValue) {
            Intrinsics.checkNotNullParameter(newValue, "newValue");
            return this.checkRegionName(newValue);
        }

        @Override
        @NotNull
        public String illegalArgMessage(@NotNull String newValue) {
            Intrinsics.checkNotNullParameter(newValue, "newValue");
            return "Illegal AWS region name";
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lconfig/AWSConfig$SQSQueueName;", "Lconfig/AWSConfig;", "()V", "check", "", "newValue", "", "illegalArgMessage", "Shared"})
    public static final class SQSQueueName
    extends AWSConfig {
        @NotNull
        public static final SQSQueueName INSTANCE = new SQSQueueName();

        private SQSQueueName() {
            super("event.fifo", "EventQueue", "QUEUE_NAME", null);
        }

        @Override
        public boolean check(@NotNull String newValue) {
            Intrinsics.checkNotNullParameter(newValue, "newValue");
            return this.checkQueueName(newValue);
        }

        @Override
        @NotNull
        public String illegalArgMessage(@NotNull String newValue) {
            Intrinsics.checkNotNullParameter(newValue, "newValue");
            return "Illegal AWS SQS queue name";
        }
    }
}

