/*
 * Decompiled with CFR 0.152.
 */
package spec.cvlast;

import config.Config;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import log.Logger;
import log.LoggerTypes;
import org.jetbrains.annotations.NotNull;
import spec.cvlast.CVLRuleChoiceKt;
import spec.cvlast.DistanceToName;
import utils.CertoraErrorType;
import utils.CertoraException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\u001af\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u001a\b\u0002\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\b2\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\t2\b\b\u0002\u0010\u000e\u001a\u00020\t\u001a\u0016\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004\u001a\u0014\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"logger", "Llog/Logger;", "getClosestStrings", "", "", "illegalWord", "legalWords", "distanceFunc", "Lkotlin/Function2;", "", "maxDist", "maxDistRatio", "", "maxSuggestions", "maxDelta", "inputStringDistance", "_input_str", "_dict_str", "validateRuleChoices", "", "allRules", "Shared"})
public final class CVLRuleChoiceKt {
    @NotNull
    private static final Logger logger = new Logger(LoggerTypes.SPEC);

    /*
     * WARNING - void declaration
     */
    public static final void validateRuleChoices(@NotNull Set<String> allRules) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(allRules, "allRules");
        HashSet<String> hashSet = Config.INSTANCE.getRuleChoices();
        if (hashSet == null) {
            return;
        }
        HashSet<String> chosenRules = hashSet;
        Set<String> unknownRules = SetsKt.minus((Set)chosenRules, (Iterable)allRules);
        if (unknownRules.isEmpty()) {
            return;
        }
        logger.info((Function0<? extends Object>)new Function0<Object>(unknownRules, allRules){
            final /* synthetic */ Set<String> $unknownRules;
            final /* synthetic */ Set<String> $allRules;
            {
                this.$unknownRules = $unknownRules;
                this.$allRules = $allRules;
                super(0);
            }

            @NotNull
            public final Object invoke() {
                return "Could not find rules: " + this.$unknownRules + ". Starting to offer replacement rules names. All rule names are " + this.$allRules;
            }
        });
        String errStr = "The rules: " + unknownRules + " were not found in any of the specification files.";
        Iterable $this$flatMap$iv = unknownRules;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = CVLRuleChoiceKt.getClosestStrings$default(it, allRules, null, 0, 0.0, 0, 0, 124, null);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        List allSuggestions = (List)destination$iv$iv;
        if (allSuggestions.size() == 1) {
            errStr = errStr + " Did you mean rule " + allSuggestions.get(0) + "?";
        } else if (allSuggestions.size() >= 2) {
            errStr = errStr + " Did you mean rule " + allSuggestions.get(0) + " or " + allSuggestions.get(1) + "?";
        }
        throw new CertoraException(CertoraErrorType.ILLEGAL_RULE_CHOICE, errStr, null, 4, null);
    }

    @NotNull
    public static final Set<String> getClosestStrings(@NotNull String illegalWord, @NotNull Set<String> legalWords, @NotNull Function2<? super String, ? super String, Integer> distanceFunc, int maxDist, double maxDistRatio, int maxSuggestions, int maxDelta) {
        DistanceToName currentTuple;
        int currDist;
        Intrinsics.checkNotNullParameter(illegalWord, "illegalWord");
        Intrinsics.checkNotNullParameter(legalWords, "legalWords");
        Intrinsics.checkNotNullParameter(distanceFunc, "distanceFunc");
        Comparator compareByDistance = CVLRuleChoiceKt::getClosestStrings$lambda-1;
        PriorityQueue<DistanceToName> distanceQueue = new PriorityQueue<DistanceToName>(compareByDistance);
        for (String legalWord : legalWords) {
            int distance = ((Number)distanceFunc.invoke(illegalWord, legalWord)).intValue();
            distanceQueue.add(new DistanceToName(distance, legalWord));
        }
        Set allSuggestions = new LinkedHashSet();
        int lastDist = Integer.MAX_VALUE;
        while (!distanceQueue.isEmpty() && allSuggestions.size() <= maxSuggestions && (currDist = (currentTuple = (DistanceToName)distanceQueue.poll()).getDistance()) <= maxDist && !((double)currDist / ((double)illegalWord.length() * 10.0) > maxDistRatio)) {
            if (lastDist != Integer.MAX_VALUE && Math.abs(currDist - lastDist) > maxDelta) continue;
            allSuggestions.add(currentTuple.getName());
            lastDist = currDist;
        }
        return allSuggestions;
    }

    public static /* synthetic */ Set getClosestStrings$default(String string2, Set set, Function2 function2, int n, double d, int n2, int n3, int n4, Object object) {
        if ((n4 & 4) != 0) {
            function2 = getClosestStrings.1.INSTANCE;
        }
        if ((n4 & 8) != 0) {
            n = 40;
        }
        if ((n4 & 0x10) != 0) {
            d = 0.5;
        }
        if ((n4 & 0x20) != 0) {
            n2 = 2;
        }
        if ((n4 & 0x40) != 0) {
            n3 = 2;
        }
        return CVLRuleChoiceKt.getClosestStrings(string2, set, function2, n, d, n2, n3);
    }

    public static final int inputStringDistance(@NotNull String _input_str, @NotNull String _dict_str) {
        int n;
        Intrinsics.checkNotNullParameter(_input_str, "_input_str");
        Intrinsics.checkNotNullParameter(_dict_str, "_dict_str");
        String string2 = _input_str.toLowerCase();
        Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).toLowerCase()");
        String inputStr = string2;
        String string3 = _dict_str.toLowerCase();
        Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String).toLowerCase()");
        String dictStr = string3;
        if (Intrinsics.areEqual(inputStr, dictStr)) {
            return 0;
        }
        if (StringsKt.startsWith$default(inputStr, dictStr, false, 2, null) || StringsKt.startsWith$default(dictStr, inputStr, false, 2, null)) {
            return Math.abs(dictStr.length() - inputStr.length());
        }
        int numRows = inputStr.length() + 1;
        int numCols = dictStr.length() + 1;
        int n2 = 0;
        int[][] nArrayArray = new int[numRows][];
        while (n2 < numRows) {
            n = n2++;
            nArrayArray[n] = new int[numCols];
        }
        int[][] distanceMatrix = nArrayArray;
        n2 = 1;
        while (n2 < numRows) {
            int row;
            distanceMatrix[row][0] = row = n2++;
        }
        n2 = 1;
        while (n2 < numCols) {
            int col;
            distanceMatrix[0][col] = col = n2++;
        }
        n2 = 1;
        while (n2 < numRows) {
            int row = n2++;
            n = 1;
            while (n < numCols) {
                char dictChar;
                int col = n++;
                char inputChar = inputStr.charAt(row - 1);
                int cost = inputChar == (dictChar = dictStr.charAt(col - 1)) ? 0 : (inputChar == '_' || dictChar == '_' ? 1 : 10);
                distanceMatrix[row][col] = cost + Math.min(distanceMatrix[row - 1][col], Math.min(distanceMatrix[row][col - 1], distanceMatrix[row - 1][col - 1]));
            }
        }
        return distanceMatrix[numRows - 1][numCols - 1];
    }

    private static final int getClosestStrings$lambda-1(DistanceToName t1, DistanceToName t2) {
        Intrinsics.checkNotNullParameter(t1, "t1");
        Intrinsics.checkNotNullParameter(t2, "t2");
        return t1.getDistance() - t2.getDistance();
    }
}

