/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.harmony.unpack200.bytecode.forms;

import org.apache.commons.compress.harmony.unpack200.bytecode.ByteCode;
import org.apache.commons.compress.harmony.unpack200.bytecode.OperandManager;
import org.apache.commons.compress.harmony.unpack200.bytecode.forms.VariableInstructionForm;

public class WideForm
extends VariableInstructionForm {
    public WideForm(int opcode, String name) {
        super(opcode, name);
    }

    @Override
    public void setByteCodeOperands(ByteCode byteCode, OperandManager operandManager, int codeLength) {
        int instruction = operandManager.nextWideByteCode();
        if (instruction == 132) {
            this.setByteCodeOperandsFormat2(instruction, byteCode, operandManager, codeLength);
        } else {
            this.setByteCodeOperandsFormat1(instruction, byteCode, operandManager, codeLength);
        }
    }

    protected void setByteCodeOperandsFormat1(int instruction, ByteCode byteCode, OperandManager operandManager, int codeLength) {
        int local = operandManager.nextLocal();
        int[] newRewrite = new int[4];
        int rewriteIndex2 = 0;
        newRewrite[rewriteIndex2++] = byteCode.getOpcode();
        newRewrite[rewriteIndex2++] = instruction;
        this.setRewrite2Bytes(local, rewriteIndex2, newRewrite);
        rewriteIndex2 += 2;
        byteCode.setRewrite(newRewrite);
    }

    protected void setByteCodeOperandsFormat2(int instruction, ByteCode byteCode, OperandManager operandManager, int codeLength) {
        int local = operandManager.nextLocal();
        int constWord = operandManager.nextShort();
        int[] newRewrite = new int[6];
        int rewriteIndex2 = 0;
        newRewrite[rewriteIndex2++] = byteCode.getOpcode();
        newRewrite[rewriteIndex2++] = instruction;
        this.setRewrite2Bytes(local, rewriteIndex2, newRewrite);
        this.setRewrite2Bytes(constWord, rewriteIndex2 += 2, newRewrite);
        rewriteIndex2 += 2;
        byteCode.setRewrite(newRewrite);
    }
}

