/**
 * Builder options
 */
export interface BuilderOptions {
    /**
     * Entry file
     */
    readonly entry: string;
    /**
     * The output directory
     */
    readonly outDir: string;
    /**
     * Expose modules as UMD under this name
     */
    readonly global: string;
    /**
     * Minify
     */
    readonly minify?: boolean;
    /**
     * Include source maps
     */
    readonly sourceMaps?: boolean;
    /**
     * The cache directory
     */
    readonly cacheDir?: string;
    /**
     * The node version to use as target for Babel
     */
    readonly nodeVersion?: string;
}
/**
 * Builder
 */
export declare class Builder {
    private readonly options;
    private readonly parcelBinPath;
    constructor(options: BuilderOptions);
    build(): void;
}
