# Generated by ariadne-codegen
# Source: queries.graphql

from typing import Any, Dict, List, Optional, Union

from .add_product_to_collection import AddProductToCollection
from .async_base_client import AsyncBaseClient
from .base_model import UNSET, UnsetType
from .bulk_fetch_products import BulkFetchProducts
from .create_collection import CreateCollection
from .create_product import CreateProduct
from .create_product_variants_bulk import CreateProductVariantsBulk
from .delete_collection import DeleteCollection
from .delete_product import DeleteProduct
from .enrich_product_data import EnrichProductData
from .get_bulk_operation import GetBulkOperation
from .get_collection import GetCollection
from .get_collection_basic import GetCollectionBasic
from .get_collection_products import GetCollectionProducts
from .get_multiple_products_for_collection_sync import (
    GetMultipleProductsForCollectionSync,
)
from .get_product import GetProduct
from .get_product_basic import GetProductBasic
from .get_product_collections import GetProductCollections
from .get_product_variants import GetProductVariants
from .get_shop import GetShop
from .get_shop_details import GetShopDetails
from .get_shop_metafield import GetShopMetafield
from .input_types import (
    CollectionDeleteInput,
    CollectionInput,
    CreateMediaInput,
    MetafieldsSetInput,
    ProductCreateInput,
    ProductDeleteInput,
    ProductUpdateInput,
    ProductVariantsBulkInput,
)
from .list_collections import ListCollections
from .list_products import ListProducts
from .remove_product_from_collection import RemoveProductFromCollection
from .set_metafield import SetMetafield
from .update_collection import UpdateCollection
from .update_product import UpdateProduct
from .update_variants import UpdateVariants


def gql(q: str) -> str:
    return q


class Client(AsyncBaseClient):
    async def get_product(self, id: str, **kwargs: Any) -> GetProduct:
        query = gql(
            """
            query getProduct($id: ID!) {
              product(id: $id) {
                id
                title
                handle
                descriptionHtml
                vendor
                productType
                tags
                status
                createdAt
                updatedAt
                publishedAt
                templateSuffix
                options {
                  id
                  name
                  position
                  optionValues {
                    id
                    name
                    hasVariants
                  }
                }
                variants(first: 250) {
                  edges {
                    node {
                      id
                      title
                      price
                      compareAtPrice
                      sku
                      barcode
                      inventoryQuantity
                      selectedOptions {
                        name
                        value
                      }
                      position
                      taxable
                      createdAt
                      updatedAt
                    }
                  }
                }
                media(first: 250) {
                  edges {
                    node {
                      __typename
                      ... on MediaImage {
                        id
                        image {
                          url
                          altText
                        }
                        alt
                      }
                    }
                  }
                }
                collections(first: 250) {
                  edges {
                    node {
                      id
                      handle
                      title
                      description
                      updatedAt
                    }
                  }
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"id": id}
        response = await self.execute(
            query=query, operation_name="getProduct", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return GetProduct.model_validate(data)

    async def get_product_basic(self, id: str, **kwargs: Any) -> GetProductBasic:
        query = gql(
            """
            query getProductBasic($id: ID!) {
              product(id: $id) {
                id
                title
                handle
                descriptionHtml
                vendor
                productType
                tags
                status
                createdAt
                updatedAt
                publishedAt
                templateSuffix
              }
            }
            """
        )
        variables: Dict[str, object] = {"id": id}
        response = await self.execute(
            query=query, operation_name="getProductBasic", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return GetProductBasic.model_validate(data)

    async def get_product_variants(
        self,
        id: str,
        first: Union[Optional[int], UnsetType] = UNSET,
        after: Union[Optional[str], UnsetType] = UNSET,
        **kwargs: Any
    ) -> GetProductVariants:
        query = gql(
            """
            query getProductVariants($id: ID!, $first: Int = 250, $after: String) {
              product(id: $id) {
                id
                variants(first: $first, after: $after) {
                  edges {
                    node {
                      id
                      title
                      price
                      compareAtPrice
                      sku
                      barcode
                      selectedOptions {
                        name
                        value
                      }
                      position
                      createdAt
                      updatedAt
                    }
                  }
                  pageInfo {
                    hasNextPage
                    hasPreviousPage
                    startCursor
                    endCursor
                  }
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"id": id, "first": first, "after": after}
        response = await self.execute(
            query=query,
            operation_name="getProductVariants",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return GetProductVariants.model_validate(data)

    async def list_products(
        self,
        first: Union[Optional[int], UnsetType] = UNSET,
        after: Union[Optional[str], UnsetType] = UNSET,
        query: Union[Optional[str], UnsetType] = UNSET,
        **kwargs: Any
    ) -> ListProducts:
        _query = gql(
            """
            query listProducts($first: Int = 50, $after: String, $query: String) {
              products(first: $first, after: $after, query: $query) {
                edges {
                  node {
                    id
                    title
                    handle
                    vendor
                    productType
                    status
                    createdAt
                    updatedAt
                    publishedAt
                  }
                }
                pageInfo {
                  hasNextPage
                  hasPreviousPage
                  startCursor
                  endCursor
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"first": first, "after": after, "query": query}
        response = await self.execute(
            query=_query, operation_name="listProducts", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return ListProducts.model_validate(data)

    async def get_multiple_products_for_collection_sync(
        self, ids: List[str], **kwargs: Any
    ) -> GetMultipleProductsForCollectionSync:
        query = gql(
            """
            query getMultipleProductsForCollectionSync($ids: [ID!]!) {
              nodes(ids: $ids) {
                __typename
                ... on Product {
                  id
                  collections(first: 250) {
                    edges {
                      node {
                        id
                        handle
                      }
                    }
                  }
                  variants(first: 250) {
                    edges {
                      node {
                        id
                        position
                      }
                    }
                  }
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"ids": ids}
        response = await self.execute(
            query=query,
            operation_name="getMultipleProductsForCollectionSync",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return GetMultipleProductsForCollectionSync.model_validate(data)

    async def get_product_collections(
        self, productId: str, **kwargs: Any
    ) -> GetProductCollections:
        query = gql(
            """
            query getProductCollections($productId: ID!) {
              product(id: $productId) {
                collections(first: 100) {
                  edges {
                    node {
                      id
                      handle
                    }
                  }
                  pageInfo {
                    hasNextPage
                    endCursor
                  }
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"productId": productId}
        response = await self.execute(
            query=query,
            operation_name="getProductCollections",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return GetProductCollections.model_validate(data)

    async def enrich_product_data(
        self, productId: str, **kwargs: Any
    ) -> EnrichProductData:
        query = gql(
            """
            query enrichProductData($productId: ID!) {
              product(id: $productId) {
                collections(first: 100) {
                  edges {
                    node {
                      id
                      handle
                    }
                  }
                  pageInfo {
                    hasNextPage
                    endCursor
                  }
                }
                images(first: 250) {
                  edges {
                    node {
                      id
                      url
                      altText
                      height
                      width
                    }
                  }
                }
                media(first: 250) {
                  edges {
                    node {
                      __typename
                      id
                      ... on MediaImage {
                        alt
                        status
                        image {
                          url
                          width
                          height
                        }
                        originalSource {
                          url
                        }
                      }
                    }
                  }
                }
                variants(first: 250) {
                  edges {
                    node {
                      id
                      image {
                        id
                        url
                        altText
                        height
                        width
                      }
                    }
                  }
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"productId": productId}
        response = await self.execute(
            query=query,
            operation_name="enrichProductData",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return EnrichProductData.model_validate(data)

    async def get_collection(self, id: str, **kwargs: Any) -> GetCollection:
        query = gql(
            """
            query getCollection($id: ID!) {
              collection(id: $id) {
                id
                handle
                title
                description
                updatedAt
                products(first: 250) {
                  edges {
                    node {
                      id
                      title
                      handle
                    }
                  }
                  pageInfo {
                    hasNextPage
                    hasPreviousPage
                    startCursor
                    endCursor
                  }
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"id": id}
        response = await self.execute(
            query=query, operation_name="getCollection", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return GetCollection.model_validate(data)

    async def get_collection_basic(self, id: str, **kwargs: Any) -> GetCollectionBasic:
        query = gql(
            """
            query getCollectionBasic($id: ID!) {
              collection(id: $id) {
                id
                handle
                title
                description
                updatedAt
              }
            }
            """
        )
        variables: Dict[str, object] = {"id": id}
        response = await self.execute(
            query=query,
            operation_name="getCollectionBasic",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return GetCollectionBasic.model_validate(data)

    async def list_collections(
        self,
        first: Union[Optional[int], UnsetType] = UNSET,
        after: Union[Optional[str], UnsetType] = UNSET,
        query: Union[Optional[str], UnsetType] = UNSET,
        **kwargs: Any
    ) -> ListCollections:
        _query = gql(
            """
            query listCollections($first: Int = 50, $after: String, $query: String) {
              collections(first: $first, after: $after, query: $query) {
                edges {
                  node {
                    id
                    handle
                    title
                    description
                    updatedAt
                  }
                }
                pageInfo {
                  hasNextPage
                  hasPreviousPage
                  startCursor
                  endCursor
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"first": first, "after": after, "query": query}
        response = await self.execute(
            query=_query,
            operation_name="listCollections",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return ListCollections.model_validate(data)

    async def get_collection_products(
        self,
        id: str,
        first: Union[Optional[int], UnsetType] = UNSET,
        after: Union[Optional[str], UnsetType] = UNSET,
        **kwargs: Any
    ) -> GetCollectionProducts:
        query = gql(
            """
            query getCollectionProducts($id: ID!, $first: Int = 250, $after: String) {
              collection(id: $id) {
                id
                handle
                title
                products(first: $first, after: $after) {
                  edges {
                    node {
                      id
                      title
                      handle
                      vendor
                      productType
                      status
                      createdAt
                      updatedAt
                    }
                  }
                  pageInfo {
                    hasNextPage
                    hasPreviousPage
                    startCursor
                    endCursor
                  }
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"id": id, "first": first, "after": after}
        response = await self.execute(
            query=query,
            operation_name="getCollectionProducts",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return GetCollectionProducts.model_validate(data)

    async def get_shop_metafield(
        self, namespace: str, key: str, **kwargs: Any
    ) -> GetShopMetafield:
        query = gql(
            """
            query getShopMetafield($namespace: String!, $key: String!) {
              shop {
                metafield(namespace: $namespace, key: $key) {
                  id
                  namespace
                  key
                  value
                  type
                  createdAt
                  updatedAt
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"namespace": namespace, "key": key}
        response = await self.execute(
            query=query,
            operation_name="getShopMetafield",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return GetShopMetafield.model_validate(data)

    async def get_shop(self, **kwargs: Any) -> GetShop:
        query = gql(
            """
            query getShop {
              shop {
                id
              }
            }
            """
        )
        variables: Dict[str, object] = {}
        response = await self.execute(
            query=query, operation_name="getShop", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return GetShop.model_validate(data)

    async def get_shop_details(self, **kwargs: Any) -> GetShopDetails:
        query = gql(
            """
            query getShopDetails {
              shop {
                id
                name
                email
                primaryDomain {
                  host
                }
                myshopifyDomain
                createdAt
                updatedAt
              }
            }
            """
        )
        variables: Dict[str, object] = {}
        response = await self.execute(
            query=query, operation_name="getShopDetails", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return GetShopDetails.model_validate(data)

    async def get_bulk_operation(self, id: str, **kwargs: Any) -> GetBulkOperation:
        query = gql(
            """
            query getBulkOperation($id: ID!) {
              node(id: $id) {
                __typename
                ... on BulkOperation {
                  id
                  status
                  errorCode
                  createdAt
                  completedAt
                  fileSize
                  url
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"id": id}
        response = await self.execute(
            query=query,
            operation_name="getBulkOperation",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return GetBulkOperation.model_validate(data)

    async def create_product(
        self, product: ProductCreateInput, media: List[CreateMediaInput], **kwargs: Any
    ) -> CreateProduct:
        query = gql(
            """
            mutation createProduct($product: ProductCreateInput!, $media: [CreateMediaInput!]!) {
              productCreate(product: $product, media: $media) {
                product {
                  id
                  title
                  handle
                  status
                  variants(first: 10) {
                    edges {
                      node {
                        id
                        price
                        barcode
                        createdAt
                      }
                    }
                  }
                }
                userErrors {
                  field
                  message
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"product": product, "media": media}
        response = await self.execute(
            query=query, operation_name="createProduct", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return CreateProduct.model_validate(data)

    async def update_product(
        self, product: ProductUpdateInput, **kwargs: Any
    ) -> UpdateProduct:
        query = gql(
            """
            mutation updateProduct($product: ProductUpdateInput!) {
              productUpdate(product: $product) {
                product {
                  id
                  title
                  handle
                  bodyHtml
                  vendor
                  productType
                  tags
                  status
                  createdAt
                  updatedAt
                }
                userErrors {
                  field
                  message
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"product": product}
        response = await self.execute(
            query=query, operation_name="updateProduct", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return UpdateProduct.model_validate(data)

    async def delete_product(
        self, input: ProductDeleteInput, **kwargs: Any
    ) -> DeleteProduct:
        query = gql(
            """
            mutation deleteProduct($input: ProductDeleteInput!) {
              productDelete(input: $input) {
                deletedProductId
                userErrors {
                  field
                  message
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"input": input}
        response = await self.execute(
            query=query, operation_name="deleteProduct", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return DeleteProduct.model_validate(data)

    async def create_product_variants_bulk(
        self, productId: str, variants: List[ProductVariantsBulkInput], **kwargs: Any
    ) -> CreateProductVariantsBulk:
        query = gql(
            """
            mutation createProductVariantsBulk($productId: ID!, $variants: [ProductVariantsBulkInput!]!) {
              productVariantsBulkCreate(productId: $productId, variants: $variants) {
                productVariants {
                  id
                }
                userErrors {
                  field
                  message
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"productId": productId, "variants": variants}
        response = await self.execute(
            query=query,
            operation_name="createProductVariantsBulk",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return CreateProductVariantsBulk.model_validate(data)

    async def update_variants(
        self, productId: str, variants: List[ProductVariantsBulkInput], **kwargs: Any
    ) -> UpdateVariants:
        query = gql(
            """
            mutation updateVariants($productId: ID!, $variants: [ProductVariantsBulkInput!]!) {
              productVariantsBulkUpdate(productId: $productId, variants: $variants) {
                productVariants {
                  id
                  price
                  barcode
                  createdAt
                }
                userErrors {
                  field
                  message
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"productId": productId, "variants": variants}
        response = await self.execute(
            query=query, operation_name="updateVariants", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return UpdateVariants.model_validate(data)

    async def create_collection(
        self, input: CollectionInput, **kwargs: Any
    ) -> CreateCollection:
        query = gql(
            """
            mutation createCollection($input: CollectionInput!) {
              collectionCreate(input: $input) {
                collection {
                  id
                  title
                  handle
                  updatedAt
                }
                userErrors {
                  field
                  message
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"input": input}
        response = await self.execute(
            query=query,
            operation_name="createCollection",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return CreateCollection.model_validate(data)

    async def update_collection(
        self, input: CollectionInput, **kwargs: Any
    ) -> UpdateCollection:
        query = gql(
            """
            mutation updateCollection($input: CollectionInput!) {
              collectionUpdate(input: $input) {
                collection {
                  id
                  title
                  handle
                  updatedAt
                }
                userErrors {
                  field
                  message
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"input": input}
        response = await self.execute(
            query=query,
            operation_name="updateCollection",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return UpdateCollection.model_validate(data)

    async def add_product_to_collection(
        self, id: str, productIds: List[str], **kwargs: Any
    ) -> AddProductToCollection:
        query = gql(
            """
            mutation addProductToCollection($id: ID!, $productIds: [ID!]!) {
              collectionAddProducts(id: $id, productIds: $productIds) {
                collection {
                  id
                  products(first: 10) {
                    edges {
                      node {
                        id
                      }
                    }
                  }
                }
                userErrors {
                  field
                  message
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"id": id, "productIds": productIds}
        response = await self.execute(
            query=query,
            operation_name="addProductToCollection",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return AddProductToCollection.model_validate(data)

    async def remove_product_from_collection(
        self, id: str, productIds: List[str], **kwargs: Any
    ) -> RemoveProductFromCollection:
        query = gql(
            """
            mutation removeProductFromCollection($id: ID!, $productIds: [ID!]!) {
              collectionRemoveProducts(id: $id, productIds: $productIds) {
                job {
                  id
                }
                userErrors {
                  field
                  message
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"id": id, "productIds": productIds}
        response = await self.execute(
            query=query,
            operation_name="removeProductFromCollection",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return RemoveProductFromCollection.model_validate(data)

    async def delete_collection(
        self, input: CollectionDeleteInput, **kwargs: Any
    ) -> DeleteCollection:
        query = gql(
            """
            mutation deleteCollection($input: CollectionDeleteInput!) {
              collectionDelete(input: $input) {
                deletedCollectionId
                userErrors {
                  field
                  message
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"input": input}
        response = await self.execute(
            query=query,
            operation_name="deleteCollection",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return DeleteCollection.model_validate(data)

    async def set_metafield(
        self, metafields: List[MetafieldsSetInput], **kwargs: Any
    ) -> SetMetafield:
        query = gql(
            """
            mutation setMetafield($metafields: [MetafieldsSetInput!]!) {
              metafieldsSet(metafields: $metafields) {
                metafields {
                  id
                  namespace
                  key
                  value
                  type
                  createdAt
                  updatedAt
                }
                userErrors {
                  field
                  message
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"metafields": metafields}
        response = await self.execute(
            query=query, operation_name="setMetafield", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return SetMetafield.model_validate(data)

    async def bulk_fetch_products(self, query: str, **kwargs: Any) -> BulkFetchProducts:
        _query = gql(
            """
            mutation bulkFetchProducts($query: String!) {
              bulkOperationRunQuery(query: $query) {
                bulkOperation {
                  id
                  status
                }
                userErrors {
                  field
                  message
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"query": query}
        response = await self.execute(
            query=_query,
            operation_name="bulkFetchProducts",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return BulkFetchProducts.model_validate(data)
