# Generated by ariadne-codegen
# Source: queries.graphql

from typing import Any, List, Literal, Optional, Union

from pydantic import Field

from .base_model import BaseModel
from .enums import ProductStatus


class GetProduct(BaseModel):
    product: Optional["GetProductProduct"]


class GetProductProduct(BaseModel):
    id: str
    title: str
    handle: str
    descriptionHtml: Any
    vendor: str
    productType: str
    tags: List[str]
    status: ProductStatus
    createdAt: Any
    updatedAt: Any
    publishedAt: Optional[Any]
    templateSuffix: Optional[str]
    options: List["GetProductProductOptions"]
    variants: "GetProductProductVariants"
    media: "GetProductProductMedia"
    collections: "GetProductProductCollections"


class GetProductProductOptions(BaseModel):
    id: str
    name: str
    position: int
    optionValues: List["GetProductProductOptionsOptionValues"]


class GetProductProductOptionsOptionValues(BaseModel):
    id: str
    name: str
    hasVariants: bool


class GetProductProductVariants(BaseModel):
    edges: List["GetProductProductVariantsEdges"]


class GetProductProductVariantsEdges(BaseModel):
    node: "GetProductProductVariantsEdgesNode"


class GetProductProductVariantsEdgesNode(BaseModel):
    id: str
    title: str
    price: Any
    compareAtPrice: Optional[Any]
    sku: Optional[str]
    barcode: Optional[str]
    inventoryQuantity: Optional[int]
    selectedOptions: List["GetProductProductVariantsEdgesNodeSelectedOptions"]
    position: int
    taxable: bool
    createdAt: Any
    updatedAt: Any


class GetProductProductVariantsEdgesNodeSelectedOptions(BaseModel):
    name: str
    value: str


class GetProductProductMedia(BaseModel):
    edges: List["GetProductProductMediaEdges"]


class GetProductProductMediaEdges(BaseModel):
    node: Union[
        "GetProductProductMediaEdgesNodeMedia",
        "GetProductProductMediaEdgesNodeMediaImage",
    ] = Field(discriminator="typename__")


class GetProductProductMediaEdgesNodeMedia(BaseModel):
    typename__: Literal["ExternalVideo", "Media", "Model3d", "Video"] = Field(
        alias="__typename"
    )


class GetProductProductMediaEdgesNodeMediaImage(BaseModel):
    typename__: Literal["MediaImage"] = Field(alias="__typename")
    id: str
    image: Optional["GetProductProductMediaEdgesNodeMediaImageImage"]
    alt: Optional[str]


class GetProductProductMediaEdgesNodeMediaImageImage(BaseModel):
    url: Any
    altText: Optional[str]


class GetProductProductCollections(BaseModel):
    edges: List["GetProductProductCollectionsEdges"]


class GetProductProductCollectionsEdges(BaseModel):
    node: "GetProductProductCollectionsEdgesNode"


class GetProductProductCollectionsEdgesNode(BaseModel):
    id: str
    handle: str
    title: str
    description: str
    updatedAt: Any


GetProduct.model_rebuild()
GetProductProduct.model_rebuild()
GetProductProductOptions.model_rebuild()
GetProductProductVariants.model_rebuild()
GetProductProductVariantsEdges.model_rebuild()
GetProductProductVariantsEdgesNode.model_rebuild()
GetProductProductMedia.model_rebuild()
GetProductProductMediaEdges.model_rebuild()
GetProductProductMediaEdgesNodeMediaImage.model_rebuild()
GetProductProductCollections.model_rebuild()
GetProductProductCollectionsEdges.model_rebuild()
