
def run(data, context):
    # this Lambda function is triggered by this API GW method https://545ojrb6r0.execute-api.eu-west-2.amazonaws.com/dev/event-handler
    from pbx_gs_python_utils.gsbot.API_GS_Bot import API_GS_Bot, log_debug

    #log_debug("Message received from /dev/event-handler API GW: {0}".format(data) , category='gs_bot')
    try:
        if "challenge" in data:              # required for Slack event check
            return data.get("challenge")
        team_id = data.get('team_id')
        if data.get('event'):
            slack_event = data.get('event')
            if ("bot_id" in slack_event) is False:                      # this happens when the data was generated by an bot
                slack_event['team_id'] = team_id                        # add team_id field so that it is available in the other lambda handlers
                API_GS_Bot(team_id).process_event(slack_event)          # add a `return` here to see message in test
        elif data.get('body'):
            return API_GS_Bot(team_id).process_posted_body(data.get('body'))
        return "200 OK"
    except Exception as error:
        log_debug("Error processing request: {0}".format(error), data=data, category='gs_bot')
        return "500 Error"